

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTAdvisoryClear.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTAdvisoryClear.sp,v $ $Id: br_NTAdvisoryClear.sp,v 1.5.60.1 2017/02/10 21:21:45 sjohnson Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_NTAdvisoryClear - Create the new alert definition
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_NTAdvisoryClear <<<'

IF EXISTS (select * from sysobjects where name='br_NTAdvisoryClear')
	drop procedure br_NTAdvisoryClear
IF EXISTS (select * from GxQscripts where name='br_NTAdvisoryClear')
	delete from GxQscripts where name = 'br_NTAdvisoryClear'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAdvisoryClear')
	delete from GXDBVersions where aliasname = 'br_NTAdvisoryClear'
GO
print '... Creating Procedure: br_NTAdvisoryClear'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_NTAdvisoryClear
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID int,
  @locale int,
  @xmlString varchar(MAX)
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT ON
DECLARE	@function				varchar(80)
SET		@function				= 'br_NTAdvisoryClear'
DECLARE @brAlertTrace           varchar(256)
SET		@brAlertTrace               =(select value from gxglobalParam Where name = 'bralertTrace')
DECLARE @iDoc     				int
DECLARE @errorCode				int
SET		@errorCode				=0
DECLARE	@errorString			varchar(512)
SET		@errorString			=''
DECLARE	@capability int
SET		@capability				= 18				--'EV_MANAGE_ALERTS' (EvCapability.h)
DECLARE @thisEventId			int
DECLARE @thisClientId			int
DECLARE @ClientStringList		nvarchar(4000)
DECLARE @Seper					nvarchar(5)
SET		@Seper					= ''
----------------------------------------------------------
--	FETCH PARAMETERS FROM THE XML STRING PASSED IN	--
----------------------------------------------------------
if @brAlertTrace <> 0
	exec br_ntTrace '.. br_NTAdvisoryClear', 0, 0, 0, 0, @xmlString
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
BEGIN TRY
	if object_id('tempdb.dbo.#advisoryWorkList') is not null
		DROP TABLE #advisoryWorkList
	CREATE TABLE #advisoryWorkList
	(
		[eventId]       integer NOT NuLL,
		[advisoryType]  integer NOT NuLL
	)
	exec br_NTPermCheck @ownerId, @locale, @capability, 2018, 2, @errorCode OUTPUT, @errorString OUTPUT
	IF @errorCode <> 0
		goto CREATE_EXIT
	if object_id('tempdb.dbo.#ClientList') is not null
		DROP TABLE #ClientList
	CREATE TABLE #ClientList
	(
		clientId       integer NOT NuLL
	)
	----------------------------------------------------
	--- Collect List of Advisories to Clear From XML ---
	----------------------------------------------------
	INSERT #advisoryWorkList
		SELECT eventId, advisoryType
		FROM OPENXML(@iDoc, 'CVGui_AlertSRMAdvisoryClearReq/srmAsdvisories', 0)
			WITH (	eventId			integer './@eventId',
					advisoryType	integer './@advisoryType')
	---------------------------------------------------------------------------------------
	---  GATHERED ENOUGH INFORMATION, TIME TO START DELETING SOME DATA FROM THE TABLES! ---
	---------------------------------------------------------------------------------------
	DECLARE AdvisoriesToClear CURSOR FOR
	SELECT eventId FROM #advisoryWorkList
	OPEN AdvisoriesToClear
	FETCH AdvisoriesToClear INTO @thisEventId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		set @thisClientId = ISNULL((Select top 1 clientId from NTDSRMAdvisory
                                            where eventId = @thisEventId), 0)
		EXEC br_NTPermCheck @ownerId, @locale, @capability, 2009, @thisClientId, @errorCode OUTPUT, @errorString OUTPUT
		IF (@errorCode = 0)
			DELETE NTDetectedAlerts WHERE eventId = @thisEventId
		ELSE
			if NOT EXISTS (Select * from #ClientList where clientId = @thisClientId)
			BEGIN
				INSERT #ClientList VALUES (@thisClientId)
				SET @ClientStringList = @ClientStringList + @SEPER + ISNULL((Select name from app_client where id = @thisClientId), '??')
				SET @seper = ', '
				IF LEN(@ClientStringList) > 0
				BEGIN
					SET @errorCode = 2
					SET @errorString = 'Not all selected advisories cleared.  User has insuffecient credentials to clear advisories for clients ['
										+@clientStringList  + '].'
				END
			END
		FETCH AdvisoriesToClear INTO @thisEventId
	END
	CLOSE		AdvisoriesToClear
	DEALLOCATE	AdvisoriesToClear
/*
	DELETE  NTDetectedAlerts
	FROM NTDetectedAlerts AS NT, #advisoryWorkList as WL
	Where NT.eventId = WL.eventID
*/
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = 1
	SET @errorString = 'Problems Executing [' + @function +'] Error Message [' + ERROR_MESSAGE() + '].'
END CATCH
	--								????????????????????????
CREATE_EXIT:
---------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
DROP TABLE #advisoryWorkList
SELECT	1			         as TAG,
		NULL		         as Parent,
	@errorCode			     as [CVGui_GenericResp!1!errorCode],
	@errorString	         as [CVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT
EXEC sp_xml_removedocument @idoc
/* TEST CODE:
DECLARE @xml  varchar(MAX)
SET		@xml = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><CVGui_AlertSRMAdvisoryClearReq xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_AlertSRMAdvisoryClearReqType.xsd"><srmAsdvisories advisoryType="10012" appTypeId="0" clientId="0" eventId="1" formatString="" level="0" parameters="" sourceRDN="" timestamp="0"/><srmAsdvisories advisoryType="10013" appTypeId="0" clientId="0" eventId="2" formatString="" level="0" parameters="" sourceRDN="" timestamp="0"/><srmAsdvisories advisoryType="10012" appTypeId="0" clientId="0" eventId="4" formatString="" level="0" parameters="" sourceRDN="" timestamp="0"/></CVGui_AlertSRMAdvisoryClearReq>'
exec br_NTAdvisoryClear 1, 4, @xml
*/
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTAdvisoryClear')
	delete from GxQscripts where name = 'br_NTAdvisoryClear'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAdvisoryClear')
	delete from GXDBVersions where aliasname = 'br_NTAdvisoryClear'
GO

insert into GXDBVersions values(2, 'br_NTAdvisoryClear',  '00010005006000010000', 'br_NTAdvisoryClear', '00010005006000010000')
GO

