

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/br_NTAdvisoriesList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/br_NTAdvisoriesList.sp,v $ $Id: br_NTAdvisoriesList.sp,v 1.7.210.2 2018/03/27 07:58:54 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   br_NTAdvisoriesList   - Fetch the list of current Advisories
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: br_NTAdvisoriesList <<<'

IF EXISTS (select * from sysobjects where name='br_NTAdvisoriesList')
	drop procedure br_NTAdvisoriesList
IF EXISTS (select * from GxQscripts where name='br_NTAdvisoriesList')
	delete from GxQscripts where name = 'br_NTAdvisoriesList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAdvisoriesList')
	delete from GXDBVersions where aliasname = 'br_NTAdvisoriesList'
GO
print '... Creating Procedure: br_NTAdvisoriesList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure br_NTAdvisoriesList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @localeId int,
  @clientId int,
  @appTypeId int,
  @sourceRDN nvarchar(2048),
  @reCurse int
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
DECLARE @sourceRDNcompare		nvarchar(2048)
IF @reCurse <> 0
	SET @sourceRDNcompare = @sourceRDN+'%'
ELSE
	SET @sourceRDNcompare = @sourceRDN
if object_id('tempdb.dbo.#advisoryList') is not null
    DROP TABLE #advisoryList
CREATE TABLE #advisoryList
(
    [eventId]		integer NOT NuLL,
	[NTAdvisoryMsgId] integer NOT NuLL,
    [advisoryType]  integer NOT NuLL,
    [clientId]		integer NOT NuLL,
    [appTypeId]		integer NOT NuLL,
    [sourceRDN]     nvarchar(2048),			-- #define !@#@!#!@#
    [level]			integer NOT NuLL,
    [timestamp]		integer NOT NuLL,
    [formatString]  nvarchar(2048),			-- #define !@#@!#!@#
    [parameters]    nvarchar(2048)			-- #define !@#@!#!@#
)
--------------------------------------------------
-- BASED ON INPUT PARAMETERS, DETERMINE DATASET --
--------------------------------------------------
IF @clientId <> 0
	INSERT #advisoryList
	SELECT [eventId],
		 NTAdvisoryMsgId,
		 0,					-- advisoryType
		 [clientId],
		 [appTypeId],
		 [sourceRDN],
		 0,					-- level
		 initialOccurence,
		 '',				-- formatString
		  [parameters]
	FROM NTDSrmAdvisory
	WHERE [clientId] = @clientId
ELSE IF @appTypeId <> 0
	INSERT #advisoryList
	SELECT [eventId],
		 NTAdvisoryMsgId,
		 0,					-- advisoryType
		 [clientId],
		 [appTypeId],
		 [sourceRDN],
		 0,					-- level
		 initialOccurence,
		 '',				-- formatString
		  [parameters]
	FROM NTDSrmAdvisory
	WHERE [appTypeID] = @appTypeId
ELSE IF  LEN(@sourceRDNcompare) > 0
	INSERT #advisoryList
	SELECT [eventId],
		 NTAdvisoryMsgId,
		 0,					-- advisoryType
		 [clientId],
		 [appTypeId],
		 [sourceRDN],
		 0,					-- level
		 initialOccurence,
		 '',				-- formatString
		  [parameters]
	FROM NTDSrmAdvisory
	WHERE [sourceRDN] like @sourceRDNcompare
-- WHOLE LIST IS "DEFAULT" RETURN --
ELSE
	INSERT #advisoryList
	SELECT [eventId],
		 NTAdvisoryMsgId,
		 0,					-- advisoryType
		 [clientId],
		 [appTypeId],
		 [sourceRDN],
		 0,					-- level
		 initialOccurence,
		 '',				-- formatString
		  [parameters]
	FROM NTDSrmAdvisory
UPDATE #advisoryList
		SET advisoryType = DA.criteria
		FROM #advisoryList AS AL, NTDetectedAlerts AS DA
		WHERE AL.[eventId] = DA.eventId
UPDATE #advisoryList
		SET level = AT.level, formatString = dbo.fn_EvFormatEventMsgText(0 ,@localeId, msgId, 0,2)
		FROM #advisoryList AS AL, NTAdvisoryMsg AS AT
		WHERE  AL.NTAdvisoryMsgId = AT.id
--Select nowTime1=@nowTime1, nowTime2=@nowTime2, diff= @diff
--select step='Debug 1', * FROM #advisoryList
SET NOCOUNT ON
	SELECT	1			                as TAG,
		NuLL			                as Parent,
		NuLL			                as [CVGui_AlertSRMAdvisoryListResp!1],
		NuLL							as [srmAsdvisories!2!eventId],
		NuLL							as [srmAsdvisories!2!advisoryType],
		NuLL							as [srmAsdvisories!2!clientId],
		NuLL							as [srmAsdvisories!2!appTypeId],
		NuLL							as [srmAsdvisories!2!sourceRDN],
		NuLL							as [srmAsdvisories!2!level],
		NuLL							as [srmAsdvisories!2!timestamp],
		NuLL							as [srmAsdvisories!2!formatString],
		NuLL							as [srmAsdvisories!2!parameters]
	UNION ALL
	----------------------------------
	---- ALERT INFO ----
	----------------------------------
	SELECT	2, 1, NuLL,
		[eventId], [advisoryType], [clientId], [appTypeId], [sourceRDN], [level], [timeStamp], [formatString], [parameters]
 	FROM #advisoryList
--	ORDER BY [srmAsdvisoryTypes!2!appTypeId], [srmAsdvisoryTypes!2!advisoryType]
	FOR XML EXPLICIT
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'br_NTAdvisoriesList')
	delete from GxQscripts where name = 'br_NTAdvisoriesList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='br_NTAdvisoriesList')
	delete from GXDBVersions where aliasname = 'br_NTAdvisoriesList'
GO

insert into GXDBVersions values(2, 'br_NTAdvisoriesList',  '00010007021000020000', 'br_NTAdvisoriesList', '00010007021000020000')
GO

