

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archXMLStoragePolicyOperation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archXMLStoragePolicyOperation')
BEGIN
	print '>>> Drop Stored Procedure: archXMLStoragePolicyOperation <<<'
	drop procedure archXMLStoragePolicyOperation
END
IF EXISTS (select * from GxQscripts where name='archXMLStoragePolicyOperation')
	delete from GxQscripts where name = 'archXMLStoragePolicyOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archXMLStoragePolicyOperation')
	delete from GXDBVersions where aliasname = 'archXMLStoragePolicyOperation'
GO
print '... Creating Procedure: archXMLStoragePolicyOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archXMLStoragePolicyOperation
  @i_sp_options varchar(MAX),
  @i_CreateOpt integer
AS
  DECLARE @o_agrcpyID integer;
  DECLARE @o_agrID integer;
  DECLARE @o_error integer;
  DECLARE @o_xmltxt XML;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/*Local Variables*/
 DECLARE @EVCODE BIGINT
 DECLARE @spname varchar(100)
 DECLARE @legalhold INT
 DECLARE @incrsp INT
 DECLARE @maxstreams INT
 DECLARE @siblocksizekb INT
 DECLARE @copyname varchar(100)
 DECLARE @copynameSILO varchar(100)
 DECLARE @basicdays INT
 DECLARE @basiccycles INT
 DECLARE @archiverdays INT
 DECLARE @library varchar(100)
 DECLARE @drivepool varchar(100)
 DECLARE @sparegroup varchar(100)
 DECLARE @IsHardwareCompressed INT
 DECLARE @dedupEnable INT
 DECLARE @mediaagent varchar(100)
 DECLARE @pathname varchar(100)
 DECLARE @siloCopyId INT
 DECLARE @siloappid INT
 DECLARE @silosincache INT
 DECLARE @encType INT
 DECLARE @encKeyLen INT
 DECLARE @copyFlag	INT
 DECLARE @sourceCopyId	INT
 DECLARE @isSnapCopy	INT
 DECLARE @isMirrorCopy	INT
 DECLARE @siloEnabled INT
 DECLARE @siloDPLibId INT
 DECLARE @siloDPDrivePoolId INT
 DECLARE @siloDPScratchPoolId INT
 DECLARE @siloDPMAId INT
 DECLARE @dedupFlags INT
 DECLARE @EVMSG VARCHAR(1000)
 DECLARE @sp_options XML
 set @dedupFlags = 0
 set @sp_options = cast(@i_sp_options AS XML)
BEGIN
	select  @spname = Node.value('@SPName','varchar(100)'),
			@legalhold = Node.value('@LegalHold','INT'),
			@incrsp = Node.value('@IncrSP','INT'),
			@maxstreams= Node.value('@MaxStreams','INT'),
			@siblocksizekb = Node.value('@SIBlockSizeKB','INT')
	FROM	@sp_options.nodes('/MediaManager_SPOpType/SPDetails') tmpxml (Node);
	select	@copyname = Node.value('@CopyName','varchar(100)'),
			@copyFlag = Node.value('@flags', 'INT'),
			@isSnapCopy = Node.value('@isSnapCopy', 'INT'),
			@isMirrorCopy = Node.value('@isMirrorCopy', 'INT'),
			@sourceCopyId = Node.value('@sourceCopyId', 'INT')
	FROM	@sp_options.nodes('/MediaManager_SPOpType/CopyDetails/copy') Tmpxml2(Node);
	select	@basicdays = Node.value ('@BasicDays','INT'),
		@archiverdays = Node.value ('@ArchiverDays','INT')
	FROM	@sp_options.nodes('/MediaManager_SPOpType/CopyDetails/Retention')Tmpxml3(Node);
	select	@library = Node.value('@Library','varchar(100)'),
			@drivepool = Node.value('@DrivePool','varchar(100)'),
			@sparegroup = Node.value('@SpareGroup','varchar(100)'),
			@IsHardwareCompressed = Node.value('@CompressHardware','INT')
	FROM	@sp_options.nodes('/MediaManager_SPOpType/CopyDetails/DPInfo/defaultDP') tmpxml4(Node);
	select	@dedupEnable = Node.value('@DedupEnable','INT'),
			@mediaagent = Node.value('@MediaAgent','varchar(100)'),
			@pathname = Node.value('@Path','varchar(100)'),
			@siloappid = Node.value('@SiloAppID','INT'),
			@silosincache = Node.value('@SilosInCache','INT'),
			@dedupFlags = Node.value('@dedupFlags','INT')
	FROM	@sp_options.nodes('/MediaManager_SPOpType/CopyDetails/dedup') Tmpxml5(Node);
	select	@encType = Node.value('@encType','varchar(100)'),
			@encKeyLen = Node.value('@encKeyLen','varchar(100)')
	FROM	@sp_options.nodes('/MediaManager_SPOpType/CopyDetails/copyEncryption') tmpxml6(Node);
	select 	@siloDPMAId = Node.value('@MediaAgent', 'INT'),
			@siloDPLibId = Node.value('@Library', 'INT'),
			@siloDPDrivePoolId = Node.value('@DrivePool', 'INT'),
			@siloDPScratchPoolId = Node.value('@SpareGroup', 'INT')
	FROM	@sp_options.nodes('/MediaManager_SPOpType/CopyDetails/siloDPInfo/defaultDP') Tmpxml7(Node);
	SET @basiccycles = -1
 END
 DECLARE @defaultCopy INT
 DECLARE @defaultSnapCopy INT
 DECLARE @archGroupID INT
 DECLARE @todayDate INT
 DECLARE @SIDBStoreID INT
 DECLARE @ArchGroupCopyID INT
 DECLARE @LibraryID INT
 DECLARE @MasterPoolID INT
 DECLARE @DrivePoolID INT
 DECLARE @MediaTypeID INT
 DECLARE @comCellID INT
 DECLARE @RecordingFormatID INT
 DECLARE @ClientID INT
 DECLARE @todayDateTime DATETIME
 DECLARE @archFlags INT
 DECLARE @newSiloForSizeTB INT
 DECLARE @maxstreamNUM INT
 DECLARE @AgingRuleflags INT
 DECLARE @weekStart INT
 DECLARE @monthStart INT
 DECLARE @yearStart INT
 DECLARE @mediaPasswd VARCHAR(100)
 DECLARE @SpareGroupId INT
 DECLARE @LibType INT
 DECLARE @DEDUPXML XML
 DECLARE @streamFlags INT
 DECLARE @driveTypeId INT
 DECLARE @copy        INT
 DECLARE @ret INT
 DECLARE @SILOXML XML
 DECLARE @siloDataPathId INT
 DECLARE @minutesSinceDayStarts INT
SET @defaultCopy = 0
SET @defaultSnapCopy = 0
SET @archFlags = 0
SET @archFlags |= 16384
SET @newSiloForSizeTB = 0
SET @maxstreamNUM = 0
SET @AgingRuleflags = 2 --#define	AM_AGING_FLAGS_EXT_DIRTY	2	flag Defined in AMAgingRule.h
SET @weekStart = 5
SET @monthStart  = 1
SET @yearStart  = 0
SET @SIDBStoreID = 0
SET @o_xmltxt = ''
SET @o_error = 0
SET @streamFlags = 0
SET @driveTypeId = 0
SET @copy = 0
SET @siloDataPathId = 0
SET @minutesSinceDayStarts=0
SET @archFlags |= @copyFlag
select @mediaPasswd = value from GxGlobalParam where name='MediaPassword';
IF @mediaPasswd = '1' OR @mediaPasswd = '2'
BEGIN
	SET @mediaPasswd = ''
END
BEGIN TRANSACTION
DECLARE @RETVAL_ARCH_TMP TABLE(ERRORNUM INTEGER)
IF (@i_CreateOpt = 0)
BEGIN
	IF ISNULL((select count(*) from archGroup where name = @spname), 0) <> 0
	BEGIN
		SET @o_error = 1
		SET @EVCODE = (99 | (CAST(POWER(2, 24) AS BIGINT) * 80))
		SET @EVMSG = 'EV_E_SP_NAME_EXISTIG'
		SET @o_xmltxt = dbo.getXMLError((104 | (CAST(POWER(2, 24) AS BIGINT) * 80)),@EVCODE,@spname,NULL,NULL)
		GOTO ERROR_EXIT
	END
	INSERT archGroup(defaultCopy,name,description,maxStreams,type,incrSP,origCCcommCellID,
		 origCCarchGroupId,defaultSnapCopy,SIBlockSizeKB,AuxCopyAlertGB,
		 AuxCopyAlertDays,flags,mediaPassword,TimeZoneType,TimeZone)
	VALUES	(@defaultCopy,@spname,'',@maxstreams,1,@incrsp,0,0,0,@siblocksizekb,
		-1,-1,36,@mediaPasswd,0,'');
	select @archGroupID = id from archGroup where name = @spname;
END
ELSE
BEGIN
IF NOT EXISTS(select * from archGroup where name = @spname)
BEGIN
	SET @o_error = 1
	SET @EVCODE = (32 | (CAST(POWER(2, 24) AS BIGINT) * 80))
	SET @EVMSG = 'EV_E_ARCH_INVALID_STORAGE_POLICY'
	SET @o_xmltxt = dbo.getXMLError((32 | (CAST(POWER(2, 24) AS BIGINT) * 80)),@EVCODE,@spname,NULL,NULL)
	GOTO ERROR_EXIT
END
select @archGroupID = id from archGroup where name = @spname;
/*Get the copy no*/
 select @copy = max(copy) from archGroupCopy where archGroupId = @archGroupID
END
/*GetDate and convert into unixTime*/
select  @todayDate = dbo.GetUnixTime(GETDATE());
IF(@copyname = '')
BEGIN
	SET	@copyname = 'PC_'+cast(@archGroupID as varchar(100))
END
/*IF ISNULL((select count(*) from archGroupCopy where name = @copyname), 0) <> 0
BEGIN
	SET @o_error = 1
	SET @EVCODE = (100 | (CAST(POWER(2, 24) AS BIGINT) * 80))
	SET @EVMSG = 'EV_E_SP_COPY_NAME_EXISTIG'
	SET @o_xmltxt = dbo.getXMLError((104 | (CAST(POWER(2, 24) AS BIGINT) * 80)),@EVCODE,@copyname,NULL,NULL)
	GOTO ERROR_EXIT
END*/
IF ((@dedupFlags & 2097152) > 0)
SET @dedupFlags = @dedupFlags | 16777216
INSERT	archGroupCopy
		(archGroupId, copy, name, flags,
		maxMultiplex, isActive, type, startTime, waitForIfOffline,
		waitForIfBusy, archCheckStartTime, origCCcommCellID, origCCarchCopyId, sourceCopyId,
		delayedDays, maxStreamNum, archCheckValidPeriod, calendarId, SIDBStoreId,
		encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed,
		SIDBSnapIntervalHours, siloAppId, nDataInstance, description, dedupeFlags,
		blockCacheValidDays, nSiloStreams, silosInCache, siloRestoreMAClientId, siloRestoreClientId,
		sealStoreTaskId, extendedFlags, destMediaCopyId, archCheckValidPeriodType,
		endTime)
VALUES	(@archGroupID,@copy+1,@copyname,@archFlags,
		0, 1, 1, -@todayDate, 1,
		0, -@todayDate, 0, 0, @sourceCopyId,
		0, @maxstreamNUM, 0, 1, @SIDBStoreID,
		@encType, @encKeyLen, @isSnapCopy, @isMirrorCopy, 0,
		0, 0, 1, 'Copy created through qcreate command', @dedupFlags,
		0, 0, 0, 0, 0,
		0, 0, 0, 0,
		2147483647);
IF ISNULL((select count(*) from MMLibrary where AliasName = @library), 0) = 0
BEGIN
	SET @o_error = 1
	SET @EVCODE = (101 | (CAST(POWER(2, 24) AS BIGINT) * 80))
	SET @EVMSG = 'EV_E_LIBRARY_NOT_EXISTIG'
	SET @o_xmltxt = dbo.getXMLError((104 | (CAST(POWER(2, 24) AS BIGINT) * 80)),@EVCODE,@library,NULL,NULL)
	GOTO ERROR_EXIT
END
select @ArchGroupCopyID = id from archGroupCopy where name = @copyname and archGroupId = @archGroupID;
UPDATE ArchGroup SET defaultSnapCopy = @ArchGroupCopyID
WHERE id = @archGroupID AND defaultSnapCopy = 0 AND @isSnapCopy > 0
select @LibraryID = LibraryId from MMLibrary where AliasName = @library;
select @ClientID = id from APP_Client where net_hostname = @mediaagent
select @DrivePoolID = DrivePoolid,@MasterPoolID = MasterPoolID
from MMDrivePool where DrivePoolName = @drivepool AND ClientId = @ClientID
if @DrivePoolID is null
begin
	select @MasterPoolID = MasterPoolID from MMMasterPool where LibraryId = @LibraryID
	select @DrivePoolID = DrivePoolid from MMDrivePool where MasterPoolID = @MasterPoolID AND ClientId = @ClientID
end
SET @comCellID = 2
select DISTINCT @MediaTypeID = isnull(MediaTypeId,0) from MMMedia where libraryid = @LibraryID
SET @SpareGroupId = null
if(@sparegroup is not null)
begin
  select @SpareGroupId = isnull(SpareGroupId,0) from MMSpareGroup Where spareGroupName = @sparegroup
													AND LibraryId = @LibraryID
end
if(@SpareGroupId is null OR @SpareGroupId = 0)
begin
  SET  @SpareGroupId = isnull((select SpareGroupId from MMSpareGroup Where SpareGroupType = 2 AND LibraryId = @LibraryID) ,0)
end
select @LibType = LibraryTypeId from MMLibrary where libraryid = @LibraryID;
select DISTINCT @driveTypeId = drivetypeid from MMDrive where masterpoolid = @MasterPoolID
select DISTINCT @RecordingFormatID = RecordingFormatId from MMRecFmtMedTyp where DriveTypeId = @driveTypeId
	AND MediaTypeId = @MediaTypeID
SET  @o_agrcpyID = @ArchGroupCopyID
SET  @o_agrID = @archGroupID
IF @LibType = 3 AND @IsHardwareCompressed = 1
BEGIN
	SET @o_error = 1
	SET @EVCODE = (103 | (CAST(POWER(2, 24) AS BIGINT) * 80))
	SET @EVMSG = 'EV_E_HW_CAN_NOT_COMPRESS'
	SET @o_xmltxt = dbo.getXMLError((104 | (CAST(POWER(2, 24) AS BIGINT) * 80)),@EVCODE,NULL,NULL,NULL)
	GOTO ERROR_EXIT
END
IF @LibType = 1  AND @DedupEnable = 1
BEGIN
	SET @o_error = 1
	SET @EVCODE = (102 | (CAST(POWER(2, 24) AS BIGINT) * 80))
	SET @EVMSG = 'EV_E_DEDUP_CAN_NOT_ENABLE'
	SET @o_xmltxt = dbo.getXMLError((104 | (CAST(POWER(2, 24) AS BIGINT) * 80)),@EVCODE,NULL,NULL,NULL)
	GOTO ERROR_EXIT
END
IF (@i_CreateOpt <> 0)
BEGIN
	SET @maxstreams = (select maxStreams from archGroup where id = @archGroupId)
END
/*Create archStream*/
INSERT @RETVAL_ARCH_TMP EXEC archStreamCreate @archGroupID,@ArchGroupCopyID,0,@maxstreams,@streamFlags,@DrivePoolID,0,@MediaTypeID,@RecordingFormatID
 /*update ArchGroup with new defaultCopy Value*/
IF (@i_CreateOpt = 0)
BEGIN
 UPDATE ArchGroup SET defaultCopy = @ArchGroupCopyID WHERE Id = @archGroupID;
END
INSERT archAgingRule(copyId,retentionDays,fullCycles,flags,weekStart,monthStart,yearStart,archiverRetDays,minutesSinceDayStarts)
		VALUES	 (@ArchGroupCopyID,@basicdays,@basiccycles,@AgingRuleflags,@weekStart,@monthStart,@yearStart,
				 @archiverdays,@minutesSinceDayStarts);
INSERT MMDatapath (CopyId,DrivePoolId,HostClientId,Flag,SpareGroupId,ReadinessFlag,Priority,IsHardwareCompressed,
		ChunkSizeMB,FlushBlockSizeKB,UseHardwareEncryption)
	VALUES(@ArchGroupCopyID,@DrivePoolID,@ClientID,7,@SpareGroupId,0,0,@IsHardwareCompressed,0,0,0);
IF ((@dedupFlags & 2097152) > 0)
BEGIN
	SET @copynameSILO = @copyname + '_SILO_Copy'
	IF @silosInCache = 0
		SET @silosInCache = 1
	INSERT	archGroupCopy
			(archGroupId, copy, name, flags,
			maxMultiplex, isActive, type, startTime, waitForIfOffline,
			waitForIfBusy, archCheckStartTime, origCCcommCellID, origCCarchCopyId, sourceCopyId,
			delayedDays, maxStreamNum, archCheckValidPeriod, calendarId, SIDBStoreId,
			encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed,
			SIDBSnapIntervalHours, siloAppId, nDataInstance, description, dedupeFlags,
			blockCacheValidDays, nSiloStreams, silosInCache, siloRestoreMAClientId, siloRestoreClientId,
			sealStoreTaskId, archCheckValidPeriodType)
VALUES	(@archGroupID,@copy+2,@copynameSILO,@archFlags | 524288,
			0, 1, 1, -@todayDate, 1,
			0, -@todayDate, 0, 0, @ArchGroupCopyID,
			0, @maxstreamNUM, 0, 1, 0,
			@encType, @encKeyLen, 0, 0, 0,
			0, @siloAppId, 1, 'SILO Copy created through qcreate command', @dedupFlags,
			0, 0, @silosInCache, 0, 0,
			0, 0);
	SET @siloCopyId = @@IDENTITY
	INSERT archAgingRule(copyId,retentionDays,fullCycles,flags,weekStart,monthStart,yearStart,archiverRetDays,minutesSinceDayStarts )
		VALUES	 (@siloCopyId,-1,-1,@AgingRuleflags,@weekStart,@monthStart,@yearStart,
				 @archiverdays,@minutesSinceDayStarts);
	SET @SILOXML = '<CVGui_CreateOnDemandBackupSetReq dataArchGrpId="'+ convert(char(5), @archGroupId) + '" siloCopyId="' + convert(char(5), @ArchGroupCopyId) + '" />'
	declare @tblODM table (backupsetId int, subclientId int, errorString varchar(1024))
	insert @tblODM EXEC @ret = AppCreateOnDemandBackupSet @SILOXML
	IF (@ret <> 0)
	BEGIN
                IF (@ret = -1)
                BEGIN
		   SET @o_error = 1
		   SET @EVCODE = (1308 | (CAST(power(2, 23) as bigint) * 70))
		   SET @EVMSG = 'GUIMSG_ARCHMGR_CREATE_SILO_BACKUPSET_DB_ERROR'
		   SET @o_xmltxt = dbo.getXMLError((1308 | (CAST(power(2, 23) as bigint) * 70)),@EVCODE,NULL,NULL,NULL)
		   GOTO ERROR_EXIT
                END
	END
	set @siloappid = (select subclientId from @tblODM)
	update archGroupCopy set siloAppId = @siloappid where id = @ArchGroupCopyId
	SET @streamFlags = 1
	SET @maxstreams = 1
	INSERT @RETVAL_ARCH_TMP EXEC archStreamCreate @archGroupID,@siloCopyId,0,@maxstreams,@streamFlags,@DrivePoolID,0,@MediaTypeID,@RecordingFormatID
	INSERT MMDatapath (CopyId,DrivePoolId,HostClientId,Flag,SpareGroupId,ReadinessFlag,Priority,IsHardwareCompressed,
		ChunkSizeMB,FlushBlockSizeKB,UseHardwareEncryption)
	VALUES(@siloCopyId,@siloDPDrivePoolId,@siloDPMAId,12,@siloDPScratchPoolId,0,0,0,0,0,0);
	SET @siloDataPathId = @@IDENTITY
	declare @tblError table (errorCode int)
	insert into @tblError
	EXEC ArchAddSiloDataPath @siloAppId, @siloDataPathId
	if exists (select * from @tblError where errorCode <> 0)
	BEGIN
		   SET @o_error = 1
		   SET @EVCODE = (1308 | (CAST(power(2, 23) as bigint) * 70))
		   SET @EVMSG = 'GUIMSG_FAILED_TO_ADD_DATAPATH'
		   SET @o_xmltxt = dbo.getXMLError((1308 | (CAST(power(2, 23) as bigint) * 70)),@EVCODE,NULL,NULL,NULL)
		   GOTO ERROR_EXIT
	END
END
 IF (@DedupEnable = 1 ) --If Deduplication is enabled
 BEGIN
		SET @DEDUPXML = '
			<MediaManager_Deduplication SPName = "'+@spname+'"
					CopyName = "'+@copyname+'"
            		DedupEnable = "1"
					Path = "'+@pathname+'"
					SiloAppID = "'+CAST(@siloappid AS VARCHAR(100))+'"
					CommCellID = "'+CAST(@comCellID AS VARCHAR(100))+'"
					ClientID = "'+CAST(@ClientID AS VARCHAR(100))+'"
					SilosInCache = "'+CAST(@silosincache AS VARCHAR(100))+'" />'
	--DECLARE @ret int
	EXEC @ret = archXMLSetStoragePolicyDEDUP @DEDUPXML
	IF (@ret <> 0)
	BEGIN
                IF (@ret = -1)
                BEGIN
		   SET @o_error = 1
		   SET @EVCODE = (1414 | (CAST(power(2, 23) as bigint) * 124))
		   SET @EVMSG = 'EV_E_MM_DB_SIDB_EXIST_FOR_COPY'
		   SET @o_xmltxt = dbo.getXMLError((1414 | (CAST(power(2, 23) as bigint) * 124)),@EVCODE,NULL,NULL,NULL)
		   GOTO ERROR_EXIT
                END
	END
 END
	IF @o_error = 0
	BEGIN
		COMMIT TRANSACTION
	END
ERROR_EXIT:
	IF @o_error <> 0
	BEGIN
		ROLLBACK TRANSACTION
	END
SELECT @o_agrcpyID, @o_agrID, @o_error, @o_xmltxt
GO

IF EXISTS (select * from GxQscripts where name = 'archXMLStoragePolicyOperation')
	delete from GxQscripts where name = 'archXMLStoragePolicyOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archXMLStoragePolicyOperation')
	delete from GXDBVersions where aliasname = 'archXMLStoragePolicyOperation'
GO

insert into GXDBVersions values(2, 'archXMLStoragePolicyOperation',  '00000000000000000000', 'archXMLStoragePolicyOperation', '00000000000000000000')
GO

