

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archXMLSetStoragePolicyDEDUP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archXMLSetStoragePolicyDEDUP')
BEGIN
	print '>>> Drop Stored Procedure: archXMLSetStoragePolicyDEDUP <<<'
	drop procedure archXMLSetStoragePolicyDEDUP
END
IF EXISTS (select * from GxQscripts where name='archXMLSetStoragePolicyDEDUP')
	delete from GxQscripts where name = 'archXMLSetStoragePolicyDEDUP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archXMLSetStoragePolicyDEDUP')
	delete from GXDBVersions where aliasname = 'archXMLSetStoragePolicyDEDUP'
GO
print '... Creating Procedure: archXMLSetStoragePolicyDEDUP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archXMLSetStoragePolicyDEDUP
  @sp_options XML
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/*Local Variables*/
 DECLARE @copyname varchar(100)
 DECLARE @ClientID INT
 DECLARE @comCellID INT
 DECLARE @dedupEnable INT
 DECLARE @idxPoolID INT
 DECLARE @idxCacheID INT
 DECLARE @idxAccessPathID INT
 DECLARE @idxcacheDiskFreeWarningThreshhold INT
 DECLARE @IdxCacheType INT
 DECLARE @pathname varchar(100)
 DECLARE @ArchGroupCopyID INT
 DECLARE @spname varchar(100)
 DECLARE @siloappid INT
 DECLARE @silosincache INT
 DECLARE @SIDBStoreName VARCHAR(100)
 DECLARE @todayDate INT
 DECLARE @SIDBStoreID INT
 DECLARE @archFlags INT
 DECLARE @newSiloForSizeTB INT
 DECLARE @retVal INT
 DECLARE @storeId INT
 SET @retVal = 0
BEGIN
	select  @spname = Node.value('@SPName','varchar(100)')
	FROM	@sp_options.nodes('MediaManager_Deduplication') tmpxml (Node);
	select	@copyname = Node.value('@CopyName','varchar(100)')
	FROM	@sp_options.nodes('MediaManager_Deduplication') Tmpxml2(Node);
	select	@dedupEnable = Node.value('@DedupEnable','INT'),
			@pathname = Node.value('@Path','varchar(100)'),
			@siloappid = Node.value('@SiloAppID','INT'),
			@silosincache = Node.value('@SilosInCache','INT')
	FROM	@sp_options.nodes('MediaManager_Deduplication') Tmpxml5(Node);
	select	@comCellID = Node.value('@CommCellID','INT'),
		@ClientID = Node.value('@ClientID','INT')
	FROM	@sp_options.nodes('MediaManager_Deduplication') Tmpxml6(Node);
END
	SET @SIDBStoreName = 'SIDB_'+@spname+'_'+@copyname
	SET @SIDBStoreID = 0
	SET @idxcacheDiskFreeWarningThreshhold = 1024
	SET @IdxCacheType = 2 --  #define  IDX_CACHE_TYPE_SIDB		2 defined in mms2idxdefines.h
	SET @archFlags = 262144
	SET @newSiloForSizeTB = 100
BEGIN
	select @ArchGroupCopyID = id from archGroupCopy where name = @copyname;
	select  @todayDate = dbo.GetUnixTime(GETDATE());
	insert into idxPool (Description,Enabled,IsShared,AgeingNoOfDays)
	values('SIDB Index Pool ('+@SIDBStoreName+')',1,1,35);
	select @idxPoolId = idxPoolId from idxPool where Description like '%'+@SIDBStoreName+'%';
	INSERT idxCaChe (IdxPoolId,Description,Enabled,Creationtime,SoftState,OfflineReason,AgeingPercentDiskspace,
			 FillUpOrder,FreeDiskSpaceMB,LastUpdateTime,LastUpdateAPId,DiskUsageMB,DiskUsageLastChecked,
			 DiskFreeThresholdMB,DiskFreeWarningThreshholdMB,IdxCacheType,DiskReadSpeed,DiskWriteSpeed,
			 CatalogServerClientId,flags,TotalCapacityMB)
		VALUES (@idxPoolId,'SIDB Index Cache ('+@SIDBStoreName+')',1,@todayDate,1,0,90,1,0,0,@idxPoolId,
			0,0,0,@idxcacheDiskFreeWarningThreshhold ,@IdxCacheType,0,0,0,0,0);
	select @idxCacheID = idxCacheId from idxCaChe where idxPoolId = @idxPoolId;
	-- validate if the access path is already used by someone.
	IF EXISTS (select * from IdxAccessPath where Path = @pathname)
	BEGIN
		SET @retVal = -1
		goto ERROR_EXIT
	END
	INSERT idxAccessPath (IdxCacheId,ClientId,Path,Username,Password,Enabled,SoftState,OfflineReason,Priority,
				LocalIndexTimeStamp,ActualDaysIndexRetain,Flags,AgeingNoOfDays,AgeingPercentDiskspace,
				DiskFreeThresholdMB,DiskFreeWarningThreshholdMB,TotalCapacityMB,StagingCachePath, VolumeGUID)
		 VALUES		(@idxCacheID,@ClientID,@pathname,'','',1,1,0,1,0,0,0,0,0,0,0,0,'', '');
	select @idxAccessPathID = idxAccessPathId from idxAccessPath where IdxCacheId = @idxCacheID;
--use mmAddSIDBStore proc for the following later
	INSERT INTO IdxSIDBStore(SIDBStoreName,SIDBStoreAliasName,CommCellId,IdxCacheId,IdxAccessPathId,ClientId,
				FirstBackupTime,MinObjSizeKB,oldestEligibleObjArchiveTime,SignatureType,flags,
				TotalDataSizeBytes,InstancedDataSizeBytes,Status,LastAccessTime,CreatedTime,
				SealedTime,origCCSIDBStoreId,Version,SIDBSnapPath,LastSnapTime,LastRecoveryTime,
				SealedReason,SIDBSiloedTime,SIDBSiloStatus,SIDBSiloJobId, SubStoreCount, MaxAllowedConnections, MaxNumOfAFsInSecFile)
		  VALUES		(@SIDBStoreName+'('+CAST(getdate() AS VARCHAR(100))+')',@SIDBStoreName,@comCellID,
						@idxCacheID,@idxAccessPathID,@ClientID,-1,50,365,4,2,0,0,0,0,@todayDate,0,0,-1,'',0,0,0,0,0,0,1,0,0);
	SET @storeId = SCOPE_IDENTITY()
	DECLARE @AFPerSec INT = 0 -- Set it to 0, older MAs anyway wont read that field.
	SELECT @AFPerSec = 1
		FROM APP_Client C WITH (NOLOCK)
		    LEFT OUTER JOIN APP_VMToPMMap MAP WITH (READUNCOMMITTED) ON MAP.VMClientId = C.Id
		    INNER JOIN SimInstalledPackages PKG WITH (READUNCOMMITTED) ON PKG.ClientId = ISNULL(MAP.PMClientId, C.Id)
WHERE (C.releaseId > 16) OR ((C.releaseId = 16)  AND (PKG.HighestSP >= 13))
	AND C.id = @ClientID
	INSERT INTO IdxSIDBSubStore
           (SIDBStoreId, commCellId, GroupNumber, IdxCacheId, IdxAccessPathId, ClientId, FirstBackupTime
           ,flags, TotalDataSizeBytes, InstancedDataSizeBytes,Status, LastAccessTime
           ,CreatedTime, SealedTime, Version, SIDBSnapPath, LastSnapTime, origSubStoreId, ReconLevel, LastSnapJobId, DDBBackupCSGUID, PrimaryId, MemDbTimeStamp, CorruptionTime, ZeroRefBatchSeq, StartLogSequence, EndLogSequence, SnapLogSequence, MaxNumOfAFsInSecFile, ExtendedFlags, DDBSubClientId, PageSize)
     	VALUES
           (@storeId, @comCellID, 0, @idxCacheID, @idxAccessPathID, @ClientID, -1
           ,2, 0, 0, 0, 0
           ,@todayDate, 0, -1, '', 0, 0, 0, 0, '', 0, 0, 0, 0, '', '', '', @AFPerSec, 0, 0, 0)
	select @SIDBStoreID = SIDBStoreId from IdxSIDBStore where idxcacheId = @idxCacheID;
	INSERT archCopySIDBStore (CopyId,SIDBStoreId,CommCellId,flags,TotalDataSizeBytes,InstancedDataSizeBytes)
			VALUES	(@ArchGroupCopyID,@SIDBStoreID,@comCellID,0,0,0);
	UPDATE archGroupCopy SET SIDBStoreId = @SIDBStoreID,dedupeflags |= @archFlags WHERE id = @ArchGroupCopyID;
	UPDATE archGroup SET flags=36 WHERE name=@spname;
ERROR_EXIT:
RETURN @retVal
END
GO

IF EXISTS (select * from GxQscripts where name = 'archXMLSetStoragePolicyDEDUP')
	delete from GxQscripts where name = 'archXMLSetStoragePolicyDEDUP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archXMLSetStoragePolicyDEDUP')
	delete from GXDBVersions where aliasname = 'archXMLSetStoragePolicyDEDUP'
GO

insert into GXDBVersions values(2, 'archXMLSetStoragePolicyDEDUP',  '00000000000000000000', 'archXMLSetStoragePolicyDEDUP', '00000000000000000000')
GO

