

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archWillMoveSnapJobToMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archWillMoveSnapJobToMedia.sp,v $ $Id: archWillMoveSnapJobToMedia.sp,v 1.5.200.2 2018/03/22 01:18:37 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archWillMoveSnapJobToMedia <<<'

IF EXISTS (select * from sysobjects where name='archWillMoveSnapJobToMedia')
	drop procedure archWillMoveSnapJobToMedia
IF EXISTS (select * from GxQscripts where name='archWillMoveSnapJobToMedia')
	delete from GxQscripts where name = 'archWillMoveSnapJobToMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archWillMoveSnapJobToMedia')
	delete from GXDBVersions where aliasname = 'archWillMoveSnapJobToMedia'
GO
print '... Creating Procedure: archWillMoveSnapJobToMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archWillMoveSnapJobToMedia
  @i_jobId integer,
  @i_appId integer,
  @i_appType integer,
  @i_archGroupId integer,
  @i_startDate integer,
  @i_backupLevel integer,
  @i_fullCycleNum integer,
  @i_nextFullTime integer,
  @i_today integer
AS
  DECLARE @moveToMedia INTEGER;
  DECLARE @deferredDays INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@i_commCellId   INTEGER
SET	@i_commCellId = 2
DECLARE	@l_moveToMedia	INTEGER
DECLARE	@l_deferredDays	INTEGER
SET	@l_moveToMedia = 0
SET	@l_deferredDays = 0
-- Check if backup of snapshot is applicable
IF NOT EXISTS (
	SELECT * FROM JMOpTable
	WHERE	appTypeType = @i_appType AND operation = 60)
	GOTO RETURN_PROC
DECLARE	@l_enabled		INT
DECLARE	@l_type			INT
DECLARE	@l_flags		INT
DECLARE	@l_startTime	INT
DECLARE	@l_sourceCopyId	INT
DECLARE	@l_numPeriod	INT
DECLARE	@l_dayNumber	INT
DECLARE	@l_currPeriodBegin	INT
DECLARE	@l_currPeriodEnd	INT
SET @l_enabled = 0
SELECT	@l_enabled = enabled,
		@l_type = type,
		@l_flags = flags,
		@l_startTime = startTime,
		@l_sourceCopyId = sourceCopyId,
		@l_deferredDays = a.deferredDays,
		@l_numPeriod = numPeriod,
		@l_dayNumber = dayNumber,
		@l_currPeriodBegin = currPeriodBegin,
		@l_currPeriodEnd = currPeriodEnd
FROM	archMaterializeSnapshotProp a WITH (NOLOCK)
WHERE	archGroupId = @i_archGroupId
IF @l_sourceCopyId = 0
	SELECT @l_sourceCopyId = defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = @i_archGroupId
IF	@l_enabled = 0
OR @l_type = 9
OR @l_type <> 0 AND (@i_backupLevel NOT IN (1, 64, 128, 1024, 32768) AND dbo.GetBkpLevelOfSnapJobs(@i_jobId, @i_CommCellId, @l_sourceCopyId) <> 1)
 OR @i_startDate < @l_startTime
	GOTO RETURN_PROC
IF	@l_type = 0 OR @l_type = 1 AND @l_numPeriod = 1
	GOTO MOVE_TO_MEDIA
-- Apply selection rules.
IF	@l_type IN (1, 10, 3, 2, 4, 6)
BEGIN
	DECLARE @l_startDate	INT
	DECLARE @l_fullCycleNum	INT
	SELECT	TOP 1 @l_startDate = J.servStartDate, @l_fullCycleNum = J.fullCycleNum
	FROM	JMBkpStats J WITH (NOLOCK), JMJobSnapshotStats S WITH (NOLOCK)
	WHERE	J.jobId = S.jobId AND J.commCellId = S.commCellId
		AND S.appId = @i_appId AND S.materializationStatus IN (100, 101, 102, 103) AND S.disabled & (1+256) = 0
	ORDER BY J.servStartDate DESC
IF	@l_type = 1
	BEGIN
		IF	@i_fullCycleNum < (@l_numPeriod + @l_fullCycleNum)
			GOTO RETURN_PROC
	END
	ELSE
IF	@l_type IN (10, 3, 2, 4, 6)
	BEGIN
		IF	@l_startDate >= @l_currPeriodBegin
		OR	@i_startDate <  @l_currPeriodBegin
			AND (@l_startDate >= (@l_currPeriodBegin - (@l_currPeriodEnd - @l_currPeriodBegin))
OR @l_flags & 4096 = 0)
OR	@l_flags & 4096 <> 0
AND (@l_flags & 8192 <> 0 AND @i_startDate >= @l_currPeriodBegin
OR @l_flags & 8192 = 0 AND @i_nextFullTime >= @l_currPeriodBegin AND @i_nextFullTime < @l_currPeriodEnd)
			GOTO RETURN_PROC
	END
END
MOVE_TO_MEDIA:
SET	@l_moveToMedia = 1
RETURN_PROC:
SELECT	@l_moveToMedia, @l_deferredDays
RETURN  0;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archWillMoveSnapJobToMedia')
	delete from GxQscripts where name = 'archWillMoveSnapJobToMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archWillMoveSnapJobToMedia')
	delete from GXDBVersions where aliasname = 'archWillMoveSnapJobToMedia'
GO

insert into GXDBVersions values(2, 'archWillMoveSnapJobToMedia',  '00010005020000020000', 'archWillMoveSnapJobToMedia', '00010005020000020000')
GO

