

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archVolumeByJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archVolumeByJob.sp,v $ $Id: archVolumeByJob.sp,v 1.10.210.1 2018/03/22 00:59:51 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archVolumeByJob <<<'

IF EXISTS (select * from sysobjects where name='archVolumeByJob')
	drop procedure archVolumeByJob
IF EXISTS (select * from GxQscripts where name='archVolumeByJob')
	delete from GxQscripts where name = 'archVolumeByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archVolumeByJob')
	delete from GXDBVersions where aliasname = 'archVolumeByJob'
GO
print '... Creating Procedure: archVolumeByJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archVolumeByJob
  @i_jobId integer,
  @i_commCellId integer,
  @i_dataType integer,
  @i_noPartialJob integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_archCopyId integer;
  DECLARE @o_volumeId integer;
  DECLARE @o_volumeFlags integer;
  DECLARE @o_mediaId integer;
  DECLARE @o_uniqueId char(256);
  DECLARE @o_barCode char(256);
  DECLARE @o_mediaTypeId integer;
  DECLARE @o_mediaFlags integer;
SET NOCOUNT ON
DECLARE @tblAFCopy	TABLE (archFileId INT, commcellId INT, dataType INT, archCopyId INT)
DECLARE @tblChunk	TABLE (archChunkId BIGINT, commCellId INT, archCopyId INT)
DECLARE @tblVolume	TABLE (volumeId INT, archCopyId INT)
INSERT	INTO @tblAFCopy
SELECT	AF.id, @i_commCellId, AF.fileType, AFC.archCopyId
FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
WHERE	AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId
	AND AF.id = AFC.archFileId AND (@i_dataType = 0 OR AF.fileType = @i_dataType)
IF @i_noPartialJob <> 0
BEGIN
DELETE	@tblAFCopy
FROM	@tblAFCopy a, JMJobDataStats b WITH (NOLOCK)
WHERE	b.jobId = @i_jobId
	AND b.archGrpCopyId = a.archCopyId
	AND b.dataType = a.dataType
	AND b.commCellId = @i_commCellId AND b.status <> 100
END
INSERT	INTO @tblChunk
SELECT	A.archChunkId, A.commcellId, A.archCopyId
FROM	@tblAFCopy T, archChunkMapping A WITH (NOLOCK)
WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commcellid AND A.archCopyId = T.archCopyId
INSERT	INTO @tblVolume
SELECT	A.volumeId, T.archCopyId
FROM	@tblChunk T, archChunk A WITH (NOLOCK)
WHERE	A.id = T.archChunkId AND A.commCellId = T.commCellId
GROUP BY A.volumeId, T.archCopyId
SELECT	A.archCopyId, B.VolumeId, B.VolumeFlags, C.MediaId, C.UniqueId, C.BarCode, C.MediaTypeId, C.MediaFlags
FROM	@tblVolume A, MMVolume B WITH (NOLOCK), MMMedia C WITH (NOLOCK)
WHERE	A.volumeId = B.VolumeId AND B.MediaId = C.MediaId
ORDER BY A.archCopyId ASC, B.VolumeId ASC
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archVolumeByJob')
	delete from GxQscripts where name = 'archVolumeByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archVolumeByJob')
	delete from GXDBVersions where aliasname = 'archVolumeByJob'
GO

insert into GXDBVersions values(2, 'archVolumeByJob',  '00010010021000010000', 'archVolumeByJob', '00010010021000010000')
GO

