

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archVolumeByAuxCopyJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archVolumeByAuxCopyJob.sp,v $ $Id: archVolumeByAuxCopyJob.sp,v 1.7.276.3 2020/05/30 00:30:20 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archVolumeByAuxCopyJob')
BEGIN
	print '>>> Drop Stored Procedure: archVolumeByAuxCopyJob <<<'
	drop procedure archVolumeByAuxCopyJob
END
IF EXISTS (select * from GxQscripts where name='archVolumeByAuxCopyJob')
	delete from GxQscripts where name = 'archVolumeByAuxCopyJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archVolumeByAuxCopyJob')
	delete from GXDBVersions where aliasname = 'archVolumeByAuxCopyJob'
GO
print '... Creating Procedure: archVolumeByAuxCopyJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archVolumeByAuxCopyJob
  @i_auxCopyJobID integer,
  @i_commCellId integer,
  @i_noPartialJobs integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_archCopyId integer;
  DECLARE @o_volumeId integer;
  DECLARE @o_volumeFlags integer;
  DECLARE @o_mediaId integer;
  DECLARE @o_uniqueId char(256);
  DECLARE @o_barCode char(256);
  DECLARE @o_mediaTypeId integer;
  DECLARE @o_mediaFlags integer;
SET NOCOUNT ON
DECLARE @currentTime INT = dbo.GetUnixTime(GetUTCDate())
SELECT  DISTINCT RH.CopyId, MV.VolumeId, MV.VolumeFlags, M.MediaId, M.UniqueId, M.BarCode, M.MediaTypeId, M.MediaFlags
FROM    JMJobResourceHistory RH WITH (READUNCOMMITTED), MMVolume MV WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED)
WHERE
    RH.jobId = @i_auxCopyJobID
    AND RH.commCellId = @i_commCellId
    AND RH.ReservationType = 2
    AND RH.totalUncompBytes > 0
    AND MV.VolumeId = RH.volumeId
    AND M.MediaId = MV.MediaId
UNION
SELECT  DISTINCT RH.CopyId, MV.VolumeId, MV.VolumeFlags, M.MediaId, M.UniqueId, M.BarCode, M.MediaTypeId, M.MediaFlags
FROM    JMJobResourceHistory RH WITH (READUNCOMMITTED), MMVolume MV WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED)
WHERE
    RH.jobId = @i_auxCopyJobID
    AND RH.commCellId = @i_commCellId
    AND RH.ReservationType = 2
    AND RH.totalUncompBytes = 0
    AND RH.ReleaseTime > 0
    AND EXISTS (SELECT 1 FROM archChunk AC WITH (READUNCOMMITTED) WHERE AC.VolumeId = RH.VolumeID AND AC.physicalSize > 0 AND AC.createTime BETWEEN RH.ReservationTime AND RH.ReleaseTime)
    AND MV.VolumeId = RH.volumeId
    AND M.MediaId = MV.MediaId
UNION
SELECT  DISTINCT RH.CopyId, MV.VolumeId, MV.VolumeFlags, M.MediaId, M.UniqueId, M.BarCode, M.MediaTypeId, M.MediaFlags
FROM    JMJobResourceHistory RH WITH (READUNCOMMITTED), MMVolume MV WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED)
WHERE
    RH.jobId = @i_auxCopyJobID
    AND RH.commCellId = @i_commCellId
    AND RH.ReservationType = 2
    AND RH.totalUncompBytes = 0
    AND RH.ReleaseTime = 0
    AND EXISTS (SELECT 1 FROM archChunk AC WITH (READUNCOMMITTED) WHERE AC.VolumeId = RH.VolumeID AND AC.physicalSize > 0 AND AC.createTime BETWEEN RH.ReservationTime AND @currentTime)
    AND MV.VolumeId = RH.volumeId
    AND M.MediaId = MV.MediaId
ORDER BY RH.CopyId, MV.VolumeId
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archVolumeByAuxCopyJob')
	delete from GxQscripts where name = 'archVolumeByAuxCopyJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archVolumeByAuxCopyJob')
	delete from GXDBVersions where aliasname = 'archVolumeByAuxCopyJob'
GO

insert into GXDBVersions values(2, 'archVolumeByAuxCopyJob',  '00010007027600030000', 'archVolumeByAuxCopyJob', '00010007027600030000')
GO

