

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archViewSearchedJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archViewSearchedJobs.sp,v $ $Id: archViewSearchedJobs.sp,v 1.7.48.2 2018/03/22 01:11:24 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archViewSearchedJobs <<<'

IF EXISTS (select * from sysobjects where name='archViewSearchedJobs')
	drop procedure archViewSearchedJobs
IF EXISTS (select * from GxQscripts where name='archViewSearchedJobs')
	delete from GxQscripts where name = 'archViewSearchedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewSearchedJobs')
	delete from GXDBVersions where aliasname = 'archViewSearchedJobs'
GO
print '... Creating Procedure: archViewSearchedJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archViewSearchedJobs
  @dummy integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_commCellId integer
  DECLARE @o_commCellName char(255)
  DECLARE @o_jobId integer
  DECLARE @o_dataState integer
  DECLARE @o_physicalSize bigint
  DECLARE @o_clientId integer
  DECLARE @o_clientName char(255)
  DECLARE @o_appTypeId integer
  DECLARE @o_appTypeName char(255)
  DECLARE @o_backupSetId integer
  DECLARE @o_backupSetName char(255)
  DECLARE @o_subClientId integer
  DECLARE @o_subClientName char(255)
  DECLARE @o_instanceId integer
  DECLARE @o_instanceName char(255)
  DECLARE @o_startTime datetime
  DECLARE @o_endTime datetime
  DECLARE @o_level integer
  DECLARE @o_status integer
  DECLARE @o_fullCycleNum integer
  DECLARE @o_seqNumInCycle integer
  DECLARE @o_duration integer
  DECLARE @o_streamNum integer
  DECLARE @o_initFrom integer
  DECLARE @o_attributes integer
  DECLARE @o_failReason char(255)
  DECLARE @o_userName char(255)
  DECLARE @o_totalWriteTime integer
  DECLARE @o_scanFileFailures integer
  DECLARE @o_scanFolderFailures integer
  DECLARE @o_bkpFileFailures integer
  DECLARE @o_bkpFolderFailures integer
  DECLARE @o_numObjects integer
  DECLARE @o_retentionDays integer
  DECLARE @o_pinJobEndTime datetime
  DECLARE @o_agedTime integer
  DECLARE @o_flagsCI integer
  DECLARE @o_minFileType integer
  DECLARE @o_contentIndexTime datetime
  DECLARE @o_archGroupId integer
  DECLARE @o_archGroupName NVARCHAR(255)
SET NOCOUNT ON
DECLARE @MAXINT	integer
SET	@MAXINT	= 0x7FFFFFFF
/* This temp table must be created and populated before executing this procedure.
CREATE TABLE #tempJobs(
	jobId int, commCellId int)
*/
CREATE TABLE #tempJobFromAF(
	jobId int, commCellId int, archGroupId int, appId int, flagsCI int, minFileType int, contentIndexTime int,
	PRIMARY KEY(jobId, commCellId))
CREATE TABLE #tempApps(
appId int,		subclientName varchar(255),
backupSet int,	backupSetName varchar(255),
instance int,	instanceName varchar(255),
appType int,	appTypeName varchar(255),
clientId int,	clientName varchar(255),
	isDMAppType int,
	PRIMARY KEY(appId))
CREATE TABLE #tempJobStats(
	commCellId			int,
commCellName		varchar(255),
	jobId				int,
	dataState			int,
	physicalSize		bigint,
	clientId			int,
clientName			varchar(255),
	appTypeId 			int,
appTypeName			varchar(255),
	backupSetId			int,
backupSetName		varchar(255),
	subClientId 		int,
subClientName		varchar(255),
	instanceId 			int,
instanceName		varchar(255),
	startTime			int,
	endTime				int,
	level				int,
	status				int,
	fullCycleNum		int,
	seqNumInCycle		int,
	duration			int,
	streamNum			int,
	initFrom			int,
	attributes			int,
failReason			varchar(255),
userName			varchar(255),
	totalWriteTime		int,
	scanFileFailures	int,
	scanFolderFailures	int,
	bkpFileFailures		int,
	bkpFolderFailures	int,
	numObjects			int,
	retentionDays		int,
	pinJobEndTime		bigint,
	agedTime			int,
	flagsCI				int,
	minFileType			int,
	contentIndexTime	int,
	archGroupId			int,
archGroupName		nvarchar(255),
	PRIMARY KEY(jobId, commCellId))
CREATE TABLE #tempJobRetention(
	jobId INT, commCellId INT, archGrpCopyId INT,
	retentionDays INT, extRetentionFlags INT, extRetentionDays INT,
	manualRetentionEndTime BIGINT, manualRetaided INT,
	PRIMARY KEY(jobId, commCellId, archGrpCopyId))
CREATE TABLE #maxJobRetention(
	jobId INT, commCellId INT, retentionDays INT, extRetentionDays INT, manualRetentionEndTime BIGINT,
	PRIMARY KEY(jobId, commCellId))
INSERT INTO #tempJobFromAF
SELECT	a.jobId, a.commCellId, archGroupId, a.appId, MAX(a.flags & 0x1F0), MIN(a.fileType), MAX(a.contentIndexTime)
FROM	archFile a WITH (NOLOCK), #tempJobs b
WHERE	a.jobId = b.jobId AND a.commCellId = b.commCellId
AND a.fileType = 1 AND a.isValid = 1
GROUP BY a.jobId, a.commCellId, archGroupId, a.appId
INSERT	INTO #tempApps
SELECT	a.id, a.subclientName,
		a.backupSet,(select name from APP_BackupSetName where id = a.backupSet),
		a.instance,	(select name from APP_InstanceName  where id = a.instance),
		a.appTypeId,(select name from APP_iDAType where type = a.appTypeId),
		a.clientId, (select name from APP_Client where id = a.clientId),
		0
FROM	APP_Application a, (SELECT DISTINCT appId FROM #tempJobFromAF) b
WHERE	a.id = b.appId
UPDATE	#tempApps SET isDMAppType = 1
WHERe	appType IN (SELECT appTypeId FROM APP_IDATypeHandlingInfo WITH (NOLOCK) WHERE isDMAppType = 1)
INSERT INTO #tempJobStats
SELECT	J.commCellId, (select aliasName from APP_CommCell WITH (NOLOCK) where id = J.commCellId),
		J.jobId, B.dataStatus,
		(case B.totalCompBytes when 0 then B.totalUncompBytes else B.totalCompBytes end),
		A.clientId, A.clientName, A.appType, A.appTypeName, A.backupSet, A.backupSetName,
		A.appId, A.subclientName, A.instance, A.instanceName,
		B.servStartDate, B.servEndDate, B.bkpLevel, B.displayStatus, B.fullCycleNum, B.cycleSequence,
		B.duration, B.numStreams, B.initFrom, B.bkpAttributes, B.failureReason, B.username, B.totalWriteTime,
		B.scanFileFailures, B.scanFolderFailures, B.backupFileFailures, B.backupFolderFailures,
		(select sum(numObjects) from JMBkpAtmptStats WITH (NOLOCK) where jobId = J.jobId and commCellId = J.commCellId),
		0/*retentionDays*/, 0/*pinJobEndTime*/, B.agedTime, J.flagsCI, J.minFileType, J.contentIndexTime,
		J.archGroupId, (select name from archGroup WITH (NOLOCK) where id = J.archGroupId)
FROM	#tempApps A, JMBkpStats B WITH (NOLOCK), #tempJobFromAF J
WHERE	B.jobId = J.jobId AND B.commCellId = J.commCellId
	AND A.appId = J.appId
INSERT INTO #tempJobStats
SELECT	J.commCellId, (select aliasName from APP_CommCell WITH (NOLOCK) where id = J.commCellId),
		J.jobId, B.dataStatus, B.TotalSize,
		A.clientId, A.clientName, A.appType, A.appTypeName, A.backupSet, A.backupSetName,
		A.appId, A.subclientName, A.instance, A.instanceName,
		B.servStart, B.servEnd, B.ER_BkpLevel, B.status, B.fullCycleNum, 0/*B.cycleSequence*/,
		0/*duration*/, B.noOfStreams, B.initFrom, 0/*bkpAttributes*/, B.failureReason, B.username, B.totalWriteTime,
		0/*scanFileFailures*/, 0/*scanFolderFailures*/, 0/*backupFileFailures*/, 0/*backupFolderFailures*/, 0/*numObjects*/,
		0/*retentionDays*/, 0/*pinJobEndTime*/, 0/*agedTime*/, J.flagsCI, J.minFileType, J.contentIndexTime,
		J.archGroupId, (select name from archGroup WITH (NOLOCK) where id = J.archGroupId)
FROM	#tempApps A, JMAdminJobStatsTable B WITH (NOLOCK), #tempJobFromAF J
WHERE	B.commCellId = J.commCellId AND B.jobId = J.jobId
	AND A.appId = J.appId
INSERT INTO #tempJobRetention
SELECT	DISTINCT B.jobId, B.commCellId, B.archGrpCopyId,
		(case when AP.isDMAppType = 1 then A.archiverRetDays else A.retentionDays end),
		B.retentionFlags, 0,
		B.manualRetentionEndTime, B.disabled & 2
FROM	JMJobDataStats B WITH (NOLOCK), #tempJobStats J, #tempApps AP,
		(SELECT AR.copyId,
				(case when AR.retentionDays < 0 then @MAXINT else AR.retentionDays end) AS retentionDays,
				(case when AR.archiverRetDays < 0 then @MAXINT else AR.archiverRetDays end) AS archiverRetDays
		FROM	archAgingRule AR WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK),
				(SELECT DISTINCT archGroupId FROM #tempJobFromAF) AG
		WHERE	AR.copyId = AGC.id AND AGC.archGroupId = AG.archGroupId) A
WHERE	B.commCellId = J.commCellId AND B.jobId = J.jobId
	AND A.copyId = B.archGrpCopyId
	AND AP.appId = B.appId
DROP TABLE #tempApps
UPDATE	#tempJobRetention
SET		extRetentionFlags = (
		case
		when extRetentionFlags &64 <> 0 then 64
		when extRetentionFlags & 8 <> 0 then 8
		when extRetentionFlags & 4 <> 0 then 4
		when extRetentionFlags & 2 <> 0 then 2
		end)
WHERE	extRetentionFlags <> 0
UPDATE	#tempJobRetention
SET		extRetentionDays = b.retentionDays
FROM	#tempJobRetention a,
		(SELECT AR.copyId, AR.retentionRule,
		(case when AR.retentionDays < 0 then @MAXINT else AR.retentionDays end) AS retentionDays
		FROM	archAgingRuleExtended AR, archGroupCopy AGC WITH (NOLOCK),
				(SELECT DISTINCT archGroupId FROM #tempJobFromAF) AG
		WHERE	AR.copyId = AGC.id AND AGC.archGroupId = AG.archGroupId) b
WHERE	b.copyId = a.archGrpCopyId AND b.retentionRule = a.extRetentionFlags
DROP TABLE #tempJobFromAF
INSERT INTO #maxJobRetention
SELECT	jobId, commCellId, MAX(retentionDays), MAX(extRetentionDays), MAX(manualRetentionEndTime)
FROM	#tempJobRetention
GROUP BY jobId, commCellId
DROP TABLE #tempJobRetention
UPDATE	#tempJobStats
SET		retentionDays = (case when JR.extRetentionDays > JR.retentionDays then JR.extRetentionDays else JR.retentionDays end),
		pinJobEndTime = JR.manualRetentionEndTime
FROM	#tempJobStats JS, #maxJobRetention JR
WHERE	JR.jobId = JS.jobId AND JR.commCellId = JS.commCellId
UPDATE	#tempJobStats
SET		retentionDays = -1
WHERE 	retentionDays = @MAXINT
SELECT
	commCellId,
	commCellName,
	jobId,
	dataState,
	physicalSize,
	clientId,
	clientName,
	appTypeId,
	appTypeName,
	backupSetId,
	backupSetName,
	subClientId,
	subClientName,
	instanceId,
	instanceName,
	dbo.GetDateTime(startTime) as startTime,
	dbo.GetDateTime(endTime) as endTime,
	level,
	status,
	fullCycleNum,
	seqNumInCycle,
	duration,
	streamNum,
	initFrom,
	attributes,
	failReason,
	userName,
	totalWriteTime,
	scanFileFailures,
	scanFolderFailures,
	bkpFileFailures,
	bkpFolderFailures,
	numObjects,
	retentionDays,
	dbo.GetDateTimeBig(pinJobEndTime) as pinJobEndTime,
	agedTime,
	flagsCI,
	minFileType,
	dbo.GetDateTime(contentIndexTime) as contentIndexTime,
	archGroupId,
	archGroupName
FROM	#tempJobStats
ORDER BY commcellId DESC, jobId DESC
DROP TABLE #tempJobStats
DROP TABLE #maxJobRetention
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archViewSearchedJobs')
	delete from GxQscripts where name = 'archViewSearchedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewSearchedJobs')
	delete from GXDBVersions where aliasname = 'archViewSearchedJobs'
GO

insert into GXDBVersions values(2, 'archViewSearchedJobs',  '00010007004800020000', 'archViewSearchedJobs', '00010007004800020000')
GO

