

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archViewSILOJobsByCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archViewSILOJobsByCopy.sp,v $ $Id: archViewSILOJobsByCopy.sp,v 1.10.194.2.68.1 2021/03/04 05:52:19 cliu Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archViewSILOJobsByCopy')
BEGIN
	print '>>> Drop Stored Procedure: archViewSILOJobsByCopy <<<'
	drop procedure archViewSILOJobsByCopy
END
IF EXISTS (select * from GxQscripts where name='archViewSILOJobsByCopy')
	delete from GxQscripts where name = 'archViewSILOJobsByCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewSILOJobsByCopy')
	delete from GXDBVersions where aliasname = 'archViewSILOJobsByCopy'
GO
print '... Creating Procedure: archViewSILOJobsByCopy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archViewSILOJobsByCopy
  @i_copyId int,
  @timeRangeBegin int,
  @timeRangeEnd int,
  @isAged int,
  @dataState int,
  @orderByCode int
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_jobId int
  DECLARE @o_commCellId int
  DECLARE @o_jobStatus int
  DECLARE @o_SIDBStoreName NVARCHAR(255)
  DECLARE @o_startTime int
  DECLARE @o_endTime int
  DECLARE @o_totalCompBytes bigint
  DECLARE @o_totalUncompBytes bigint
  DECLARE @o_sizeOfBackup bigint
  DECLARE @o_userName NVARCHAR(255)
  DECLARE @o_jobCopyAttributes int
  DECLARE @o_sizeOnMedia bigint
SET NOCOUNT ON
CREATE TABLE #tempJobStats
(
	jobId				int,
	commCellId			int,
	jobStatus			int,
	SIDBStoreName		nvarchar(max),
	startTime			int,
	endTime				int,
	totalCompBytes		bigint,
	totalUncompBytes	bigint,
	totalBackupSize		bigint,
userName			nvarchar(255),
	jobCopyAttributes	int,
	physicalSize		bigint,
	PRIMARY KEY(jobId, commCellId)
)
CREATE TABLE #tempJobAFList
(
	archFileId		int,
	jobId			int,
	commCellId		int,
	PRIMARY KEY(archFileId, commCellId)
)
CREATE TABLE #tempJobSizeList
(
	jobId			int,
	commCellId		int,
	encKeyType		int,
	physicalSize	bigint,
	PRIMARY KEY(jobId, commCellId)
)
CREATE TABLE #jobCRC
(
	jobId			int,
	commCellId		int,
	minCRC			int,
	maxHwEnc		int,
	PRIMARY KEY(jobId, commCellId)
)
-- Bit map for @dataState
-- 0 = show all
-- bit 0 (=1) = show available
-- bit 2 (=4) = show to be copied
-- bit 3 (=8) = show not to be copied
DECLARE @spId 					INT
IF	@timeRangeEnd <= 0
	SET @timeRangeEnd = dbo.getUnixTime(GetUTCDate())
SELECT	@spId = archGroupId
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @i_copyId
INSERT	INTO #tempJobStats
SELECT	DISTINCT J.jobId, J.commCellId, J.status, dbo.getSIDBStoreNameList(J.jobId, J.commCellId),
		B.servStartDate, B.servEndDate, B.totalCompBytes, B.totalUncompBytes, B.totalBackupSize, B.username, 0, 0
FROM	JMBkpStats B WITH (NOLOCK), JMJobDataStats J WITH (NOLOCK)
WHERE	B.jobId = J.jobId AND B.commCellId = J.commCellId
AND		B.servStartDate >= @timeRangeBegin
AND 	B.servStartDate < @timeRangeEnd
AND 	B.status IN (1, 3, 14)
AND 	J.archGrpCopyId = @i_copyId
AND		(@dataState = 0 AND J.status IN (100, 101, 102, 103) AND (J.disabled & 1) = 0
		OR (@dataState & 1) > 0 AND J.status = 100
		OR (@dataState & 4) > 0 AND J.status IN (101, 102, 103) AND (J.disabled & 1) = 0
		OR (@dataState & 8) > 0 AND J.status IN (101, 102, 103) AND (J.disabled & 1) = 1)
AND		(@isAged = 0 AND (J.disabled & 256) = 0 OR @isAged = 1 AND (J.disabled & 256) > 0 OR @isAged = 2)
INSERT	INTO #tempJobAFList
SELECT	A.id, A.jobId, A.commCellId
FROM	archFile A WITH (NOLOCK), #tempJobStats T
WHERE	A.jobId = T.jobId
AND 	A.commCellId = T.commCellId
AND 	A.archGroupId = @spId
AND 	A.isValid = 1
INSERT INTO #tempJobSizeList
SELECT	T.jobId, T.commCellId, MAX(A.encKeyType), SUM(A.physicalSize)
FROM	archFileCopy A WITH (NOLOCK), #tempJobAFList T
WHERE	A.archFileId = T.archFileId
AND A.commCellId = T.commCellId
AND A.archCopyId = @i_copyId
GROUP BY T.jobId, T.commCellId
UPDATE	#tempJobStats
SET		physicalSize = B.physicalSize
FROM	#tempJobStats A, #tempJobSizeList B
WHERE	A.commCellId = B.commCellId
AND 	A.jobId = B.jobId
-- Set jobCopyAttributes
UPDATE	#tempJobStats
SET		jobCopyAttributes = (A.jobCopyAttributes | 2)
FROM	#tempJobStats A, #tempJobSizeList B
WHERE	A.jobId = B.jobId
AND		A.commCellId = B.commCellId
AND 	B.encKeyType <> 0
INSERT	INTO #jobCRC
SELECT	T.jobId, T.commCellId, MIN(AC.flags & 16),
(MAX(AC.flags & 1048576) | MAX(LEN(hwEncKey)))
FROM	#tempJobAFList T, archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK)
WHERE	ACM.archFileId = T.archFileId
AND 	ACM.commCellId = T.commCellId
AND 	ACM.archCopyId = @i_copyId
AND 	AC.id = ACM.archChunkId
AND 	AC.commCellId = ACM.chunkCommCellId
GROUP BY T.jobId, T.commCellId
UPDATE	#tempJobStats
SET		jobCopyAttributes = (A.jobCopyAttributes | 4)
FROM	#tempJobStats A, #jobCRC B
WHERE	A.jobId = B.jobId
AND 	A.commCellId = B.commCellId
AND 	B.minCRC <> 0
UPDATE	#tempJobStats
SET		jobCopyAttributes = (A.jobCopyAttributes | 8)
FROM	#tempJobStats A, #jobCRC B
WHERE	A.jobId = B.jobId
AND 	A.commCellId = B.commCellId
AND 	B.maxHwEnc <> 0
DROP TABLE #jobCRC
DROP TABLE #tempJobAFList
DROP TABLE #tempJobSizeList
IF @orderByCode = 0
	SELECT	*
	FROM	#tempJobStats
	ORDER BY commCellId DESC, jobId DESC
ELSE
	SELECT	*
	FROM	#tempJobStats
	ORDER BY commCellId DESC, jobId ASC
DROP TABLE #tempJobStats
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archViewSILOJobsByCopy')
	delete from GxQscripts where name = 'archViewSILOJobsByCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewSILOJobsByCopy')
	delete from GXDBVersions where aliasname = 'archViewSILOJobsByCopy'
GO

insert into GXDBVersions values(2, 'archViewSILOJobsByCopy',  'v1.10.194.2.68.1', 'archViewSILOJobsByCopy', 'v1.10.194.2.68.1')
GO

