

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archViewMediaForRestore.sp] ---------- 

--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archViewMediaForRestore.sp,v $ $Id: archViewMediaForRestore.sp,v 1.4.210.2 2018/03/22 01:11:55 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archViewMediaForRestore <<<'

IF EXISTS (select * from sysobjects where name='archViewMediaForRestore')
	drop procedure archViewMediaForRestore
IF EXISTS (select * from GxQscripts where name='archViewMediaForRestore')
	delete from GxQscripts where name = 'archViewMediaForRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewMediaForRestore')
	delete from GXDBVersions where aliasname = 'archViewMediaForRestore'
GO
print '... Creating Procedure: archViewMediaForRestore'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archViewMediaForRestore
  @i_jobIdsXml xml
AS
  DECLARE @policyId integer
  DECLARE @policyName NVARCHAR(255)
  DECLARE @copyId integer
  DECLARE @copyName NVARCHAR(255)
  DECLARE @streamNumber integer
  DECLARE @mediaGroupId integer
  DECLARE @mediaId integer
  DECLARE @uniqueId char(255)
  DECLARE @barCode char(255)
  DECLARE @attributes integer
  DECLARE @guiAttributes integer
  DECLARE @locationType integer
  DECLARE @locationId integer
  DECLARE @location NVARCHAR(255)
--get list of jobs from the "," separated list into this table
DECLARE  @tblJob TABLE (jobId int)
INSERT	INTO @tblJob
SELECT	T.c.value('@jobId', 'int')
FROM	@i_jobIdsXml.nodes('/r/h') T(c)
DECLARE @tblMedia TABLE (MediaId int, MountPathId int, MountPathName varchar(1024), MountPathTypeId int,
		MediaGroupId int)
INSERT	INTO @tblMedia
SELECT	M.MediaId, ISNULL(MP.MountPathId, 0), ISNULL(MP.MountPathName, ''), ISNULL(MP.MountPathTypeId, 0),
		M.MediaGroupId
FROM	(SELECT V.MediaId, V.MediaSideId, V.MediaGroupId
		FROM	(SELECT VolumeId FROM JMJobResourceHistory WHERE jobId IN (SELECT jobId FROM @tblJob)) as V1, MMVolume V
		WHERE	V.VolumeId = V1.volumeId
		GROUP BY MediaId, MediaSideId, MediaGroupId
		) AS M LEFT OUTER JOIN MMS2getMountPathNameGUIView AS MP ON M.MediaSideId = MP.MediaSideId
SELECT	S.archGroupId, (SELECT name FROM archGroup WHERE id = S.archGroupId),
		S.archGroupCopyId, (SELECT name FROM archGroupCopy WHERE id = S.archGroupCopyId),
		S.stream, S.MediaGroupId,
		M.MediaId, M.UniqueId, M.BarCode,
		M.Attributes,
		dbo.MMS2FUNC_GetGUIMediaAttribute(M.MediaId),
		M.MediaLocation,
		(case M.MediaTypeId
		when 10001 then M1.MountPathId
		else (case M.MediaLocation
			when 1 then (SELECT SlotId FROM MMSlot WHERE MediaId = M.MediaId)
			when 2 then (SELECT DriveId FROM MMDrive WHERE MediaId = M.MediaId)
			else M.ExportLocationId
			end)
		end),
		(case M.MediaTypeId
		when 10001 then M1.MountPathName
		else
			(case M.MediaLocation
			when 1 then (SELECT SlotName FROM MMSlot WHERE MediaId = M.MediaId)
			when 2 then (SELECT AliasName FROM MMDrive WHERE MediaId = M.MediaId)
			when 3 then (SELECT ExportLocation FROM MMExportLocation WHERE ExportLocationId = M.ExportLocationId)
			else '' end)
		end)
FROM 	archStream S, @tblMedia M1, MMMedia M
WHERE	S.mediaGroupId = M1.MediagroupId AND M.MediaId = M1.MediaId
ORDER BY S.archGroupId ASC, S.archGroupCopyId ASC, S.stream ASC
GO

IF EXISTS (select * from GxQscripts where name = 'archViewMediaForRestore')
	delete from GxQscripts where name = 'archViewMediaForRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewMediaForRestore')
	delete from GXDBVersions where aliasname = 'archViewMediaForRestore'
GO

insert into GXDBVersions values(2, 'archViewMediaForRestore',  '00010004021000020000', 'archViewMediaForRestore', '00010004021000020000')
GO

