

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archViewMediaByJobCopy.sp] ---------- 

--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archViewMediaByJobCopy.sp,v $ $Id: archViewMediaByJobCopy.sp,v 1.9.88.2 2018/03/22 01:02:02 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archViewMediaByJobCopy <<<'

IF EXISTS (select * from sysobjects where name='archViewMediaByJobCopy')
	drop procedure archViewMediaByJobCopy
IF EXISTS (select * from GxQscripts where name='archViewMediaByJobCopy')
	delete from GxQscripts where name = 'archViewMediaByJobCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewMediaByJobCopy')
	delete from GXDBVersions where aliasname = 'archViewMediaByJobCopy'
GO
print '... Creating Procedure: archViewMediaByJobCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archViewMediaByJobCopy
  @i_commCellId integer,
  @i_archGroupId integer,
  @i_copyId integer,
  @i_copyPrecedence integer,
  @i_includeAgedData integer,
  @i_jobIdsXml xml
AS
  DECLARE @policyId integer
  DECLARE @policyName NVARCHAR(255)
  DECLARE @copyId integer
  DECLARE @copyName NVARCHAR(255)
  DECLARE @streamNumber integer
  DECLARE @mediaGroupId integer
  DECLARE @mediaId integer
  DECLARE @uniqueId char(255)
  DECLARE @barCode char(255)
  DECLARE @attributes integer
  DECLARE @guiAttributes integer
  DECLARE @locationType integer
  DECLARE @locationId integer
  DECLARE @location NVARCHAR(255)
--get list of jobs from the "," separated list into this table
DECLARE  @tblJob TABLE (jobId int, isRunning int)
INSERT	INTO @tblJob
SELECT	T.c.value('@jobId', 'int'), 0
FROM	@i_jobIdsXml.nodes('/r/h') T(c)
-- for a running job, don't check if archive file is valid.
DECLARE @l_isRunningJob	integer
SET @l_isRunningJob = 0
IF @i_commCellId = 2
	UPDATE	@tblJob SET	isRunning = 1
	FROM	@tblJob J, MMResourceToJob R
	WHERE	R.jobId_h = 0 AND R.jobId_l = J.jobId
-- get a list of archFileId in copies
DECLARE @tblAFC TABLE (archFileId int, archCopyId int)
IF @i_archGroupId > 0 OR @i_copyId > 0
BEGIN
	-- this cursor is called at storage policy/copy level
	IF @i_archGroupId = 0 AND @i_copyId > 0
		SET @i_archGroupId = ISNULL((SELECT archGroupId FROM archGroupCopy WHERE id = @i_copyId), 0)
	INSERT	INTO @tblAFC
	SELECT	AFC.archFileId, AFC.archCopyId
	FROM	(SELECT A.id FROM archFile A, @tblJob J
			WHERE	A.jobId = J.jobId AND A.commCellId = @i_commCellId
				AND A.archGroupId = @i_archGroupId AND (J.isRunning <> 0 OR A.isValid = 1)) AF, archFileCopy AFC
	WHERE	AFC.archFileId = AF.id AND AFC.commCellId = @i_commCellId AND (@i_copyId = 0 OR AFC.archCopyId = @i_copyId)
		AND AFC.physicalSize > 0 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
END
ELSE
BEGIN
	-- this cursor is called at backupset/subclient level
	-- get a list of archFileId for the given job
	DECLARE @tblAF TABLE (id int, archGroupId int)
	INSERT INTO @tblAF
	SELECT	A.id, A.archGroupId
	FROM	archFile A, @tblJob J
	WHERE	A.jobId = J.jobId AND A.commCellId = @i_commCellId
		AND (J.isRunning <> 0 OR A.isValid = 1)
	IF (@i_CopyPrecedence = -2)
	BEGIN
		-- from all copies
		INSERT	INTO @tblAFC
		SELECT	AFC.archFileId, AFC.archCopyId
		FROM	@tblAF AF, archFileCopy AFC
		WHERE	AFC.archFileId = AF.id AND AFC.commCellId = @i_commCellId
			AND AFC.physicalSize > 0 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
	END
	ELSE
	IF (@i_CopyPrecedence = -1)
	BEGIN
		-- from the primary copy
		INSERT	INTO @tblAFC
		SELECT	AFC.archFileId, AFC.archCopyId
		FROM	@tblAF AF, archFileCopy AFC, archGroup AG
		WHERE	AG.id = AF.archGroupId AND AFC.archFileId = AF.id AND AFC.commCellId = @i_commCellId AND AFC.archCopyId = AG.defaultCopy
			AND AFC.physicalSize > 0 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
	END
	ELSE
	IF(@i_CopyPrecedence > 0)
	BEGIN
		-- from a given copy precedence
		INSERT	INTO @tblAFC
		SELECT	AFC.archFileId, AFC.archCopyId
		FROM	@tblAF AF, archFileCopy AFC, archGroupCopy AGC
		WHERE	AFC.archFileId = AF.id AND AFC.commCellId = @i_commCellId AND AFC.archCopyId = AGC.id AND AGC.copy = @i_CopyPrecedence
			AND AFC.physicalSize > 0 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
	END
	ELSE
	IF(@i_CopyPrecedence = 0)
	BEGIN
		-- from the copy which has the given job and has the lowest precedence
		DECLARE getArchFileCopy CURSOR FOR
		SELECT	AFC.archFileId, AFC.archCopyId
		FROM	@tblAF AF, archFileCopy AFC, archGroupCopy AGC
		WHERE	AFC.archFileId = AF.id AND AFC.commCellId = @i_commCellId AND AFC.archCopyId = AGC.id
			AND AFC.physicalSize > 0 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
		ORDER BY AFC.archFileId ASC, AFC.isValid DESC, AGC.copy ASC
		OPEN getArchFileCopy
		DECLARE @l_archFileId int
		DECLARE @l_archCopyId int
		FETCH NEXT FROM getArchFileCopy INTO @l_archFileId, @l_archCopyId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO @tblAFC
			SELECT @l_archFileId, @l_archCopyId
			WHERE  NOT EXISTS (SELECT * FROM @tblAFC WHERE archFileId = @l_archFileId)
			FETCH NEXT FROM getArchFileCopy INTO @l_archFileId, @l_archCopyId
		END
		CLOSE getArchFileCopy
		DEALLOCATE getArchFileCopy
	END
END
-- get volumes that contain the data we need.
DECLARE @tblVolId TABLE (volumeId int, firstChunkId bigint)
INSERT	INTO @tblVolId
SELECT	AC.volumeId, MIN(AC.id)
FROM	(SELECT	DISTINCT archChunkId, chunkCommCellId
		FROM	@tblAFC AFC, archChunkMapping ACM
		WHERE	ACM.archFileId = AFC.archFileId AND ACM.commCellId = @i_commCellId AND ACM.archCopyId = AFC.archCopyId
			AND ACM.physicalSize > 0) AC1, archChunk AC
WHERE	AC.id = AC1.archChunkId AND AC.commcellId = AC1.chunkCommCellId
GROUP BY AC.volumeId
-- insert for running jobs. Give the first archchunkid as MaxInt.
--IF @l_isRunningJob <> 0
	INSERT	INTO @tblVolId
	SELECT	DISTINCT R.VolumeId, 2147483647
	FROM	MMResourceToJob AS R2J, MMResource AS R, @tblJob J
	WHERE	R2J.jobId_h = 0 AND R2J.jobId_l = J.jobId
		AND R.ReservationId = R2J.ReservationId
		AND R.VolumeId NOT IN (SELECT VolumeId FROM @tblVolId)
		AND J.isRunning > 0
-- get media that contain the data we need.
DECLARE @tblVolume TABLE (MediaId int, MediaSIdeId int, MediaGroupId int, VolumeName varchar(112), firstChunkId bigint)
INSERT	INTO @tblVolume
SELECT	V.MediaId, V.MediaSIdeId, V.MediaGroupId, V.VolumeName, V1.firstChunkId
FROM	@tblVolId V1 INNER JOIN MMVolume V WITH (NOLOCK) ON V.VolumeId = V1.volumeId
DECLARE @tblMedia TABLE (MediaId int, MountPathId int, MountPathName varchar(1024), MountPathTypeId int)
INSERT INTO @tblMedia
SELECT	a.MediaId, ISNULL(b.MountPathId, 0), ISNULL(b.MountPathName, ''), ISNULL(b.MountPathTypeId, 0)
FROM	(SELECT	DISTINCT MediaId, MediaSideId FROM @tblVolume) AS a
		LEFT OUTER JOIN MMS2getMountPathNameGUIView b WITH (NOLOCK) ON a.MediaSideId = b.MediaSideId
DECLARE @tblMediaLocation TABLE (MediaId int, UniqueId varchar(300), BarCode varchar(256),
MediaTypeId int, Attributes int, LocationType int, LocationId int, Location nvarchar(1024))
INSERT INTO @tblMediaLocation
SELECT	DISTINCT M.MediaId, M.UniqueId, M.BarCode, M.MediaTypeId, M.Attributes, M.MediaLocation,
		(case M.MediaTypeId
when 10001 then MP.MountPathId
		else (case M.MediaLocation
			when 1 then (SELECT SlotId  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
			when 2 then (SELECT DriveId FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
			else M.ExportLocationId
			end)
		end),
		(case M.MediaTypeId
when 10001 then MP.MountPathName
		else
			(case M.MediaLocation
			when 1 then (SELECT SlotName  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
			when 2 then (SELECT AliasName FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
			else ISNULL((SELECT ExportLocation FROM MMExportLocation WHERE ExportLocationId = M.ExportLocationId), '') end)
		end)
FROM	@tblMedia AS MP, MMMedia AS M WITH (NOLOCK)
WHERE	M.MediaId = MP.MediaId
SELECT	(case when (S.flags & 2) = 0 then S.ArchGroupId else (select archGroupId from archStream WITH (NOLOCK) where MediaGroupId = S.mediaGroupId and (flags & 2) = 0) end),
(SELECT name FROM archGroup WITH (NOLOCK) WHERE id = (case when (S.flags & 2) = 0 then S.ArchGroupId else (select archGroupId from archStream WITH (NOLOCK) where MediaGroupId = S.mediaGroupId and (flags & 2) = 0) end)),
(case when (S.flags & 2) = 0 then S.ArchGroupCopyId else (select archGroupCopyId from archStream WITH (NOLOCK) where MediaGroupId = S.mediaGroupId and (flags & 2) = 0) end),
(SELECT name FROM archGroupCopy WITH (NOLOCK) WHERE id = (case when (S.flags & 2) = 0 then S.archGroupCopyId else (select archGroupCopyId from archStream WITH (NOLOCK) where MediaGroupId = S.mediaGroupId and (flags & 2) = 0) end)),
		S.stream, S.MediaGroupId,
		ML.MediaId, ML.UniqueId,
(case when ML.MediaTypeId = 10001 then V.VolumeName else ML.BarCode end),
		ML.Attributes, dbo.MMS2FUNC_GetGUIMediaAttribute(ML.MediaId),
		ML.LocationType, ML.LocationId, ML.Location
FROM 	@tblVolume V, @tblMediaLocation ML, archStream S WITH (NOLOCK)
WHERE	V.MediaId = ML.MediaId AND S.mediaGroupId = V.MediaGroupId
AND (S.flags & 2) = 0
ORDER BY S.archGroupCopyId, S.stream, V.firstChunkId
GO

IF EXISTS (select * from GxQscripts where name = 'archViewMediaByJobCopy')
	delete from GxQscripts where name = 'archViewMediaByJobCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewMediaByJobCopy')
	delete from GXDBVersions where aliasname = 'archViewMediaByJobCopy'
GO

insert into GXDBVersions values(2, 'archViewMediaByJobCopy',  '00010009008800020000', 'archViewMediaByJobCopy', '00010009008800020000')
GO

