

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archViewJobsByPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
/*
	ClientIds xml format
	<ClientIdList><Client id=""/></ClientIdList>
*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archViewJobsByPolicy.sp,v $ $Id: archViewJobsByPolicy.sp,v 1.99.32.21 2020/06/06 02:42:14 prasanthm Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archViewJobsByPolicy')
BEGIN
	print '>>> Drop Stored Procedure: archViewJobsByPolicy <<<'
	drop procedure archViewJobsByPolicy
END
IF EXISTS (select * from GxQscripts where name='archViewJobsByPolicy')
	delete from GxQscripts where name = 'archViewJobsByPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewJobsByPolicy')
	delete from GXDBVersions where aliasname = 'archViewJobsByPolicy'
GO
print '... Creating Procedure: archViewJobsByPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archViewJobsByPolicy
  @spId integer,
  @isAged integer,
  @theBackupLevel integer,
  @timeRangeBegin integer,
  @timeRangeEnd integer,
  @CIStatusFilter integer,
  @orderByCode integer,
  @options integer,
  @bkpCopyStatusFilter integer,
  @subClntId integer = 0,
  @i_clientIdsXML XML = '',
  @i_userId integer = 1
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_jobId integer
  DECLARE @o_commCellId integer
  DECLARE @o_commCellName nvarchar(255)
  DECLARE @o_dataState integer
  DECLARE @o_sizeOfapplication bigint
  DECLARE @o_sizeOfAppCompressed bigint
  DECLARE @o_sizeOnMedia bigint
  DECLARE @o_sizeOfNWTransfer bigint
  DECLARE @o_clientId integer
  DECLARE @o_clientName nvarchar(255)
  DECLARE @o_appTypeId integer
  DECLARE @o_appTypeName varchar(255)
  DECLARE @o_backupSetId integer
  DECLARE @o_backupSetName nvarchar(255)
  DECLARE @o_subClientId integer
  DECLARE @o_subClientName nvarchar(255)
  DECLARE @o_instanceId integer
  DECLARE @o_instanceName nvarchar(255)
  DECLARE @o_startTime integer
  DECLARE @o_endTime integer
  DECLARE @o_opType integer
  DECLARE @o_level integer
  DECLARE @o_status integer
  DECLARE @o_fullCycleNum integer
  DECLARE @o_seqNumInCycle integer
  DECLARE @o_duration integer
  DECLARE @o_streamNum integer
  DECLARE @o_initFrom integer
  DECLARE @o_attributes bigint
  DECLARE @o_attributesEx bigint
  DECLARE @o_failReason varchar(255)
  DECLARE @o_userName nvarchar(255)
  DECLARE @o_totalWriteTime integer
  DECLARE @o_scanFileFailures integer
  DECLARE @o_scanFolderFailures integer
  DECLARE @o_bkpFileFailures integer
  DECLARE @o_bkpFolderFailures integer
  DECLARE @o_numObjects bigint
  DECLARE @o_extRetentionFlags integer
  DECLARE @o_retentionEndTime bigint
  DECLARE @o_agedTime bigint
  DECLARE @o_flagsCI integer
  DECLARE @o_flagsFLA integer
  DECLARE @o_minFileType integer
  DECLARE @o_contentIndexTime integer
  DECLARE @o_snapToTapeStatus integer
  DECLARE @o_snapDeferredCatalogStatus integer
  DECLARE @o_retainedBy integer
  DECLARE @o_dedupSaving bigint
  DECLARE @o_copyId int
  DECLARE @o_stubDataSize bigint
  DECLARE @o_jobDescription nvarchar(MAX)
  DECLARE @o_searchEngine varchar(1024)
  DECLARE @o_indexBackupJob int
  DECLARE @o_encrypted int
  DECLARE @o_clientDisplayName nvarchar(255)
SET NOCOUNT ON
--DECLARE @MAXINT	integer
--SET	@MAXINT	= 0x7FFFFFFF
DECLARE @MAXINT BIGINT
SET @MAXINT = 0x7FFFFFFFFFFFFFFF
DECLARE @ExtRetainedOnly	integer
DECLARE	@srcCopyID integer
SET	@ExtRetainedOnly= (@CIStatusFilter & 16)
SET	@CIStatusFilter	= (@CIStatusFilter & ~16)
CREATE TABLE #tempJob(
	jobId INT, commCellId INT, appId INT, dataOnMedia INT, flagsCI INT, minFlagsCI INT, flagsFLA INT, minFileType INT, contentIndexTime INT, afId INT, cloudId	INT, encrypted INT
	PRIMARY KEY(jobId, commCellId))
CREATE TABLE #tempAppList(
appId int,		subclientName nvarchar(255),
backupSet int,	backupSetName nvarchar(255),
instance int,	instanceName nvarchar(255),
appType int,	appTypeName varchar(255),
clientId int,	clientName nvarchar(255),
	isDMAppType int,
    isDefferedCatalogSupported int,
clientDisplayName nvarchar(255),
	PRIMARY KEY(appId))
CREATE TABLE #tempForeignApp(
appId int,		subclientName nvarchar(255),
backupSet int,	backupSetName nvarchar(255),
instance int,	instanceName nvarchar(255),
appType int,	appTypeName varchar(255),
clientId int,	clientName nvarchar(255),
clientDisplayName nvarchar(255))
CREATE TABLE #tempJobStats(
	jobId				int,
	commCellId			int,
commCellName		nvarchar(255),
	dataState			int,
	applicationSize		bigint,
	compressedAppSize	bigint,
	sizeOnMedia			bigint,
	nwTransferSize		bigint,
	clientId			int,
clientName			nvarchar(255),
	appTypeId 			int,
appTypeName			varchar(255),
	backupSetId			int,
backupSetName		nvarchar(255),
	subClientId 		int,
subClientName		nvarchar(255),
	instanceId 			int,
instanceName		nvarchar(255),
	startTime			int,
	endTime				int,
	opType				int,
	level				int,
	status				int,
	fullCycleNum		int,
	seqNumInCycle		int,
	duration			int,
	streamNum			int,
	initFrom			int,
	attributes			bigint,
	attributesEx		bigint,
failReason			nvarchar(255),
userName			nvarchar(255),
	totalWriteTime		int,
	scanFileFailures	int,
	scanFolderFailures	int,
	bkpFileFailures		int,
	bkpFolderFailures	int,
	numObjects			bigint,
	extRetentionFlags	int,
	retentionEndTime	bigint,
	agedTime			bigint,
	flagsCI				int,
	flagsFLA			INT,
	minFileType			int,
	contentIndexTime	int,
	snapToTapeStatus	int,
	snapDeferredCatalogStatus	int,
	retainedBy	int,
	dedupSaving			bigint,
	copyId				int,
	stubDataSize        bigInt,
	jobDescription		nvarchar(MAX),
	searchEngine		varchar(1024),
	indexBackupJob 		int 	default(0),
	encrypted           int,
clientDisplayName   nvarchar(255)
	--PRIMARY KEY(jobId, commCellId, copyId)
	)
CREATE UNIQUE CLUSTERED INDEX tempJobStats_idx ON #tempJobStats (commCellId desc, jobId desc, copyId)
CREATE TABLE #temp_ret_copy
(
   copyId int PRIMARY KEY,
   retentionDays BIGINT,
   archiverRetDays BIGINT
)
CREATE TABLE #tempJobRetention(
	jobId INT, commCellId INT, archGrpCopyId INT, appId INT,
	retentionDays BIGINT, extRetentionFlags INT, extRetentionDays BIGINT,
	manualRetentionEndTime BIGINT, jobCopyStatus INT
	PRIMARY KEY(jobId, commCellId, archGrpCopyId))
CREATE TABLE #maxJobRetention(
	jobId INT, commCellId INT, copyId int, extRetentionFlags INT, retentionDays BIGINT, extRetentionDays BIGINT, manualRetentionEndTime BIGINT,
	PRIMARY KEY(jobId, commCellId, copyId))
CREATE TABLE #tempTimeZone(
	clientId INT, TimeZone VARCHAR(255))
IF	@CIStatusFilter = (1+4+8)
SET	@CIStatusFilter = 0
--1 Backup copy success, 2 Picked for backup copy, 4 Not picked for backup copy
IF	@bkpCopyStatusFilter = (1+2+4)
SET	@bkpCopyStatusFilter = 0
DECLARE	@snapToTapeEnabled		INT
SET		@snapToTapeEnabled	= 0
SELECT	@snapToTapeEnabled = enabled
FROM	archMaterializeSnapshotProp WITH (NOLOCK)
WHERE	archGroupId = @spId
DECLARE	@deferredCatalogEnabled		INT
SET		@deferredCatalogEnabled	= 0
SELECT	@deferredCatalogEnabled = enabled
FROM	archDeferredCatalogProp WITH (NOLOCK)
WHERE	archGroupId = @spId
DECLARE	@l_policyType	INT
DECLARE @l_defaultCopy	INT
DECLARE	@l_TimeZoneType	INT
DECLARE	@l_TimeZone		VARCHAR(255)
DECLARE	@l_csTimeZone	VARCHAR(255)
DECLARE	@l_flags	INT
DECLARE @HonorSPCopyRetentionForContentStore        INTEGER
SET		@HonorSPCopyRetentionForContentStore = 0
SET		@l_csTimeZone = dbo.GetClientTimeZone(2)
SELECT	@l_policyType = type, @l_defaultCopy = defaultCopy, @l_TimeZoneType = TimeZoneType, @l_TimeZone = TimeZone, @l_flags = flags
FROM	archGroup WITH (NOLOCK)
WHERE	id = @spId
SELECT	@HonorSPCopyRetentionForContentStore = isnull(value, 0)
FROM	MMConfigs WITH (NOLOCK)
WHERE	name = 'DA_CONFIG_HONOR_STORAGE_POLICY_RETENTION_FOR_CONTENT_STORE_DATA'
IF	(@options & 1) = 0
	SET	@l_TimeZone = @l_csTimeZone
IF	object_id('tempdb.dbo.#lt_subclientList') IS NOT NULL DROP TABLE #lt_subclientList
CREATE TABLE #lt_subclientList (t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT)
EXEC sec_getIdaObjectsForUser @i_userId, 7 , 0, 0, #lt_subclientList
IF	@i_clientIdsXML.exist('/ClientIdList') = 1
BEGIN
		IF object_id('tempdb.dbo.#tempAppIdList') IS NOT NULL DROP TABLE #tempAppIdList
		CREATE TABLE #tempAppIdList(appId int)
		INSERT  INTO #tempAppIdList
		SELECT  App.id
		FROM @i_clientIdsXML.nodes('/ClientIdList/Client') T(item)
	    inner join APP_Application APP ON APP.clientId = T.item.value('@id','INT')
		inner join #lt_subclientList TMP ON APP.id = TMP.t_subclientId
END
IF object_id('tempdb.dbo.#tempAppIdList') IS NOT Null
BEGIN
	INSERT INTO #tempJob
	SELECT	a.jobId, a.commCellId, a.appId,
MIN((1 - (a.flags & 2)) * a.fileType),
			MAX(a.flags & 0x1F0), MIN(a.flags & 0x1F0), 0, MIN(a.fileType), MAX(a.contentIndexTime),MAX( a.id), MAX(a.cloudID), MAX(b.encKeyType)
	FROM	archFile a WITH (NOLOCK), archFileCopy b WITH (NOLOCK), #tempAppIdList c
	WHERE  	a.appId = c.appId
AND a.archGroupId = @spId AND a.isValid > 0 AND a.fileType = 1
		AND (@timeRangeBegin <= 0 OR a.cTime >= @timeRangeBegin)
		AND (@timeRangeEnd <= 0 OR a.cTime < (@timeRangeEnd + 72*3600))
		AND a.id = b.archFileId AND a.commCellId = b.commCellId AND b.physicalSize > 0
	GROUP BY a.jobId, a.commCellId, a.appId
	INSERT	INTO #tempAppList
	SELECT	a.id, a.subclientName,
			a.backupSet,(select name from APP_BackupSetName where id = a.backupSet),
			a.instance,	(select name from APP_InstanceName  where id = a.instance),
			a.appTypeId,(select name from APP_iDAType where type = a.appTypeId),
			a.clientId, (select name from APP_Client where id = a.clientId),
			0,0, (select displayName from APP_Client WITH (READUNCOMMITTED) where id = a.clientId)
	FROM	APP_Application a, #tempAppIdList b
	WHERE	a.id = b.appId
END
ELSE
BEGIN
	INSERT INTO #tempJob
	SELECT	a.jobId, a.commCellId, a.appId,
MIN((1 - (a.flags & 2)) * a.fileType),
			MAX(a.flags & 0x1F0), MIN(a.flags & 0x1F0), 0, MIN(a.fileType), MAX(a.contentIndexTime),MAX( a.id), MAX(a.cloudId), MAX(b.encKeyType)
	FROM	archFile a WITH (NOLOCK), archFileCopy b WITH (NOLOCK), #lt_subclientList TMP
WHERE	a.archGroupId = @spId AND a.isValid > 0 AND a.fileType = 1
		AND (@timeRangeBegin <= 0 OR a.cTime >= @timeRangeBegin)
		AND (@timeRangeEnd <= 0 OR a.cTime < (@timeRangeEnd + 72*3600))
		AND a.id = b.archFileId AND a.commCellId = b.commCellId AND b.physicalSize > 0
		AND a.appId = TMP.t_subclientId
	GROUP BY a.jobId, a.commCellId, a.appId
	IF @subClntId > 0
	BEGIN
		INSERT	INTO #tempAppList
		SELECT	a.id, a.subclientName,
			a.backupSet,(select name from APP_BackupSetName where id = a.backupSet),
			a.instance,	(select name from APP_InstanceName  where id = a.instance),
			a.appTypeId,(select name from APP_iDAType where type = a.appTypeId),
			a.clientId, (select name from APP_Client WITH (READUNCOMMITTED) where id = a.clientId),
			0,0, (select displayName from APP_Client WITH (READUNCOMMITTED) where id = a.clientId)
		FROM	APP_Application a WITH (READUNCOMMITTED)
		WHERE	a.id = @subClntId
	END
	ELSE
	BEGIN
		INSERT	INTO #tempAppList
		SELECT	a.id, a.subclientName,
			a.backupSet,(select name from APP_BackupSetName where id = a.backupSet),
			a.instance,	(select name from APP_InstanceName  where id = a.instance),
			a.appTypeId,(select name from APP_iDAType where type = a.appTypeId),
			a.clientId, (select name from APP_Client where id = a.clientId),
			0,0, (select displayName from APP_Client WITH (READUNCOMMITTED) where id = a.clientId)
		FROM	APP_Application a WITH (READUNCOMMITTED)
		inner join
			(SELECT DISTINCT appId FROM archFile WITH (NOLOCK)
			WHERE 	archGroupId = @spId AND isValid > 0
			AND (@timeRangeBegin <= 0 OR cTime >= @timeRangeBegin)
		    AND (@timeRangeEnd <= 0 OR cTime < (@timeRangeEnd + 72*3600)))b
		ON	a.id = b.appId
		inner join #lt_subclientList TMP ON a.id = TMP.t_subclientId
	END
END
UPDATE	#tempJob
SET		flagsCI = (case when minFlagsCI & 256 <> 0 then 256
when minFlagsCI & 64 <> 0 then 64
when minFlagsCI & 32 <> 0 then 32
when minFlagsCI & 16 <> 0 and (flagsCI & 32 <> 0 OR flagsCI & 64 <> 0) then 32
when minFlagsCI & 16 <> 0 and flagsCI & 16 <> 0 then 16
						else flagsCI end)
WHERE	minFlagsCI <> 0
--fla status
UPDATE	#tempJob
SET flagsFLA = FI.flags
FROM archFLAIndexingInfo FI
WHERE FI.archFileId = afId
--Fla is not applicable for EDGE backup
UPDATE	#tempJob
SET flagsFLA = 512
FROM APP_application APP WITH (NOLOCK)
WHERE APP.id= appId AND (APP.subclientStatus & 0x20000)=0x20000
IF @CIStatusFilter <> 0
BEGIN
	IF @CIStatusFilter = 1
DELETE FROM #tempJob WHERE flagsCI <> 64
	ELSE IF @CIStatusFilter = 4
DELETE FROM #tempJob WHERE flagsCI & (16 + 32) = 0
	ELSE IF @CIStatusFilter = 8
DELETE FROM #tempJob WHERE flagsCI = 64
	ELSE IF @CIStatusFilter = (1 + 4)
DELETE FROM #tempJob WHERE flagsCI & (16 + 32 + 64) = 0
	ELSE IF @CIStatusFilter = (1 + 8)
DELETE FROM #tempJob WHERE flagsCI & (16 + 32) <> 0
	ELSE IF @CIStatusFilter = (4 + 8)
DELETE FROM #tempJob WHERE flagsCI = 64
END
UPDATE	#tempAppList SET isDMAppType = 1
WHERe	appType IN (SELECT appTypeId FROM APP_IDATypeHandlingInfo WITH (NOLOCK) WHERE isDMAppType = 1)
UPDATE	#tempAppList SET isDefferedCatalogSupported = dbo.IsDeferredCatalogSupported(appId)
WHERE apptype IN(select appTypeId from dbo.GetDeferredCatalogSupportedAppTypes())
-- Set CVA_AF_CI_SUPPORTED_FLAG (=8)
IF EXISTS (SELECT * FROM archContentIndexingRules WITH (NOLOCK) WHERE archGroupId = @spId AND enabled <> 0)
BEGIN
	UPDATE	#tempJob
	SET		flagsCI = (J.flagsCI | 8)
	FROM	#tempJob J,
			(SELECT	APP.appId, APP.appType
			FROM	#tempAppList APP, APP_ClientProp C WITH (NOLOCK)
			WHERE	C.ComponentNameId = APP.clientId
				AND C.attrName = N'Content Indexing Enabled' AND C.attrVal = N'1' AND C.modified = 0) A
	WHERE	J.appId = A.appId
AND J.minFileType = 1
AND J.dataOnMedia = 1
		AND A.appType IN (
			-- From OffliineCI-SupportedApptypes.doc
			-- 1.1	File System apptypes
1,
11,
13,
17,
18,
19,
20,
21,
29,
33,
34,
36,
38,
42,
43,
63,
64,
74,
73,
86,
106,
128,
124,
			-- 1.2	File System Archiver apptypes
58,
66,
			-- 1.3	Exchange application apptypes
8,
14,
35,
44,
45,
54,
55,
56,
57,
67,
68,
82,
			-- 1.4	Share point application apptypes
46,
78,
89,
			-- 1.5	Lotus notes application apptypes
52,
90,
			--gmail / gdrive
134
			)
	UPDATE	#tempJob
	SET		flagsCI = 0
	FROM	archGroupCopy AGC WITH (NOLOCK)
	WHERE	#tempJob.appId = AGC.siloAppId AND AGC.archGroupId = @spId
	UPDATE	#tempJob
	SET		flagsCI = 0
	FROM	APP_Application A WITH (NOLOCK), APP_BackupSetName B WITH (NOLOCK)
WHERE	A.id = #tempJob.appId AND A.appTypeId IN (46, 78)
AND B.id = A.backupSet AND (B.status & 0x0800) <> 0
	--do not allow to run ci job if subclient is not selected
	--get all appids associated to SP
	IF object_id('tempdb.dbo.#appIdTbl') is not null DROP TABLE #appIdTbl
	CREATE TABLE #appIdTbl (t_appId int)
	IF EXISTS (SELECT 1 FROM archContentIndexingApp (NOLOCK) WHERE  archGroupId = @spId)
	BEGIN
		INSERT INTO #appIdTbl
		SELECT DISTINCT S.id
		FROM archContentIndexingApp APP (NOLOCK)
		INNER JOIN APP_Application S (NOLOCK) ON APP.clientId =S.clientId
		WHERE archGroupID = @spId
			AND (APP.appTypeId = 0  OR APP.appTypeId = S.appTypeId)
			AND (APP.instanceId = 0 OR APP.instanceId =S.instance)
			AND (APP.instanceId = 0 OR APP.instanceId =S.instance)
			AND (APP.backupSetId = 0 OR APP.backupSetId =S.backupSet)
			AND (APP.subClientId = 0 OR APP.subClientId =S.id)
			AND (S.subclientStatus & 0x0200) = 0
	END
	ELSE
	BEGIN
		--ALL SUBCLIENTS SELECTED
		INSERT INTO #appIdTbl
		SELECT DISTINCT S.id
		FROM APP_Application S WITH (NOLOCK)
		WHERE dataArchGrpID = @spId
			AND (S.subclientStatus & 0x0200) = 0
	END
	UPDATE	#tempJob
	SET	flagsCI = 0
	FROM #tempJob T
	WHERE T.appId NOT IN (select t_appId from #appIdTbl)
	DROP TABLE #appIdTbl
	--Reset CI flag for DDB backup jobs as they are not eligible for CI.
	UPDATE	#tempJob SET  flagsCI = 0
	FROM	APP_Application	APP, APP_SubClientProp	ASP
	WHERE	#tempJob.appId = APP.id AND APP.id = ASP.componentNameId AND RTRIM(LTRIM(ASP.attrName)) = N'DDB Backup'
			AND RTRIM(LTRIM(ASP.attrVal)) = N'1'
	--Reset CI flag for INDEX backup jobs as they are not eligible for CI.
	UPDATE	#tempJob SET  flagsCI = 0
	FROM	APP_Application	APP WITH (NOLOCK)
	WHERE   #tempJob.appId = APP.id AND APP.subclientName ='IndexBackup'
	--prevent CI for edge backup jobs
	UPDATE	#tempJob SET  flagsCI = 0
	FROM	APP_Application	APP WITH (NOLOCK)
WHERE   #tempJob.appId = APP.id AND (APP.subclientStatus & 0x20000) = 0x20000
	--prevent CI for block level backup  jobs
	UPDATE	#tempJob SET  flagsCI = 0
	FROM	archFile AF (NOLOCK)
WHERE   AF.jobId = #tempJob.jobId AND AF.commCellId = #tempJob.commCellId AND (AF.flags & 512) > 0
	-- Reset CI flag for jobs that have not been fully copied yet.
	SELECT @srcCopyID = sourceCopyId FROM archContentIndexingRules WITH (NOLOCK) WHERE archGroupId = @spId
	IF (@srcCopyID  >  0 )
	BEGIN
	UPDATE #tempJob SET flagsCI = 0
	FROM (	SELECT JDS.jobId, JDS.commCellId,JDS.archGrpId, JDS.archGrpCopyId, MAX(status) as jobStats
			FROM JMJobDataStats JDS, #tempJob T
			WHERE JDS.jobId = T.jobId AND JDS.commCellId = T.commCellId AND archGrpId = @spId  AND archGrpCopyId = @srcCopyID
			GROUP BY JDS.jobId, JDS.commCellId,JDS.archGrpId, JDS.archGrpCopyId
			HAVING MAX(status) > 0 AND MAX(status) <> 1000
		 ) Q
	WHERE	#tempJob.jobId = Q.jobId AND #tempJob.commCellId = Q.commCellId AND Q.jobStats IN (101,102,103)
AND (flagsCI & 16 <> 0 OR flagsCI & 256 <> 0 )
	END
END
-- Get successful jobs including those have no archive file
INSERT INTO #tempJobStats
SELECT	B.jobId, B.commCellId, C.aliasName, B.dataStatus,
		case when B.dataArchGrpId > 1 and B.logArchGrpId > 1 and B.dataArchGrpId <> B.logArchGrpId
			then ISNULL((select sum(unCompBytes) from JMBkpAtmptStats WITH (NOLOCK)
					where jobId = B.jobId and commCellId = B.commCellId and archGrpId = @spId and status in (1,3,14)), 0)
			else B.totalUncompBytes end,
		case when B.dataArchGrpId > 1 and B.logArchGrpId > 1 and B.dataArchGrpId <> B.logArchGrpId
			then ISNULL((select sum(compBytes) from JMBkpAtmptStats WITH (NOLOCK)
					where jobId = B.jobId and commCellId = B.commCellId and archGrpId = @spId and status in (1,3,14)), 0)
			else B.totalCompBytes end,
		B.totalBackupSize,
		case when B.dataArchGrpId > 1 and B.logArchGrpId > 1 and B.dataArchGrpId <> B.logArchGrpId
			then ISNULL((select sum(nwTransBytes) from JMBkpAtmptStats WITH (NOLOCK)
					where jobId = B.jobId and commCellId = B.commCellId and archGrpId = @spId and status in (1,3,14)), 0)
			else B.nwTransBytes end,
		A.clientId, A.clientName, A.appType, A.appTypeName, A.backupSet, A.backupSetName,
		A.appId, A.subclientName, A.instance, A.instanceName,
		B.servStartDate, B.servEndDate, B.opType, B.bkpLevel, B.displayStatus, B.fullCycleNum, B.cycleSequence,
		B.duration, B.numStreams, B.initFrom, B.bkpAttributes, B.bkpAttributesEx, B.failureReason, B.username, B.totalWriteTime,
		B.scanFileFailures, B.scanFolderFailures, B.backupFileFailures, B.backupFolderFailures,
		(select ISNULL(sum(numObjects), 0) from JMBkpAtmptStats WITH (NOLOCK) where jobId = B.jobId and commCellId = B.commCellId),
		0/*extRetentionFlags*/, 0/*retentionEndTime*/, B.agedTime,
		ISNULL(J.flagsCI, 0), ISNULL(J.flagsFLA, 0), ISNULL(J.minFileType, 1), ISNULL(J.contentIndexTime, 0),
		(case when B.opType IN (59, 65) /*AND JMV.childJobId IS NULL*/ then ISNULL((case when (S.disabled = 0 or S.materializationStatus = 100) then S.materializationStatus else 0 end), 0)
			else -1 end),
		(case when B.opType IN (59, 65) AND (A.isDefferedCatalogSupported = 1)
			then ISNULL((case when (DCS.disabled = 0 or DCS.catalogStatus = 100) then DCS.catalogStatus else 0 end), 0)
			else -1 end),
			0, 0, ISNULL(JDS.archGrpCopyId,-1),0, '', CP.stringval, 0/*for index backup job flag*/,
		encrypted = (
						CASE
							WHEN J.encrypted IS NULL THEN 2
							WHEN J.encrypted > 0 THEN 1
							ELSE 0
						END
					), A.clientDisplayName
FROM	#tempAppList A
		INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.appId = A.appId AND (B.dataArchGrpId = @spId OR B.logArchGrpId = @spId OR B.diffArchGrpId = @spId)
INNER JOIN APP_CommCell C WITH (NOLOCK) ON C.id = B.commCellId AND (C.type = 1 OR @l_policyType = 5)
		LEFT  JOIN #tempJob J ON B.jobId = J.jobId AND B.commCellId = J.commCellId
		LEFT  JOIN JMJobSnapshotStats S ON B.jobId = S.jobId AND B.commCellId = S.commCellId
		--LEFT  JOIN JMVSAAppJobLink JMV ON B.jobId = JMV.childJobId AND	B.commCellId = JMV.commCellId
		LEFT  JOIN JMJobSnapDeferredCatalogStats DCS ON  B.jobId = DCS.jobId AND B.commCellId = DCS.commCellId
LEFT  JOIN APP_ComponentProp CP ON  J.cloudId = CP.ID AND cp.modified = 0 AND CP.componentType = 1 AND CP.componentId = 2 AND CP.propertyTypeId= 1
LEFT OUTER JOIN (SELECT distinct jobId, commCellId, archGrpCopyId FROM JMJobDataStats WITH (NOLOCK)) JDS ON (@options & 128 > 0) AND JDS.jobId = B.jobId AND JDS.commCellId = B.commCellId
WHERE	(@CIStatusFilter = 0 OR J.jobId Is Not Null) AND B.status IN (1, 3, 14, 16)
	AND (@timeRangeBegin <= 0 OR B.servStartDate >= @timeRangeBegin) AND (@timeRangeEnd <= 0 OR B.servStartDate < @timeRangeEnd)
	AND (@theBackupLevel <= 0 OR B.bkpLevel = @theBackupLevel OR @theBackupLevel = 1 AND B.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
		OR @theBackupLevel = 2 AND B.bkpLevel IN (2,256))
IF (@bkpCopyStatusFilter > 0)
BEGIN
	/*
	Backup copy status in #tempJobStats
	100- Success
	101, 102, 103 - Picked for backup copy
	0 - Not picked for backup copy
	-1 - Not applicable
	*/
	IF (@bkpCopyStatusFilter = 1) 			--User wants to see only the jobs that are successfully moved
		DELETE FROM #tempJobStats WHERE snapToTapeStatus IN (101, 102, 103, 0)
	ELSE IF (@bkpCopyStatusFilter = 2) 		--User wants to see only the jobs that are in picked state for backup copy
		DELETE FROM #tempJobStats WHERE snapToTapeStatus IN (0, 100)
	ELSE IF (@bkpCopyStatusFilter = 4) 		--User wants to see only the jobs that are not picked for backup copy
		DELETE FROM #tempJobStats WHERE snapToTapeStatus IN(100, 101, 102, 103)
	ELSE IF (@bkpCopyStatusFilter = (1+2))
		DELETE FROM #tempJobStats WHERE snapToTapeStatus = 0
	ELSE IF (@bkpCopyStatusFilter = (1+4))
		DELETE FROM #tempJobStats WHERE snapToTapeStatus IN (101, 102, 103)
	ELSE IF	(@bkpCopyStatusFilter = (2+4))
		DELETE FROM #tempJobStats WHERE snapToTapeStatus  = 100
END
INSERT INTO #tempJobStats
SELECT	B.jobId, B.commCellId, AC.aliasName,
		B.dataStatus, (case when B.uncompBytes > 0 then B.uncompBytes else B.totalBackupSize end),
		(case when B.TotalSize > 0 then B.TotalSize else B.totalBackupSize end), B.totalBackupSize, B.nwTransBytes,
		A.clientId, A.clientName, A.appType, A.appTypeName, A.backupSet, A.backupSetName,
		A.appId, A.subclientName, A.instance, A.instanceName,
		B.servStart, B.servEnd, B.opType, B.ER_BkpLevel, B.status, B.fullCycleNum, 0/*B.cycleSequence*/,
		0/*duration*/, B.noOfStreams, B.initFrom, 0/*bkpAttributes*/, 0/*bkpAttributesEx*/, B.failureReason, B.username, B.totalWriteTime,
		0/*scanFileFailures*/, 0/*scanFolderFailures*/, 0/*backupFileFailures*/, 0/*backupFolderFailures*/, 0/*numObjects*/,
		0/*extRetentionFlags*/, 0/*retentionEndTime*/, 0/*agedTime*/,
		ISNULL(J.flagsCI, 0), ISNULL(J.flagsFLA, 0), ISNULL(J.minFileType, 1), ISNULL(J.contentIndexTime, 0), -1/*snapToTapeStatus*/, -1/*snapDeferredCatalogStatus*/, 0, 0, ISNULL(JDS.archGrpCopyId,-1),0, '', CP.StringVal, 0/*for index backup job flag*/,
		encrypted = 2, A.clientDisplayName
FROM	JMAdminJobStatsTable B WITH (NOLOCK)
        INNER JOIN APP_CommCell AC WITH (READUNCOMMITTED)ON AC.id=B.commCellId
		INNER JOIN #tempAppList A ON B.appId = A.appId AND B.archGrpID = @spId
		LEFT OUTER JOIN #tempJob J ON B.jobId = J.jobId AND B.commCellId = J.commCellId
LEFT  JOIN APP_ComponentProp CP ON  J.cloudId = CP.ID AND CP.modified = 0 AND CP.componentType = 1 AND CP.componentId = 2 AND CP.propertyTypeId= 1
LEFT OUTER JOIN (SELECT distinct jobId, commCellId, archGrpCopyId FROM JMJobDataStats WITH (NOLOCK)) JDS ON (@options & 128 > 0) AND JDS.jobId = B.jobId AND JDS.commCellId = B.commCellId
WHERE	(@CIStatusFilter = 0 OR J.jobId Is Not Null)
	AND (@timeRangeBegin <= 0 OR B.servStart >= @timeRangeBegin) AND (@timeRangeEnd <= 0 OR B.servStart < @timeRangeEnd)
	AND (@theBackupLevel <= 0 OR B.ER_BkpLevel = @theBackupLevel OR @theBackupLevel = 1 AND B.ER_BkpLevel IN (1, 64, 128, 1024, 16384, 32768)
		OR @theBackupLevel = 2 AND B.ER_BkpLevel IN (2,256))
DROP TABLE #tempJob
-- CI for VMWare iDA is supported only for File Level backup
UPDATE	#tempJobStats SET flagsCI = 0
WHERE	appTypeId = 106 AND (attributes & 0x18000000000) <> 0x08000000000 AND flagsCI <> 0
INSERT INTO #temp_ret_copy
SELECT AR.copyId,
	   (case when AR.retentionDays < 0 then @MAXINT else AR.retentionDays end) AS retentionDays,
	   (case when AR.archiverRetDays < 0 then @MAXINT else AR.archiverRetDays end) AS archiverRetDays
	FROM	archAgingRule AR WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE	AR.copyId = AGC.id
	        AND AGC.archGroupId = @spId
INSERT INTO #tempJobRetention
SELECT	DISTINCT B.jobId, B.commCellId, B.archGrpCopyId, B.appId,
		MAX((case when AP.isDMAppType = 1 then A.archiverRetDays else A.retentionDays end)),
		MAX(B.retentionFlags), 0,
		MAX((case when (B.disabled & 2 = 0) then 0 when B.manualRetentionEndTime = -1 then @MAXINT else B.manualRetentionEndTime end)),
		MAX(CASE WHEN B.status IN (2, 100, 102, 103) THEN 1 ELSE 0 END) |
		--MAX(CASE WHEN B.status IN (101, 102, 103) THEN 2 ELSE 0 END) |
		MAX(B.disabled & 256) |
		MAX(CASE WHEN ((B.disabled & 256) = 0 AND B.status IN (100, 102, 103)) THEN 1024 ELSE 0 END) --| /*If there is at least one row with valid data unaged we'll not consider them as fully aged job*/
		--MAX(CASE WHEN B.status IN (1000) THEN 512 ELSE 0 END)
FROM	JMJobDataStats B WITH (NOLOCK), #tempJobStats J, #tempAppList AP,#temp_ret_copy A
WHERE	B.commCellId = J.commCellId AND B.jobId = J.jobId
--	AND B.status IN (2, 100) AND (
--		@isAged = 0 AND B.disabled & CVA_AGED_DATA_FLAG = 0 OR
--		@isAged = 1 AND B.disabled & CVA_AGED_DATA_FLAG <> 0 OR
--		@isAged = 2)
	AND (@ExtRetainedOnly = 0 OR B.retentionFlags <> 0)
	AND A.copyId = B.archGrpCopyId
	AND AP.appId = B.appId
GROUP BY B.jobId, B.commCellId, B.archGrpCopyId, B.appId
DELETE FROM #tempJobRetention
WHERE 	NOT		((  #tempJobRetention.jobCopyStatus & 1 > 0)
			AND (	@isAged = 0 AND (#tempJobRetention.jobCopyStatus & 256 = 0 OR #tempJobRetention.jobCopyStatus & 1024 <> 0)
				OR	@isAged = 1 AND #tempJobRetention.jobCopyStatus & 256 <> 0
				OR	@isAged = 2))
UPDATE	#tempJobRetention
SET		extRetentionFlags = (
		case
				when extRetentionFlags & (64|4096) <> 0 then 64
				when extRetentionFlags & (32|2048) <> 0 then 32
				when extRetentionFlags & (16|1024) <> 0 then 16
				when extRetentionFlags & (8 | 512) <> 0 then 8
				when extRetentionFlags & (4 | 256) <> 0 then 4
				when extRetentionFlags & (524288 | 8388608) <> 0 then 524288
				when extRetentionFlags & (262144 | 4194304) <> 0 then 262144
				when extRetentionFlags & 2 <> 0 then 2
		end)
WHERE	extRetentionFlags <> 0
UPDATE	#tempJobRetention
SET		extRetentionDays = b.retentionDays
FROM	#tempJobRetention a,
		(SELECT AR.copyId, AR.retentionRule,
		(case when AR.retentionDays < 0 then @MAXINT else AR.retentionDays end) AS retentionDays
		FROM	archAgingRuleExtended AR, archGroupCopy AGC WITH (NOLOCK)
		WHERE	AR.copyId = AGC.id AND AGC.archGroupId = @spId) b
WHERE	b.copyId = a.archGrpCopyId AND b.retentionRule = a.extRetentionFlags
--Update retentionDays for those appType and copy that honors Job Based Retention
UPDATE #tempJobRetention
SET retentionDays = -2,
		extRetentionDays = -2
FROM	#tempJobRetention T, archAgingRule AAR WITH (NOLOCK), App_Application A WITH (NOLOCK)
WHERE	T.archGrpCopyId = AAR.copyId
AND		(AAR.flags & 128) > 0
AND		AAR.retentionJobs > 0
AND 	T.appId = A.id
AND		A.appTypeId NOT IN (
				SELECT appTypeId
				FROM APP_IDATypeHandlingInfo
				WHERE ignoreJobRetention = 1
			)
AND		T.manualRetentionEndTime = 0
--Update isDDBBackup = 1 for DDB subclients
UPDATE #tempJobRetention
SET retentionDays = -2,
		extRetentionDays = -2
FROM	#tempJobRetention T, App_SubclientProp B WITH (NOLOCK)
WHERE	T.appId = B.componentNameId
AND		B.attrName = 'DDB Backup'
AND		B.attrVal = '1'
AND		B.modified = 0
AND		T.manualRetentionEndTime = 0
UPDATE #tempJobStats
SET indexBackupJob = 1
FROM	#tempJobStats T, App_SubclientProp B WITH (NOLOCK)
WHERE	T.subClientId = B.componentNameId
AND		B.attrName = 'Index SubClient'
AND		B.attrVal = '1'
AND		B.modified = 0
IF(@options & 128 = 0)
	INSERT INTO #maxJobRetention
	SELECT	jobId, commCellId, -1, MAX(extRetentionFlags), MAX(retentionDays), MAX(extRetentionDays), MAX(manualRetentionEndTime)
	FROM	#tempJobRetention
	GROUP BY jobId, commCellId
ELSE
	INSERT INTO #maxJobRetention
	SELECT	jobId, commCellId, archGrpCopyId, extRetentionFlags, retentionDays, extRetentionDays, manualRetentionEndTime
	FROM	#tempJobRetention
DROP TABLE #tempJobRetention
IF(@options & 128 = 0)
	DELETE	#tempJobStats
	FROM	#tempJobStats JS LEFT OUTER JOIN #maxJobRetention JR
			ON JR.jobId = JS.jobId AND JR.commCellId = JS.commCellId
	WHERE	JR.jobId IS NULL
ELSE
	DELETE	#tempJobStats
	FROM	#tempJobStats JS LEFT OUTER JOIN #maxJobRetention JR
			ON JR.jobId = JS.jobId AND JR.commCellId = JS.commCellId AND JR.copyId = JS.copyId
	WHERE	JR.jobId IS NULL
-- Filter some columns for Storage policy summary as these are not used
IF(@options & 256 = 0)
BEGIN
	UPDATE	#maxJobRetention
	SET		retentionDays = extRetentionDays
	WHERE	retentionDays < extRetentionDays
IF(@options & 128 = 0)
	UPDATE	#tempJobStats
	SET		extRetentionFlags = JR.extRetentionFlags,
			retentionEndTime  = case when JR.retentionDays = -2 then -2
					 					when (JR.manualRetentionEndTime = @MAXINT OR JR.retentionDays = @MAXINT) then -1
										when  JR.manualRetentionEndTime > (JS.startTime + retentionDays*24*3600) then JR.manualRetentionEndTime
									 else (JS.startTime + retentionDays*24*3600) end,
			retainedBy = 	case when JR.retentionDays = @MAXINT then 0 when JR.manualRetentionEndTime = @MAXINT then 1  when  JR.manualRetentionEndTime > (JS.startTime + retentionDays*24*3600) then 1 else 0 end
	FROM	#tempJobStats JS, #maxJobRetention JR
	WHERE	JR.jobId = JS.jobId AND JR.commCellId = JS.commCellId
ELSE
	UPDATE	#tempJobStats
	SET		extRetentionFlags = JR.extRetentionFlags,
			retentionEndTime  = case when JR.retentionDays = -2 then -2
				 						when (JR.manualRetentionEndTime = @MAXINT OR JR.retentionDays = @MAXINT) then -1
										when  JR.manualRetentionEndTime > (JS.startTime + retentionDays*24*3600) then JR.manualRetentionEndTime
									 else (JS.startTime + retentionDays*24*3600) end,
			retainedBy = 	case when JR.retentionDays = @MAXINT then 0 when JR.manualRetentionEndTime = @MAXINT then 1 when  JR.manualRetentionEndTime > (JS.startTime + retentionDays*24*3600) then 1 else 0 end
	FROM	#tempJobStats JS, #maxJobRetention JR
	WHERE	JR.jobId = JS.jobId AND JR.commCellId = JS.commCellId AND JS.copyId = JR.copyId
END
-- Delete the foreing jobs if they are already prepared
DELETE	#tempJobStats
FROM	#tempJobStats, JMPreparedJob
WHERE	#tempJobStats.jobId = JMPreparedJob.jobId AND #tempJobStats.commCellId = JMPreparedJob.commCellId
		AND JMPreparedJob.status = 3
DECLARE	@l_jobId		INT
DECLARE	@l_commCellId	INT
DECLARE	@l_instanceName	VARCHAR(255)
DECLARE	@l_len			INT
DECLARE	@t_jobId		INT
DECLARE	@t_commCellId	INT
DECLARE	@t_instanceName	VARCHAR(255)
DECLARE	@t_len			INT
SET	@l_jobId		= 0
SET	@l_commCellId	= 0
SET	@l_len			= 0
DECLARE	GetInstanceNameCur CURSOR STATIC FOR
SELECT	T.jobId, T.commCellId, I.name, LEN(I.name)
FROM	archFileOracle A WITH (NOLOCK), archFile F WITH (NOLOCK), APP_InstanceName I WITH (NOLOCK), JMBkpStats J WITH (NOLOCK),
(SELECT DISTINCT jobId, commCellId, instanceId FROM #tempJobStats WHERE appTypeId = 22) T
WHERE	A.archFileId = F.id AND A.commCellId = F.commCellId
	AND F.jobId = T.jobId AND F.commCellId = T.commCellId
AND J.jobId = T.jobId AND J.commCellId = T.commCellId AND (J.bkpAttributes & 0x20000) > 0
	AND I.id = A.instanceId AND A.instanceId <> T.instanceId
GROUP BY T.jobId, T.commCellId, I.name
ORDER BY T.jobId, T.commCellId, I.name
OPEN	GetInstanceNameCur
FETCH	FROM GetInstanceNameCur
INTO	@t_jobId, @t_commCellId, @t_instanceName, @t_len
WHILE @@FETCH_STATUS = 0
BEGIN
	IF	@l_jobId = @t_jobId AND @l_commCellId = @t_commCellId
	BEGIN
IF	@l_len < (255 - 6)
		BEGIN
IF	(@l_len + @t_len) < (255 - 6)
			BEGIN
				SET @l_instanceName = @l_instanceName + ', ' + @t_instanceName
				SET @l_len = @l_len + @t_len + 2
			END
			ELSE
			BEGIN
				SET @l_instanceName = @l_instanceName + ', ...)'
SET @l_len = 255
			END
		END
	END
	ELSE
	BEGIN
		IF	@l_jobId > 0
			UPDATE	#tempJobStats SET instanceName = @l_instanceName + ')'
			WHERE	jobId = @l_jobId AND commCellId = @l_commCellId
		SET @l_jobId		= @t_jobId
		SET @l_commCellId	= @t_commCellId
		SET	@l_instanceName	= 'On Demand Instance (' + @t_instanceName
		SET @l_len			= @t_len + 20
	END
	FETCH	FROM GetInstanceNameCur
	INTO	@t_jobId, @t_commCellId, @t_instanceName, @t_len
END
IF	@l_jobId > 0
	UPDATE	#tempJobStats SET instanceName = @l_instanceName + ')'
	WHERE	jobId = @l_jobId AND commCellId = @l_commCellId
CLOSE		GetInstanceNameCur
DEALLOCATE	GetInstanceNameCur
IF	@l_policyType = 1
AND (@options & (32|64)) <> 0
BEGIN
	IF	object_id('tempdb.dbo.#tempAppIdList') IS NOT Null
		INSERT	#tempForeignApp
		SELECT	a.id, a.subclientName,
				a.backupSet,(select name from APP_BackupSetName where id = a.backupSet),
				a.instance,	(select name from APP_InstanceName  where id = a.instance),
				a.appTypeId,(select name from APP_iDAType where type = a.appTypeId),
				a.clientId, (select name from APP_Client where id = a.clientId),
				(select displayName from APP_Client where id = a.clientId)
		FROM	APP_Application a, #tempAppIdList c,
				(SELECT	componentNameId
				FROM	APP_SubclientProp
				WHERE	attrName = N'EDC Foreign Subclient' AND attrVal = N'1' AND modified = 0) b
		WHERE	a.dataArchGrpId = @spId AND a.id = c.appId
			AND b.componentNAmeId = a.id
	ELSE
		INSERT	#tempForeignApp
		SELECT	a.id, a.subclientName,
				a.backupSet,(select name from APP_BackupSetName where id = a.backupSet),
				a.instance,	(select name from APP_InstanceName  where id = a.instance),
				a.appTypeId,(select name from APP_iDAType where type = a.appTypeId),
				a.clientId, (select name from APP_Client where id = a.clientId),
				(select displayName from APP_Client where id = a.clientId)
		FROM	APP_Application a,
				(SELECT	componentNameId
				FROM	APP_SubclientProp
				WHERE	attrName = N'EDC Foreign Subclient' AND attrVal = N'1' AND modified = 0) b
		WHERE	a.dataArchGrpId = @spId
			AND b.componentNAmeId = a.id
END
-- Show discovered foreign snap jobs taht will or will not be moved to tape.
IF	EXISTS (SELECT * FROM #tempForeignApp)
BEGIN
IF	(@options & 32) <> 0
		INSERT	INTO #tempJobStats
		SELECT	B.jobId, B.commCellId, C.aliasName,
				B.dataStatus, B.totalUncompBytes, B.totalCompBytes, B.totalBackupSize, B.nwTransBytes,
				A.clientId, A.clientName, A.appType, A.appTypeName, A.backupSet, A.backupSetName,
				A.appId, A.subclientName, A.instance, A.instanceName,
				B.servStartDate, B.servEndDate, B.opType, B.bkpLevel, B.displayStatus, B.fullCycleNum, B.cycleSequence,
				B.duration, B.numStreams, B.initFrom, B.bkpAttributes, B.bkpAttributesEx, B.failureReason, B.username, B.totalWriteTime,
				B.scanFileFailures, B.scanFolderFailures, B.backupFileFailures, B.backupFolderFailures,
				(select ISNULL(sum(numObjects), 0) from JMBkpAtmptStats WITH (NOLOCK) where jobId = B.jobId and commCellId = B.commCellId),
				0/*extRetentionFlags*/, 0/*retentionEndTime*/, 0/*agedTime*/,
				0/*flagsCI*/, 0/*flagsFLA*/, 0/*minFileType*/, 0/*contentIndexTime*/, J.materializationStatus, -1 /*@Todo - What should we do for deferred catalog*/,0, 0, ISNULL(JDS.archGrpCopyId, -1), '', '', 0/*for index backup job flag*/,
				encrypted = 2, A.clientDisplayName
		FROM	#tempForeignApp A
				INNER JOIN JMBkpStats B WITH (NOLOCK)
					ON B.appId = A.appId AND B.status IN (1, 3, 14, 16)
				INNER JOIN APP_CommCell C WITH (NOLOCK)
					ON C.id = B.commCellId AND C.type > 1
				INNER JOIN JMJobSnapshotStats J WITH (NOLOCK)
					ON B.jobId = J.jobId AND B.commCellId = J.commCellId
					AND J.archGrpId = @spId AND J.materializationStatus IN (101, 102, 103) AND J.disabled = 0
				LEFT OUTER JOIN JMPreparedJob PJ WITH (NOLOCK)
					ON J.jobId = PJ.jobId AND J.commCellId = PJ.commCellId
LEFT OUTER JOIN (SELECT distinct jobId, commCellId, archGrpCopyId FROM JMJobDataStats WITH (NOLOCK)) JDS ON (@options & 128 > 0) AND JDS.jobId = B.jobId AND JDS.commCellId = B.commCellId
		WHERE	PJ.jobId IS NULL
			AND (@timeRangeBegin <= 0 OR B.servStartDate >= @timeRangeBegin) AND (@timeRangeEnd <= 0 OR B.servStartDate < @timeRangeEnd)
			AND (@theBackupLevel <= 0 OR B.bkpLevel = @theBackupLevel OR @theBackupLevel = 1 AND B.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
				OR @theBackupLevel = 2 AND B.bkpLevel IN (2,256))
IF	(@options & 64) <> 0
		INSERT	INTO #tempJobStats
		SELECT	B.jobId, B.commCellId, C.aliasName,
				B.dataStatus, B.totalUncompBytes, B.totalCompBytes, B.totalBackupSize, B.nwTransBytes,
				A.clientId, A.clientName, A.appType, A.appTypeName, A.backupSet, A.backupSetName,
				A.appId, A.subclientName, A.instance, A.instanceName,
				B.servStartDate, B.servEndDate, B.opType, B.bkpLevel, B.displayStatus, B.fullCycleNum, B.cycleSequence,
				B.duration, B.numStreams, B.initFrom, B.bkpAttributes, B.bkpAttributesEx, B.failureReason, B.username, B.totalWriteTime,
				B.scanFileFailures, B.scanFolderFailures, B.backupFileFailures, B.backupFolderFailures,
				(select ISNULL(sum(numObjects), 0) from JMBkpAtmptStats WITH (NOLOCK) where jobId = B.jobId and commCellId = B.commCellId),
				0/*extRetentionFlags*/, 0/*retentionEndTime*/, 0/*agedTime*/,
				0/*flagsCI*/, 0/*flagsFLA*/, 0/*minFileType*/, 0/*contentIndexTime*/, 0/*snapToTapeStatus*/, 0 /*@Todo - What should we do for deferred catalog*/,0, 0, ISNULL(JDS.archGrpCopyId, -1), '', '', 0/*for index backup job flag*/,
				encrypted = 2, A.clientDisplayName
		FROM	#tempForeignApp A
				INNER JOIN JMBkpStats B WITH (NOLOCK)
					ON B.appId = A.appId AND B.status IN (1, 3, 14, 16)
				INNER JOIN APP_CommCell C WITH (NOLOCK)
					ON C.id = B.commCellId AND C.type > 1
				LEFT OUTER JOIN JMJobSnapshotStats J WITH (NOLOCK)
					ON J.jobId = B.jobId AND J.commCellId = B.commCellId AND J.archGrpId = @spId
LEFT OUTER JOIN (SELECT distinct jobId, commCellId, archGrpCopyId FROM JMJobDataStats WITH (NOLOCK)) JDS ON (@options & 128 > 0) AND JDS.jobId = B.jobId AND JDS.commCellId = B.commCellId
		WHERE	(J.jobId IS NULL OR J.materializationStatus IN (101, 102, 103) AND J.disabled <> 0)
			AND (@timeRangeBegin <= 0 OR B.servStartDate >= @timeRangeBegin) AND (@timeRangeEnd <= 0 OR B.servStartDate < @timeRangeEnd)
			AND (@theBackupLevel <= 0 OR B.bkpLevel = @theBackupLevel OR @theBackupLevel = 1 AND B.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
				OR @theBackupLevel = 2 AND B.bkpLevel IN (2,256))
END
IF	(@options & 1) = 0 OR @l_TimeZoneType = 0
	INSERT	INTO #tempTimeZone
	SELECT	DISTINCT clientId, @l_csTimeZone
	FROM	#tempAppList
ELSE
IF	@l_TimeZoneType = 1
	INSERT	INTO #tempTimeZone
	SELECT	T.clientId, dbo.archGroupTimeZone(@spId, T.clientId)
	FROM	(SELECT DISTINCT clientId FROM #tempAppList) T
ELSE
	INSERT	INTO #tempTimeZone
	SELECT	DISTINCT clientId, @l_TimeZone
	FROM	#tempAppList
UPDATE	#tempJobStats
SET		startTime		= JS.startTime + dbo.GetDiffFromCSTimeZone(JS.startTime, TZ.TimeZone, @l_csTimeZone),
		endTime			= JS.endTime + dbo.GetDiffFromCSTimeZone(JS.endTime, TZ.TimeZone, @l_csTimeZone),
		retentionEndTime= case when JS.retentionEndTime = -2 then -2
					when JS.retentionEndTime = @MAXINT then -1
					else JS.retentionEndTime + dbo.GetDiffFromCSTimeZone(JS.retentionEndTime, TZ.TimeZone, @l_csTimeZone) end,
		agedTime		= case when JS.agedTime = 0 then 0 else
						JS.agedTime + dbo.GetDiffFromCSTimeZone(JS.agedTime, TZ.TimeZone, @l_csTimeZone) end,
		contentIndexTime= case when JS.contentIndexTime = 0 then 0 else
						JS.contentIndexTime + dbo.GetDiffFromCSTimeZone(JS.contentIndexTime, TZ.TimeZone, @l_csTimeZone) end
FROM	#tempJobStats JS, #tempTimeZone TZ
WHERE	JS.clientId = TZ.clientId AND TZ.TimeZone <> '' AND TZ.TimeZone <> @l_csTimeZone
-- Update retention criteria for OBJECT_STORE / CONTENT_SERVER=OBJECT_SERVER
-- DO NOT Honour SP/Copy Retention for Content Store Based On MMConfigs Option
IF @HonorSPCopyRetentionForContentStore = 0
BEGIN
	UPDATE	#tempJobStats
	SET		retentionEndTime = -1
	FROM	#tempJobStats J
WHERE	appTypeId IN (131,124)
END
IF(@options & 128 = 0)
	UPDATE	#tempJobStats
	SET		sizeOnMedia = S.sizeOnMedia
	FROM	(SELECT	J.jobId, J.commCellId, SUM(J.sizeOnMedia) AS sizeOnMedia
			FROM	#tempJobStats T, JMJobDataStats J WITH (NOLOCK)
			WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.archGrpCopyId = @l_defaultCopy
			GROUP BY J.jobId, J.commCellId
	        HAVING  SUM(J.sizeOnMedia) > 0) S
	WHERE	#tempJobStats.jobId = S.jobId AND #tempJobStats.commCellId = S.commCellId
ELSE
	UPDATE	#tempJobStats
	SET		sizeOnMedia = S.sizeOnMedia
	FROM	(SELECT	J.jobId, J.commCellId, J.archGrpCopyId, SUM(J.sizeOnMedia) AS sizeOnMedia
			FROM	#tempJobStats T, JMJobDataStats J WITH (NOLOCK)
			WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.archGrpCopyId = T.copyId
			GROUP BY J.jobId, J.commCellId, J.archGrpCopyId
			HAVING  SUM(J.sizeOnMedia) > 0) S
	WHERE	#tempJobStats.jobId = S.jobId AND #tempJobStats.commCellId = S.commCellId AND #tempJobStats.copyId = S.archGrpCopyId
-- Filter some columns for Storage policy summary as these are not used
IF(@options & 256 = 0)
BEGIN
UPDATE #tempJobStats
SET jobDescription = JMJS.jobDescription
	FROM JMJobStats as JMJS WITH (READUNCOMMITTED)
where #tempJobStats.jobId = JMJS.jobId AND #tempJobStats.commCellId = JMJS.commCellId
UPDATE	#tempJobStats
	SET	 stubDataSize = ISNULL((select attributeValueInt from JMJobOptions jm WITH (NOLOCK)  where jm.jobid = #tempJobStats.jobId AND jm.attributeName = 'stub size'),0)
UPDATE #tempJobStats SET opType = subOpType
	FROM JMJobStats JMS WITH (READUNCOMMITTED)
WHERE #tempJobStats.jobId = JMS.jobId AND #tempJobStats.commCellId = JMS.commCellId AND JMS.subOpType > 0
IF (@options & 128 = 0)
	UPDATE #tempJobStats
	SET dedupSaving = T.dedupSaving
	FROM
	( SELECT SUM(ISNULL(AFD.secondaryObjSize, 0) + ISNULL(AFD.secondaryMetaDataSize, 0) + ISNULL(AFD.primaryMetaDataSize, 0)) as dedupSaving, J.jobId, J.commCellId
		FROM #tempJobStats J
				INNER JOIN archFile AF WITH (READUNCOMMITTED)
				ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND AF.isValid = 1
				INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED)
				ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = @l_defaultCopy AND (AFC.flags &256) = 0
				LEFT OUTER JOIN archFileCopyDedup AFD WITH (READUNCOMMITTED)
				ON AFD.archFileId = AFC.archFileId AND AFD.commCellId = AFC.commCellId AND AFD.archCopyId = AFC.archCopyId AND AFD.secondaryObjSize > 0
		GROUP BY J.jobId, J.commCellId
	) T
	WHERE #tempJobStats.jobId = T.jobId
	AND #tempJobStats.commCellId = T.commCellId
ELSE
	UPDATE #tempJobStats
	SET dedupSaving = T.dedupSaving
	FROM
	( SELECT SUM(ISNULL(AFD.secondaryObjSize, 0) + ISNULL(AFD.secondaryMetaDataSize, 0) + ISNULL(AFD.primaryMetaDataSize, 0)) as dedupSaving, J.jobId, J.commCellId,J.copyId
		FROM #tempJobStats J
				INNER JOIN archFile AF WITH (READUNCOMMITTED)
				ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND AF.isValid = 1
				INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED)
				ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = J.copyId AND (AFC.flags &256) = 0
				LEFT OUTER JOIN archFileCopyDedup AFD WITH (READUNCOMMITTED)
				ON AFD.archFileId = AFC.archFileId AND AFD.commCellId = AFC.commCellId AND AFD.archCopyId = AFC.archCopyId AND AFD.secondaryObjSize > 0
		GROUP BY J.jobId, J.commCellId, J.copyId
	) T
	WHERE #tempJobStats.jobId = T.jobId
	AND #tempJobStats.commCellId = T.commCellId
	AND #tempJobStats.copyId = T.copyId
END
IF @orderByCode = 0
	SELECT * FROM #tempJobStats
	ORDER BY commcellId DESC, jobId DESC
ELSE
IF @orderByCode = 1
	SELECT * FROM #tempJobStats
	ORDER BY clientName, appTypeName, instanceName, backupSetName, subClientName, commCellId DESC, jobId DESC
ELSE
IF @orderByCode = 2
	SELECT * FROM #tempJobStats
	ORDER BY appTypeName, clientName, instanceName, backupSetName, subClientName, commCellId DESC, jobId DESC
DROP TABLE #tempAppList
DROP TABLE #tempForeignApp
DROP TABLE #tempTimeZone
DROP TABLE #tempJobStats
DROP TABLE #maxJobRetention
if (OBJECT_ID('tempdb.dbo.#temp_ret_copy') IS NOT NULL) DROP TABLE #temp_ret_copy
IF object_id('tempdb.dbo.#tempAppIdList') IS NOT NULL DROP TABLE #tempAppIdList
IF object_id('tempdb.dbo.#lt_subclientList') IS NOT NULL DROP TABLE #lt_subclientList
RETURN;
GO


IF EXISTS (select * from GxQscripts where name = 'archViewJobsByPolicy')
	delete from GxQscripts where name = 'archViewJobsByPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewJobsByPolicy')
	delete from GXDBVersions where aliasname = 'archViewJobsByPolicy'
GO

insert into GXDBVersions values(2, 'archViewJobsByPolicy',  '00010099003200210000', 'archViewJobsByPolicy', '00010099003200210000')
GO

