

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archViewJobsByGlobalPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archViewJobsByGlobalPolicy.sp,v $ $Id: archViewJobsByGlobalPolicy.sp,v 1.13.46.12 2020/05/10 01:16:26 pveeravalli Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archViewJobsByGlobalPolicy')
BEGIN
	print '>>> Drop Stored Procedure: archViewJobsByGlobalPolicy <<<'
	drop procedure archViewJobsByGlobalPolicy
END
IF EXISTS (select * from GxQscripts where name='archViewJobsByGlobalPolicy')
	delete from GxQscripts where name = 'archViewJobsByGlobalPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewJobsByGlobalPolicy')
	delete from GXDBVersions where aliasname = 'archViewJobsByGlobalPolicy'
GO
print '... Creating Procedure: archViewJobsByGlobalPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archViewJobsByGlobalPolicy
  @spId integer,
  @isAged integer,
  @theBackupLevel integer,
  @timeRangeBegin integer,
  @timeRangeEnd integer,
  @jobFilter integer,
  @orderByCode integer,
  @options integer,
  @subClntId integer = 0
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_jobId integer
  DECLARE @o_commCellId integer
  DECLARE @o_commCellName nvarchar(255)
  DECLARE @o_dataState integer
  DECLARE @o_sizeOfapplication bigint
  DECLARE @o_sizeOfAppCompressed bigint
  DECLARE @o_sizeOnMedia bigint
  DECLARE @o_sizeOfNWTransfer bigint
  DECLARE @o_clientId integer
  DECLARE @o_clientName nvarchar(255)
  DECLARE @o_appTypeId integer
  DECLARE @o_appTypeName varchar(255)
  DECLARE @o_backupSetId integer
  DECLARE @o_backupSetName nvarchar(255)
  DECLARE @o_subClientId integer
  DECLARE @o_subClientName nvarchar(255)
  DECLARE @o_instanceId integer
  DECLARE @o_instanceName nvarchar(255)
  DECLARE @o_startTime integer
  DECLARE @o_endTime integer
  DECLARE @o_opType integer
  DECLARE @o_level integer
  DECLARE @o_status integer
  DECLARE @o_fullCycleNum integer
  DECLARE @o_seqNumInCycle integer
  DECLARE @o_duration integer
  DECLARE @o_streamNum integer
  DECLARE @o_initFrom integer
  DECLARE @o_attributes bigint
  DECLARE @o_failReason varchar(255)
  DECLARE @o_userName nvarchar(255)
  DECLARE @o_totalWriteTime integer
  DECLARE @o_scanFileFailures integer
  DECLARE @o_scanFolderFailures integer
  DECLARE @o_bkpFileFailures integer
  DECLARE @o_bkpFolderFailures integer
  DECLARE @o_numObjects bigint
  DECLARE @o_extRetentionFlags integer
  DECLARE @o_retentionEndTime bigint
  DECLARE @o_agedTime bigint
  DECLARE @o_copyId integer
  DECLARE @o_policyName NVARCHAR(255)
  DECLARE @o_copyName NVARCHAR(255)
  DECLARE @o_retainedBy integer
  DECLARE @o_jobDescription nvarchar(MAX)
  DECLARE @o_clientDisplayName nvarchar(255)
SET NOCOUNT ON
CREATE TABLE #tempCopy
(
	archGroupId		int,
archGroupName	nvarchar(255),
	copyId			int,
copyName		nvarchar(255)
)
CREATE TABLE #tempJob
(
	jobId				int,
	commCellId			int,
	appId				int,
	sizeOfApplication	bigint,
	sizeOfAppCompressed	bigint,
	sizeOfBackup		bigint,
	sizeOfNWTransfer	bigint,
	startTime			int,
	endTime				int,
	opType				int,
	level				int,
	jobStatus			int,
	fullCycleNum		int,
	seqNumInCycle		int,
	duration			int,
	numStreams			int,
	numObjects			bigint,
	initFrom			int,
	attributes			bigint,
	attributesEx		bigint,
userName			nvarchar(255),
	totalWriteTime		int,
	scanFileFailures	int,
	scanFolderFailures	int,
	bkpFileFailures		int,
	bkpFolderFailures	int,
	subClientId 		int,
	clientId			int,
	appTypeId			int,
	instanceId			int,
	backupSetId			int,
clientName			nvarchar(255),
appTypeName			varchar(255),
instanceName		nvarchar(255),
backupSetName		nvarchar(255),
subClientName		nvarchar(255),
commCellName		nvarchar(255),
	status				int,
	disabled			int,
	toBeCopied			int,
	jobCopyAttributes	int,
	sizeOnMedia			bigint,
	archCheckEndTime	int,
	archCheckStatus 	int,
	extRetentionFlags	int,
	retentionEndTime	bigint,
	copiedTime			int,
	agedTime			bigint,
	errorCode			int,
	retainedBy int,
	copyId				int,
	dedupSaving			bigint,
	jobCopyStatus		int,
	jobDescription		nvarchar(MAX),
	jobDisplayFlags		bigint,
	indexBackupJob		int,
	clientOwnerList		nvarchar(MAX),
	RequiredByJobIds		nvarchar(MAX),
	lastRefreshTime      int,
clientDisplayName			nvarchar(255),
	PRIMARY KEY(jobId, commCellId, copyId)
)
DECLARE	@l_defCopyId	INT = 0
DECLARE	@l_spFlags		INT = 0
SELECT	@l_defCopyId = defaultCopy, @l_spFlags = flags
FROM	archGroup  WITH (READUNCOMMITTED)
WHERE	id = @spId
IF	(@l_spFlags & 256) <> 0 OR  (@l_spFlags & 8388608) <> 0 OR (@l_spFlags & 16384) <> 0
BEGIN
	INSERT	INTO #tempCopy
	SELECT	AG.id, AG.name, AGC.id, AGC.name
	FROM	archCopyToGlobalPolicy GP WITH (READUNCOMMITTED) , archGroupCopy AGC WITH (READUNCOMMITTED) , archGroup AG WITH (READUNCOMMITTED)
	WHERE	GP.GlobalPolicyId = @spId
			AND GP.CopyId = AGC.id
			AND AGC.archGroupId = AG.id
END
DECLARE	@t_copyId	INT = 0
DECLARE	GetCopyCur CURSOR FOR
SELECT	copyId FROM #tempCopy
OPEN	GetCopyCur
FETCH	FROM GetCopyCur INTO @t_copyId
WHILE @@FETCH_STATUS = 0
BEGIN
	DECLARE @bkpLvl INT = 0
	IF EXISTS (SELECT * FROM archSelectiveCopy WHERE copyId = @t_copyId)
	BEGIN
		SET @bkpLvl = 1
	END
	ELSE
	BEGIN
		SET @bkpLvl = @theBackupLevel
	END
	INSERT	INTO #tempJob
	EXEC	archViewJobsByCopy @t_copyId, 0, @isAged, @bkpLvl, @timeRangeBegin, @timeRangeEnd, @jobFilter, @orderByCode, @options
	FETCH	FROM GetCopyCur INTO @t_copyId
END
CLOSE		GetCopyCur
DEALLOCATE	GetCopyCur
--have only completed and partially completed jobs only.
DELETE FROM #tempJob
WHERE status NOT IN (100, 103)
IF object_id('tempdb.dbo.#tempJobStatsGDSP') is not null
BEGIN
INSERT INTO #tempJobStatsGDSP
SELECT	J.jobId, J.commCellId, J.commCellName, CASE WHEN J.status = 1000 THEN 2 WHEN (J.disabled & 256) <> 0 THEN 1 ELSE 0 END,
			J.sizeOfApplication, J.sizeOfAppCompressed, J.sizeOnMedia, J.sizeOfNWTransfer,
			J.clientId, J.clientName, J.appTypeId, J.appTypeName, J.backupSetId, J.backupSetName, J.subClientId, J.subClientName, J.instanceId, J.instanceName,
			J.startTime, J.endTime, J.opType, J.level, J.jobStatus, J.fullCycleNum, J.seqNumInCycle, J.duration, J.numStreams, J.initFrom, J.attributes,
			'', J.userName, J.totalWriteTime, J.scanFileFailures, J.scanFolderFailures, J.bkpFileFailures, J.bkpFolderFailures, J.numObjects,
			J.extRetentionFlags, J.retentionEndTime, J.agedTime, J.jobDescription, J.copyId, C.copyName,C.archGroupId, C.archGroupName,  J.retainedBy
	FROM	#tempJob J, #tempCopy C
	WHERE	C.copyId = J.copyId
	ORDER BY J.commCellId DESC, J.jobId DESC
END
ELSE
BEGIN
IF @orderByCode = 0
SELECT	J.jobId, J.commCellId, J.commCellName, CASE WHEN J.status = 1000 THEN 2 WHEN (J.disabled & 256) <> 0 THEN 1 ELSE 0 END,
			J.sizeOfApplication, J.sizeOfAppCompressed, J.sizeOnMedia, J.sizeOfNWTransfer,
			J.clientId, J.clientName, J.appTypeId, J.appTypeName, J.backupSetId, J.backupSetName, J.subClientId, J.subClientName, J.instanceId, J.instanceName,
			J.startTime, J.endTime, J.opType, J.level, J.jobStatus, J.fullCycleNum, J.seqNumInCycle, J.duration, J.numStreams, J.initFrom, J.attributes,
			'', J.userName, J.totalWriteTime, J.scanFileFailures, J.scanFolderFailures, J.bkpFileFailures, J.bkpFolderFailures, J.numObjects,
			J.extRetentionFlags, J.retentionEndTime, J.agedTime, J.copyId, C.archGroupName, C.copyName, J.retainedBy, J.jobDescription, J.clientDisplayName
	FROM	#tempJob J, #tempCopy C
	WHERE	C.copyId = J.copyId
	ORDER BY J.commCellId DESC, J.jobId DESC
ELSE
IF @orderByCode = 1
SELECT	J.jobId, J.commCellId, J.commCellName, CASE WHEN J.status = 1000 THEN 2 WHEN (J.disabled & 256) <> 0 THEN 1 ELSE 0 END,
			J.sizeOfApplication, J.sizeOfAppCompressed, J.sizeOnMedia, J.sizeOfNWTransfer,
			J.clientId, J.clientName, J.appTypeId, J.appTypeName, J.backupSetId, J.backupSetName, J.subClientId, J.subClientName, J.instanceId, J.instanceName,
			J.startTime, J.endTime, J.opType, J.level, J.jobStatus, J.fullCycleNum, J.seqNumInCycle, J.duration, J.numStreams, J.initFrom, J.attributes,
			'', J.userName, J.totalWriteTime, J.scanFileFailures, J.scanFolderFailures, J.bkpFileFailures, J.bkpFolderFailures, J.numObjects,
			J.extRetentionFlags, J.retentionEndTime, J.agedTime, J.copyId, C.archGroupName, C.copyName, J.retainedBy, J.jobDescription, J.clientDisplayName
	FROM	#tempJob J, #tempCopy C
	WHERE	C.copyId = J.copyId
	ORDER BY J.clientName, J.appTypeName, J.instanceName, J.backupSetName, J.subClientName, J.commCellId DESC, J.jobId DESC
ELSE
IF @orderByCode = 2
SELECT	J.jobId, J.commCellId, J.commCellName, CASE WHEN J.status = 1000 THEN 2 WHEN (J.disabled & 256) <> 0 THEN 1 ELSE 0 END,
			J.sizeOfApplication, J.sizeOfAppCompressed, J.sizeOnMedia, J.sizeOfNWTransfer,
			J.clientId, J.clientName, J.appTypeId, J.appTypeName, J.backupSetId, J.backupSetName, J.subClientId, J.subClientName, J.instanceId, J.instanceName,
			J.startTime, J.endTime, J.opType, J.level, J.jobStatus, J.fullCycleNum, J.seqNumInCycle, J.duration, J.numStreams, J.initFrom, J.attributes,
			'', J.userName, J.totalWriteTime, J.scanFileFailures, J.scanFolderFailures, J.bkpFileFailures, J.bkpFolderFailures, J.numObjects,
			J.extRetentionFlags, J.retentionEndTime, J.agedTime, J.copyId, C.archGroupName, C.copyName, J.retainedBy, J.jobDescription, J.clientDisplayName
	FROM	#tempJob J, #tempCopy C
	WHERE	C.copyId = J.copyId
	ORDER BY J.appTypeName, J.clientName, J.instanceName, J.backupSetName, J.subClientName, J.commCellId DESC, J.jobId DESC
END
DROP TABLE #tempJob
DROP TABLE #tempCopy
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archViewJobsByGlobalPolicy')
	delete from GxQscripts where name = 'archViewJobsByGlobalPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewJobsByGlobalPolicy')
	delete from GXDBVersions where aliasname = 'archViewJobsByGlobalPolicy'
GO

insert into GXDBVersions values(2, 'archViewJobsByGlobalPolicy',  '00010013004600120000', 'archViewJobsByGlobalPolicy', '00010013004600120000')
GO

