

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archViewJobsByCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archViewJobsByCopy.sp,v $ $Id: archViewJobsByCopy.sp,v 1.93.2.30.8.1 2021/03/04 05:52:15 cliu Exp $";
/*
	ClientIds xml format
	<ClientIdList><Client id=""/></ClientIdList>
*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archViewJobsByCopy')
BEGIN
	print '>>> Drop Stored Procedure: archViewJobsByCopy <<<'
	drop procedure archViewJobsByCopy
END
IF EXISTS (select * from GxQscripts where name='archViewJobsByCopy')
	delete from GxQscripts where name = 'archViewJobsByCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewJobsByCopy')
	delete from GXDBVersions where aliasname = 'archViewJobsByCopy'
GO
print '... Creating Procedure: archViewJobsByCopy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archViewJobsByCopy
  @i_copyId int,
  @showNeedCopyTo int,
  @isAged int,
  @theBackupLevel int,
  @timeRangeBegin int,
  @timeRangeEnd int,
  @dataState int,
  @orderByCode int,
  @options int,
  @userId int = 0,
  @i_clientIdsXML XML = ''
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_jobId int
  DECLARE @o_commCellId int
  DECLARE @o_appId int
  DECLARE @o_sizeOfApplication bigint
  DECLARE @o_sizeOfAppCompressed bigint
  DECLARE @o_sizeOfBackup bigint
  DECLARE @o_sizeOfNWTransfer bigint
  DECLARE @o_startTime int
  DECLARE @o_endTime int
  DECLARE @o_opType int
  DECLARE @o_level int
  DECLARE @o_jobStatus int
  DECLARE @o_fullCycleNum int
  DECLARE @o_seqNumInCycle int
  DECLARE @o_duration int
  DECLARE @o_numStreams int
  DECLARE @o_numObjects bigint
  DECLARE @o_initFrom int
  DECLARE @o_attributes bigint
  DECLARE @o_attributesEx bigint
  DECLARE @o_userName nvarchar(255)
  DECLARE @o_totalWriteTime int
  DECLARE @o_scanFileFailures int
  DECLARE @o_scanFolderFailures int
  DECLARE @o_bkpFileFailures int
  DECLARE @o_bkpFolderFailures int
  DECLARE @o_subClientId int
  DECLARE @o_clientId int	
  DECLARE @o_appTypeId int	
  DECLARE @o_instanceId int
  DECLARE @o_backupSetId int
  DECLARE @o_clientName nvarchar(255)
  DECLARE @o_appTypeName varchar(255)
  DECLARE @o_instanceName nvarchar(255)
  DECLARE @o_backupSetName nvarchar(255)
  DECLARE @o_subClientName nvarchar(255)
  DECLARE @o_commCellName nvarchar(255)
  DECLARE @o_status int
  DECLARE @o_disabled int
  DECLARE @o_toBeCopied int
  DECLARE @o_jobCopyAttributes int
  DECLARE @o_sizeOnMedia bigint
  DECLARE @o_archCheckEndTime int
  DECLARE @o_archCheckStatus int
  DECLARE @o_extRetentionFlags int
  DECLARE @o_retentionEndTime bigint
  DECLARE @o_copiedTime int
  DECLARE @o_agedTime bigint
  DECLARE @o_errorCode int
  DECLARE @o_retainedBy integer
  DECLARE @o_copyId int
  DECLARE @o_dedupSaving bigint
  DECLARE @o_jobCopyStatus int
  DECLARE @o_jobDescription nvarchar(MAX)
  DECLARE @o_jobDisplayFlags bigint
  DECLARE @o_indexBackupJob int
  DECLARE @o_clientOwnerList nvarchar(MAX)
  DECLARE @o_RequiredByJobIds nvarchar(MAX)
  DECLARE @o_lastRefreshTime int
  DECLARE @o_clientDisplayName nvarchar(255)
SET NOCOUNT ON
-- Bit map for @o_jobCopyStatus
-- 0 = show all
-- bit 0 (=1) = Available
-- bit 1 (=2) = To be copied
-- bit 2 (=4) = Do Not Copy
-- bit 8 (=256)= Aged
-- bit 9 (=512)= Pruned
-- Bit map for @dataState
-- 0 = show all
-- bit 0 (=1) = show available
-- bit 2 (=4) = show to be copied
-- bit 3 (=8) = show not to be copied
-- bit 4 (=16)= show extended retained
-- bit 5 (=32)= show to be copied snap jobs
-- bit 6 (=64)= show not to be copied snap jobs
--Bit map for @options
-- bit 0 (=1) = Apply specify TimeZone
-- bit 2 (=2) = Show Minor
-- bit 3 (=4) = Show Major
-- bit 4 (=8)= show Critical
-- The values of status column of JMJobDataStats table
--   2 = NODATA
--   3 = INVALIODDATA
-- 100 = READY
-- 101 = NO DATA COPIED
-- 102 = NO DATA VALID
-- 103 = PARTIAL DATA
if (OBJECT_ID('tempdb.dbo.#tempAppList') IS NOT NULL) DROP TABLE #tempAppList
if (OBJECT_ID('tempdb.dbo.#tempJobStats') IS NOT NULL) DROP TABLE #tempJobStats
if (OBJECT_ID('tempdb.dbo.#tempJobData') IS NOT NULL) DROP TABLE #tempJobData
if (OBJECT_ID('tempdb.dbo.#tempReqByJobList') IS NOT NULL) DROP TABLE #tempReqByJobList
if (OBJECT_ID('tempdb.dbo.#tempJobAFList') IS NOT NULL) DROP TABLE #tempJobAFList
if (OBJECT_ID('tempdb.dbo.#realInstanceNames') IS NOT NULL) DROP TABLE #realInstanceNames
if (OBJECT_ID('tempdb.dbo.#tempJobCopyAttr') IS NOT NULL) DROP TABLE #tempJobCopyAttr
if (OBJECT_ID('tempdb.dbo.#jobCRC') IS NOT NULL) DROP TABLE #jobCRC
if (OBJECT_ID('tempdb.dbo.#tempTimeZone') IS NOT NULL) DROP TABLE #tempTimeZone
IF OBJECT_ID('tempdb..#tmpParentAppIdList') IS NOT NULL	DROP TABLE #tmpParentAppIdList
CREATE TABLE #tmpParentAppIdList(appId int, parentAppId INT, Primary Key(appId, parentAppId))
CREATE TABLE #tempAppList
(
	appId				int,
	clientId			int,
	appTypeId			int,
	instance			int,
	backupSet			int,
clientName			nvarchar(255),
appTypeName			varchar(255),
instanceName		nvarchar(255),
backupSetName		nvarchar(255),
subclientName		nvarchar(255),
	clientOwnersList	nvarchar(MAX),
clientDisplayName	nvarchar(255),
	PRIMARY KEY(appId)
	)
CREATE TABLE #tempJobStats
(
	jobId				int,
	commCellId			int,
	appId				int,
	applicationSize		bigint,
	compressedAppSize	bigint,
	totalBackupSize		bigint,
	nwTransferSize		bigint,
	startTime			int,
	endTime				int,
	opType				int,
	level				int,
	jobStatus			int,
	fullCycleNum		int,
	seqNumInCycle		int,
	duration			int,
	numStreams			int,
	numObjects			bigint,
	initFrom			int,
	attributes			bigint,
	attributesEx		bigint,
userName			nvarchar(255),
	totalWriteTime		int,
	scanFileFailures	int,
	scanFolderFailures	int,
	bkpFileFailures		int,
	bkpFolderFailures	int,
	PRIMARY KEY(jobId, commCellId)
)
CREATE TABLE #tempJobData
(
	jobId				int,
	commCellId			int,
	appId				int,
	minStatus			int,
	maxStatus			int,
	disabled			int,
	toBeCopied			int,
	jobCopyAttributes	int,
	sizeOnMedia			bigint,
	errorCode			int,
	archCheckEndTime	int,
	archCheckStatus		int,
	extRetentionFlags	int,
	retentionDays		bigint,
	retentionEndTime	bigint,
	copiedTime			int,
	agedTime			bigint,
	jobDescription		nvarchar(MAX),
	retainedBy	int,
	dedupSaving			bigint,
	retentionJobs		int,
	isDDBBackup			int,
	jobCopyStatus		bigint,
	jobDisplayFlags	bigint,
  indexBackupJob 		int,
  RequiredByJobIds	nvarchar(MAX)
	PRIMARY KEY(jobId, commCellId)
)
CREATE TABLE #tempReqByJobList
(
	jobId				int,
	commCellId	int,
  ReqByJobId	int
)
CREATE CLUSTERED INDEX Idx_tempReqByJobList_1 ON #tempReqByJobList (jobId, commCellId)
CREATE TABLE #tempJobAFList
(
	archFileId			int,
	jobId				int,
	commCellId			int,
	isDeduped			int,
	dedupSaving			bigint,
	PRIMARY KEY(archFileId, commCellId)
)
CREATE TABLE #realInstanceNames
(
	jobId				int,
	commCellId			int,
name				nvarchar(255)
)
CREATE TABLE #tempJobCopyAttr
(
	jobId				int,
	commCellId			int,
	encKeyType			int,
	isDeduped			int,
	PRIMARY KEY(jobId, commCellId)
)
CREATE TABLE #jobCRC
(
	jobId				int,
	commCellId			int,
	minCRC				int,
	maxHwEnc			int,
	PRIMARY KEY(jobId, commCellId)
)
CREATE TABLE #tempTimeZone(
	clientId INT, TimeZone VARCHAR(255))
if object_id('tempdb.dbo.#archCopyToAppId') is not null DROP TABLE #archCopyToAppId
CREATE TABLE #archCopyToAppId (
copyId			INTEGER,
AppId				INTEGER
)
CREATE CLUSTERED INDEX idx_archCopyToAppId ON #archCopyToAppId (copyId,AppId)
IF	@dataState = 0
	SET	@dataState = (1+4+8)
ELSE
IF	@dataState = 16
	SET	@dataState = (1+16)
DECLARE @spId INT
DECLARE @defCopyId INT
DECLARE @srcCopyId INT
DECLARE @defSnapCopyId INT
DECLARE @combineStreams INT
DECLARE @forAllClients INT
DECLARE @regularAge	INT
DECLARE @archiverAge INT
DECLARE @dedupeFlags INT
DECLARE @silo_appId INT
DECLARE	@l_TimeZoneType	INT
DECLARE	@l_TimeZone		VARCHAR(255)
DECLARE	@l_csTimeZone	VARCHAR(255)
DECLARE @MinorVal INTEGER
DECLARE @MajorVal INTEGER
DECLARE @CriticalVal INTEGER
DECLARE @today INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @extendedFlags BIGINT
DECLARE @HonorSPCopyRetentionForContentStore        INTEGER
CREATE TABLE #refreshTime	 (commCellId int,jobId int,lastRefreshTime int)
DECLARE @retentionJobs INTEGER
SET			@retentionJobs = 0
SET		@l_csTimeZone = dbo.GetClientTimeZone(2)
SET 	@HonorSPCopyRetentionForContentStore = 0
SELECT	@spId = AG.id, @defCopyId = AG.defaultCopy, @defSnapCopyId = defaultSnapCopy,
		@srcCopyId = (CASE	WHEN AGC.sourceCopyId = 0 AND AGC.isSnapCopy = 0 THEN AG.defaultCopy
							WHEN AGC.sourceCopyId = 0 AND AGC.isSnapCopy = 1 THEN AG.defaultSnapCopy
							ELSE AGC.sourceCopyId END),
@combineStreams = (AGC.flags & 4), @silo_appId = AGC.siloAppId, @dedupeFlags = dedupeFlags,
		@l_TimeZoneType = AG.TimeZoneType, @l_TimeZone = (CASE WHEN AG.TimeZone = '' THEN @l_csTimeZone ELSE AG.TimeZone END),
		@extendedFlags = AGC.extendedFlags
FROM	archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
WHERE	AG.id = AGC.archGroupId AND AGC.id = @i_copyId
SELECT	@MinorVal = (value * 3600)
FROM	MMConfigs
WHERE NAME = 'HOURS_TO_CONSIDER_TO_BE_COPIED_DATA_HAS_MET_MINOR_CRITERIA'
		AND	nConfigSubSystemId = 3
SELECT	@MajorVal = (value * 3600)
FROM	MMConfigs
WHERE NAME = 'HOURS_TO_CONSIDER_TO_BE_COPIED_DATA_HAS_MET_MAJOR_CRITERIA'
		AND nConfigSubSystemId = 3
SELECT	@CriticalVal = (value * 3600)
FROM	MMConfigs
WHERE	NAME = 'HOURS_TO_CONSIDER_TO_BE_COPIED_DATA_HAS_MET_CRITICAL_CRITERIA'
		AND	nConfigSubSystemId = 3
SELECT	@HonorSPCopyRetentionForContentStore = isnull(value, 0)
FROM	MMConfigs WITH (NOLOCK)
WHERE	name = 'DA_CONFIG_HONOR_STORAGE_POLICY_RETENTION_FOR_CONTENT_STORE_DATA'
IF	@i_copyId = @defCopyId AND @defSnapCopyId > 0
	SET	@dataState = (@dataState | 32)
SELECT	@regularAge = retentionDays, @archiverAge = archiverRetDays
FROM	archAgingRule WITH (NOLOCK)
WHERE	copyId = @i_copyId
IF	object_id('tempdb.dbo.#idaListTemp') IS NOT NULL DROP TABLE #idaListTemp
CREATE TABLE #idaListTemp
(
    t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
IF(ISNULL(@userId, 0) > 0)
	EXEC sec_getIdaObjectsForUser @userId, 7 ,0,0,#idaListTemp
IF @i_clientIdsXML.exist('/ClientIdList') = 1
BEGIN
	IF object_id('tempdb.dbo.#tempClientList') IS NOT NULL DROP TABLE #tempClientList
CREATE TABLE #tempClientList(id int, name nvarchar(255), displayName nvarchar(255))
	INSERT INTO #tempClientList
	SELECT CL.id, CL.name, CL.displayName
	     FROM @i_clientIdsXML.nodes('/ClientIdList/Client') T(item)
	     inner join APP_Client CL ON CL.id = T.item.value('@id','INT')
	SET @forAllClients = 0
	IF(ISNULL(@userId, 0) > 0)
		INSERT	INTO #tempAppList
		SELECT	A.id, A.clientId, A.appTypeId, A.instance, A.backupSet,
				T.name, IDA.name, INS.name, BKP.name, A.subclientName, '', T.displayName
		FROM	APP_Application A WITH (NOLOCK)
		INNER JOIN  #tempClientList T ON A.clientId = T.id
			INNER JOIN #idaListTemp V ON V.t_subclientId = A.id
			INNER JOIN APP_BackupSetName BKP WITH (NOLOCK) ON V.t_backupsetId = BKP.id
			INNER JOIN APP_InstanceName INS WITH (NOLOCK) ON V.t_instanceId = INS.id
			INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON V.t_appTypeId = IDA.type
	ELSE
		INSERT	INTO #tempAppList
		SELECT	A.id, A.clientId, A.appTypeId, A.instance, A.backupSet,
				T.name, IDA.name, INS.name, BKP.name, A.subclientName, '', T.displayName
		FROM	APP_Application A WITH (NOLOCK)
			INNER JOIN  #tempClientList T ON A.clientId = T.id
			INNER JOIN APP_BackupSetName BKP WITH (NOLOCK) ON A.backupSet = BKP.id
			INNER JOIN APP_InstanceName INS WITH (NOLOCK) ON A.instance = INS.id
			INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON A.appTypeId = IDA.type
	IF object_id('tempdb.dbo.#tempClientList') IS NOT NULL DROP TABLE #tempClientList
END
ELSE
BEGIN
	IF(ISNULL(@userId, 0) > 0)
	BEGIN
		SET @forAllClients = 0
		INSERT	INTO #tempAppList
		SELECT	V.t_subclientId, V.t_clientId, V.t_appTypeId, V.t_instanceId, V.t_backupsetId,
		C.name, IDA.name, INS.name, BKP.name, SUB.subclientName, '', C.displayName
		FROM #idaListTemp V
			INNER JOIN APP_Application SUB WITH (NOLOCK) ON V.t_subclientId = SUB.id
			INNER JOIN APP_BackupSetName BKP WITH (NOLOCK) ON V.t_backupsetId = BKP.id
			INNER JOIN APP_InstanceName INS WITH (NOLOCK) ON V.t_instanceId = INS.id
			INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON V.t_appTypeId = IDA.type
			INNER JOIN APP_Client C WITH (NOLOCK) ON V.t_clientId = C.id
	END
	ELSE
		SET @forAllClients = 1
END
IF	object_id('tempdb.dbo.#idaListTemp') IS NOT NULL DROP TABLE #idaListTemp
IF	@timeRangeBegin <= 0 AND @timeRangeEnd <= 0 AND @theBackupLevel <= 0
AND (@i_copyId != @defCopyId OR @defSnapCopyId = 0 OR (@dataState & (32|64)) = 0)
BEGIN
	IF	@forAllClients = 1
		INSERT	INTO #tempJobData
		SELECT	J.jobId, J.commCellId, J.appId,
				MIN(J.status), MAX(J.status), dbo.BitwiseOR(J.disabled), 0, 0, SUM(J.sizeOnMedia), 0,
				MAX(J.archCheckEndTime), MAX(J.archCheckStatus),
				MAX(J.retentionFlags), @regularAge, MAX(J.manualRetentionEndTime),
				MAX(J.copiedTime), MAX(J.agedTime), '', 0, 0, 0, 0,
				MAX(CASE WHEN J.status IN (2, 100) THEN 1 ELSE 0 END) |
				MAX(CASE WHEN J.status IN (101, 102, 103) THEN 2 ELSE 0 END) |
				MAX(J.disabled & 256) |
				MAX(CASE WHEN J.status IN (1000) THEN 512 ELSE 0 END) |
				MAX(CASE WHEN ((J.disabled & 256) = 0) THEN 1024 ELSE 0 END) |
				MAX(J.disabled & 4) AS jobCopyStatus, 0, 0 /* for index backup job flag*/, ''
		FROM	JMJobDataStats J WITH (NOLOCK)
		WHERE  	J.archGrpCopyId = @i_copyId
				AND J.Status <> 1000
		GROUP BY J.jobId, J.commCellId, J.appId
	ELSE
		INSERT	INTO #tempJobData
		SELECT	J.jobId, J.commCellId, J.appId,
				MIN(J.status), MAX(J.status), dbo.BitwiseOR(J.disabled), 0, 0, SUM(J.sizeOnMedia), 0,
				MAX(J.archCheckEndTime), MAX(J.archCheckStatus),
				MAX(J.retentionFlags), @regularAge, MAX(J.manualRetentionEndTime),
				MAX(J.copiedTime), MAX(J.agedTime), '', 0, 0, 0, 0,
				MAX(CASE WHEN J.status IN (2, 100) THEN 1 ELSE 0 END) |
				MAX(CASE WHEN J.status IN (101, 102, 103) THEN 2 ELSE 0 END) |
				MAX(J.disabled & 256) |
				MAX(CASE WHEN ((J.disabled & 256) = 0) THEN 1024 ELSE 0 END) |
				MAX(CASE WHEN J.status IN (1000) THEN 512 ELSE 0 END) |
				MAX(J.disabled & 4) AS jobCopyStatus, 0, 0 /* for index backup job flag*/, ''
		FROM	JMJobDataStats J WITH (NOLOCK), #tempAppList T
		WHERE  	J.appId = T.appId
			AND J.archGrpCopyId = @i_copyId
			AND J.Status <> 1000
		GROUP BY J.jobId, J.commCellId, J.appId
END
ELSE
BEGIN
	IF	@timeRangeEnd <= 0
		SET @timeRangeEnd = dbo.getUnixTime(GetUTCDate())
	IF	@forAllClients = 0
		--Use index (appId, servStartDate)
		INSERT	INTO #tempJobStats
		SELECT	J.jobId, J.commCellId, J.appId,
				case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
					then ISNULL((select sum(unCompBytes) from JMBkpAtmptStats WITH (NOLOCK)
							where jobId = J.jobId and commCellId = J.commCellId and archGrpId = @spId and status in (1,3,14,16)), 0)
					else J.totalUncompBytes end,
				case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
					then ISNULL((select sum(compBytes) from JMBkpAtmptStats WITH (NOLOCK)
							where jobId = J.jobId and commCellId = J.commCellId and archGrpId = @spId and status in (1,3,14,16)), 0)
					else J.totalCompBytes end,
				J.totalBackupSize,
				case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
					then ISNULL((select sum(nwTransBytes) from JMBkpAtmptStats WITH (NOLOCK)
							where jobId = J.jobId and commCellId = J.commCellId and archGrpId = @spId and status in (1,3,14,16)), 0)
					else J.nwTransBytes end,
				J.servStartDate, J.servEndDate, J.opType, J.bkpLevel, J.status,
				J.fullCycleNum, J.cycleSequence, J.duration, J.numStreams,
				(select sum(numObjects) from JMBkpAtmptStats where jobId = J.jobId and commCellId = J.commCellId),
				J.initFrom, J.bkpAttributes, J.bkpAttributesEx, J.username, J.totalWriteTime,
				J.scanFileFailures, J.scanFolderFailures, J.backupFileFailures, J.backupFolderFailures
		FROM	JMBkpStats J WITH(NOLOCK), #tempAppList T
		WHERE	J.appId = T.appId
			AND J.servStartDate >= @timeRangeBegin AND J.servStartDate < @timeRangeEnd
			AND J.status IN (1, 3, 14, 16)
			AND (J.dataArchGrpId = @spId OR J.logArchGrpId = @spId OR J.diffArchGrpId = @spId)
			AND (	@theBackupLevel <= 0
				OR	@theBackupLevel = J.bkpLevel
				OR	@theBackupLevel = 1 AND J.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
				OR	@theBackupLevel = 2 AND J.bkpLevel IN (2, 256)
				)
	ELSE
		--Use index (servStartDate, opType)
		INSERT	INTO #tempJobStats
		SELECT	J.jobId, J.commCellId, J.appId,
				case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
					then ISNULL((select sum(unCompBytes) from JMBkpAtmptStats WITH (NOLOCK)
							where jobId = J.jobId and commCellId = J.commCellId and archGrpId = @spId and status in (1,3,14,16)), 0)
					else J.totalUncompBytes end,
				case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
					then ISNULL((select sum(compBytes) from JMBkpAtmptStats WITH (NOLOCK)
							where jobId = J.jobId and commCellId = J.commCellId and archGrpId = @spId and status in (1,3,14,16)), 0)
					else J.totalCompBytes end,
				J.totalBackupSize,
				case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
					then ISNULL((select sum(nwTransBytes) from JMBkpAtmptStats WITH (NOLOCK)
							where jobId = J.jobId and commCellId = J.commCellId and archGrpId = @spId and status in (1,3,14,16)), 0)
					else J.nwTransBytes end,
				J.servStartDate, J.servEndDate, J.opType, J.bkpLevel, J.displayStatus,
				J.fullCycleNum, J.cycleSequence, J.duration, J.numStreams,
				(select sum(numObjects) from JMBkpAtmptStats where jobId = J.jobId and commCellId = J.commCellId),
				J.initFrom, J.bkpAttributes, J.bkpAttributesEx, J.username, J.totalWriteTime,
				J.scanFileFailures, J.scanFolderFailures, J.backupFileFailures, J.backupFolderFailures
		FROM	JMBkpStats J WITH(NOLOCK)
		WHERE	J.servStartDate >= @timeRangeBegin AND J.servStartDate < @timeRangeEnd
			AND J.status IN (1, 3, 14, 16)
			AND (J.dataArchGrpId = @spId OR J.logArchGrpId = @spId OR J.diffArchGrpId = @spId)
			AND (	@theBackupLevel <= 0
				OR	@theBackupLevel = J.bkpLevel
				OR	@theBackupLevel = 1 AND J.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
				OR	@theBackupLevel = 2 AND J.bkpLevel IN (2, 256)
				)
	INSERT	INTO #tempJobStats
	SELECT	J.jobId, J.commCellId, J.appId, (case when J.uncompBytes > 0 then J.uncompBytes else J.totalBackupSize end),
			(case when J.TotalSize > 0 then J.TotalSize else J.totalBackupSize end), J.totalBackupSize, J.nwTransBytes,
			J.servStart, J.servEnd, J.opType, J.ER_BkpLevel, J.status,
			J.fullCycleNum, 0/*J.cycleSequence*/, 0/*J.duration*/, J.noOfStreams, 1/*numObjects*/,
			J.initFrom, 0/*J.bkpAttributes*/, 0/*J.bkpAttributesEx*/, J.username, J.totalWriteTime,
			0/*J.scanFileFailures*/, 0/*J.scanFolderFailures*/, 0/*J.backupFileFailures*/, 0/*J.backupFolderFailures*/
	FROM	JMAdminJobStatsTable J WITH (NOLOCK)
	WHERE	J.servStart >= @timeRangeBegin AND J.servStart < @timeRangeEnd
		AND J.opType IN (11, 64, 148)
		AND J.ArchGrpId = @spId
		AND (	@theBackupLevel <= 0
			OR	@theBackupLevel = J.ER_BkpLevel
			OR	@theBackupLevel = 1 AND J.ER_BkpLevel IN (1, 64, 128, 1024, 16384, 32768)
			OR	@theBackupLevel = 2 AND J.ER_BkpLevel IN (2, 256)
			)
	INSERT	INTO #tempJobData
	SELECT	J.jobId, J.commCellId, J.appId,
			MIN(J.status), MAX(J.status), dbo.BitwiseOR(J.disabled), 0, 0, SUM(J.sizeOnMedia), 0,
			MAX(J.archCheckEndTime), MAX(J.archCheckStatus),
			MAX(J.retentionFlags), @regularAge, MAX(J.manualRetentionEndTime),
			MAX(J.copiedTime), MAX(J.agedTime), '', 0, 0, 0, 0,
				MAX(CASE WHEN J.status IN (2, 100) THEN 1 ELSE 0 END) |
				MAX(CASE WHEN J.status IN (101, 102, 103) THEN 2 ELSE 0 END) |
				MAX(J.disabled & 256) |
				MAX(CASE WHEN ((J.disabled & 256) = 0) THEN 1024 ELSE 0 END) |
				MAX(CASE WHEN J.status IN (1000) THEN 512 ELSE 0 END) |
				MAX(J.disabled & 4) AS jobCopyStatus, 0, 0 /* for index backup job flag*/, ''
	FROM	JMJobDataStats J WITH (NOLOCK), #tempJobStats T
	WHERE  	J.jobId = T.jobId AND J.commCellId = T.commCellId
		AND J.archGrpCopyId = @i_copyId
		AND J.Status <> 1000
	GROUP BY J.jobId, J.commCellId, J.appId
END
IF(@i_copyId IN (@defCopyId, @defSnapCopyId))
	DELETE #tempJobData
	WHERE maxStatus = 101 AND minStatus = 101
DELETE FROM #tempJobData
WHERE 	NOT		((	@dataState & 1 <> 0 AND (#tempJobData.jobCopyStatus & 1 = 1)
				OR	@dataState & 4 <> 0 AND (#tempJobData.jobCopyStatus & 2 = 2) AND #tempJobData.disabled & (1+256) = 0
				OR	@dataState & 8 <> 0 AND (#tempJobData.jobCopyStatus & 2 = 2) AND #tempJobData.disabled & (1+256) <> 0)
			AND (	@dataState & 16 = 0 OR #tempJobData.extRetentionFlags <> 0)
			AND (	@isAged = 0 AND (#tempJobData.disabled & 256 = 0 OR (#tempJobData.jobCopyStatus & 1024 = 1024))
				OR	@isAged = 1 AND #tempJobData.disabled & 256 <> 0
				OR	@isAged = 2))
IF @i_copyId != @defCopyId AND @isAged <> 1
BEGIN
	CREATE TABLE #SelectableJob (jobId int, commCellId int, appId int)
	CREATE TABLE #AssociatedApp (appId int)
	IF	@forAllClients = 0
	BEGIN
		IF	@timeRangeBegin <= 0 AND @timeRangeEnd <= 0 AND @theBackupLevel <= 0
			INSERT	INTO #SelectableJob
			SELECT	DISTINCT J.jobId, J.commCellId, J.appId
			FROM	JMJobDataStats J WITH (NOLOCK), #tempAppList T
			WHERE	J.appId = T.appId AND J.archGrpCopyId = @srcCopyId
AND J.status IN (100, 101, 102, 103) AND J.disabled & (1+256) = 0
			UNION
			SELECT	J.jobId, J.commCellId, J.appId
			FROM	JMJobDataStats J WITH (NOLOCK), #tempAppList T
			WHERE	J.appId = T.appId AND J.archGrpCopyId = @i_copyId
			GROUP BY J.jobId, J.commCellId, J.appId
HAVING MAX(J.status) = 100 AND MAX(J.disabled & (256)) = 0 AND MIN(J.status) = 100
		ELSE
			INSERT	INTO #SelectableJob
			SELECT	DISTINCT J.jobId, J.commCellId, J.appId
			FROM	JMJobDataStats J WITH (NOLOCK), JMBkpStats B WITH (NOLOCK), #tempAppList T
			WHERE	J.appId = T.appId AND B.jobId = J.jobId AND B.commCellId = J.commCellId
				AND B.servStartDate >= @timeRangeBegin AND (@timeRangeEnd <= 0 OR B.servStartDate < @timeRangeEnd)
				AND B.status IN (1, 3, 14, 16)
				AND (B.dataArchGrpId = @spId OR B.logArchGrpId = @spId OR B.diffArchGrpId = @spId)
				AND (	@theBackupLevel <= 0
					OR	@theBackupLevel = B.bkpLevel
					OR	@theBackupLevel = 1 AND B.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
					OR	@theBackupLevel = 2 AND B.bkpLevel IN (2, 256)
					)
				AND J.archGrpCopyId = @srcCopyId
AND J.status IN (100, 101, 102, 103) AND J.disabled & (1+256) = 0
			UNION
			SELECT	DISTINCT J.jobId, J.commCellId, J.appId
			FROM	JMJobDataStats J WITH (NOLOCK), JMBkpStats B WITH (NOLOCK), #tempAppList T
			WHERE	J.appId = T.appId AND B.jobId = J.jobId AND B.commCellId = J.commCellId
				AND B.servStartDate >= @timeRangeBegin AND (@timeRangeEnd <= 0 OR B.servStartDate < @timeRangeEnd)
				AND B.status IN (1, 3, 14, 16)
				AND (B.dataArchGrpId = @spId OR B.logArchGrpId = @spId OR B.diffArchGrpId = @spId)
				AND (	@theBackupLevel <= 0
					OR	@theBackupLevel = B.bkpLevel
					OR	@theBackupLevel = 1 AND B.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
					OR	@theBackupLevel = 2 AND B.bkpLevel IN (2, 256)
					)
				AND J.archGrpCopyId = @i_copyId
				GROUP BY J.jobId, J.commCellId, J.appId
HAVING MAX(J.status) = 100	AND MAX(J.disabled & (256)) = 0 AND MIN(J.status) = 100
	END
	ELSE
	BEGIN
		IF	@timeRangeBegin <= 0 AND @timeRangeEnd <= 0 AND @theBackupLevel <= 0
			INSERT	INTO #SelectableJob
			SELECT	DISTINCT J.jobId, J.commCellId, J.appId
			FROM	JMJobDataStats J WITH (NOLOCK)
			WHERE	J.archGrpCopyId = @srcCopyId
AND J.status IN (100, 101, 102, 103) AND J.disabled & (1+256) = 0
			UNION
			SELECT	J.jobId, J.commCellId, J.appId
			FROM	JMJobDataStats J WITH (NOLOCK)
			WHERE	J.archGrpCopyId = @i_copyId
			GROUP BY J.jobId, J.commCellId, J.appId
HAVING MAX(J.status) = 100 AND MAX(J.disabled & (256)) = 0 AND MIN(J.status) = 100
		ELSE
			INSERT	INTO #SelectableJob
			SELECT	DISTINCT J.jobId, J.commCellId, J.appId
			FROM	JMJobDataStats J WITH (NOLOCK), JMBkpStats B WITH (NOLOCK)
			WHERE	B.jobId = J.jobId AND B.commCellId = J.commCellId
				AND B.servStartDate >= @timeRangeBegin AND (@timeRangeEnd <= 0 OR B.servStartDate < @timeRangeEnd)
				AND B.status IN (1, 3, 14, 16)
				AND (B.dataArchGrpId = @spId OR B.logArchGrpId = @spId OR B.diffArchGrpId = @spId)
				AND (	@theBackupLevel <= 0
					OR	@theBackupLevel = B.bkpLevel
					OR	@theBackupLevel = 1 AND B.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
					OR	@theBackupLevel = 2 AND B.bkpLevel IN (2, 256)
					)
				AND J.archGrpCopyId = @srcCopyId
AND J.status IN (100, 101, 102, 103) AND J.disabled & (1+256) = 0
			UNION
			SELECT	J.jobId, J.commCellId, J.appId
			FROM	JMJobDataStats J WITH (NOLOCK), JMBkpStats B WITH (NOLOCK)
			WHERE	B.jobId = J.jobId AND B.commCellId = J.commCellId
				AND B.servStartDate >= @timeRangeBegin AND (@timeRangeEnd <= 0 OR B.servStartDate < @timeRangeEnd)
				AND B.status IN (1, 3, 14, 16)
				AND (B.dataArchGrpId = @spId OR B.logArchGrpId = @spId OR B.diffArchGrpId = @spId)
				AND (	@theBackupLevel <= 0
					OR	@theBackupLevel = B.bkpLevel
					OR	@theBackupLevel = 1 AND B.bkpLevel IN (1, 64, 128, 1024, 16384, 32768)
					OR	@theBackupLevel = 2 AND B.bkpLevel IN (2, 256)
					)
				AND J.archGrpCopyId = @i_copyId
			GROUP BY J.jobId, J.commCellId, J.appId
HAVING MAX(J.status) = 100  AND MAX(J.disabled & (256)) = 0 AND MIN(J.status) = 100
	END
	UPDATE	#tempJobData SET disabled = (disabled | 8)
	FROM	#SelectableJob T
	WHERE	#tempJobData.jobId = T.jobId AND #tempJobData.commCellId = T.commCellId
	IF	EXISTS (SELECT 1 FROM archCopyToApp WHERE copyId = @i_copyId AND assocType <> 2)
	BEGIN
		INSERT INTO #archCopyToAppId
		SELECT DISTINCT @i_copyId , appId
		FROM #tempJobData
		EXEC archGetArchCopyToAppAssociations @i_copyId
		--unset the selectable flag if not associated
		UPDATE	#tempJobData SET disabled = (disabled & ~8)
		FROM	#tempJobData L LEFT JOIN #archCopyToAppId t ON t.appId = L.appId AND t.CopyID = @i_copyId
		WHERE	(t.appId IS NULL)
	END
	IF	@dataState = 8
		DELETE	#tempJobData
		WHERE	disabled & 8 = 0
	IF	@dataState = 0 OR (@dataState & 8) <> 0
	BEGIN
		INSERT	INTO #tempJobData
		SELECT	DISTINCT S.jobId, S.commCellId, S.appId, 0, 0, (1+8), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, 0 /* for index backup job flag*/, ''
		FROM	(SELECT	A.jobId, A.commCellId, A.appId
				FROM	#SelectableJob A LEFT OUTER JOIN #tempJobData B
					ON	B.jobId = A.jobId AND B.commCellId = A.commCellId
				WHERE	B.jobId IS null
				) AS S LEFT OUTER JOIN JMJobDataStats J
			ON	S.jobId = J.jobId AND S.commCellId = J.commCellId AND J.archGrpCopyId = @i_copyId
		WHERE	J.jobId IS null
OR	J.disabled & (1+256) <> 0
		IF (@@ROWCOUNT > 0)
			UPDATE	#tempJobData
			SET		minStatus = ISNULL(O.minStatus, D.minStatus),
					maxStatus = ISNULL(O.maxStatus, D.maxStatus),
					disabled = ISNULL(O.disabled | (D.disabled & 8), D.disabled),
					jobCopyStatus = ISNULL(O.jobCopyStatus, D.jobCopyStatus)
			FROM	#tempJobData D,
					(SELECT	J.jobId, J.commCellId, J.appId,
							MIN(J.status) AS minStatus, MAX(J.status) AS maxStatus, dbo.BitwiseOR(J.disabled) AS disabled,
								MAX(CASE WHEN J.status IN (2, 100) THEN 1 ELSE 0 END) |
								MAX(CASE WHEN J.status IN (101, 102, 103) THEN 2 ELSE 0 END) |
								MAX(J.disabled & 256) |
								MAX(CASE WHEN ((J.disabled & 256) = 0) THEN 1024 ELSE 0 END) |
								MAX(CASE WHEN J.status IN (1000) THEN 512 ELSE 0 END) |
								MAX(J.disabled & 4) AS jobCopyStatus
					FROM	JMJobDataStats J WITH (NOLOCK), #tempJobData T
					WHERE  	J.jobId = T.jobId AND J.commCellId = T.commCellId
						AND J.archGrpCopyId = @i_copyId
						AND (T.Disabled & (1+8)) = (1+8)
					GROUP BY J.jobId, J.commCellId, J.appId) O
			WHERE	D.jobId = O.jobId
					AND D.commCellId = O.commCellId
					AND D.appId = O.appId
	END
	DROP TABLE #AssociatedApp
	DROP TABLE #SelectableJob
END
INSERT	INTO #tempJobStats
SELECT	J.jobId, J.commCellId, J.appId,
		case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
			then ISNULL((select sum(unCompBytes) from JMBkpAtmptStats WITH (NOLOCK)
					where jobId = J.jobId and commCellId = J.commCellId and archGrpId = @spId and status in (1,3,14)), 0)
			else J.totalUncompBytes end,
		case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
			then ISNULL((select sum(compBytes) from JMBkpAtmptStats WITH (NOLOCK)
					where jobId = J.jobId and commCellId = J.commCellId and archGrpId = @spId and status in (1,3,14)), 0)
			else J.totalCompBytes end,
		J.totalBackupSize,
		case when J.dataArchGrpId > 1 and J.logArchGrpId > 1 and J.dataArchGrpId <> J.logArchGrpId
			then ISNULL((select sum(nwTransBytes) from JMBkpAtmptStats WITH (NOLOCK)
					where jobId = J.jobId and commCellId = J.commCellId and archGrpId = @spId and status in (1,3,14)), 0)
			else J.nwTransBytes end,
		J.servStartDate, J.servEndDate, J.opType, J.bkpLevel, J.displayStatus,
		J.fullCycleNum, J.cycleSequence, J.duration, J.numStreams,
		(select sum(numObjects) from JMBkpAtmptStats where jobId = J.jobId and commCellId = J.commCellId),
		J.initFrom, J.bkpAttributes, J.bkpAttributesEx, J.username, J.totalWriteTime,
		J.scanFileFailures, J.scanFolderFailures, J.backupFileFailures, J.backupFolderFailures
FROM	JMBkpStats J WITH(NOLOCK)
		INNER JOIN (SELECT DISTINCT jobId, commCellId FROM #tempJobData) A ON J.jobId = A.jobId AND J.commCellId = A.commCellId
		LEFT OUTER JOIN #tempJobStats B ON J.jobId = B.jobId AND J.commCellId = B.commCellId
WHERE	B.jobId IS null AND J.status IN (1, 3, 14, 16)
INSERT	INTO #tempJobStats
SELECT	J.jobId, J.commCellId, J.appId, (case when J.uncompBytes > 0 then J.uncompBytes else J.totalBackupSize end),
		(case when J.TotalSize > 0 then J.TotalSize else J.totalBackupSize end), J.totalBackupSize, J.nwTransBytes,
		J.servStart, J.servEnd, J.opType, J.ER_BkpLevel, J.status,
		J.fullCycleNum, 0/*J.cycleSequence*/, 0/*J.duration*/, J.noOfStreams, 1/*numObjects*/,
		J.initFrom, 0/*J.bkpAttributes*/, 0/*J.bkpAttributesEx*/, J.username, J.totalWriteTime,
		0/*J.scanFileFailures*/, 0/*J.scanFolderFailures*/, 0/*J.backupFileFailures*/, 0/*J.backupFolderFailures*/
FROM	JMAdminJobStatsTable J WITH (NOLOCK)
		INNER JOIN (SELECT DISTINCT jobId, commCellId FROM #tempJobData) A ON J.jobId = A.jobId AND J.commCellId = A.commCellId
		LEFT OUTER JOIN #tempJobStats B ON J.jobId = B.jobId AND J.commCellId = B.commCellId
WHERE	B.jobId IS null AND J.status IN (1, 3, 14)
CREATE INDEX JobStats_appId on #tempJobStats (appId)
INSERT	INTO #tempAppList
SELECT	A.id, A.clientId, A.appTypeId, A.instance, A.backupSet,
		(select name from APP_Client WITH (NOLOCK) where id = A.clientId),
		(select name from APP_iDAType WITH (NOLOCK) where type = A.appTypeId),
		(select name from APP_InstanceName WITH (NOLOCK) where id = A.instance),
		(select name from APP_BackupSetName WITH (NOLOCK) where id = A.backupSet),
		A.subclientName, '',
		(select displayName from APP_Client WITH (NOLOCK) where id = A.clientId)
FROM	APP_Application A WITH (NOLOCK)
		INNER JOIN (SELECT DISTINCT appId FROM #tempJobStats) B ON A.id = B.appId
		LEFT OUTER JOIN #tempAppList C ON C.appId = B.appId
WHERE	C.appId IS null
IF	@dataState = 8
	GOTO SELECTABLE_JOBS
-- Update retentionDays based on extended retention rules.
IF @regularAge >= 0
BEGIN
	CREATE TABLE #tempAgingRulesExt(retentionDays INT, retentionRule INT, graceRule INT)
	INSERT	INTO #tempAgingRulesExt
	SELECT	retentionDays, retentionRule,0
	FROM	archAgingRuleExtended WITH (NOLOCK)
	WHERE	copyId = @i_copyId
	IF @@ERROR = 0 AND @@ROWCOUNT > 0
	BEGIN
		UPDATE #tempAgingRulesExt
		SET    graceRule =  CASE
								WHEN retentionRule = 64 THEN 4096
								WHEN retentionRule = 32 THEN 2048
								WHEN retentionRule = 16 THEN 1024
								WHEN retentionRule = 8 THEN 512
								WHEN retentionRule = 4 THEN 256
								WHEN retentionRule = 524288 THEN 8388608
								WHEN retentionRule = 262144 THEN 4194304
								ELSE 0
							END
		DECLARE @l_ExtRetentionRuleSum	INT
		SELECT	@l_ExtRetentionRuleSum = SUM(retentionRule+graceRule) FROM #tempAgingRulesExt
		UPDATE	#tempJobData
		SET		extRetentionFlags = (
				case
				when extRetentionFlags & (64|4096) <> 0 then 64
				when extRetentionFlags & (32|2048) <> 0 then 32
				when extRetentionFlags & (16|1024) <> 0 then 16
				when extRetentionFlags & (8 | 512) <> 0 then 8
				when extRetentionFlags & (4 | 256) <> 0 then 4
				when extRetentionFlags & (524288 | 8388608) <> 0 then 524288
				when extRetentionFlags & (262144 | 4194304) <> 0 then 262144
				when extRetentionFlags & 2 <> 0 then 2
				end)
		WHERE	extRetentionFlags & @l_ExtRetentionRuleSum <> 0
		UPDATE	#tempJobData
		SET		retentionDays = b.retentionDays
		FROM	#tempJobData a, #tempAgingRulesExt b
		WHERE	b.retentionRule = a.extRetentionFlags
			AND (b.retentionDays < 0 OR b.retentionDays > a.retentionDays)
	END
	DROP TABLE #tempAgingRulesExt
END
UPDATE	#tempJobData
SET		retentionDays = @archiverAge
FROM	#tempJobData a,
		(SELECT appId
		FROM	#tempAppList APP, APP_IDATypeHandlingInfo IDA WITH (NOLOCK)
		WHERE	IDA.appTypeId = APP.appTypeId AND IDA.isDMAppType = 1) b
WHERE	a.appId = b.appId
--Update retentionJobs for those appType and copy that honors Job Based Retention
IF EXISTS (SELECT copyId FROM archAgingRule AAR WITH (NOLOCK) WHERE AAR.copyId = @i_copyId AND (AAR.flags & 128) > 0)
BEGIN
	SELECT	@retentionJobs = AAR.retentionJobs
	FROM archAgingRule AAR WITH (NOLOCK)
	WHERE AAR.copyId = @i_copyId
AND (AAR.flags & 128) > 0
	UPDATE #tempJobData
	SET retentionJobs = @retentionJobs
	FROM	#tempJobData T, App_Application A WITH (NOLOCK)
	WHERE	T.appId = A.id
	AND		@retentionJobs > 0
	AND		A.appTypeId NOT IN (
					SELECT appTypeId
					FROM APP_IDATypeHandlingInfo
					WHERE ignoreJobRetention = 1
				)
END
--Update isDDBBackup = 1 for DDB subclients
UPDATE #tempJobData
SET isDDBBackup = 1
FROM	#tempJobData T, App_SubclientProp B WITH (NOLOCK)
WHERE	T.appId = B.componentNameId
AND		B.attrName = 'DDB Backup'
AND		B.attrVal = '1'
AND		B.modified = 0
UPDATE #tempJobData
SET indexBackupJob = 1
FROM	#tempJobData T, App_SubclientProp B WITH (NOLOCK)
WHERE	T.appId = B.componentNameId
AND		B.attrName = 'Index SubClient'
AND		B.attrVal = '1'
AND		B.modified = 0
--The retentionEndTime here is the one we get from manualRetentionEndTime column of JMJobDataStats so if it is -1 or greater than the one we calculate from aging rule consider it retained by user
UPDATE	#tempJobData
SET		retainedBy = case when (A.retentionEndTime > (B.startTime + A.retentionDays*24*3600) OR A.retentionEndTime = -1) then 1
								else 0 end
FROM	#tempJobData A, #tempJobStats B
WHERE	B.jobId = A.jobId AND B.commCellId = A.commCellId
--Set retentionEndTime = -2 to show N/A in GUI
UPDATE	#tempJobData
SET		retentionEndTime = case when (A.retentionEndTime = 0 AND A.retentionJobs > 0) then -2
								when (A.retentionEndTime = 0 AND A.isDDBBackup > 0) then -2
								when A.retentionDays < 0 then -1
								when A.retentionEndTime >(B.startTime + A.retentionDays*24*3600) then A.retentionEndTime
								else (B.startTime + A.retentionDays*24*3600) end
FROM	#tempJobData A, #tempJobStats B
WHERE	B.jobId = A.jobId AND B.commCellId = A.commCellId AND A.retentionEndTime > -1
--Set N\A for edge subclient jobs
UPDATE T
SET retentionEndTime = -2
FROM #tempJobData T INNER JOIN App_Application APP WITH(NOLOCK) ON T.appId = APP.id
WHERE APP.subclientStatus & 0x20000 > 0
-- Update retention criteria for OBJECT_STORE / CONTENT_SERVER=OBJECT_SERVER
-- DO NOT Honor SP/Copy Retention for Content Store Based On MMConfigs Option
IF @HonorSPCopyRetentionForContentStore = 0
BEGIN
	UPDATE	#tempJobData
	SET		retentionEndTime = -1,
			retentionDays    = -1
	FROM	#tempJobData J , #tempAppList A
	WHERE	J.appId = A.appId
AND	A.appTypeId IN (131,124)
END
UPDATE	#tempJobData SET archCheckStatus = 4
FROM	JMJobDataStats B WITH (NOLOCK), #tempJobData A
WHERE	B.jobId = A.jobId AND B.archGrpCopyId = @i_copyId AND B.commCellId = A.commCellId
	AND A.archCheckStatus = 5 AND B.archCheckStatus < 5
UPDATE	#tempJobData SET errorCode = B.errorCode
FROM	#tempJobData A,
		(SELECT	DISTINCT backupJobId, commCellId, errorCode
		FROM	archChunkSkipped WITH (NOLOCK)
		WHERE	destCopyId = @i_copyId) B
WHERE	A.jobId = B.backupJobId AND A.commCellId = B.commCellId
	AND A.maxStatus <> 100
IF @showNeedCopyTo <> 0
BEGIN
	IF object_id('tempdb.dbo.#tempDestCopy') IS NOT NULL DROP TABLE #tempDestCopy
	SELECT	id
	INTO	#tempDestCopy
	FROM	archGroupCopy WITH (NOLOCK)
	WHERE	archGroupId = @spId AND id <> @defCopyId AND id <> @i_copyId
		AND ((@i_copyId = @defCopyId AND sourceCopyId = 0) OR sourceCopyId = @i_copyId)
	IF EXISTS (SELECT * FROM #tempDestCopy)
	BEGIN
		-- already copied
		UPDATE	#tempJobData SET toBeCopied = 2 FROM #tempJobData J
WHERE	J.maxStatus = 100 AND J.disabled & (1+256) = 0
			AND EXISTS (SELECT * FROM JMJobDataStats WITH (NOLOCK)
				WHERE jobId = J.jobId
				AND archGrpCopyId IN (SELECT id FROM #tempDestCopy)
				AND commCellId = J.commCellId
				AND status = 100)
		-- to be copied
		UPDATE	#tempJobData SET toBeCopied = 1 FROM #tempJobData J
WHERE	J.maxStatus = 100 AND J.disabled & (1+256) = 0
			AND EXISTS (SELECT * FROM JMJobDataStats WITH (NOLOCK)
				WHERE jobId = J.jobId
				AND archGrpCopyId IN (SELECT id FROM #tempDestCopy)
				AND commCellId = J.commCellId
AND status IN (101, 102, 103) AND disabled & (1+256) = 0)
	END
	DROP TABLE #tempDestCopy
END
SELECTABLE_JOBS:
INSERT	INTO #tempJobAFList
SELECT	A.id, A.jobId, A.commCellId, 0, 0
FROM	archFile A WITH (NOLOCK), #tempJobData T
WHERE	A.jobId = T.jobId AND A.commCellId = T.commCellId AND A.archGroupId = @spId AND A.isValid = 1
IF (@dedupeFlags & 262144) > 0
BEGIN
	UPDATE	#tempJobAFList
	SET		isDeduped = 1,
	dedupSaving = ISNULL(A.secondaryObjSize, 0) + ISNULL(A.secondaryMetaDataSize, 0) + ISNULL(A.primaryMetaDataSize, 0)
	FROM	archFileCopyDedup A WITH (NOLOCK), #tempJobAFList T
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = @i_copyId AND A.secondaryObjSize > 0
	UPDATE #tempJobData
	SET	dedupSaving = (SELECT SUM(dedupSaving) FROM #tempJobAFList T WHERE T.jobId = #tempJobData.jobId AND T.commCellId = #tempJobData.commCellId)
END
DECLARE	@l_jobId		INT
DECLARE	@l_commCellId	INT
DECLARE	@l_instanceName	VARCHAR(255)
DECLARE	@l_len			INT
DECLARE	@t_jobId		INT
DECLARE	@t_commCellId	INT
DECLARE	@t_instanceName	VARCHAR(255)
DECLARE	@t_len			INT
SET	@l_jobId		= 0
SET	@l_commCellId	= 0
SET	@l_len			= 0
DECLARE	GetInstanceNameCur CURSOR FOR
SELECT	T.jobId, T.commCellId, I.name, LEN(I.name)
FROM	archFileOracle A WITH (NOLOCK), APP_InstanceName I WITH (NOLOCK), APP_Application APP WITH (NOLOCK), JMBkpStats J WITH (NOLOCK), #tempJobAFList T
WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND I.id = A.instanceId
AND J.jobId = T.jobId AND J.commCellId = T.commCellId AND (J.bkpAttributes & 0x20000) > 0
	AND APP.id = A.appId AND APP.instance <> A.instanceId
GROUP BY T.jobId, T.commCellId, I.name
ORDER BY T.jobId, T.commCellId, I.name
OPEN	GetInstanceNameCur
FETCH	FROM GetInstanceNameCur
INTO	@t_jobId, @t_commCellId, @t_instanceName, @t_len
WHILE @@FETCH_STATUS = 0
BEGIN
	IF	@l_jobId = @t_jobId AND @l_commCellId = @t_commCellId
	BEGIN
IF	@l_len < (255 - 6)
		BEGIN
IF	(@l_len + @t_len) < (255 - 6)
			BEGIN
				SET @l_instanceName = @l_instanceName + ', ' + @t_instanceName
				SET @l_len = @l_len + @t_len + 2
			END
			ELSE
			BEGIN
				SET @l_instanceName = @l_instanceName + ', ...)'
SET @l_len = 255
			END
		END
	END
	ELSE
	BEGIN
		IF	@l_jobId > 0
			INSERT	INTO #realInstanceNames
			SELECT	@l_jobId, @l_commCellId, @l_instanceName + ')'
		SET @l_jobId		= @t_jobId
		SET @l_commCellId	= @t_commCellId
		SET	@l_instanceName	= 'On Demand Instance (' + @t_instanceName
		SET @l_len			= @t_len + 20
	END
	FETCH	FROM GetInstanceNameCur
	INTO	@t_jobId, @t_commCellId, @t_instanceName, @t_len
END
IF	@l_jobId > 0
	INSERT	INTO #realInstanceNames
	SELECT	@l_jobId, @l_commCellId, @l_instanceName + ')'
CLOSE		GetInstanceNameCur
DEALLOCATE	GetInstanceNameCur
-- Set jobCopyAttributes
INSERT INTO #tempJobCopyAttr
SELECT	T.jobId, T.commCellId, MAX(A.encKeyType), MAX(T.isDeduped)
FROM	#tempJobAFList T
		INNER JOIN archFileCopy A WITH (NOLOCK)
		ON A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = @i_copyId
GROUP BY T.jobId, T.commCellId
UPDATE	#tempJobData
SET		jobCopyAttributes = (A.jobCopyAttributes | B.isDeduped * 1)
FROM	#tempJobData A, #tempJobCopyAttr B
WHERE	A.commCellId = B.commCellId AND A.jobId = B.jobId
UPDATE	#tempJobData
SET		jobCopyAttributes = (A.jobCopyAttributes | 2)
FROM	#tempJobData A, #tempJobCopyAttr B
WHERE	A.commCellId = B.commCellId AND A.jobId = B.jobId  AND B.encKeyType <> 0
IF EXISTS (SELECT TOP 1 1 FROM MMConfigs WHERE name like 'MMCONFIG_SHOW_JOB_MEDIA_REFRESH' AND value = 1)
BEGIN
	UPDATE	#tempJobData
SET		jobCopyAttributes = (A.jobCopyAttributes | (CASE WHEN JDS.status = 101 AND JDS.disabled & 1 = 0 THEN 32
WHEN JDS.status = 1000 THEN 64
WHEN JDS.status IN (102,103) THEN 128  END))
	FROM	#tempJobData A, JMJobDataStats JDS WITH (READUNCOMMITTED), archCopyMediaRefreshProp M WITH (READUNCOMMITTED)
	WHERE	A.commCellId = JDS.commCellId AND A.jobId = JDS.jobId AND JDS.archGrpCopyId = M.targetCopyId AND M.copyId = @i_copyId
			AND JDS.opType = 74
	UPDATE	#tempJobData
SET		jobCopyAttributes = (A.jobCopyAttributes | 256 )
	FROM	#tempJobData A, archFile AF WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED)
	WHERE	AFC.mediaType <> 10001
		AND AF.commCellId = AFC.commCellId
		AND AF.commCellId = A.commCellId
		AND AF.id = AFC.archFileId
		AND AFC.archCopyId = @i_copyId
		AND AF.jobId = A.jobId
	INSERT INTO #refreshTime
	SELECT DISTINCT JDs.commCellId,JDS.jobId ,JDS.copiedTime
	FROM	#tempJobData A, JMJobDataStats JDS WITH (READUNCOMMITTED), archCopyMediaRefreshProp M WITH (READUNCOMMITTED)
	WHERE	A.commCellId = JDS.commCellId AND A.jobId = JDS.jobId AND JDS.archGrpCopyId = M.targetCopyId AND M.copyId = @i_copyId
END
IF (@dedupeFlags & (262144 | 2097152)) = (262144 | 2097152)
BEGIN
	CREATE TABLE #tempJobChunk (jobId INT, archChunkId bigint, commCellId int, isSiloed int)
	INSERT	INTO #tempJobChunk
	SELECT	T.jobId, ACM.archChunkId, ACM.commCellId, 0
	FROM	#tempJobAFList T, archChunkMapping ACM WITH (NOLOCK)
	WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = @i_copyId
	UPDATE	#tempJobChunk
	SET		isSiloed = 1
	FROM	#tempJobChunk T, archChunkToSilo AC WITH (NOLOCK), archFileSiloVolume SV WITH (NOLOCK)
	WHERE	AC.archChunkId = T.archChunkId AND AC.commCellId = T.commCellId
		AND AC.volumeId = SV.siloVolumeId
AND AC.archChunkId <= SV.lastSiloChunkId AND (SV.flags & (1 | 2)) <> 0
	DELETE	#tempJobChunk
	FROM	#tempJobChunk T, (SELECT DISTINCT jobId, commCellId FROM #tempJobChunk WHERE isSiloed = 0) B
	WHERE	T.jobId = B.jobId AND T.commCellId = B.commCellId
	UPDATE	#tempJobData
SET		jobCopyAttributes = (A.jobCopyAttributes | 16)
	FROM	#tempJobData A, (SELECT DISTINCT jobId, commCellId FROM #tempJobChunk WHERE isSiloed = 1) B
	WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
	DROP TABLE #tempJobChunk
END
INSERT	INTO #jobCRC
SELECT	T.jobId, T.commCellId, MIN(AC.flags & 16),
(MAX(AC.flags & 1048576) | MAX(LEN(hwEncKey)))
FROM	#tempJobAFList T, archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK)
WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = @i_copyId
	AND AC.id = ACM.archChunkId AND AC.commCellId = ACM.commCellId
	AND AC.physicalSize > 0
	AND AC.logicalSize > 0
GROUP BY T.jobId, T.commCellId
UPDATE	#tempJobData
SET		jobCopyAttributes = (A.jobCopyAttributes | 4)
FROM	#tempJobData A, #jobCRC B
WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId AND B.minCRC <> 0
UPDATE	#tempJobData
SET		jobCopyAttributes = (A.jobCopyAttributes | 8)
FROM	#tempJobData A, #jobCRC B
WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId AND B.maxHwEnc <> 0
DROP TABLE #jobCRC
DROP TABLE #tempJobAFList
DROP TABLE #tempJobCopyAttr
-- Show snap jobs on primary copy
IF	@i_copyId = @defCopyId AND @defSnapCopyId > 0 AND (@dataState & (32|64)) != 0
BEGIN
	SELECT	DISTINCT T.*
	INTO	#tempSnapJobs
	FROM	#tempJobStats T
			INNER JOIN JMJobDataStats JS WITH (NOLOCK)
ON JS.jobId = T.jobId AND JS.commCellId = T.commCellId AND JS.archGrpCopyId = @defSnapCopyId AND JS.dataType IN (1, 4)
			LEFT OUTER JOIN #tempJobData JD
				ON JD.jobId = JS.jobId AND JD.commCellId = JS.commCellId
	WHERE	JD.jobId IS NULL
	IF	(@dataState & 64) = 0
		INSERT	INTO #tempJobData
		SELECT	S.jobId, S.commCellId, S.appId, J.materializationStatus, J.materializationStatus,
8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 2, (16 | 32768), 0 /* for index backup job flag*/, ''
		FROM	#tempSnapJobs S
				INNER JOIN JMJobSnapshotStats J WITH (NOLOCK)
					ON J.jobId = S.jobId AND J.commCellId = S.commCellId AND J.archGrpId = @spId
						AND J.materializationStatus IN (101, 102, 103) AND J.disabled = 0
AND J.flags & 1  = 0
	ELSE
		INSERT	INTO #tempJobData
		SELECT	S.jobId, S.commCellId, S.appId, ISNULL(J.materializationStatus, 101), ISNULL(J.materializationStatus, 101),
				ISNULL(J.disabled, 1)+8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 2, 0, 0 /* for index backup job flag*/, ''
		FROM	#tempSnapJobs S
				INNER JOIN JMJobSnapshotStats J WITH (NOLOCK)
					ON J.jobId = S.jobId AND J.commCellId = S.commCellId AND J.archGrpId = @spId
		WHERE	J.jobId IS NULL OR J.materializationStatus IN (101, 102, 103)
AND J.flags & 1  = 0
	DROP TABLE 	#tempSnapJobs
END
-- Apply specified time zone
IF	(@options & 1) = 0 OR @l_TimeZoneType = 0
	INSERT	INTO #tempTimeZone
	SELECT	DISTINCT clientId, @l_csTimeZone
	FROM	#tempAppList
ELSE
IF	@l_TimeZoneType = 1
	INSERT	INTO #tempTimeZone
	SELECT	T.clientId, dbo.archGroupTimeZone(@spId, T.clientId)
	FROM	(SELECT DISTINCT clientId FROM #tempAppList) T
ELSE
	INSERT	INTO #tempTimeZone
	SELECT	DISTINCT clientId, @l_TimeZone
	FROM	#tempAppList
UPDATE	#tempJobStats
SET		startTime		= J.startTime + dbo.GetDiffFromCSTimeZone(J.startTime, TZ.TimeZone, @l_csTimeZone),
		endTime			= J.endTime + dbo.GetDiffFromCSTimeZone(J.endTime, TZ.TimeZone, @l_csTimeZone)
FROM	#tempJobStats J, #tempAppList A, #tempTimeZone TZ
WHERE	J.appId = A.appId AND A.clientId = TZ.clientId AND TZ.TimeZone <> '' AND TZ.TimeZone <> @l_csTimeZone
-- Delete the foreign jobs if they are already prepared
DELETE	#tempJobStats
FROM	#tempJobStats, JMPreparedJob
WHERE	#tempJobStats.jobId = JMPreparedJob.jobId AND #tempJobStats.commCellId = JMPreparedJob.commCellId
		AND JMPreparedJob.status = 3
UPDATE	#tempJobData
SET		archCheckEndTime= case when J.archCheckEndTime = 0 then 0 else
						J.archCheckEndTime + dbo.GetDiffFromCSTimeZone(J.archCheckEndTime, TZ.TimeZone, @l_csTimeZone) end,
		retentionEndTime= case 	when J.retentionEndTime = -2 then -2
														when J.retentionEndTime = -1 then -1
											else 	J.retentionEndTime + dbo.GetDiffFromCSTimeZone(J.retentionEndTime, TZ.TimeZone, @l_csTimeZone) end,
		copiedTime		= case when J.copiedTime = 0 then 0 else
						J.copiedTime + dbo.GetDiffFromCSTimeZone(J.copiedTime, TZ.TimeZone, @l_csTimeZone) end,
		agedTime		= case when J.agedTime = 0 then 0 else
						J.agedTime + dbo.GetDiffFromCSTimeZone(J.agedTime, TZ.TimeZone, @l_csTimeZone) end
FROM	#tempJobData J, #tempAppList A, #tempTimeZone TZ
WHERE	J.appId = A.appId AND A.clientId = TZ.clientId AND TZ.TimeZone <> '' AND TZ.TimeZone <> @l_csTimeZone
UPDATE #tempJobData
SET jobDescription = JMJS.jobDescription
FROM JMJobStats JMJS
WHERE #tempJobData.jobId = JMJS.jobId and #tempJobData.commCellId = JMJS.commCellId
UPDATE #tempJobData
SET jobDisplayFlags =	T2.jobDisplayFlags
FROM #tempJobData T1 INNER JOIN
(
SELECT JDS1.jobId, JDS1.commcellId, (
MAX(CASE WHEN JDS2.status = 100 AND (JDS2.disabled & 1) = 0 THEN 1 ELSE 0 END) |
MAX(CASE WHEN JDS2.status = 100 AND (JDS2.disabled & 1) > 0 THEN 2 ELSE 0 END) |
MAX(CASE WHEN JDS2.status IN (102, 103) AND (JDS2.disabled & 1) = 0 THEN 4 ELSE 0 END) |
MAX(CASE WHEN JDS2.status IN (102, 103) AND (JDS2.disabled & 1) > 0 THEN 8 ELSE 0 END) |
MAX(CASE WHEN JDS2.status = 101 AND (JDS2.disabled & 1) = 0 THEN 16 ELSE 0 END) |
MAX(CASE WHEN JDS2.status = 101 AND (JDS2.disabled & 1) > 0 THEN 32 ELSE 0 END) |
MAX(CASE WHEN JDS2.status = 1000 THEN 64 ELSE 0 END) |
MAX(CASE WHEN (JDS2.disabled & 64) > 0 THEN 128 ELSE 0 END) |
MAX(CASE WHEN (JDS2.disabled & 256) > 0 THEN 256 ELSE 0 END) |
MAX(CASE WHEN (JDS2.disabled & 256) = 0 THEN 512 ELSE 0 END) |
MAX(CASE WHEN (JDS2.disabled & 2) > 0 THEN 1024 ELSE 0 END) |
MAX(CASE WHEN (JDS2.disabled & 1) > 0 THEN 2048 ELSE 0 END) |
MAX(CASE WHEN (JDS2.disabled & 16384) > 0 THEN 8192 ELSE 0 END) |
MAX(CASE WHEN JDS2.jobId IS NULL THEN 16384 ELSE 0 END)
							) "jobDisplayFlags"
					FROM #tempJobData JDS1 LEFT OUTER JOIN JMJobDataStats JDS2 WITH(NOLOCK) ON JDS1.jobId = JDS2.jobId AND JDS1.commcellId = JDS2.commcellId AND JDS2.archGrpCopyId = @i_copyId
WHERE JDS1.jobDisplayFlags & 32768 = 0
					GROUP BY JDS1.jobId, JDS1.commcellId
					) T2 ON T1.jobId = T2.jobId AND T1.commcellId = T2.commcellId
DECLARE @l_deferredDays int = 0
SELECT @l_deferredDays = delayedDays FROM ArchGroupCopy WITH(NOLOCK) WHERE id = @i_copyId
IF(@l_deferredDays > 0)
	UPDATE #tempJobData
SET jobDisplayFlags = jobDisplayFlags | 4096
	FROM #tempJobData JDS INNER JOIN #tempJobStats JBKP ON JDS.jobId = JBKP.jobId AND JDS.commcellID = JBKP.commcellId
WHERE JDS.jobDisplayFlags & (16 | 4) > 0
AND JDS.jobDisplayFlags & 32768 = 0
AND JDS.jobDisplayFlags & 2048 = 0
	AND DATEDIFF(day, dbo.GetDateTime(JBKP.StartTime), GETUTCDATE()) < @l_deferredDays
--Set the Required By JobIds list
INSERT INTO #tempReqByJobList
SELECT a.JobId, a.commCellId, b.parentJobId
FROM #tempJobData a, JMJobDataLinkViewForDA b WITH (NOLOCK)
WHERE	a.JobId = b.ChildJobId
AND 	a.commCellId = b.CommCellId
AND		b.parentJobId > 0
AND		b.parentJobId != b.ChildJobId
INSERT INTO #tempReqByJobList
SELECT a.JobId, a.commCellId, b.childJobId
FROM #tempJobData a, JMVSAAppJobLink b WITH (NOLOCK)
WHERE	a.JobId = b.parentJobId
AND 	a.commCellId = b.CommCellId
AND		b.childJobId > 0
AND		b.parentJobId != b.ChildJobId
UPDATE #tempJobData
SET RequiredByJobIds = T.JobList
FROM #tempJobData TMP, ( SELECT a.JobId, a.commCellId, SUBSTRING((	SELECT DISTINCT ( ', ' + CAST(b.ReqByJobId AS VARCHAR(10)))
																																		FROM 	#tempReqByJobList b
																																		WHERE	a.JobId = b.JobId
																																		AND 	a.commCellId = b.CommCellId
																																		FOR XML PATH('') ), 2, 99999999) AS JobList
												 FROM 	#tempJobData a
											 )	T
WHERE TMP.JobId = T.JobId
AND		TMP.commCellId = T.commCellId
-- get laptop owner list
CREATE TABLE #LaptopOwner (clientId INT, ownerName NVARCHAR(255))
CREATE TABLE #LaptopOwnerList (clientId INT, ownerList NVARCHAR(MAX))
INSERT	INTO #LaptopOwner
SELECT	C.id, U.login
FROM	#tempTimeZone AS T
		INNER JOIN APP_Client C ON T.clientId = C.id AND (C.status&0x1000) <> 0
		INNER JOIN sec_getClientOwnersExpandUG O ON O.clientId = C.id
		INNER JOIN UMUsers U ON U.id = O.userId
ORDER BY C.id, U.login
INSERT	#LaptopOwnerList
SELECT	clientId,
		STUFF((SELECT ','+[ownerName] FROM #LaptopOwner WHERE clientId = T.clientId FOR XML PATH('')), 1, 1, '')
FROM	(SELECT DISTINCT clientId FROM #LaptopOwner) T
DROP TABLE #LaptopOwner
CREATE INDEX #LaptopOwnerList_clientId_idx ON #LaptopOwnerList (clientId)
UPDATE  A SET clientOwnersList = L.ownerList
FROM	#tempAppList A INNER JOIN #LaptopOwnerList L ON A.clientId = L.clientId
DROP TABLE #LaptopOwnerList
IF @orderByCode = 0
	SELECT	B.*, A.appId, A.clientId, A.appTypeId, A.instance, A.backupSet,	A.clientName, A.appTypeName,
			InstName = (CASE WHEN I.name IS Null THEN A.instanceName ELSE I.name END), A.backupSetName, A.subclientName,
			(select aliasName from APP_CommCell WITH (NOLOCK) where id=J.commCellId),
			(case when (J.minStatus = 100 and J.maxStatus = 101) then 103 when (J.minStatus < 1000 and J.maxStatus = 1000) then J.minStatus else J.maxStatus end),
			J.disabled, J.toBeCopied, J.jobCopyAttributes, J.sizeOnMedia, J.archCheckEndTime, J.archCheckStatus,
			J.extRetentionFlags, J.retentionEndTime, J.copiedTime, J.agedTime, J.errorCode, J.retainedBy, @i_copyId, J.dedupSaving, J.jobCopyStatus,
			J.jobDescription, J.jobDisplayFlags, J.indexBackupJob, A.clientOwnersList, J.RequiredByJobIds, R.lastRefreshTime, A.clientDisplayName
	FROM	#tempAppList A, #tempJobStats B, #tempJobData J
 			LEFT OUTER JOIN #realInstanceNames AS I ON I.jobId = J.jobId AND I.commcellId = J.CommcellId
			LEFT OUTER JOIN #refreshTime  AS R ON R.jobId = J.jobId AND R.commcellId = J.CommcellId
	WHERE	J.jobId = B.jobId AND J.commCellId = B.commCellId AND A.appId = B.appId
	AND ((@options = 0 OR @options = 1) OR (( J.jobCopyStatus & 2 = 0 ) OR ( J.jobCopyStatus & 2 > 0 AND (((@options & 2) <> 0 AND (@today - B.StartTime) BETWEEN @MinorVal AND @MajorVal)
		OR ((@options & 4) <> 0 AND (@today - B.StartTime) BETWEEN @MajorVal AND @CriticalVal)
		OR ((@options & 8) <> 0 AND (@today - B.StartTime) >= @CriticalVal)))))
	ORDER BY J.commCellId DESC, J.jobId DESC
ELSE
IF @orderByCode = 1
	SELECT	B.*, A.appId, A.clientId, A.appTypeId, A.instance, A.backupSet,	A.clientName, A.appTypeName,
			InstName = (CASE WHEN I.name IS Null THEN A.instanceName ELSE I.name END), A.backupSetName, A.subClientName,
			(select aliasName from APP_CommCell WITH (NOLOCK) where id=J.commCellId),
			(case when (J.minStatus = 100 and J.maxStatus = 101) then 103 when (J.minStatus < 1000 and J.maxStatus = 1000) then J.minStatus else J.maxStatus end),
			J.disabled, J.toBeCopied, J.jobCopyAttributes, J.sizeOnMedia, J.archCheckEndTime, J.archCheckStatus,
			J.extRetentionFlags, J.retentionEndTime, J.copiedTime, J.agedTime, J.errorCode, J.retainedBy, @i_copyId , J.dedupSaving, J.jobCopyStatus,
			J.jobDescription, J.jobDisplayFlags, J.indexBackupJob, A.clientOwnersList, J.RequiredByJobIds, R.lastRefreshTime, A.clientDisplayName
	FROM	#tempAppList A, #tempJobStats B, #tempJobData J
 			LEFT OUTER JOIN #realInstanceNames AS I ON I.jobId = J.jobId AND I.commcellId = J.CommcellId
			LEFT OUTER JOIN #refreshTime  AS R ON R.jobId = J.jobId AND R.commcellId = J.CommcellId
	WHERE	J.jobId = B.jobId AND J.commCellId = B.commCellId AND A.appId = B.appId
	AND ((@options = 0 OR @options = 1) OR (( J.jobCopyStatus & 2 = 0 ) OR ( J.jobCopyStatus & 2 > 0 AND (((@options & 2) <> 0 AND (@today - B.StartTime) BETWEEN @MinorVal AND @MajorVal)
		OR ((@options & 4) <> 0 AND (@today - B.StartTime) BETWEEN @MajorVal AND @CriticalVal)
		OR ((@options & 8) <> 0 AND (@today - B.StartTime) >= @CriticalVal)))))
	ORDER BY A.clientName, A.appTypeName, InstName, A.backupSetName, A.subClientName, J.commCellId DESC, J.jobId DESC
ELSE
IF @orderByCode = 2
	SELECT	B.*, A.appId, A.clientId, A.appTypeId, A.instance, A.backupSet,	A.clientName, A.appTypeName,
			InstName = (CASE WHEN I.name IS Null THEN A.instanceName ELSE I.name END), A.backupSetName, A.subClientName,
			(select aliasName from APP_CommCell WITH (NOLOCK) where id=J.commCellId),
			(case when (J.minStatus = 100 and J.maxStatus = 101) then 103 when (J.minStatus < 1000 and J.maxStatus = 1000) then J.minStatus else J.maxStatus end),
			J.disabled, J.toBeCopied, J.jobCopyAttributes, J.sizeOnMedia, J.archCheckEndTime, J.archCheckStatus,
			J.extRetentionFlags, J.retentionEndTime, J.copiedTime, J.agedTime, J.errorCode, J.retainedBy, @i_copyId, J.dedupSaving, J.jobCopyStatus,
			J.jobDescription, J.jobDisplayFlags, J.indexBackupJob, A.clientOwnersList, J.RequiredByJobIds, R.lastRefreshTime, A.clientDisplayName
	FROM	#tempAppList A, #tempJobStats B, #tempJobData J
 			LEFT OUTER JOIN #realInstanceNames AS I ON I.jobId = J.jobId AND I.commcellId = J.CommcellId
			LEFT OUTER JOIN #refreshTime  AS R ON R.jobId = J.jobId AND R.commcellId = J.CommcellId
	WHERE	J.jobId = B.jobId AND J.commCellId = B.commCellId AND A.appId = B.appId
	AND ((@options = 0 OR @options = 1) OR (( J.jobCopyStatus & 2 = 0 ) OR ( J.jobCopyStatus & 2 > 0 AND (((@options & 2) <> 0 AND (@today - B.StartTime) BETWEEN @MinorVal AND @MajorVal)
		OR ((@options & 4) <> 0 AND (@today - B.StartTime) BETWEEN @MajorVal AND @CriticalVal)
		OR ((@options & 8) <> 0 AND (@today - B.StartTime) >= @CriticalVal)))))
	ORDER BY A.appTypeName, A.clientName, InstName, A.backupSetName, A.subClientName, J.commCellId DESC, J.jobId DESC
if (OBJECT_ID('tempdb.dbo.#tempAppList') IS NOT NULL) DROP TABLE #tempAppList
if (OBJECT_ID('tempdb.dbo.#tempJobStats') IS NOT NULL) DROP TABLE #tempJobStats
if (OBJECT_ID('tempdb.dbo.#tempJobData') IS NOT NULL) DROP TABLE #tempJobData
if (OBJECT_ID('tempdb.dbo.#tempReqByJobList') IS NOT NULL) DROP TABLE #tempReqByJobList
if (OBJECT_ID('tempdb.dbo.#tempJobAFList') IS NOT NULL) DROP TABLE #tempJobAFList
if (OBJECT_ID('tempdb.dbo.#realInstanceNames') IS NOT NULL) DROP TABLE #realInstanceNames
if (OBJECT_ID('tempdb.dbo.#tempJobCopyAttr') IS NOT NULL) DROP TABLE #tempJobCopyAttr
if (OBJECT_ID('tempdb.dbo.#jobCRC') IS NOT NULL) DROP TABLE #jobCRC
if (OBJECT_ID('tempdb.dbo.#tempTimeZone') IS NOT NULL) DROP TABLE #tempTimeZone
if OBJECT_ID('tempdb.dbo.#archCopyToAppId') is not null DROP TABLE #archCopyToAppId
RETURN;
GO


IF EXISTS (select * from GxQscripts where name = 'archViewJobsByCopy')
	delete from GxQscripts where name = 'archViewJobsByCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewJobsByCopy')
	delete from GXDBVersions where aliasname = 'archViewJobsByCopy'
GO

insert into GXDBVersions values(2, 'archViewJobsByCopy',  'v1.93.2.30.8.1', 'archViewJobsByCopy', 'v1.93.2.30.8.1')
GO

