

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archViewDRJobsByCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archViewDRJobsByCopy.sp,v $ $Id: archViewDRJobsByCopy.sp,v 1.20.46.3.36.1 2021/03/04 05:52:17 cliu Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archViewDRJobsByCopy')
BEGIN
	print '>>> Drop Stored Procedure: archViewDRJobsByCopy <<<'
	drop procedure archViewDRJobsByCopy
END
IF EXISTS (select * from GxQscripts where name='archViewDRJobsByCopy')
	delete from GxQscripts where name = 'archViewDRJobsByCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewDRJobsByCopy')
	delete from GXDBVersions where aliasname = 'archViewDRJobsByCopy'
GO
print '... Creating Procedure: archViewDRJobsByCopy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archViewDRJobsByCopy
  @i_copyId integer,
  @showNeedCopyTo integer,
  @isAged integer,
  @timeRangeBegin integer,
  @timeRangeEnd integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_commCellId integer
  DECLARE @o_jobId integer
  DECLARE @o_status integer
  DECLARE @o_disabled integer
  DECLARE @o_toBeCopied integer
  DECLARE @o_sizeOfApplication bigint
  DECLARE @o_sizeOfBackup bigint
  DECLARE @o_sizeOnMedia bigint
  DECLARE @o_startTime integer
  DECLARE @o_endTime integer
  DECLARE @o_opType integer
  DECLARE @o_level integer
  DECLARE @o_sendCount integer
  DECLARE @o_storagePolicyId integer
  DECLARE @o_storagePolicy NVARCHAR(255)
  DECLARE @o_DB nvarchar(255)
  DECLARE @o_destination nvarchar(255)
  DECLARE @o_usedMedia nvarchar(255)
  DECLARE @o_initFrom integer
  DECLARE @o_userName nvarchar(255)
  DECLARE @o_jobCopyAttributes integer
  DECLARE @o_archCheckEndTime integer
  DECLARE @o_archCheckStatus integer
  DECLARE @o_extRetentionFlags integer
  DECLARE @o_retentionDays integer
  DECLARE @o_pinJobEndTime bigint
  DECLARE @o_copiedTime integer
  DECLARE @o_agedTime bigint
  DECLARE @o_errorCode integer
  DECLARE @o_jobDisplayFlags bigint
SET NOCOUNT ON
CREATE TABLE #tempJobList
(
	jobId				int,
	commcellId			int,
	appId	            int,
	status				int,
	disabled			int,
	toBeCopied			int,
	sizeOnMedia			bigint,
	errorCode			int,
	jobCopyAttributes	int,
	archCheckEndTime	int,
	archCheckStatus		int,
	extRetentionFlags	int,
	extRetentionDays	int,
	manualRetentionEndTime bigint,
	copiedTime			int,
	agedTime			bigint,
	jobDisplayFlags		bigint,
	PRIMARY KEY(jobId, commCellId)
)
CREATE TABLE #tempJobAFList
(
	archFileId			int,
	jobId				int,
	commCellId			int,
	isDeduped			int,
	PRIMARY KEY(archFileId, commCellId)
)
CREATE TABLE #tempJobCopyAttr
(
	jobId				int,
	commCellId			int,
	encKeyType			int,
	isDeduped			int,
	PRIMARY KEY(jobId, commCellId)
)
CREATE TABLE #jobCRC
(
	jobId				int,
	commCellId			int,
	minCRC				int,
	maxHwEnc			int,
	PRIMARY KEY(jobId, commCellId)
)
DECLARE @spId integer
DECLARE @srcCopyId integer
DECLARE @defCopyId integer
DECLARE @dedupeFlags integer
DECLARE @checkSumLiveSyncSubclient INTEGER
SET @checkSumLiveSyncSubclient = CHECKSUM(N'CommServe LiveSync Backup')
/*
 32768  - This jobDisplayFlag describes as Commserve DR Job
 65536  - This jobDisplayFlag describes as Commserve LiveSync Job
*/
SELECT	@spId = AG.id, @defCopyId = AG.defaultCopy, @dedupeFlags = AGC.dedupeFlags,
		@srcCopyId = (CASE WHEN AGC.sourceCopyId = 0 THEN AG.defaultCopy ELSE AGC.sourceCopyId END),
		@o_storagePolicy = AG.name
FROM	archGroupCopy AGC WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
WHERE	AG.id = AGC.archGroupId AND AGC.id = @i_copyId
INSERT	INTO #tempJobList
SELECT	jobId, commcellId,appId, max(status), max(disabled), 0, sum(sizeOnMedia), 0, 0, max(archCheckEndTime),
		(case when max(archCheckStatus) <> 5 then max(archCheckStatus) when min(archCheckStatus) = 5 then 5 else 4 end),
		max(retentionFlags), 0, max(manualRetentionEndTime), max(copiedTime), max(agedTime),
							(
MAX(CASE WHEN status = 100 AND (disabled & 1) = 0 THEN 1 ELSE 0 END) |
MAX(CASE WHEN status = 100 AND (disabled & 1) > 0 THEN 2 ELSE 0 END) |
MAX(CASE WHEN status IN (102, 103) AND (disabled & 1) = 0 THEN 4 ELSE 0 END) |
MAX(CASE WHEN status IN (102, 103) AND (disabled & 1) > 0 THEN 8 ELSE 0 END) |
MAX(CASE WHEN status = 101 AND (disabled & 1) = 0 THEN 16 ELSE 0 END) |
MAX(CASE WHEN status = 101 AND (disabled & 1) > 0 THEN 32 ELSE 0 END) |
MAX(CASE WHEN status = 1000 THEN 64 ELSE 0 END) |
MAX(CASE WHEN (disabled & 64) > 0 THEN 128 ELSE 0 END) |
MAX(CASE WHEN (disabled & 256) > 0 THEN 256 ELSE 0 END) |
MAX(CASE WHEN (disabled & 256) = 0 THEN 512 ELSE 0 END) |
MAX(CASE WHEN (disabled & 2) > 0 THEN 1024 ELSE 0 END) |
MAX(CASE WHEN (disabled & 1) > 0 THEN 2048 ELSE 0 END) |
MAX(CASE WHEN (disabled & 16384) > 0 THEN 8192 ELSE 0 END) |
MAX(CASE WHEN jobId IS NULL THEN 16384 ELSE 0 END)
							)
FROM	JMJobDataStats WITH (READUNCOMMITTED)
WHERE	archGrpCopyId = @i_copyId
	AND (status IN (100, 102, 103) OR
(status = 101 AND disabled & (1+256) = 0))
AND ((@isAged = 0 AND (disabled & 256) = 0) OR
(@isAged = 1 AND (disabled & 256) <> 0) OR
		@isAged = 2)
GROUP BY jobId,appId,commcellId
UPDATE #tempJobList
SET jobDisplayFlags |= (CASE WHEN B.appTypeId = 1000 THEN 32768 ELSE 0 END)
FROM	#tempJobList A INNER JOIN APP_Application B WITH (READUNCOMMITTED) ON  A.appId =B.id
UPDATE #tempJobList
SET jobDisplayFlags |= (CASE WHEN B.attrVal='1' THEN 65536 ELSE 0 END)
FROM	#tempJobList A INNER JOIN APP_SubClientProp B WITH (READUNCOMMITTED) ON  A.appId = B.componentNameId
WHERE jobDisplayFlags & 32768=0 AND B.attrName = N'CommServe LiveSync Backup'  AND cs_attrName = @checkSumLiveSyncSubclient
UPDATE	#tempJobList SET status = 103 FROM #tempJobList J
WHERE	J.status IN (101, 102) AND EXISTS (SELECT * FROM JMJobDataStats WITH (READUNCOMMITTED)
WHERE	jobId = J.jobId AND archGrpCopyId = @i_copyId AND commcellId = J.commcellId AND status = 100)
DELETE	#tempJobList FROM #tempJobList J
WHERE	J.status = 101 AND EXISTS (SELECT * FROM JMJobDataStats X WITH (READUNCOMMITTED)
    WHERE X.jobId = J.jobId
      AND X.archGrpCopyId = @i_copyId
      AND X.commcellId = J.commcellId
      AND X.status <> 100
      AND NOT EXISTS (SELECT * FROM JMJobDataStats Y WITH (READUNCOMMITTED)
          WHERE Y.jobId = X.jobId
            AND Y.archGrpCopyId = @srcCopyId
            AND Y.dataType = X.dataType
            AND Y.commcellId = X.commcellId
AND Y.status = 100 AND Y.disabled & (1+256) = 0 ))
UPDATE	#tempJobList SET errorCode = B.errorCode
FROM	#tempJobList A,
	(SELECT	DISTINCT backupJobId, commCellId, errorCode
	FROM	archChunkSkipped WITH (READUNCOMMITTED)
	WHERE	destCopyId = @i_copyId) B
WHERE	A.jobId = B.backupJobId AND A.commCellId = B.commCellId
	AND A.status <> 100
-- Update retentionDays based on extended retention rules.
DECLARE @l_ExtRetentionRuleSum	INT
DECLARE @l_BasicRetentionDays	INT
SELECT	@l_BasicRetentionDays = retentionDays FROM archAgingRule WHERE copyId = @i_copyId
IF @l_BasicRetentionDays >= 0
BEGIN
	CREATE	TABLE #tempAginRules(retentionDays INT, retentionRule INT)
	INSERT	INTO #tempAginRules
	SELECT	retentionDays, retentionRule
	FROM	archAgingRuleExtended WITH (READUNCOMMITTED)
	WHERE	copyId = @i_copyId
	IF @@ERROR = 0 AND @@ROWCOUNT > 0
	BEGIN
		SELECT @l_ExtRetentionRuleSum = SUM(retentionRule) FROM #tempAginRules
		UPDATE	#tempJobList
		SET		extRetentionFlags = (
				case
				when extRetentionFlags & (64|4096) <> 0 then 64
				when extRetentionFlags & (32|2048) <> 0 then 32
				when extRetentionFlags & (16|1024) <> 0 then 16
				when extRetentionFlags & (8 | 512) <> 0 then 8
				when extRetentionFlags & (4 | 256) <> 0 then 4
				when extRetentionFlags & (524288 | 8388608) <> 0 then 524288
				when extRetentionFlags & (262144 | 4194304) <> 0 then 262144
				when extRetentionFlags & 2 <> 0 then 2
				end)
		WHERE	extRetentionFlags & @l_ExtRetentionRuleSum <> 0
		UPDATE	#tempJobList
		SET		extRetentionDays = b.retentionDays
		FROM	#tempJobList a, #tempAginRules b
		WHERE	b.retentionRule = a.extRetentionFlags
		AND (b.retentionDays < 0 OR b.retentionDays > a.extRetentionDays)
	END
	DROP TABLE #tempAginRules
END
IF @showNeedCopyTo <> 0
BEGIN
	SELECT	id
	INTO	#tempDestCopy
	FROM	archGroupCopy WITH (READUNCOMMITTED)
	WHERE	archGroupId = @spId AND id <> @defCopyId AND id <> @i_copyId
		AND ((@i_copyId = @defCopyId AND sourceCopyId = 0) OR sourceCopyId = @i_copyId)
	IF EXISTS (SELECT * FROM #tempDestCopy)
	BEGIN
		-- already copied
		UPDATE	#tempJobList SET toBeCopied = 2 FROM #tempJobList J
WHERE	J.status = 100 AND J.disabled & (1+256) = 0
			AND EXISTS	(SELECT * FROM JMJobDataStats WITH (READUNCOMMITTED)
				WHERE	jobId = J.jobId
					AND archGrpCopyId IN (SELECT id FROM #tempDestCopy)
					AND commcellId = J.commcellId
					AND status = 100)
		-- to be copied
		UPDATE	#tempJobList SET toBeCopied = 1 FROM #tempJobList J
WHERE	J.status = 100 AND J.disabled & (1+256) = 0
			AND EXISTS	(SELECT * FROM JMJobDataStats WITH (READUNCOMMITTED)
				WHERE	jobId = J.jobId
					AND archGrpCopyId IN (SELECT id FROM #tempDestCopy)
					AND commcellId = J.commcellId
					AND status IN (101, 102, 103)
AND disabled & (1+256) = 0)
	END
	DROP TABLE #tempDestCopy
END
-- Set jobCopyAttributes
INSERT	INTO #tempJobAFList
SELECT	A.id, A.jobId, A.commCellId, 0
FROM	archFile A WITH (READUNCOMMITTED), #tempJobList T
WHERE	A.jobId = T.jobId AND A.commCellId = T.commCellId AND A.archGroupId = @spId AND A.isValid = 1
IF (@dedupeFlags & 262144) > 0
	UPDATE	#tempJobAFList
	SET		isDeduped = 1
	FROM	archFileCopyDedup A WITH (NOLOCK), #tempJobAFList T
	WHERE	A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = @i_copyId AND A.secondaryObjSize > 0
INSERT INTO #tempJobCopyAttr
SELECT	T.jobId, T.commCellId, MAX(A.encKeyType), MAX(T.isDeduped)
FROM	#tempJobAFList T
		INNER JOIN archFileCopy A WITH (READUNCOMMITTED)
		ON A.archFileId = T.archFileId AND A.commCellId = T.commCellId AND A.archCopyId = @i_copyId
GROUP BY T.jobId, T.commCellId
UPDATE	#tempJobList
SET		jobCopyAttributes = (A.jobCopyAttributes | B.isDeduped * 1)
FROM	#tempJobList A, #tempJobCopyAttr B
WHERE	A.commCellId = B.commCellId AND A.jobId = B.jobId
UPDATE	#tempJobList
SET		jobCopyAttributes = (A.jobCopyAttributes | 2)
FROM	#tempJobList A, #tempJobCopyAttr B
WHERE	A.commCellId = B.commCellId AND A.jobId = B.jobId AND B.encKeyType <> 0
IF (@dedupeFlags & (262144 | 2097152)) = (262144 | 2097152)
BEGIN
	CREATE TABLE #tempJobChunk (jobId INT, afCommcellId int, archChunkId bigint, acCommcellId int, isSiloed int)
	INSERT	INTO #tempJobChunk
	SELECT	T.jobId, ACM.commcellId, ACM.archChunkId, ACM.chunkCommCellId, 0
	FROM	#tempJobAFList T, archChunkMapping ACM WITH (NOLOCK)
	WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = @i_copyId
	UPDATE	#tempJobChunk
	SET		isSiloed = 1
	FROM	#tempJobChunk T, archChunkToSilo AC WITH (NOLOCK), archFileSiloVolume SV WITH (NOLOCK)
	WHERE	AC.archChunkId = T.archChunkId AND AC.commCellId = T.acCommCellId
		AND AC.volumeId = SV.siloVolumeId
AND AC.archChunkId <= SV.lastSiloChunkId AND (SV.flags & (1 | 2)) <> 0
	DELETE	#tempJobChunk
	FROM	#tempJobChunk T, (SELECT DISTINCT jobId, afCommCellId FROM #tempJobChunk WHERE isSiloed = 0) B
	WHERE	T.jobId = B.jobId AND T.afCommCellId = B.afCommCellId
	UPDATE	#tempJobList
SET		jobCopyAttributes = (A.jobCopyAttributes | 16)
	FROM	#tempJobData A, (SELECT DISTINCT jobId, afCommCellId FROM #tempJobChunk WHERE isSiloed = 1) B
	WHERE	A.jobId = B.jobId AND A.commCellId = B.afCommCellId
	DROP TABLE #tempJobChunk
END
INSERT	INTO #jobCRC
SELECT	T.jobId, T.commCellId, MIN(AC.flags & 16),
(MAX(AC.flags & 1048576) | MAX(LEN(hwEncKey)))
FROM	#tempJobAFList T, archChunkMapping ACM WITH (READUNCOMMITTED), archChunk AC WITH (READUNCOMMITTED)
WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = @i_copyId
	AND AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
GROUP BY T.jobId, T.commCellId
UPDATE	#tempJobList
SET		jobCopyAttributes = (A.jobCopyAttributes | 4)
FROM	#tempJobList A, #jobCRC B
WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId AND B.minCRC <> 0
UPDATE	#tempJobList
SET		jobCopyAttributes = (A.jobCopyAttributes | 8)
FROM	#tempJobList A, #jobCRC B
WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId AND B.maxHwEnc <> 0
DROP TABLE #jobCRC
DROP TABLE #tempJobAFList
DROP TABLE #tempJobCopyAttr
SELECT	J.commcellId, J.jobId, J.status, J.disabled, J.toBeCopied,
		(case when B.uncompBytes > 0 then B.uncompBytes else B.totalBackupSize end), B.totalBackupSize, J.sizeOnMedia,
		B.servStart, B.servEnd, B.opType, B.ER_BkpLevel, B.ER_SendCount, B.archGrpID, CAST(B.archGrpName AS NVARCHAR(255)), CAST(B.ER_DBName AS NVARCHAR(255)),
		CAST(B.ER_Destination AS NVARCHAR(255)), CAST(B.ER_MediasUsed AS NVARCHAR(255)), B.initFrom, B.username,
		J.jobCopyAttributes, J.archCheckEndTime, J.archCheckStatus, J.extRetentionFlags,
		(case	when @l_BasicRetentionDays < 0 OR J.ExtRetentionDays < 0 then -1
				when J.ExtRetentionDays > @l_BasicRetentionDays then J.ExtRetentionDays
				else @l_BasicRetentionDays end) AS retentionDays,
		J.manualRetentionEndTime, J.copiedTime, J.agedTime, J.errorCode, J.jobDisplayFlags
FROM	JMAdminJobStatsTable B WITH (READUNCOMMITTED), #tempJobList J
WHERE	B.jobId = J.jobId AND B.commcellId = J.commcellId
	AND (@timeRangeBegin <= 0 OR B.servStart >= @timeRangeBegin)
	AND (@timeRangeEnd <= 0 OR B.servStart < @timeRangeEnd)
UNION
SELECT	J.commcellId, J.jobId, J.status, J.disabled, J.toBeCopied,
  	    (case when B.totalUncompBytes > 0 then B.totalUncompBytes else B.totalBackupSize end),
        B.totalBackupSize, J.sizeOnMedia,
        CAST(B.servStartDate AS int), CAST(B.servEndDate AS int),
        CAST(B.opType AS int), CAST(B.bkpLevel AS int), 0, @spId, @o_storagePolicy,
        CAST('' AS NVARCHAR(255)),CAST('' AS NVARCHAR(255)), CAST('' AS NVARCHAR(255)),
        B.initFrom, CAST(B.username AS NVARCHAR(255)),
		J.jobCopyAttributes, J.archCheckEndTime, J.archCheckStatus, J.extRetentionFlags,
		(case	when @l_BasicRetentionDays < 0 OR J.ExtRetentionDays < 0 then -1
            when J.ExtRetentionDays > @l_BasicRetentionDays then J.ExtRetentionDays
    	        else @l_BasicRetentionDays end) AS retentionDays,
	   J.manualRetentionEndTime, J.copiedTime, J.agedTime, J.errorCode,
	   J.jobDisplayFlags
	   FROM  JMBkpStats B WITH (READUNCOMMITTED) INNER JOIN  #tempJobList J ON B.jobId = J.jobId AND B.commcellId = J.commcellId
	   WHERE	(@timeRangeBegin <= 0 OR B.servStartDate >= @timeRangeBegin)
	        AND (@timeRangeEnd <= 0 OR B.servStartDate < @timeRangeEnd)
ORDER BY J.commcellId, J.jobId DESC
DROP TABLE #tempJobList
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archViewDRJobsByCopy')
	delete from GxQscripts where name = 'archViewDRJobsByCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewDRJobsByCopy')
	delete from GXDBVersions where aliasname = 'archViewDRJobsByCopy'
GO

insert into GXDBVersions values(2, 'archViewDRJobsByCopy',  'v1.20.46.3.36.1', 'archViewDRJobsByCopy', 'v1.20.46.3.36.1')
GO

