

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archViewCloudSnaps.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archViewCloudSnaps.sp,v $ $Id: archViewCloudSnaps.sp,v 1.1.2.11 2020/03/11 01:04:07 pnara Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archViewCloudSnaps')
BEGIN
	print '>>> Drop Stored Procedure: archViewCloudSnaps <<<'
	drop procedure archViewCloudSnaps
END
IF EXISTS (select * from GxQscripts where name='archViewCloudSnaps')
	delete from GxQscripts where name = 'archViewCloudSnaps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewCloudSnaps')
	delete from GXDBVersions where aliasname = 'archViewCloudSnaps'
GO
print '... Creating Procedure: archViewCloudSnaps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archViewCloudSnaps
  @i_instanceId integer,
  @i_appId integer = 0,
  @i_copyPrecedence integer = 0,
  @i_includeAgedData integer = 0,
  @i_startTime integer = 0,
  @i_endTime integer = 0,
  @i_regionId integer = 0,
  @i_dbName nvarchar(1024) = '',
  @i_regionCode nvarchar(1024) = ''
AS
  DECLARE @o_snapShotName nvarchar(2048)
  DECLARE @o_dbName nvarchar(1024)
  DECLARE @o_regionName nvarchar(1024)
  DECLARE @o_createTime integer
  DECLARE @o_status integer
  DECLARE @o_archFileId integer
  DECLARE @o_commCellId integer
  DECLARE @o_copyId integer
  DECLARE @o_dbType nvarchar(2048)
  DECLARE @o_rdsAttributes XML
  DECLARE @o_regionCode nvarchar(1024)
  DECLARE @o_regionId integer
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- get a list of archFiles for given instance/subclient
IF OBJECT_ID('tempdb..#tblAF') IS NOT NULL DROP TABLE #tblAF
CREATE TABLE #tblAF (archFileId int, commCellId int, jobId int, appId int, name nvarchar(2048), cTime int, archGroupId int, primary key (archFileId, commCellId))
INSERT 	INTO #tblAF
SELECT	AF.id, AF.commCellId, AF.jobId, AF.appId, AF.name, AF.cTime, AF.archGroupId
FROM	archFile AF
		INNER JOIN App_Application SC ON AF.appId = SC.id
WHERE	SC.instance = @i_instanceId AND (@i_appId = 0 OR SC.id = @i_appId) AND AF.isValid = 1
-- get only snaps in given region
IF (@i_regionId = 0) AND (@i_regionCode <> '')
BEGIN
SET @i_regionId = (SELECT ISNULL(Id, 0) FROM App_CloudVendorRegion WHERE RegionCode = @i_regionCode)
END
IF @i_regionId > 0 AND EXISTS(SELECT 1 FROM App_CloudVendorRegion WHERE Id = @i_regionId)
BEGIN
	DELETE 	AF
	FROM	#tblAF AF LEFT OUTER JOIN ArchFileCopyRegion AFR
			ON AF.archFileId = AFR.archFileId AND AF.commCellId = AFR.commCellId AND AFR.RegionId = @i_regionId
	WHERE	AFR.archFileId IS NULL
END
-- get only snaps for given DB
IF LEN(@i_dbName) > 0
BEGIN
	DELETE	AF
	FROM	#tblAF AF
			INNER JOIN ArchFileCopyRegion AFR ON AF.archFileId = AFR.archFileId AND AF.commCellId = AFR.commCellId
			LEFT OUTER JOIN App_RDSSubclientContentMap SCM ON AFR.DBContentId = SCM.id AND SCM.DBName = @i_dbName
	WHERE	SCM.id IS NULL
END
-- get a list of archFiles in copies
IF OBJECT_ID('tempdb..#tblAFC') IS NOT NULL DROP TABLE #tblAFC
CREATE TABLE #tblAFC (archFileId int, commCellId int, archCopyId int, primary key (archFileId, commCellId, archCopyId))
IF (@i_copyPrecedence = -2)
BEGIN
	-- from all copies
	INSERT	INTO #tblAFC
	SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId
	FROM	#tblAF AF, archFileCopy AFC
	WHERE	AFC.archFileId = AF.archFileId AND AFC.commCellId = AF.commCellId
			AND AFC.isValid = 1 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
			AND (@i_regionId = 0 OR EXISTS(SELECT 1 FROM ArchFileCopyRegion AFR WHERE AFC.archFileId = AFR.ArchFileId AND AFC.commCellId = AFR.CommCellId AND AFC.archCopyId = AFR.ArchCopyId AND AFR.RegionId = @i_regionId))
END
ELSE
IF (@i_copyPrecedence = -1)
BEGIN
	-- from the primary copy
	INSERT	INTO #tblAFC
	SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId
	FROM	#tblAF AF, archFileCopy AFC, archGroup AG, archGroupCopy AGC
	WHERE	AFC.archFileId = AF.archFileId AND AFC.commCellId = AF.commCellId
			AND AG.id = AF.archGroupId AND AFC.archCopyId = AGC.id
			AND ((AGC.isSnapCopy = 1 AND AGC.id = AG.defaultSnapCopy) OR (AGC.isSnapCopy = 0 AND AGC.id = AG.defaultCopy))
			AND AFC.isValid = 1 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
			AND (@i_regionId = 0 OR EXISTS(SELECT 1 FROM ArchFileCopyRegion AFR WHERE AFC.archFileId = AFR.ArchFileId AND AFC.commCellId = AFR.CommCellId AND AFC.archCopyId = AFR.ArchCopyId AND AFR.RegionId = @i_regionId))
END
ELSE
IF(@i_copyPrecedence > 0)
BEGIN
	-- from a given copy precedence
	INSERT	INTO #tblAFC
	SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId
	FROM	#tblAF AF, archFileCopy AFC, archGroupCopy AGC
	WHERE	AFC.archFileId = AF.archFileId AND AFC.commCellId = AF.commCellId
			AND AFC.archCopyId = AGC.id AND AGC.copy = @i_copyPrecedence
			AND AFC.isValid = 1 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
			AND (@i_regionId = 0 OR EXISTS(SELECT 1 FROM ArchFileCopyRegion AFR WHERE AFC.archFileId = AFR.ArchFileId AND AFC.commCellId = AFR.CommCellId AND AFC.archCopyId = AFR.ArchCopyId AND AFR.RegionId = @i_regionId))
END
ELSE
IF(@i_copyPrecedence = 0)
BEGIN
	-- from the copy which has the given job and has the lowest precedence
	WITH AFCopy AS
	(
		SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId, ROW_NUMBER() OVER (PARTITION BY AFC.archFileId, AFC.commCellId ORDER BY AGC.copy ASC) AS RowNum
		FROM	#tblAF AF, archFileCopy AFC, archGroupCopy AGC
		WHERE	AFC.archFileId = AF.archFileId AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = AGC.id
				AND AFC.isValid = 1 AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
				AND (@i_regionId = 0 OR EXISTS(SELECT 1 FROM ArchFileCopyRegion AFR WHERE AFC.archFileId = AFR.ArchFileId AND AFC.commCellId = AFR.CommCellId AND AFC.archCopyId = AFR.ArchCopyId AND AFR.RegionId = @i_regionId))
	)
	INSERT INTO #tblAFC
	SELECT 	archFileId, commCellId, archCopyId
	FROM	AFCopy
	WHERE	RowNum = 1
END
-- remove archFiles which doesn't exists in given copy precedence.
DELETE 	AF
FROM	#tblAF AF
		LEFT OUTER JOIN #tblAFC AFC ON AF.archFileId = AFC.archFileId AND AF.commCellId = AFC.commCellId
WHERE 	AFC.archFileId IS NULL
IF @i_startTime = 0 AND @i_endTime = 0
BEGIN
	-- get only latest job
	DELETE 	AF
	FROM	#tblAF AF LEFT OUTER JOIN
			(
				SELECT 	A.archFileId, A.commCellId,
						ROW_NUMBER() OVER (PARTITION BY APP.instance, SCM.DBName, AFR.RegionId, CASE WHEN AFR.DBContentId IS NULL THEN A.appId ELSE 0 END
											ORDER BY A.cTime DESC) AS RowNum
				FROM 	#tblAF A
						INNER JOIN App_Application APP ON A.appId = APP.id
						LEFT OUTER JOIN ArchFileCopyRegion AFR ON A.archFileId = AFR.archFileId AND A.commCellId = AFR.commCellId
						LEFT OUTER JOIN App_RDSSubclientContentMap SCM ON AFR.DBContentId = SCM.id
			) AS LatestJob ON AF.archFileId = LatestJob.archFileId AND AF.commCellId = LatestJob.commCellId AND LatestJob.RowNum = 1
	WHERE	LatestJob.archFileId IS NULL
END
ELSE
BEGIN
	-- get only snaps in given time range
	IF @i_startTime > 0
	BEGIN
		DELETE 	AF
		FROM	#tblAF AF, JMBkpStats J
		WHERE	AF.jobId = J.jobId AND AF.commCellId = J.commCellId
				AND J.servStartDate < @i_startTime
	END
	IF @i_endTime > 0
	BEGIN
		DELETE 	AF
		FROM	#tblAF AF, JMBkpStats J
		WHERE	AF.jobId = J.jobId AND AF.commCellId = J.commCellId
				AND J.servEndDate > @i_endTime
	END
END
SELECT  AF.name SnapShotName, ISNULL(SCM.dbName, '') DBName, ISNULL(R.RegionName, '') RegionName, AF.cTime createTime, 0 Status, AF.archFileId, AF.commCellId, AFC.archCopyId, ISNULL(SCM.dbType,'') dbType, CAST((CASE WHEN ISNULL(SCM.rsdAttributes, '') = '' THEN '<App_RDSAttributes />' ELSE SCM.rsdAttributes END) AS XML) RDSAttributes,
		R.RegionCode RegionCode, R.Id RegionId
FROM	#tblAF AF
		INNER JOIN #tblAFC AFC ON AF.archFileId = AFC.archFileId AND AF.commCellId = AFC.commCellId
		LEFT OUTER JOIN ArchFileCopyRegion AFR ON AFC.archFileId = AFR.archFileId AND AFC.commCellId = AFR.commCellId AND AFC.archCopyId = AFR.archCopyId
		LEFT OUTER JOIN App_RDSSubclientContentMap SCM ON AFR.DBContentId = SCM.id
		LEFT OUTER JOIN App_CloudVendorRegion R ON AFR.RegionId = R.id
GO

IF EXISTS (select * from GxQscripts where name = 'archViewCloudSnaps')
	delete from GxQscripts where name = 'archViewCloudSnaps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewCloudSnaps')
	delete from GXDBVersions where aliasname = 'archViewCloudSnaps'
GO

insert into GXDBVersions values(2, 'archViewCloudSnaps',  '00010001000200110000', 'archViewCloudSnaps', '00010001000200110000')
GO

