

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archViewCloudSnapRegions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archViewCloudSnapRegions')
BEGIN
	print '>>> Drop Stored Procedure: archViewCloudSnapRegions <<<'
	drop procedure archViewCloudSnapRegions
END
IF EXISTS (select * from GxQscripts where name='archViewCloudSnapRegions')
	delete from GxQscripts where name = 'archViewCloudSnapRegions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewCloudSnapRegions')
	delete from GXDBVersions where aliasname = 'archViewCloudSnapRegions'
GO
print '... Creating Procedure: archViewCloudSnapRegions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archViewCloudSnapRegions
  @i_xml XML
AS
  DECLARE @o_xml XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @i_copyPrecedence integer
	DECLARE @i_instanceId integer
	DECLARE @i_subClientId integer
	DECLARE @i_includeAgedData integer
	DECLARE @i_startTime integer
	DECLARE @i_endTime integer
	DECLARE @i_clientId integer
	SELECT  @i_copyPrecedence = ISNULL(col.value('@copyPresedence', 'integer'), 0),
			@i_includeAgedData = ISNULL(col.value('@includeAgedData', 'integer'), 0),
			@i_startTime = 	ISNULL(col.value('@startTime', 'integer'), 0),
			@i_endTime = ISNULL(col.value('@endTime', 'integer'), 0),
			@i_subClientId = ISNULL(col.value('entity[1]/@subclientId', 'integer'), 0),
			@i_instanceId = ISNULL(col.value('entity[1]/@instanceId', 'integer'), 0),
			@i_clientId = ISNULL(col.value('entity[1]/@clientId', 'integer'), 0)
	FROM @i_xml.nodes('/App_ArchViewCloudSnapRegionsReq') node(col)
	DECLARE	@return_value int
	IF OBJECT_ID('tempdb..#tblAF1') IS NOT NULL DROP TABLE #tblAF1
	CREATE TABLE #tblAF1 (SnapShotName nvarchar(2048), DBName nvarchar(2048), RegionName nvarchar(2048), createTime int, Status int, archFileId int, commCellId int, archCopyId int, dbType nvarchar(2048), RDSAttributes XML, RegionCode nvarchar(2048), RegionId int, primary key (archFileId, commCellId, RegionId))
	INSERT        INTO #tblAF1
	EXEC	@return_value = [dbo].[archViewCloudSnaps] @i_instanceId, @i_subClientId, @i_copyPrecedence, @i_includeAgedData, @i_startTime, @i_endTime
	DELETE FROM #tblAF1 where RegionName = ''
	SET @o_xml = (SELECT  DISTINCT ISNULL(RegionName, '') regionName, RegionCode regionCode, RegionId regionId
	FROM #tblAF1
	FOR XML RAW ('regionList'), ROOT ('App_ArchViewCloudSnapRegionsResp') )
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @o_xml = (SELECT @@ERROR AS '@errorCode', 'Failed to get backup regions.' AS '@errorMessage'
			FOR XML PATH ('response'), root(N'App_ArchViewCloudSnapRegionsResp'))
END CATCH
IF @o_xml IS NULL
	SET @o_xml = '<App_ArchViewCloudSnapRegionsResp/>'
IF OBJECT_ID('tempdb..#tblAF1') IS NOT NULL
    DROP TABLE #tblAF1
IF OBJECT_ID('tempdb..#tblAFC1') IS NOT NULL
	DROP TABLE #tblAFC1
SELECT @o_xml AS o_xml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archViewCloudSnapRegions')
	delete from GxQscripts where name = 'archViewCloudSnapRegions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archViewCloudSnapRegions')
	delete from GXDBVersions where aliasname = 'archViewCloudSnapRegions'
GO

insert into GXDBVersions values(2, 'archViewCloudSnapRegions',  '00000000000000000000', 'archViewCloudSnapRegions', '00000000000000000000')
GO

