

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archUpdateTotalBkpSizeForAuxCopy.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  archUpdateTotalBkpSizeForAuxCopy()
--  |				 Description:  Set the source MAs used for the Dash job as job option.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archUpdateTotalBkpSizeForAuxCopy.sp,v $ $Id: archUpdateTotalBkpSizeForAuxCopy.sp,v 1.3.2.2 2018/03/27 08:43:02 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archUpdateTotalBkpSizeForAuxCopy <<<'

IF EXISTS (select * from sysobjects where name='archUpdateTotalBkpSizeForAuxCopy')
	drop procedure archUpdateTotalBkpSizeForAuxCopy
IF EXISTS (select * from GxQscripts where name='archUpdateTotalBkpSizeForAuxCopy')
	delete from GxQscripts where name = 'archUpdateTotalBkpSizeForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUpdateTotalBkpSizeForAuxCopy')
	delete from GXDBVersions where aliasname = 'archUpdateTotalBkpSizeForAuxCopy'
GO
print '... Creating Procedure: archUpdateTotalBkpSizeForAuxCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archUpdateTotalBkpSizeForAuxCopy
  @i_jobId integer,
  @i_commcellId integer
AS
  DECLARE @errorCode integer;
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
SET @errorCode = 0
		UPDATE JMAdminJobStatsTable
		SET totalBackupSize = ISNULL((
			SELECT  SUM(ACM.dedupedSize)
			FROM	(SELECT DISTINCT JDS.JobID, JDS.CommCellId, JDS.archGrpCopyId
					FROM   JMJobDataStats JDS WITH (NOLOCK)
					WHERE  JDS.auxCopyJobId = @i_jobId ) T,
					archChunkMapping ACM WITH (NOLOCK), archChunk AC WITH (NOLOCK)
			WHERE	T.jobId = ACM.jobId
					AND T.commCellId = ACM.commCellId
					AND T.archGrpCopyID = ACM.archCopyId
					AND ACM.archChunkId = AC.id
					AND ACM.chunkCommCellId = AC.commCellId
					AND AC.createTime BETWEEN JMAdminJobStatsTable.servStart AND JMAdminJobStatsTable.servEnd), 0)
	    WHERE jobId = @i_jobId AND commCellId = @i_commcellId
COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
	ROLLBACK TRANSACTION
END CATCH;
	SELECT  @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'archUpdateTotalBkpSizeForAuxCopy')
	delete from GxQscripts where name = 'archUpdateTotalBkpSizeForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUpdateTotalBkpSizeForAuxCopy')
	delete from GXDBVersions where aliasname = 'archUpdateTotalBkpSizeForAuxCopy'
GO

insert into GXDBVersions values(2, 'archUpdateTotalBkpSizeForAuxCopy',  '00010003000200020000', 'archUpdateTotalBkpSizeForAuxCopy', '00010003000200020000')
GO

