

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archUpdateStoreLimitFlagOnStoragePolicy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archUpdateStoreLimitFlagOnStoragePolicy.sp,v $ $Id: archUpdateStoreLimitFlagOnStoragePolicy.sp,v 1.17.48.7 2020/11/06 16:44:41 abilbrey Exp $";
--  +========================================================================+
--  | Stored Proc:  archUpdateStoreLimitFlagOnStoragePolicy()
--  |
--  | Description:  Select the AppId to be pruned in the ArchAppCopyToBeAged
--	| table based on the selected Library Id/CopyId/ClientId.
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archUpdateStoreLimitFlagOnStoragePolicy')
BEGIN
	print '>>> Drop Stored Procedure: archUpdateStoreLimitFlagOnStoragePolicy <<<'
	drop procedure archUpdateStoreLimitFlagOnStoragePolicy
END
IF EXISTS (select * from GxQscripts where name='archUpdateStoreLimitFlagOnStoragePolicy')
	delete from GxQscripts where name = 'archUpdateStoreLimitFlagOnStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUpdateStoreLimitFlagOnStoragePolicy')
	delete from GXDBVersions where aliasname = 'archUpdateStoreLimitFlagOnStoragePolicy'
GO
print '... Creating Procedure: archUpdateStoreLimitFlagOnStoragePolicy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archUpdateStoreLimitFlagOnStoragePolicy
AS
  DECLARE @o_retVal INTEGER = 0
  DECLARE @o_copyId integer;
  DECLARE @o_SIDBStoreId integer;
  DECLARE @o_SIDBStoreName NVARCHAR(256);
  DECLARE @o_newSIDBStoreId integer;
  DECLARE @o_newSIDBStoreName NVARCHAR(256);
  DECLARE @o_fullReason tinyint;
  DECLARE @o_createdNewDDB tinyint;
SET NOCOUNT ON
	-- Update avgQITime with median for previous day
	EXEC archSetMedianAvgQITime
	IF EXISTS(SELECT 1 FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_ENABLE_INFINI_STORE' AND value = 1)
	BEGIN
		EXEC archCreateNewDDBsOnFull
		RETURN
	END
	DECLARE @archGroupV 		TABLE(archGroupId  int, archGroupCopyId int, SIDBStoreId int, PrimaryEntriesInMil bigint, AvgQITime bigint, archGroupFlags int, origFlags int, isDefault int)
	DECLARE @SubStoresAvgQITime TABLE(SIDBStoreId int, SubStoreId int, ModifiedTime int, AvgQITime bigint, RowNumber int)
DECLARE @thresholdDaysToConsider int = 14; -- Default MMCONFIG_STORE_AVG_QI_TIME_LIMIT_DAYS_TO_CONSIDER_DEFAULT
DECLARE	@primaryEntriesLimitForSubClient int = 400
DECLARE	@avgQITimeLimit int = 2000
	DECLARE	@storeLimitPercent int = 60 -- Default MMCONFIG_STORE_LIMIT_PERC_DEFAULT
SELECT	TOP 1 @primaryEntriesLimitForSubClient = ISNULL(value, 400)
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_SMALL_DDB_LIMIT_FOR_SUBCLIENT_ASSOCIATION_MIL'
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
SELECT	TOP 1 @avgQITimeLimit = ISNULL(value, 2000)
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_MAX_AVGQITIME_FOR_SIDB'
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
SELECT	TOP 1 @storeLimitPercent = ISNULL(value, 80)
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_STORE_LIMIT_PERC'
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
SELECT	TOP 1 @thresholdDaysToConsider = ISNULL(value, 14)
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_STORE_AVG_QI_TIME_LIMIT_DAYS_TO_CONSIDER'
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	INSERT INTO @archGroupV
	SELECT	AG.id, AGC.id, AGC.SIDBStoreId, 0, dbo.GetCurrentAvgQITimeMedian(AGC.SIDBStoreId, 0 /*SubStoreId*/, ST.CommCellId, @thresholdDaysToConsider),
AG.flags & 65536, AG.flags & 65536,
			CASE WHEN AG.defaultCopy = AGC.id THEN 1 ELSE 0 END
	FROM	archGroup AG with (readuncommitted),
			archGroupCopy AGC with (readuncommitted),
			IdxSIDBStore ST with (readuncommitted)
	WHERE	AG.id = AGC.archGroupId
	AND 	AGC.SIDBStoreId = ST.SIDBStoreId
	AND		AGC.SIDBStoreId > 0
	AND		ST.Version >= 3   --Consider only v10+ stores
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	UPDATE	@archGroupV
	SET		PrimaryEntriesInMil =
			(SELECT ISNULL(MIN(T.PrimaryEntries)/(1000000), 0)
			 FROM
				(SELECT SubStoreId, MAX(ModifiedTime) AS ModifiedTime
				 FROM IdxSIDBUsageHistory WHERE tmp.SIDBStoreId = SIDBStoreId
				 Group BY SubStoreId) Usage,
				IdxSIDBUsageHistory T
			WHERE T.SubStoreId = Usage.SubStoreID
			AND T.ModifiedTime = Usage.ModifiedTime
			AND T.SIDBStoreId = tmp.SIDBStoreId
			)
	FROM	@archGroupV tmp
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	UPDATE 	AGV
	SET		archGroupFlags = (CASE WHEN (AvgQITime < ((@avgQITimeLimit * @storeLimitPercent)/100 ))
										OR (PrimaryEntriesInMil < @primaryEntriesLimitForSubClient)
										OR ISNULL(AG.SubclientExtensionTimeStamp, 0) >= dbo.getUnixTime(GETUTCDATE())
								THEN 0
ELSE 65536 END)
	FROM @archGroupV AGV
	JOIN archGroup AG WITH(READUNCOMMITTED)
		ON AG.id = AGV.archGroupId
	WHERE AGV.isDefault = 1
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	UPDATE	AG
SET		AG.flags = (AG.flags & ~65536)
	FROM	archGroup AG
		LEFT OUTER JOIN (select ArchGroupId, archGroupFlags from @archGroupV where isDefault = 1) A ON AG.id = A.archGroupId
	WHERE A.archGroupId IS NULL
AND AG.flags & 65536 > 0
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	DELETE	@archGroupV
	WHERE	archGroupFlags = origFlags
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	UPDATE	AG
	SET		AG.flags = (CASE WHEN A.archGroupFlags > 0
THEN AG.flags | 65536
ELSE AG.flags & ~65536 END)
	FROM	archGroup AG, (select ArchGroupId, archGroupFlags from @archGroupV where isDefault = 1) A
	WHERE	AG.id = A.archGroupId
AND		(AG.flags & 65536) <> A.archGroupFlags
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
	UPDATE	AGC
SET		AGC.extendedFlags = AGC.extendedFlags & ~128
	FROM	archGroupCopy AGC
WHERE	AGC.extendedFlags & 128 = 128
	SELECT	@o_retVal = @@ERROR
	IF (@o_retVal != 0) GOTO CX_ERROR_EXIT
CX_EXIT:
CX_ERROR_EXIT:
	SELECT   @o_retVal, 0, 0, '', 0, '', 0, 0
-- END of stored procedure
GO

IF EXISTS (select * from GxQscripts where name = 'archUpdateStoreLimitFlagOnStoragePolicy')
	delete from GxQscripts where name = 'archUpdateStoreLimitFlagOnStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUpdateStoreLimitFlagOnStoragePolicy')
	delete from GXDBVersions where aliasname = 'archUpdateStoreLimitFlagOnStoragePolicy'
GO

insert into GXDBVersions values(2, 'archUpdateStoreLimitFlagOnStoragePolicy',  '00010017004800070000', 'archUpdateStoreLimitFlagOnStoragePolicy', '00010017004800070000')
GO

