

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archUpdateStoragePoolClientGroupAssociation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archUpdateStoragePoolClientGroupAssociation.sp,v $ $Id: archUpdateStoragePoolClientGroupAssociation.sp,v 1.1.2.3 2018/03/22 01:08:04 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archUpdateStoragePoolClientGroupAssociation <<<'

IF EXISTS (select * from sysobjects where name='archUpdateStoragePoolClientGroupAssociation')
	drop procedure archUpdateStoragePoolClientGroupAssociation
IF EXISTS (select * from GxQscripts where name='archUpdateStoragePoolClientGroupAssociation')
	delete from GxQscripts where name = 'archUpdateStoragePoolClientGroupAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUpdateStoragePoolClientGroupAssociation')
	delete from GXDBVersions where aliasname = 'archUpdateStoragePoolClientGroupAssociation'
GO
print '... Creating Procedure: archUpdateStoragePoolClientGroupAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archUpdateStoragePoolClientGroupAssociation
  @i_StoragePoolId integer,
  @i_UpdateStoragePoolClientGroupAssociationReqXML XML
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_ClientGroupId integer
  DECLARE @o_ClientGroupName nvarchar(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @clientGroupAdded TABLE (cgId INT, cgName nvarchar(1024))
DECLARE @clientGroupRemoved TABLE (cgId INT)
INSERT INTO @clientGroupRemoved
SELECT clientGroupId
FROM MMStoragePoolClientGroupAssociation WHERE storagePoolId = @i_StoragePoolId
EXCEPT
SELECT col.value('@clientGroupId[1]', 'INT')
FROM @i_UpdateStoragePoolClientGroupAssociationReqXML.nodes('/App_UpdateStoragePoolClientGroupAssociationReq/selectedClientGroups') paramXML(col)
INSERT INTO @clientGroupAdded
SELECT col.value('@clientGroupId[1]', 'INT'), col.value('@clientGroupName[1]', 'nvarchar(1024)')
FROM @i_UpdateStoragePoolClientGroupAssociationReqXML.nodes('/App_UpdateStoragePoolClientGroupAssociationReq/selectedClientGroups') paramXML(col)
EXCEPT
SELECT CG.id, CG.name
FROM APP_ClientGroup CG JOIN MMStoragePoolClientGroupAssociation SPCGA ON SPCGA.clientGroupId = CG.id
WHERE storagePoolId = @i_StoragePoolId
--Remove the ClientGroups which are no longer associated
DELETE SPCG
FROM MMStoragePoolClientGroupAssociation SPCG JOIN @clientGroupRemoved tmp ON SPCG.clientGroupId = tmp.cgId
WHERE SPCG.storagePoolId = @i_StoragePoolId
--Return the client group which are newly associated
--Note the new client groups are not added here. They get added in a separate API.
--Because adding a clientgroup is adding all the clients in the group in the storagepool.
SELECT cgId, cgName FROM @clientGroupAdded
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archUpdateStoragePoolClientGroupAssociation')
	delete from GxQscripts where name = 'archUpdateStoragePoolClientGroupAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUpdateStoragePoolClientGroupAssociation')
	delete from GXDBVersions where aliasname = 'archUpdateStoragePoolClientGroupAssociation'
GO

insert into GXDBVersions values(2, 'archUpdateStoragePoolClientGroupAssociation',  '00010001000200030000', 'archUpdateStoragePoolClientGroupAssociation', '00010001000200030000')
GO

