

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archUpdateSecondaryContentIndexing.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2014  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archUpdateSecondaryContentIndexing.sp,v $ $Id: archUpdateSecondaryContentIndexing.sp,v 1.2.54.1 2018/03/20 20:02:04 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archUpdateSecondaryContentIndexing <<<'

IF EXISTS (select * from sysobjects where name='archUpdateSecondaryContentIndexing')
	drop procedure archUpdateSecondaryContentIndexing
IF EXISTS (select * from GxQscripts where name='archUpdateSecondaryContentIndexing')
	delete from GxQscripts where name = 'archUpdateSecondaryContentIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUpdateSecondaryContentIndexing')
	delete from GXDBVersions where aliasname = 'archUpdateSecondaryContentIndexing'
GO
print '... Creating Procedure: archUpdateSecondaryContentIndexing'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archUpdateSecondaryContentIndexing
  @i_cloudId int,
  @i_updateXml varchar(max)
AS
  DECLARE @o_retcode integer
SET NOCOUNT ON
--
declare @error int = 0
declare @idoc int = 0
--
exec sp_xml_preparedocument @idoc output, @i_updateXml
set @error = @@error
if @error <> 0 goto finish;
--
declare @temp table
(
	afid 			int,
	commcellId 		int,
	physicalOffset	bigint,
	successcount 	int,
	failedcount 	int,
	bytesprocessed	int,
	flags			int,
	reserved		int
);
--
insert into @temp (afid, commcellid, physicalOffset, successcount, failedcount, bytesprocessed, flags, reserved)
select
	id, ccid, offset, success, failed, bytes, flags, reserved
from
	openxml(@idoc, '/root/af', 1)
with
	(id int, ccid int, offset bigint, success int, failed int, bytes bigint, flags int, reserved int)
--
--
begin transaction
--
update archFile set flags = t.flags, cloudId = @i_cloudId, contentIndexTime = dbo.GetUnixTime(GetDate()) from archFile a
inner join @temp t on a.id = t.afid and a.commCellId = t.commcellId
where a.fileType = 1
--
set @error = @@ERROR; if (@error <> 0) goto Finish
--
delete archContentIndexingSecondary from archContentIndexingSecondary s
inner join @temp t on s.CommCellId = t.commCellId and t.afid = s.archFileId
--
set @error = @@ERROR; if (@error <> 0) goto Finish
--
Finish:
	if @idoc <> 0 exec sp_xml_removedocument @idoc
	--
	if @@TRANCOUNT > 0
	begin
		if @error = 0 commit transaction else rollback transaction
	end
	--
	SET NOCOUNT OFF
	--
	select @error
	--
GO

IF EXISTS (select * from GxQscripts where name = 'archUpdateSecondaryContentIndexing')
	delete from GxQscripts where name = 'archUpdateSecondaryContentIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUpdateSecondaryContentIndexing')
	delete from GXDBVersions where aliasname = 'archUpdateSecondaryContentIndexing'
GO

insert into GXDBVersions values(2, 'archUpdateSecondaryContentIndexing',  '00010002005400010000', 'archUpdateSecondaryContentIndexing', '00010002005400010000')
GO

