

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archUpdateGlobalDependentEncryption.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2014  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archUpdateGlobalDependentEncryption.sp,v $ $Id: archUpdateGlobalDependentEncryption.sp,v 1.1.2.5 2018/03/27 08:57:49 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archUpdateGlobalDependentEncryption <<<'

IF EXISTS (select * from sysobjects where name='archUpdateGlobalDependentEncryption')
	drop procedure archUpdateGlobalDependentEncryption
IF EXISTS (select * from GxQscripts where name='archUpdateGlobalDependentEncryption')
	delete from GxQscripts where name = 'archUpdateGlobalDependentEncryption'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUpdateGlobalDependentEncryption')
	delete from GXDBVersions where aliasname = 'archUpdateGlobalDependentEncryption'
GO
print '... Creating Procedure: archUpdateGlobalDependentEncryption'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archUpdateGlobalDependentEncryption
  @i_copyId int,
  @i_globalHostSPId int
AS
  DECLARE @o_retcode integer
SET NOCOUNT ON
--
declare @error int = 0
declare @reencBit int = 8388608 /*CVA_AUXCOPY_REENCRYPT_DATA_FLAG*/
declare @encMask int = 1048576 | 8388608 | 2097152 | 4194304
declare @passThruBit int = 1048576 /*CVA_AUXCOPY_PASSTHRU_ENCRYPT*/
declare @netOnlyEncBit int = 4194304 /*CVA_AUXCOPY_NETWORK_ONLY_ENCRYPT*/
declare @storeOnMediaBit int = 131072 /*CVA_STORE_KEY_ON_MEDIA*/
DECLARE @l_DepFlags INT = 0
DECLARE @l_DepExFlags INT = 0
DECLARE	@l_DepEncType INT = 0
DECLARE @l_DepEncKeyLen INT = 0
DECLARE @l_DepIsPrimary BIT = 0
DECLARE @l_GlobalFlags INT = 0
DECLARE @l_GlobalExFlags INT = 0
DECLARE	@l_GlobalEncType INT = 0
DECLARE @l_GlobalEncKeyLen INT = 0
SELECT 	@l_DepExFlags = Dep.extendedFlags, @l_DepIsPrimary = (case when Dep.id = DepAG.defaultCopy then 1 else 0 end)
FROM	ArchGroupCopy Dep WITH(READUNCOMMITTED), ArchGroup DepAG WITH(READUNCOMMITTED)
WHERE	Dep.id = @i_copyId AND Dep.archGroupId = DepAG.id
--Don't use global policy encryption settings if override is set
IF (@l_DepExFlags & 65536) = 0
BEGIN
	--Get global policy encryption settings
	SELECT 	@l_GlobalFlags = Gbl.flags, @l_GlobalExFlags = Gbl.extendedFlags, @l_GlobalEncType = encType, @l_GlobalEncKeyLen = encKeyLen
	FROM	ArchGroupCopy Gbl WITH(READUNCOMMITTED), ArchGroup GblAG WITH(READUNCOMMITTED)
	WHERE	GblAG.id = @i_globalHostSPId AND GblAG.defaultCopy = Gbl.id
	IF @l_DepIsPrimary = 1
	BEGIN
		--Primary copy - set re-encrypt when encrypt on primary is selected else set passthrough
SET @l_DepFlags = (case when (@l_GlobalExFlags & 262144 /*CVA_ENCRYPT_ON_DEPENDENT_PRIMARY*/) > 0
								then @reencBit
								else @passThruBit end)
	END
	ELSE
	BEGIN
		--Secondary copy - Enc flags on global policy are for secondary copy only
		SET @l_DepFlags = (@l_GlobalFlags & @encMask)
	END
	--Set encType and encKeyLen only for re-encrypt or network only encryption
	IF (@l_DepFlags & (@reencBit | @netOnlyEncBit))> 0
	BEGIN
		SET @l_DepEncType = @l_GlobalEncType
		SET @l_DepEncKeyLen = @l_GlobalEncKeyLen
	END
	UPDATE 	ArchGroupCopy
	SET		flags = ((flags & ~(@encMask | @storeOnMediaBit)) | @l_DepFlags | (@l_GlobalFlags & @storeOnMediaBit)),
			encType = @l_DepEncType,
			encKeyLen = @l_DepEncKeyLen
	WHERE	id = @i_copyId
	SET @error = @@ERROR
	IF @error <> 0
	  GOTO RETURN_PROC
END
SET NOCOUNT OFF
RETURN_PROC:
--
select @error
--
GO

IF EXISTS (select * from GxQscripts where name = 'archUpdateGlobalDependentEncryption')
	delete from GxQscripts where name = 'archUpdateGlobalDependentEncryption'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUpdateGlobalDependentEncryption')
	delete from GXDBVersions where aliasname = 'archUpdateGlobalDependentEncryption'
GO

insert into GXDBVersions values(2, 'archUpdateGlobalDependentEncryption',  '00010001000200050000', 'archUpdateGlobalDependentEncryption', '00010001000200050000')
GO

