

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archUpdateGACPDependentRetention.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2014  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archUpdateGACPDependentRetention.sp,v $ $Id: archUpdateGACPDependentRetention.sp,v 1.1.2.3 2018/03/27 09:12:34 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archUpdateGACPDependentRetention <<<'

IF EXISTS (select * from sysobjects where name='archUpdateGACPDependentRetention')
	drop procedure archUpdateGACPDependentRetention
IF EXISTS (select * from GxQscripts where name='archUpdateGACPDependentRetention')
	delete from GxQscripts where name = 'archUpdateGACPDependentRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUpdateGACPDependentRetention')
	delete from GXDBVersions where aliasname = 'archUpdateGACPDependentRetention'
GO
print '... Creating Procedure: archUpdateGACPDependentRetention'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archUpdateGACPDependentRetention
  @i_copyId int,
  @i_gacpCopyId int
AS
  DECLARE @o_retcode integer
SET NOCOUNT ON
--
declare @error int = 0
--
-- Update the dependent copy with the GACP basic retention
UPDATE DepRule
SET	DepRule.retentionDays	= GACPRule.retentionDays,
	DepRule.fullCycles	= GACPRule.fullCycles,
	DepRule.flags		= GACPRule.flags,
	DepRule.weekStart	= GACPRule.weekStart,
	DepRule.monthStart	= GACPRule.monthStart,
	DepRule.yearStart	= GACPRule.yearStart,
	DepRule.archiverRetDays = GACPRule.archiverRetDays,
	DepRule.retentionJobs	= GACPRule.retentionJobs,
	DepRule.minutesSinceDayStarts = GACPRule.minutesSinceDayStarts
FROM archAgingRule DepRule, archAgingRule GACPRule, archGroupCopy C
WHERE DepRule.CopyId = @i_copyId
AND GACPRule.CopyId = @i_gacpCopyId
AND DepRule.CopyId = C.id
AND C.destMediaCopyId = GACPRule.CopyId
AND C.extendedFlags & 2048 = 0
--First drop all the rules and then recreate.
DELETE A
FROM archAgingRuleExtended A, archGroupCopy B
WHERE A.copyId = @i_copyId
AND A.copyId = B.id
AND B.destMediaCopyId = @i_gacpCopyId
AND B.extendedFlags & 2048 = 0
-- Recreate all the extended retention rules
INSERT INTO archAgingRuleExtended(copyId, retentionDays, retentionRule, currPeriodBegin, currPeriodEnd, prevPeriodBegin, nextPeriodEnd, GraceDays, EveryXHours)
SELECT @i_copyId, A.retentionDays, A.retentionRule, A.currPeriodBegin, A.currPeriodEnd, A.prevPeriodBegin, A.nextPeriodEnd, A.GraceDays, A.EveryXHours
FROM archAgingRuleExtended A, archGroupCopy B
WHERE A.copyId = @i_gacpCopyId
AND B.id = @i_copyId
AND B.destMediaCopyId = A.copyId
AND B.extendedFlags & 2048 = 0
SET NOCOUNT OFF
--
select @error
--
GO

IF EXISTS (select * from GxQscripts where name = 'archUpdateGACPDependentRetention')
	delete from GxQscripts where name = 'archUpdateGACPDependentRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUpdateGACPDependentRetention')
	delete from GXDBVersions where aliasname = 'archUpdateGACPDependentRetention'
GO

insert into GXDBVersions values(2, 'archUpdateGACPDependentRetention',  '00010001000200030000', 'archUpdateGACPDependentRetention', '00010001000200030000')
GO

