

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archUncopiedMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archUncopiedMedia.sp,v $ $Id: archUncopiedMedia.sp,v 1.17.86.4 2019/02/07 02:09:14 kjaiswal Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "archUncopiedMedia"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archUncopiedMedia')
BEGIN
	print '>>> Drop Stored Procedure: archUncopiedMedia <<<'
	drop procedure archUncopiedMedia
END
IF EXISTS (select * from GxQscripts where name='archUncopiedMedia')
	delete from GxQscripts where name = 'archUncopiedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUncopiedMedia')
	delete from GXDBVersions where aliasname = 'archUncopiedMedia'
GO
print '... Creating Procedure: archUncopiedMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archUncopiedMedia
  @i_spId integer,
  @i_copyId integer
AS
  DECLARE @o_policyId integer
  DECLARE @o_policyName NVARCHAR(256)
  DECLARE @o_copyId integer
  DECLARE @o_copyName NVARCHAR(64)
  DECLARE @o_streamNum integer
  DECLARE @o_mediaGroupId integer
  DECLARE @o_mediaId integer
  DECLARE @o_uniqueId char(300)
  DECLARE @o_barCode char(256)
  DECLARE @o_attributes integer
  DECLARE @o_guiAttributes integer
  DECLARE @o_libraryId integer
  DECLARE @o_libraryName NVARCHAR(128)
  DECLARE @o_locationType integer
  DECLARE @o_locationId integer
  DECLARE @o_location NVARCHAR(1024)
  DECLARE @o_uncopiedBytes bigint
  DECLARE @o_reason integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @isTempTablePrePopulated BIT = 1
if object_id('tempdb.dbo.#tblAFC') is not null DROP TABLE #tblAFC
if object_id('tempdb.dbo.#tblChunk') is not null DROP TABLE #tblChunk
/* create this table for bulk inputs in the caller, defaultCopyId need not be set by the caller
CREATE TABLE #tblArchUncopiedMediaInputSps(archGrpId INT, copyId INT, defaultCopyId INT)
*/
IF OBJECT_ID('tempdb.dbo.#tblArchUncopiedMediaInputSps') IS NULL
BEGIN
	CREATE TABLE #tblArchUncopiedMediaInputSps(archGrpId INT, copyId INT, defaultCopyId INT)
	INSERT INTO #tblArchUncopiedMediaInputSps
	SELECT @i_spId, @i_copyId, 0
	SET @isTempTablePrePopulated = 0
END
DECLARE @fromAlert INTEGER
IF OBJECT_ID('tempdb.dbo.#UncopiedMediaAuxCopyFallenBehindAlert') IS NOT null
	SET @fromAlert = 1
ELSE
	SET @fromAlert = 0
DECLARE @defCopyId  integer
/*
IF @i_spId = 0
   SET @i_spId = (SELECT archGroupId FROM archGroupCopy WITH (NOLOCK) WHERE id = @i_copyId)
SET @defCopyId = (SELECT defaultCopy FROM archGroup WITH (NOLOCK) WHERE id = @i_spId)
*/
IF EXISTS (SELECT 1 FROM #tblArchUncopiedMediaInputSps WHERE ISNULL(archGrpId,0) = 0)
	 UPDATE #tblArchUncopiedMediaInputSps
	 SET archGrpId = archGroupId
	 FROM #tblArchUncopiedMediaInputSps, archGroupCopy WITH (NOLOCK)
	 WHERE id = copyId
 UPDATE #tblArchUncopiedMediaInputSps
 SET defaultCopyId = defaultCopy
 FROM #tblArchUncopiedMediaInputSps, archGroup WITH (NOLOCK)
 WHERE id = archGrpId
CREATE TABLE #tblAFC (
	archFileId int, commCellId int, archCopyId int,
	isValid int, streamNum int, physicalSize bigint,
	sourceCopyId int, srcIsValid int, srcStreamNum int, srcPhysicalSize bigint, archGrpId INT,
	primary key (archFileId, commCellId, archCopyId))
CREATE INDEX tblAFC_temp_idx_1 on #tblAFC(isValid, srcIsValid )
CREATE TABLE #tblChunk (
	archCopyId int, streamNum int, volumeId int,
	archChunkId bigint, commCellId int, copiedBytes bigint, uncopiedBytes bigint, archGrpId INT)
DECLARE @tblVolume TABLE (
	commCellId int, archCopyId int, streamNum int, volumeId int, volumeName varchar(112),
	mediaId int, mediaSideId int, CreationTime int, SIDBStoreId int, SiloStatus int,
	firstChunkId bigint, copiedBytes bigint, uncopiedBytes bigint, archGrpId INT)
DECLARE @tblMedia TABLE (
MediaId int, MountPathId int, MountPathName varchar(1024), MountPathTypeId int,  archGrpId INT)
DECLARE @tblMediaLocation TABLE (
mediaId int, uniqueId varchar(300), barCode varchar(256), mediaTypeId int, attributes int,
libraryId int, locationType int, locationId int, location nvarchar(1024), archGrpId INT)
if object_id('tempdb.dbo.#tmpMediaSelect') is not null DROP TABLE #tmpMediaSelect
create table #tmpMediaSelect(MediaId integer,guiAttributes  integer)
create index tmpMediaSelect_temp_idx_1 on #tmpMediaSelect(MediaId)
INSERT INTO #tblAFC
SELECT	A.id, A.commCellId, B.archGrpCopyId, 0, 0, 0, B.sourceCopyId, 0, 0, 0, B.archGrpId
FROM	archFile A WITH (NOLOCK),
		(SELECT T.*
		FROM	JMJobDataStats J WITH (NOLOCK),
				(SELECT	JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpId, JDS.archGrpCopyId, AGC.sourceCopyId
				FROM	JMJobDataStats JDS WITH (NOLOCK),
						(SELECT id AS destCopyId, (case sourceCopyId when 0 then tI.defaultCopyId else sourceCopyId end) AS sourceCopyId, tI.archGrpId
						FROM	archGroupCopy WITH (NOLOCK), #tblArchUncopiedMediaInputSps tI
						WHERE	(tI.copyId <= 0 OR (tI.copyId = tI.defaultCopyId AND sourceCopyId = 0) OR id = tI.copyId)
							AND id <> tI.defaultCopyId AND archGroupId = tI.archGrpId AND isActive = 1) AGC
				WHERE	JDS.archGrpCopyId = AGC.destCopyId AND JDS.archGrpId = AGC.archGrpId AND JDS.status IN (101, 102, 103)
AND (JDS.disabled & (1 + 256)) = 0) T
		WHERE	J.jobId = T.jobId
			AND J.archGrpCopyId = T.sourceCopyId
			AND J.dataType = T.dataType
			AND J.commCellId = T.commCellId
AND J.status = 100 AND (J.disabled & (1 + 256)) = 0) B
WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
		AND A.fileType = B.dataType AND A.archGroupId = B.archGrpId AND A.isValid = 1
UPDATE	#tblAFC SET srcIsValid= B.isValid, srcStreamNum = B.streamNum, srcPhysicalSize = B.physicalSize
FROM	#tblAFC A, archFileCopy B WITH (NOLOCK)
WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.sourceCopyId = B.archCopyId
UPDATE	#tblAFC SET isValid = B.isValid, streamNum = B.streamNum, physicalSize = B.physicalSize
FROM	#tblAFC A, archFileCopy B WITH (NOLOCK)
WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.archCopyId = B.archCopyId
DELETE	#tblAFC
WHERE	isValid = 1 OR srcIsValid <> 1 OR physicalSize = srcPhysicalSize
UPDATE	#tblAFC
SET		streamNum = (case (B.flags & 4)
					when 0 then A.srcStreamNum
					else (1 + (A.srcStreamNum - 1)%B.maxStreamNum) end)
FROM	#tblAFC A, archGroupCopy B WITH (NOLOCK)
WHERE	A.streamNum = 0 AND A.archCopyId = B.id
INSERT INTO #tblChunk
SELECT	AFC.archCopyId, AFC.streamNum, 0, ACM.archChunkId, ACM.chunkCommCellId,
		MAX(AFC.physicalSize - ACM.physicalOffset),
		SUM(case when (AFC.physicalSize - ACM.physicalOffset) > 0 then (AFC.physicalSize - ACM.physicalOffset) else ACM.physicalSize end),
		AFC.archGrpId
FROM	#tblAFC AFC, archChunkMapping ACM WITH (NOLOCK)
WHERE	ACM.archFileId = AFC.archFileId AND ACM.commCellId = AFC.commCellId AND ACM.archCopyId = AFC.sourceCopyId
		AND ACM.physicalSize > (AFC.physicalSize - ACM.physicalOffset)
GROUP BY AFC.archCopyId, AFC.streamNum, ACM.archChunkId, ACM.chunkCommCellId, AFC.archGrpId
UPDATE	#tblChunk SET volumeId = AC.volumeId
FROM	#tblChunk T, archChunk AC WITH (NOLOCK)
WHERE	AC.id = T.archChunkId AND AC.commCellId = T.commCellId
INSERT INTO @tblVolume
SELECT	T.commCellId, T.archCopyId, T.streamNum, V.VolumeId, V.VolumeName,
		V.MediaId, V.MediaSideId, V.CreationTime, V.SIDBStoreId, V.SiloStatus,
		T.firstChunkId, T.copiedBytes, T.uncopiedBytes, T.archGrpId
FROM 	(SELECT	commCellId, archCopyId, streamNum, volumeId, archGrpId,
				MIN(archChunkId) AS firstChunkId, MAX(copiedBytes) AS copiedBytes, SUM(uncopiedBytes) AS uncopiedBytes
		FROM	#tblChunk
		GROUP BY commCellId, archCopyId, streamNum, volumeId, archGrpId) T, MMVolume V WITH (NOLOCK)
WHERE	T.volumeId = V.VolumeId
-- Get media for SILO Restore
CREATE	TABLE #SiloVol (CopyId INT, VolumeId INT, SIDBStoreId INT, CreationTime INT, archGrpId INT)
INSERT	INTO #SiloVol
SELECT	0, 0, SIDBStoreId, MAX(CreationTime), archGrpId
FROM	@tblVolume
WHERE	SIDBStoreId > 0 AND SiloStatus = 3 /*SILO_VOLUME_MIGRATED_OFFDISK*/
GROUP BY SIDBStoreId, archGrpId
IF @@ROWCOUNT > 0
BEGIN
	EXEC archMediaForSiloViatable 0, 0
	INSERT	INTO @tblVolume
	SELECT	V.origCCcommCellId, S.archGroupCopyId, S.stream, V.VolumeId, V.VolumeName,
			V.MediaId, V.MediaSideId, V.CreationTime, V.SIDBStoreId, V.SiloStatus,
			0, 0, 0, T.archGrpId
	FROM	#SiloVol T, MMVolume V WITH (READUNCOMMITTED), archStream S WITH (READUNCOMMITTED)
	WHERE	T.VolumeId = V.VolumeId AND T.VolumeId > 0
		AND S.mediaGroupId = V.MediaGroupId
END
DROP TABLE #SiloVol
INSERT INTO @tblMedia
SELECT	a.MediaId, ISNULL(b.MountPathId, 0), ISNULL(b.MountPathName, ''), ISNULL(b.MountPathTypeId, 0), archGrpId
FROM	(SELECT	DISTINCT MediaId, MediaSideId, archGrpId FROM @tblVolume) AS a
		LEFT OUTER JOIN MMS2getMountPathNameGUIView AS b WITH (NOLOCK) ON a.MediaSideId = b.MediaSideId
INSERT INTO @tblMediaLocation
SELECT	DISTINCT M.MediaId, M.UniqueId, M.BarCode, M.MediaTypeId, M.Attributes, M.LibraryId, M.MediaLocation,
		(case M.MediaTypeId
when 10001 then MP.MountPathId
		else (case M.MediaLocation
			when 1 then (SELECT SlotId  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
			when 2 then (SELECT DriveId FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
			else M.ExportLocationId
			end)
		end),
		(case M.MediaTypeId
when 10001 then MP.MountPathName
		else
			(case M.MediaLocation
			when 1 then (SELECT SlotName  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
			when 2 then (SELECT AliasName FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
			else ISNULL((SELECT ExportLocation FROM MMExportLocation WHERE ExportLocationId = M.ExportLocationId), '') end)
		end),
		archGrpId
FROM	@tblMedia AS MP, MMMedia AS M WITH (NOLOCK)
WHERE	M.MediaId = MP.MediaId
INSERT INTO #tmpMediaSelect
SELECT DISTINCT mediaId,0 FROM @tblMediaLocation
if @fromAlert = 0
	exec MMS2CalculateGUIMediaAttrEnBulk '#tmpMediaSelect'
SELECT	M.archGrpId, (SELECT name FROM archGroup WITH (NOLOCK) WHERE id = M.archGrpId),
		M.archCopyId, (SELECT name FROM archGroupCopy WITH (NOLOCK) WHERE id = M.archCopyId), M.streamNum,
		(SELECT mediaGroupId FROM archStream WITH (NOLOCK) WHERE archGroupCopyId = M.archCopyId AND stream = M.streamNum),
		ML.mediaId, ML.uniqueId,
(case when ML.mediaTypeId = 10001 then M.VolumeName else ML.barCode end),
		ML.attributes,  MLGUI.guiAttributes,
		ML.libraryId, (SELECT AliasName FROM MMLibrary WHERE LibraryId = ML.libraryId),
		ML.locationType, ML.locationId, ML.location, M.uncopiedBytes, 0
FROM 	@tblVolume M, @tblMediaLocation ML, #tmpMediaSelect MLGUI
WHERE	M.MediaId = ML.MediaId AND MLGUI.mediaId = ML.mediaId
		AND M.archGrpId = ML.archGrpId
ORDER BY M.archCopyId, M.streamNum, M.commCellId, M.copiedBytes DESC, M.firstChunkId
if object_id('tempdb.dbo.#tmpMediaSelect') is not null DROP TABLE #tmpMediaSelect
if object_id('tempdb.dbo.#tblAFC') is not null DROP TABLE #tblAFC
if object_id('tempdb.dbo.#tblChunk') is not null DROP TABLE #tblChunk
IF @isTempTablePrePopulated = 0
BEGIN
	IF OBJECT_ID('tempdb.dbo.#tblArchUncopiedMediaInputSps') IS NOT NULL DROP TABLE #tblArchUncopiedMediaInputSps
END
GO

IF EXISTS (select * from GxQscripts where name = 'archUncopiedMedia')
	delete from GxQscripts where name = 'archUncopiedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUncopiedMedia')
	delete from GXDBVersions where aliasname = 'archUncopiedMedia'
GO

insert into GXDBVersions values(2, 'archUncopiedMedia',  '00010017008600040000', 'archUncopiedMedia', '00010017008600040000')
GO

