

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archUnageJobs.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :    archUnageJobs.sp                                         */
/*                                                                            */
/*  Description :    stored procedure that will unage aged jobs               */
/*                                                                            */
/******************************************************************************/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archUnageJobs')
BEGIN
	print '>>> Drop Stored Procedure: archUnageJobs <<<'
	drop procedure archUnageJobs
END
IF EXISTS (select * from GxQscripts where name='archUnageJobs')
	delete from GxQscripts where name = 'archUnageJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUnageJobs')
	delete from GXDBVersions where aliasname = 'archUnageJobs'
GO
print '... Creating Procedure: archUnageJobs'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archUnageJobs
  @i_option INTEGER,
  @i_retainUntilUnix BIGINT,
  @i_inputXml XML,
  @i_reservedInt INTEGER
AS
  DECLARE @r_retVal INTEGER;
  DECLARE @r_errorString varchar(1024);
  DECLARE @r_unAgeFailedJobList Xml;
SET NOCOUNT ON
DECLARE @errorCode		INTEGER
SET			@errorCode		= 0
DECLARE @errorStr		varchar(1024)
SET			@errorStr		= 'NO ERROR'
DECLARE @rowCnt INTEGER
SET @rowCnt = 0
DECLARE @i_MediaId INTEGER
SET			@i_MediaId = -1
DECLARE @CVA_UNAGED_JOB_FLAG INTEGER
SET			@CVA_UNAGED_JOB_FLAG = 1073741824
BEGIN TRANSACTION
IF @i_option not in (1, 2)
BEGIN
	SET @errorCode = -1
	GOTO CX_EXIT
END
--Code Below Here is From archUnageJobs.spb
IF @i_option = 2
			SET @i_MediaId = ISNULL((SELECT T.item.value('@mediaId', 'INTEGER')
			FROM @i_inputXml.nodes('/GalaxyOperations_UnageJobs/MediaInfo') T(item)),-1)
		ELSE
			SET @i_MediaId = 0
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
	IF @i_MediaId = -1
OR (@i_MediaId = 0 AND @i_option = 2)
	BEGIN
		SET	@errorCode = -4
		GOTO CX_EXIT
	END
	IF OBJECT_ID('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
	IF OBJECT_ID('tempdb.dbo.#tempJob') IS NOT NULL DROP TABLE #tempJob
	IF OBJECT_ID('tempdb.dbo.#tempAFJob') IS NOT NULL DROP TABLE #tempAFJob
	CREATE TABLE #tempChunk
	(
			archChunkId		BIGINT,
			commCellId		INTEGER,
			VolumeId		INTEGER
			PRIMARY KEY(archChunkId, commCellId)
	)
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
	CREATE	TABLE #tempJob (
			jobId						INTEGER,
			commCellId			INTEGER,
			archCopyId			INTEGER
			PRIMARY KEY(jobId, commCellId, archCopyId)
			)
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
	CREATE	TABLE #tempAFJob (
			jobId						INTEGER,
			archFileId			INTEGER,
			afCommCellId		INTEGER,
			archChunkId			BIGINT,
			acCommCellId			INTEGER,
			archCopyId			INTEGER,
			fileType				INTEGER,
			isAged					INTEGER,
			isMediaDeleted 	INTEGER,
			isEdgeAF		INTEGER
			PRIMARY KEY(jobId, archFileId, afCommCellId, archChunkId, acCommCellId, archCopyId, fileType)
			)
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
		CREATE TABLE #unageFailedJobs (
		jobId INTEGER,
		commcellid INTEGER,
		copyId INTEGER,
		failureReason INTEGER
		)
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
IF @i_option = 2
	BEGIN
		INSERT INTO #tempChunk
		SELECT AC.id, AC.commCellId, AC.volumeId
		FROM	archChunk AC WITH (NOLOCK), MMVolume V WITH (NOLOCK)
		WHERE	V.MediaId = @i_MediaId
		AND 	AC.volumeId = V.volumeId
		--AND	AC.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
	END
	ELSE
	BEGIN
		INSERT INTO #tempJob
		SELECT	DISTINCT T.item.value('@jobId', 'INTEGER') AS JobId,
					T.item.value('@commCellId', 'INTEGER') AS commCellId,
					T.item.value('@archCopyId', 'INTEGER') AS archCopyId
					FROM	@i_inputXml.nodes('/GalaxyOperations_UnageJobs/JobInfo') T(item)
		INSERT INTO #tempChunk
		SELECT DISTINCT AC.id, AC.commCellId, AC.volumeId
		FROM	archChunk AC WITH (NOLOCK)
		INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
		INNER JOIN #tempJob TMP ON ACM.jobId = TMP.jobId AND ACM.commCellId = TMP.commCellId AND ACM.archCopyId = TMP.archCopyId
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
	END
	-- Fail if the copyId for volumes does not match with the copyId of chunks
	IF EXISTS (SELECT V.VolumeId
			FROM MMVolume V WITH (NOLOCK), archStream S WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), #tempChunk C, archGroupCopy AGC WITH (NOLOCK)
		        WHERE C.volumeId = V.volumeId
			--AND	 C.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
			AND	 C.archChunkId = ACM.archChunkId
			AND 	 C.commCellId = ACM.chunkCommCellId
			AND	 V.mediaGroupId = S.mediaGroupId
			AND	 S.archGroupCopyId <> ACM.archCopyId
			AND	 ACM.archCopyId = AGC.id
			AND	(AGC.extendedFlags & 3) = 0)
			-- CVA_GLOBAL_AUXCOPY_POLICY_FLAG | CVA_USE_GLOBAL_AUXCOPY_POLICY_FLAG - do not check above for GACP as media is shared amoung copies.
	BEGIN
		SET	@errorCode = -5
		GOTO CX_EXIT
	END
IF @i_option = 2
	BEGIN
		INSERT INTO #tempJob
		SELECT DISTINCT AF.jobId, AF.commCellId, ACM.archCopyId
		FROM	#tempChunk C, archChunkMapping ACM WITH (NOLOCK), archFile AF WITH (NOLOCK)
		WHERE C.archChunkId = ACM.archChunkId
		AND 	C.commCellId = ACM.chunkCommCellId
		AND		ACM.archFileId = AF.id
		AND		ACM.commCellId = AF.commCellId
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
	END
	INSERT INTO #tempAFJob
SELECT	AF.jobId, ACM.archFileId, ACM.commCellId, ACM.archChunkId, ACM.chunkCommCellId, ACM.archCopyId, AF.fileType, (ACM.flags & 256), 0, (AF.flags & (32768|2097152))
	FROM	#tempJob T, archChunkMapping ACM WITH (NOLOCK), archFile AF WITH (NOLOCK)
	WHERE T.jobId = AF.jobId
	AND 	T.commCellId = AF.commCellId
	AND		AF.id = ACM.archFileId
	AND		AF.commCellId = ACM.commCellId
	AND		T.archCopyId = ACM.archCopyId
	AND		AF.isValid = 1
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
	--DO NOT un-age jobs if they are partially pruned from media
	UPDATE #tempAFJob
	SET isMediaDeleted = 1
	FROM	#tempAFJob T, (	SELECT JDS.JobId, JDS.commCellId, JDS.archGrpCopyId,
															 MAX(mediaDeletedTime) AS mediaDeletedTime, MAX(status) AS status,
															 MAX(disabled & 33554432) AS mediaDeletedFlag,
															 MAX(agedBy & 33554432) AS agedByFlag
												FROM JMJobDataStats JDS WITH (NOLOCK), #tempAFJob T1
												WHERE JDS.JobId = T1.JobId
												AND		JDS.commCellId = T1.afCommCellId
												AND 	JDS.archGrpCopyId = T1.archCopyId
												GROUP BY JDS.JobId, JDS.commCellId, JDS.archGrpCopyId) AS TT
	WHERE TT.JobId = T.JobId
	AND		TT.commCellId = T.afCommCellId
	AND 	TT.archGrpCopyId = T.archCopyId
	AND		(TT.mediaDeletedTime > 0 OR TT.status = 1000 OR TT.mediaDeletedFlag > 0 OR TT.agedByFlag > 0)
	SELECT	@errorCode = @@ERROR, @rowCnt = @@ROWCOUNT
	IF	@errorCode <> 0 GOTO CX_EXIT
	IF @rowCnt > 0
	BEGIN
		INSERT INTO #unageFailedJobs
SELECT distinct a.jobId, a.afCommCellId, a.archCopyId, 123
		FROM #tempAFJob a left outer join #unageFailedJobs b ON a.jobId = b.jobId AND a.afCommCellId = b.commcellId
		WHERE isMediaDeleted = 1 AND b.jobId is null
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
	END
	-- DO NOT un-age jobs if they are partially on magnetic media and AGED
	UPDATE #tempAFJob
	SET isMediaDeleted = 1
	FROM	#tempAFJob T, (	SELECT DISTINCT T.JobId, T.afCommCellId, T.archCopyId
				FROM MMMedia M WITH (NOLOCK), MMVolume V WITH (NOLOCK), archChunk AC WITH (NOLOCK), #tempAFJob T
				WHERE 	AC.id = T.archChunkId
				AND	AC.commCellId = T.acCommCellId
				AND	T.isAged > 0
				AND	AC.volumeId = V.volumeId
				--AND	AC.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
				AND	V.MediaId = M.MediaId
				AND	M.mediaTypeId = 10001) AS TT
	WHERE TT.JobId = T.JobId
	AND   TT.afCommCellId = T.afCommCellId
	AND   TT.archCopyId = T.archCopyId
	SELECT	@errorCode = @@ERROR, @rowCnt = @@ROWCOUNT
	IF	@errorCode <> 0 GOTO CX_EXIT
 	IF @rowCnt > 0
	BEGIN
		INSERT INTO #unageFailedJobs
SELECT distinct a.jobId, a.afCommCellId, a.archCopyId, 124
		FROM #tempAFJob a left outer join #unageFailedJobs b ON a.jobId = b.jobId AND a.afCommCellId = b.commcellId
		WHERE isMediaDeleted = 1 AND b.jobId is null
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
	END
	-- DO NOT un-aged Failed / Killed jobs
	UPDATE #tempAFJob
	SET isMediaDeleted = 1
	FROM	#tempAFJob T, JMBkpStats JBS WITH (NOLOCK)
	WHERE T.JobId = JBS.JobId
	AND	T.afCommCellId = JBS.commCellId
	AND	JBS.status NOT IN (1, 3, 14)
	SELECT	@errorCode = @@ERROR, @rowCnt = @@ROWCOUNT
	IF	@errorCode <> 0 GOTO CX_EXIT
	IF @rowCnt > 0
	BEGIN
		INSERT INTO #unageFailedJobs
SELECT distinct a.jobId, a.afCommCellId, a.archCopyId, 125
		FROM #tempAFJob a left outer join #unageFailedJobs b ON a.jobId = b.jobId AND a.afCommCellId = b.commcellId
		WHERE isMediaDeleted = 1 AND b.jobId is null
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
	END
	-- DO NOT un-age partial jobs if encKey doesn't match with source copy.
	BEGIN
		-- Get source copies for copies involved in un-age jobs.
		IF OBJECT_ID('tempdb..#CopySrcMap') IS NOT NULL DROP TABLE #CopySrcMap
		CREATE TABLE #CopySrcMap (copyId smallint, sourceCopyId smallint, primaryCopyId smallint)
		INSERT INTO #CopySrcMap
		SELECT	AGC.id copyId, (case when AGC.sourceCopyId > 0 then AGC.sourceCopyId else (case when AGC.isSnapCopy > 0 then AG.defaultSnapCopy else AG.defaultCopy end) end) sourceCopyId, (case when AGC.isSnapCopy > 0 then AG.defaultSnapCopy else AG.defaultCopy end) primaryCopyId
		FROM	archGroupCopy AGC WITH (READUNCOMMITTED), archgroup AG WITH (READUNCOMMITTED)
where	AGC.archGroupId = AG.id AND (AGC.dedupeFlags & 262144) = 0
				AND AGC.id not in (AG.defaultCopy, AG.defaultSnapCopy)
				AND EXISTS (SELECT 1 FROM #tempAFJob WHERE archCopyId = AGC.id)
		IF @@ROWCOUNT > 0
		BEGIN
			-- DO NOT un-age partial jobs  when encKey doesn't match with source
			UPDATE 	#tempAFJob
			SET 	isMediaDeleted = 1
			FROM	#tempAFJob T, #CopySrcMap CSM,
					archFileCopy Dest WITH (READUNCOMMITTED), archFileCopy Src WITH (READUNCOMMITTED)
			WHERE 	T.archCopyId = CSM.copyId AND T.isMediaDeleted = 0
					AND T.archFileId = Dest.archFileId AND T.afCommCellId = Dest.commCellId
					AND Dest.archFileId = Src.archFileId AND Dest.commCellId = Src.commCellId
					AND Dest.archCopyId = CSM.copyId AND Src.archCopyId = CSM.sourceCopyId
					AND Dest.isValid = 0 AND Dest.encKey <> Src.encKey
			SELECT	@errorCode = @@ERROR, @rowCnt = @@ROWCOUNT
			IF	@errorCode <> 0 GOTO CX_EXIT
			IF EXISTS (SELECT 1 FROM #tempAFJob WHERE isEdgeAF > 0)
			BEGIN
				-- Get all source copies in hierarchy for each of the copy involved in un-age jobs.
				WITH SourceCopies (copyId, sourceCopyId) AS
				(
					SELECT 	copyId, sourceCopyId
					FROM	(
								SELECT copyId, sourceCopyId
								FROM 	#CopySrcMap
								UNION
								-- Get Primary copies
								SELECT  copyId, primaryCopyId as sourceCopyId
								FROM	#CopySrcMap
								WHERE	sourceCopyId <> primaryCopyId
							) AS T
					UNION ALL
					SELECT	SC.copyId, AGC.sourceCopyId
					FROM	archGroupCopy AGC WITH (READUNCOMMITTED), SourceCopies SC
					WHERE	AGC.id = SC.sourceCopyId AND AGC.sourceCopyId > 0
				)
				-- DO NOT un-age if EDGE AF has more data in any of the parent copies when encKey doesn't match with source
				UPDATE 	#tempAFJob
				SET 	isMediaDeleted = 1
				FROM	#tempAFJob T, #CopySrcMap CSM,
						archFileCopy Dest WITH (READUNCOMMITTED), archFileCopy Src WITH (READUNCOMMITTED),
						(
							SELECT 	AFC.archFileId, AFC.commCellId, MAX(AFC.physicalSize) physicalSize
							FROM 	#tempAFJob TAF, archFileCopy AFC WITH (READUNCOMMITTED), SourceCopies SC
							WHERE	TAF.archFileId = AFC.archFileId AND TAF.afCommCellId = AFC.commCellId
									AND AFC.archCopyId = SC.sourceCopyId AND TAF.archCopyId = SC.copyId AND TAF.isEdgeAF > 0
							GROUP BY AFC.archFileId, AFC.commCellId
						) AS MaxSrc
				WHERE 	T.archCopyId = CSM.copyId AND T.isMediaDeleted = 0
						AND T.archFileId = Dest.archFileId AND T.afCommCellId = Dest.commCellId
						AND Dest.archFileId = Src.archFileId AND Dest.commCellId = Src.commCellId
						AND Dest.archCopyId = CSM.copyId AND Src.archCopyId = CSM.sourceCopyId
						AND Src.archFileId = MaxSrc.archFileId AND Src.commCellId = MaxSrc.commCellId
						AND MaxSrc.physicalSize > Dest.physicalSize AND Dest.encKey <> Src.encKey
				SELECT	@errorCode = @@ERROR, @rowCnt = (case when @rowCnt > 0 THEN @rowCnt else @@ROWCOUNT end)
				IF	@errorCode <> 0 GOTO CX_EXIT
				--Close current running edge AFs
				UPDATE  EAF
SET     flags = EAF.flags | 1048576
				FROM    archFile EAF INNER JOIN
						(
							SELECT 	AFC.archFileId, AFC.commCellId,
									ROW_NUMBER() OVER (PARTITION BY AF.appId, AFC.streamNum ORDER BY AFC.archFileId DESC) AS RowNum
							FROM 	#tempAFJob TAF, archFile AF WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED),
									archGroup AG WITH (READUNCOMMITTED)
							WHERE	TAF.archFileId = AF.id AND TAF.afCommCellId = AF.commCellId
									AND AF.archGroupId = AG.id AND (TAF.archCopyId = AG.defaultCopy OR TAF.archCopyId = AG.defaultSnapCopy)
									AND AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId  AND AF.commCellId = 2
									AND AFC.archCopyId = TAF.archCopyId AND TAF.isEdgeAF = 1 AND TAF.isMediaDeleted = 0
									AND AF.backupLevel = 2 /*INCR*/
						) AS T ON EAF.id = T.archFileId AND EAF.commCellId = T.commCellId AND T.RowNum = 1
				SELECT	@errorCode = @@ERROR
				IF	@errorCode <> 0 GOTO CX_EXIT
			END
			IF @rowCnt > 0
			BEGIN
				INSERT INTO #unageFailedJobs
SELECT distinct a.jobId, a.afCommCellId, a.archCopyId, 152
				FROM #tempAFJob a left outer join #unageFailedJobs b ON a.jobId = b.jobId AND a.afCommCellId = b.commcellId
				WHERE isMediaDeleted = 1 AND b.jobId is null
				SET	@errorCode = @@ERROR
				IF	@errorCode <> 0 GOTO CX_EXIT
			END
		END
	END
	IF EXISTS (SELECT jobId FROM #tempAFJob WHERE isMediaDeleted = 0 AND isAged > 0)
	BEGIN
		-- Unset AGED and set AGED BY flags
		UPDATE archFileCopy WITH (PAGLOCK)
SET flags = (flags & ~256), agedBy = 1073741824-- Set un-aged job flag
		FROM #tempAFJob T, archFileCopy AFC
		WHERE AFC.archFileId = T.archFileId
		AND		AFC.commCellId = T.afCommCellId
		AND 	AFC.archCopyId = T.archCopyId
AND		AFC.flags & 256 > 0
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		UPDATE archChunkMapping WITH (PAGLOCK)
SET flags = (flags & ~256), agedBy = 1073741824	-- Set un-aged job flag
		FROM #tempAFJob T, archChunkMapping ACM
		WHERE ACM.archChunkId = T.archChunkId
		AND		ACM.archFileId = T.archFileId
		AND		ACM.commCellId = T.afCommCellId
		AND 	ACM.chunkCommcellId = T.acCommcellId
		AND 	ACM.archCopyId = T.archCopyId
AND		ACM.flags & 256 > 0
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		UPDATE archChunk WITH (PAGLOCK)
SET flags = (flags & ~256), agedBy = 1073741824	-- Set un-aged job flag
		FROM #tempAFJob T, archChunk AC
		WHERE AC.id = T.archChunkId
		AND		AC.commCellId = T.acCommCellId
AND		AC.flags & 256 > 0
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		--Pin the job for RetainUntil time
		UPDATE JMJobDataStats WITH (PAGLOCK)
SET disabled = ((disabled & ~256)|2), agedBy = 1073741824,	-- Set manually retained flag and un-aged job flag
				manualRetentionEndTime = @i_RetainUntilUnix,
				agedTime = 0,
				mediaDeletedTime = 0
		FROM #tempAFJob T, JMJobDataStats JDS
		WHERE JDS.JobId = T.JobId
		AND		JDS.commCellId = T.afCommCellId
		AND 	JDS.archGrpCopyId = T.archCopyId
		AND		JDS.dataType = T.fileType
AND		JDS.disabled & 256 > 0
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		UPDATE JMBkpStats WITH (PAGLOCK)
		SET 	dataStatus = 0, agedTime = 0,	mediaDeletedTime = 0
		FROM #tempAFJob T, JMBkpStats JBS
		WHERE JBS.JobId = T.JobId
		AND		JBS.commCellId = T.afCommCellId
		AND		JBS.agedTime > 0
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		UPDATE JMAdminJobStatsTable WITH (PAGLOCK)
		SET 	dataStatus = 0
		FROM #tempAFJob T, JMAdminJobStatsTable JAS
		WHERE JAS.JobId = T.JobId
		AND		JAS.commCellId = T.afCommCellId
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		-- Delete archfile / chunks / volumes if they exist in MMDeletedAF table
		DELETE MMDeletedAF WITH (PAGLOCK)
		FROM MMDeletedAF DAF, #tempAFJob T
		WHERE T.archChunkId = DAF.archChunkId
		-- AND		T.afCommCellId = DAF.commCellId
		AND		T.acCommCellId = DAF.chunkCommCellId
		AND		T.archCopyId = DAF.copyId
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		-- Remove the recyclable volume entries
		DELETE MMDeletedAF WITH (PAGLOCK)
		FROM MMDeletedAF DAF, archChunk AC, #tempAFJob T
		WHERE AC.id = T.archChunkId
		AND		AC.commCellId = T.acCommCellId
		AND		AC.volumeId = DAF.volumeId
		-- AND	 	T.afCommCellId = DAF.CommCellId
		AND	 	T.acCommCellId = DAF.chunkCommCellId
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		AND		DAF.archFileId = 0
		AND		DAF.archChunkId = 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		-- Mark VolumeFlags as FULL and update VolumeFullReason code
		UPDATE MMVolume
		SET	VolumeFlags = 2, VolumeFullReason = 42044,  -- E_MM_VOL_FULL_JOBS_UNAGED
			volumeFullTime = dbo.GetUnixTime(GETUTCDATE()),
Attributes = (Attributes | 1073741824)
		FROM MMVolume V, archChunk AC, #tempAFJob T
		WHERE AC.id = T.archChunkId
		AND		AC.commCellId = T.acCommCellId
		AND		AC.volumeId = V.volumeId
		--AND	 	AC.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
		AND		T.isMediaDeleted = 0
		AND		T.isAged > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
		-- Mark media as NOT AGED
		UPDATE MMMedia
		SET	IsAged = 0, IsInMediaGroup = 1,
Attributes = (M.Attributes | 1073741824)	-- UN-AGED FLAG
		FROM MMMedia M, MMVolume V, archChunk AC, #tempAFJob T
		WHERE T.isMediaDeleted = 0
		AND		T.isAged > 0
		AND		AC.id = T.archChunkId
		AND		AC.commCellId = T.acCommCellId
		AND		AC.volumeId = V.volumeId
		--AND		AC.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
		AND		V.MediaId = M.MediaId
		--AND		M.IsAged <> 0
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
	END
CX_EXIT:
	IF @errorCode <> 0
	BEGIN
		ROLLBACK TRANSACTION
		IF @errorCode = -1
			SET @errorStr = 'Error: Invalid input option ['+cast(@i_option as varchar(10))+']'
		ELSE IF @errorCode = -4
			SET @errorStr = 'Invalid MediaId information in the input xml'
		ELSE IF @errorCode = -5
			SET @errorStr = 'Inconsistent data. Cannot un-age the jobs for media'
		ELSE
			SET @errorStr = 'Database error: Err Code: '+cast(@errorCode as varchar(10))
	END
	ELSE
		COMMIT TRANSACTION
	--If @errorCode <> 0 entire transaction would have been rolledback so no jobs unaged. We need to send list of jobs unaged with reason only when unage transaction is committed but some jobs were not processed
	IF OBJECT_ID('tempdb.dbo.#unageFailedJobs') is not null
	BEGIN
		IF @errorCode = 0 AND EXISTS (SELECT * FROM #unageFailedJobs)
			SET @r_unAgeFailedJobList = (SELECT jobId, commcellId, copyId, failureReason "errorCode" FROM (SELECT * FROM #unageFailedJobs) unageJobList for xml auto, root('MediaManager_UnageJobsResp'))
		ELSE
			SET @r_unAgeFailedJobList = ''
		DROP TABLE #unageFailedJobs
	END
	ELSE
		SET @r_unAgeFailedJobList = ''
	SELECT @errorCode, @errorStr, @r_unAgeFailedJobList
	RETURN @errorCode;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archUnageJobs')
	delete from GxQscripts where name = 'archUnageJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archUnageJobs')
	delete from GXDBVersions where aliasname = 'archUnageJobs'
GO

insert into GXDBVersions values(2, 'archUnageJobs',  '00000000000000000000', 'archUnageJobs', '00000000000000000000')
GO

