

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archTransitiveCopyCreate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archTransitiveCopyCreate.sp,v $ $Id: archTransitiveCopyCreate.sp,v 1.20.42.6 2020/01/13 22:44:55 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archTransitiveCopyCreate')
BEGIN
	print '>>> Drop Stored Procedure: archTransitiveCopyCreate <<<'
	drop procedure archTransitiveCopyCreate
END
IF EXISTS (select * from GxQscripts where name='archTransitiveCopyCreate')
	delete from GxQscripts where name = 'archTransitiveCopyCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archTransitiveCopyCreate')
	delete from GXDBVersions where aliasname = 'archTransitiveCopyCreate'
GO
print '... Creating Procedure: archTransitiveCopyCreate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archTransitiveCopyCreate
  @i_srcCopyId integer,
  @i_flags integer,
  @i_daysAfterWritten integer,
  @i_daysBeforeAged integer, 
  @i_percentage integer
AS
  DECLARE @retVal integer;
  DECLARE @newCopyId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @l_newCopyId	INT
DECLARE @l_now			INT
SET		@l_newCopyId	= 0
SET		@l_now			= dbo.getUnixTime(GETUTCDATE())
SET		@retVal			= 0
DECLARE @encMask INT = (1048576 | 2097152 | 4194304 | 8388608)
DECLARE @flagsToSync INT = (2 | 4 | @encMask | 131072)
DECLARE @l_EnableReEnc INT = ISNULL((SELECT value FROM MMConfigs WITH(READUNCOMMITTED)
											WHERE name = 'MM_CONFIG_ENABLE_RE_ENCRYPTION_FOR_MEDIA_REFRESH'), 0)
CREATE TABLE #tempMediaGroupName(oldMediaGroupId int, stream int, mediaGroupName varchar(256))
IF	EXISTS (SELECT copyId FROM archCopyMediarefreshProp WHERE copyId = @i_srcCopyId)
BEGIN
	UPDATE	archCopyMediarefreshProp
	SET		flags = @i_flags, daysAfterWritten = @i_daysAfterWritten, daysBeforeAged = @i_daysBeforeAged, percentage = @i_percentage
	WHERE	copyId = @i_srcCopyId
		AND (flags != @i_flags OR daysAfterWritten != @i_daysAfterWritten OR daysBeforeAged != @i_daysBeforeAged OR percentage != @i_percentage)
	IF @l_EnableReEnc > 0
	BEGIN
		UPDATE T
SET T.flags = (T.flags & ~@flagsToSync) | (S.flags & @flagsToSync) | (case when (S.flags & @encMask) = 0 then 1048576 else 0 end),
			T.maxMultiplex = S.maxMultiplex, T.maxStreamNum = S.maxStreamNum, T.encType = S.encType, T.encKeyLen = S.encKeyLen, T.calendarId = S.calendarId
		FROM archGroupcopy T, archGroupcopy S WITH (NOLOCK)
		WHERE T.sourceCopyId = S.id AND T.type = 5
			AND S.id = @i_srcCopyId
	END
	ELSE
	BEGIN
		UPDATE T
SET T.flags = (T.flags & ~(2 + 4) )| (S.flags & (2 + 4)),
		T.maxMultiplex = S.maxMultiplex, T.maxStreamNum = S.maxStreamNum, T.calendarId = S.calendarId
		FROM archGroupcopy T, archGroupcopy S WITH (NOLOCK)
		WHERE T.sourceCopyId = S.id AND T.type = 5
			AND S.id = @i_srcCopyId
	END
	IF EXISTS ( SELECT * FROM archGroup WITH (NOLOCK) WHERE defaultCopy =  @i_srcCopyId)
	BEGIN
		IF EXISTS ( SELECT * FROM archGroupCopy WITH (NOLOCK) WHERE id = @i_srcCopyId AND maxMultiplex > 0)
		BEGIN
			UPDATE T
SET T.flags = T.flags | (2 + 4), T.maxStreamNum = 0
			FROM archGroupcopy T, archCopyMediarefreshProp S WITH (NOLOCK)
			WHERE S.copyid = @i_srcCopyId AND
T.id = S.targetCopyId AND T.type = 5
		END
		ELSE
		BEGIN
		UPDATE T
SET T.flags = T.flags & ~(2 + 4)
			FROM archGroupcopy T, archCopyMediarefreshProp S WITH (NOLOCK)
			WHERE S.copyid = @i_srcCopyId AND
T.id = S.targetCopyId AND T.type = 5
		END
	END
	GOTO FINISH
END
BEGIN TRY
	IF @l_EnableReEnc > 0
	BEGIN
		INSERT	INTO archGroupCopy
				(archGroupId, copy, name, flags,
				maxMultiplex, isActive, type, startTime, waitForIfOffline,
				waitForIfBusy, archCheckStartTime, origCCcommCellID, origCCarchCopyId, sourceCopyId,
				delayedDays, maxStreamNum, archCheckValidPeriod, calendarId, SIDBStoreId,
				encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed,
				SIDBSnapIntervalHours, siloAppId, nDataInstance, description, dedupeFlags,
				blockCacheValidDays, nSiloStreams, silosInCache, siloRestoreMAClientId, siloRestoreClientId,
				sealStoreTaskId, extendedFlags, destMediaCopyId, archCheckValidPeriodType,
				endTime)
		SELECT	archGroupId, -1, 'Transitive Copy for ' + (CASE WHEN LEN(name) > 43 THEN CONVERT(NVARCHAR(20),@i_srcCopyId) ELSE name END),
((flags & @flagsToSync) | (case when (flags & @encMask) = 0 then 1048576 else 0 end)), maxMultiplex, 1, 5, -@l_now, waitForIfOffline,
				waitForIfBusy, -@l_now, origCCcommCellID, origCCarchCopyId, @i_srcCopyId,
				0, maxStreamNum, 0, calendarId, 0,
				encType, encKeyLen, 0, 0, 0,
				0, 0, 0, 'Automatically created transitive copy for refreshing and consolidating media in copy [' + name + ']', 0,
				0, 0, 0, 0, 0,
				0, 0, 0, 0,
				2147483647
		FROM	archGroupCopy
		WHERE	id = @i_srcCopyId
	END
	ELSE
	BEGIN
		INSERT	INTO archGroupCopy
				(archGroupId, copy, name, flags,
				maxMultiplex, isActive, type, startTime, waitForIfOffline,
				waitForIfBusy, archCheckStartTime, origCCcommCellID, origCCarchCopyId, sourceCopyId,
				delayedDays, maxStreamNum, archCheckValidPeriod, calendarId, SIDBStoreId,
				encType, encKeyLen, isSnapCopy, isMirrorCopy, NWWriteSpeed,
				SIDBSnapIntervalHours, siloAppId, nDataInstance, description, dedupeFlags,
				blockCacheValidDays, nSiloStreams, silosInCache, siloRestoreMAClientId, siloRestoreClientId,
				sealStoreTaskId, extendedFlags, destMediaCopyId, archCheckValidPeriodType,
				endTime)
		SELECT	archGroupId, -1, 'Transitive Copy for ' + (CASE WHEN LEN(name) > 43 THEN CONVERT(NVARCHAR(20),@i_srcCopyId) ELSE name END),
(1048576 + flags & (2 + 4)), maxMultiplex, 1, 5, -@l_now, waitForIfOffline,
				waitForIfBusy, -@l_now, origCCcommCellID, origCCarchCopyId, @i_srcCopyId,
				0, maxStreamNum, 0, calendarId, 0,
				0, 0, 0, 0, 0,
				0, 0, 0, 'Automatically created transitive copy for refreshing and consolidating media in copy [' + name + ']', 0,
				0, 0, 0, 0, 0,
				0, 0, 0, 0,
				2147483647
		FROM	archGroupCopy
		WHERE	id = @i_srcCopyId
	END
	SET		@l_newCopyId = SCOPE_IDENTITY()
	INSERT	INTO archCopyMediarefreshProp
	SELECT	@i_srcCopyId, @l_newCopyId, @i_flags, @i_daysAfterWritten, @i_daysBeforeAged, @i_percentage
	INSERT	INTO archAgingRule
	SELECT	@l_newCopyId, -1, -1, 0, 0, 0, 0, -1, 0,0
	--	For Media Refresh set MMS2_DEFAULT_FAILOVER, MMS2_ACTIVE_FAILOVER, MMS2_ENABLED_FAILOVER, we had to remove MMS2_SILO_FAILOVER because this data path will be ignored for Media Refresh
	INSERT	INTO MMDataPath
	SELECT	@l_newCopyId, DrivePoolId, HostClientId, (Flag & 7), SpareGroupId, ReadinessFlag, Priority, IsHardwareCompressed,
			ChunkSizeMB, FlushBlockSizeKB, UseHardwareEncryption
	FROM	MMDataPath
	WHERE	CopyId = @i_srcCopyId
	INSERT	INTO archStream
	SELECT	archGroupId, @l_newCopyId, stream, 0, 1, 0, 0, 0
	FROM	archStream
	WHERE	archGroupCopyId = @i_srcCopyId
	INSERT	INTO #tempMediaGroupName
	SELECT	mediaGroupId, stream,
			'AG[' + CAST(archGroupId AS varchar(8)) + ']_AGC[' + CAST(@l_newCopyId AS varchar(8)) + ']_stream[' + CAST(stream AS varchar(8)) + ']'
	FROM	archStream
	WHERE	archGroupCopyId = @i_srcCopyId
	INSERT	INTO MMMediaGroup
	SELECT	b.mediaGroupName, a.DrivePoolId, a.SpareGroupId, a. DesiredMediaTypeId, a.RecordingFormatId, 0
	FROM	MMMediaGroup a, #tempMediaGroupName b
	WHERE	a.MediaGroupId = b.oldMediaGroupId
	UPDATE archStream SET mediaGroupId = c.MediaGroupId
	FROM   archStream a, #tempMediaGroupName b, MMMediaGroup c
	WHERE  a.archGroupCopyId = @l_newCopyId AND a.stream = b.stream AND b.mediaGroupName = c.MediaGroupName
	IF EXISTS ( SELECT * FROM archGroup WITH (NOLOCK) WHERE defaultCopy =  @i_srcCopyId)
	BEGIN
		IF EXISTS ( SELECT * FROM archGroupCopy WITH (NOLOCK) WHERE id = @i_srcCopyId AND maxMultiplex > 0)
		BEGIN
			UPDATE T
SET T.flags = T.flags | (2 + 4)
			FROM archGroupcopy T, archCopyMediarefreshProp S WITH (NOLOCK)
			WHERE S.copyid = @i_srcCopyId AND
T.id = S.targetCopyId AND T.type = 5
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET	@retVal = (SELECT ERROR_NUMBER())
END CATCH
FINISH:
DROP TABLE #tempMediaGroupName
SELECT @retVal, @l_newCopyId
RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archTransitiveCopyCreate')
	delete from GxQscripts where name = 'archTransitiveCopyCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archTransitiveCopyCreate')
	delete from GXDBVersions where aliasname = 'archTransitiveCopyCreate'
GO

insert into GXDBVersions values(2, 'archTransitiveCopyCreate',  '00010020004200060000', 'archTransitiveCopyCreate', '00010020004200060000')
GO

