

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archToBeVerifiedMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archToBeVerifiedMedia.sp,v $ $Id: archToBeVerifiedMedia.sp,v 1.8.208.3 2018/03/22 00:59:38 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "archToBeVerifiedMedia"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archToBeVerifiedMedia <<<'

IF EXISTS (select * from sysobjects where name='archToBeVerifiedMedia')
	drop procedure archToBeVerifiedMedia
IF EXISTS (select * from GxQscripts where name='archToBeVerifiedMedia')
	delete from GxQscripts where name = 'archToBeVerifiedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archToBeVerifiedMedia')
	delete from GXDBVersions where aliasname = 'archToBeVerifiedMedia'
GO
print '... Creating Procedure: archToBeVerifiedMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archToBeVerifiedMedia
  @i_spId integer,
  @i_copyId integer
AS
  DECLARE @o_policyId integer
  DECLARE @o_policyName NVARCHAR(256)
  DECLARE @o_copyId integer
  DECLARE @o_copyName NVARCHAR(64)
  DECLARE @o_streamNum integer
  DECLARE @o_mediaGroupId integer
  DECLARE @o_mediaId integer
  DECLARE @o_uniqueId char(300)
  DECLARE @o_barCode char(256)
  DECLARE @o_attributes integer
  DECLARE @o_guiAttributes integer
  DECLARE @o_libraryId integer
  DECLARE @o_libraryName NVARCHAR(128)
  DECLARE @o_locationType integer
  DECLARE @o_locationId integer
  DECLARE @o_location NVARCHAR(1024)
  DECLARE @o_bytes bigint
  DECLARE @o_reason integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @tblCopy TABLE (copyId int, archGroupId int, name nvarchar(64))
DECLARE @tblVolume TABLE (
	volumeId int, mediaId int, mediaSideId int, mediaGroupId int, commCellId int,
	CreationTime int, SIDBStoreId int, SiloStatus int, firstChunkId bigint, physicalSize bigint)
DECLARE @tblMedia TABLE (
	mediaId int, mediaSideId int, mediaGroupId int, commCellId int,	firstChunkId bigint, bytes bigint)
DECLARE @tblMediaLocation TABLE (
mediaId int, uniqueId varchar(300), barCode varchar(256), mediaTypeId int, attributes int,
libraryId int, locationType int, locationId int, location nvarchar(1024))
INSERT INTO @tblCopy
SELECT	id, archGroupId, name
FROM	archGroupCopy WITH (NOLOCK)
WHERE	@i_copyId = 0 AND archGroupId = @i_spId
	OR	@i_copyId > 0 AND id = @i_copyId
INSERT INTO @tblVolume
SELECT	V.VolumeId, V.MediaId, V.MediaSideId, V.MediaGroupId, ACM.chunkCommCellId, V.CreationTime, V.SIDBStoreId, V.SiloStatus,
		MIN(ACM.archChunkId), SUM(ACM.physicalSize)
FROM	@tblCopy C, archChunkMapping ACM WITH (NOLOCK),
		archChunk AC WITH (NOLOCK), MMVolume V WITH (NOLOCK)
WHERE	ACM.archCopyId = C.copyId AND (ACM.flags & (1+8)) <> 0 AND (ACM.flags & 256) = 0
	AND	AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
	AND V.VolumeId = AC.volumeId
GROUP BY V.VolumeId, V.MediaId, V.MediaSideId, V.MediaGroupId, ACM.chunkCommCellId, V.CreationTime, V.SIDBStoreId, V.SiloStatus
-- Get media for SILO Restore
CREATE	TABLE #SiloVol (CopyId INT, VolumeId INT, SIDBStoreId INT, CreationTime INT)
INSERT	INTO #SiloVol
SELECT	0, 0, SIDBStoreId, MAX(CreationTime)
FROM	@tblVolume
WHERE	SIDBStoreId > 0 AND SiloStatus = 3 /*SILO_VOLUME_MIGRATED_OFFDISK*/
GROUP BY SIDBStoreId
IF @@ROWCOUNT > 0
BEGIN
	EXEC archMediaForSiloViatable 0, 0
	INSERT	INTO @tblVolume
	SELECT	V.VolumeId, V.MediaId, V.MediaSideId, V.MediaGroupId, V.origCCcommCellId,
			V.CreationTime, V.SIDBStoreId, V.SiloStatus, 0, 0
	FROM	#SiloVol T, MMVolume V WITH (READUNCOMMITTED)
	WHERE	T.VolumeId = V.VolumeId AND T.VolumeId > 0
END
DROP TABLE #SiloVol
INSERT	INTO @tblMedia
SELECT	MediaId, MediaSideId, MediaGroupId, commCellId, MIN(firstChunkId), SUM(physicalSize)
FROM	@tblVolume
GROUP BY MediaId, MediaSideId, MediaGroupId, commCellId
INSERT INTO @tblMediaLocation
SELECT	DISTINCT M.MediaId, M.UniqueId, M.BarCode, M.MediaTypeId, M.Attributes, M.LibraryId, M.MediaLocation,
		(case M.MediaTypeId
when 10001 then MP.MountPathId
		else (case M.MediaLocation
			when 1 then (SELECT SlotId  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
			when 2 then (SELECT DriveId FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
			else M.ExportLocationId
			end)
		end),
		(case M.MediaTypeId
when 10001 then MP.MountPathName
		else
			(case M.MediaLocation
			when 1 then (SELECT SlotName  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
			when 2 then (SELECT AliasName FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
			else ISNULL((SELECT ExportLocation FROM MMExportLocation WHERE ExportLocationId = M.ExportLocationId), '') end)
		end)
FROM   @tblMedia M1
			inner join MMMedia M WITH (NOLOCK) on M.MediaId = M1.MediaId
			left outer join MMS2getMountPathNameGUIView MP on MP.MediaId = M.MediaId
SELECT	@i_spId, (SELECT name FROM archGroup WITH (NOLOCK) WHERE id = @i_spId),
		C.copyId, C.name,
		S.stream, S.mediaGroupId,
		ML.mediaId, ML.uniqueId,
(case when ML.mediaTypeId = 10001 then 'Magnetic' else ML.barCode end),     ---MR 18703
		ML.attributes, dbo.MMS2FUNC_GetGUIMediaAttribute(ml.mediaId),
		ML.libraryId, (SELECT AliasName FROM MMLibrary WHERE LibraryId = ML.libraryId),
		ML.locationType, ML.locationId, ML.location, M.bytes, 0
FROM 	@tblMedia M, @tblMediaLocation ML, @tblCopy C, archStream S WITH (NOLOCK)
WHERE	M.MediaId = ML.MediaId
	AND S.mediaGroupId = M.mediaGroupId
	AND C.copyId = S.archGroupCopyId
ORDER BY S.archGroupCopyId, S.stream, M.commCellId, M.firstChunkId
GO

IF EXISTS (select * from GxQscripts where name = 'archToBeVerifiedMedia')
	delete from GxQscripts where name = 'archToBeVerifiedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archToBeVerifiedMedia')
	delete from GXDBVersions where aliasname = 'archToBeVerifiedMedia'
GO

insert into GXDBVersions values(2, 'archToBeVerifiedMedia',  '00010008020800030000', 'archToBeVerifiedMedia', '00010008020800030000')
GO

