

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archToBeRefreshedMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archToBeRefreshedMedia.sp,v $ $Id: archToBeRefreshedMedia.sp,v 1.7.2.3 2018/03/22 01:18:28 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archToBeRefreshedMedia <<<'

IF EXISTS (select * from sysobjects where name='archToBeRefreshedMedia')
	drop procedure archToBeRefreshedMedia
IF EXISTS (select * from GxQscripts where name='archToBeRefreshedMedia')
	delete from GxQscripts where name = 'archToBeRefreshedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archToBeRefreshedMedia')
	delete from GXDBVersions where aliasname = 'archToBeRefreshedMedia'
GO
print '... Creating Procedure: archToBeRefreshedMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archToBeRefreshedMedia
  @i_spId integer,
  @i_copyId integer,
  @i_daysInAdvance integer
AS
  DECLARE @o_policyId integer
  DECLARE @o_policyName NVARCHAR(256)
  DECLARE @o_copyId integer
  DECLARE @o_copyName NVARCHAR(64)
  DECLARE @o_streamNum integer
  DECLARE @o_mediaGroupId integer
  DECLARE @o_mediaId integer
  DECLARE @o_uniqueId char(300)
  DECLARE @o_barCode char(256)
  DECLARE @o_attributes integer
  DECLARE @o_guiAttributes integer
  DECLARE @o_libraryId integer
  DECLARE @o_libraryName NVARCHAR(128)
  DECLARE @o_locationType integer
  DECLARE @o_locationId integer
  DECLARE @o_location NVARCHAR(1024)
  DECLARE @o_validDataBytes bigint
  DECLARE @o_reason integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
CREATE TABLE #VolForReport (
		copyId int, stream int, mediaGroupId int, volumeId int, mediaId int, volAttributes int)
DECLARE @tblMedia TABLE (
		copyId int, stream int, mediaGroupId int, mediaId int, volAttributes int, dataSize bigint, minChunkId bigint)
DECLARE @tblMediaLocation TABLE (
mediaId int, uniqueId varchar(300), barCode varchar(256), mediaTypeId int, attributes int,
libraryId int, locationType int, locationId int, location nvarchar(1024))
IF object_id('tempdb.dbo.#TmpMRDepMediaUI') IS  NOT null DROP TABLE #TmpMRDepMediaUI
IF object_id('tempdb.dbo.#TmpMRDepMediaResultSet') IS  NOT null DROP TABLE #TmpMRDepMediaResultSet
CREATE TABLE #TmpMRDepMediaUI(VolumeId INT)
CREATE TABLE #TmpMRDepMediaResultSet(BucketId INT, VolumeId INT, VolumeFlags INT,VolumeAttributes INT, MediaId INT, MediaLocation INT, MediaFlags INT)
CREATE INDEX VolForReport_idx1 ON #VolForReport(VolumeId)
CREATE INDEX TmpMRDepMediaResultSet_idx1 ON #TmpMRDepMediaResultSet(VolumeId)
CREATE INDEX TmpMRDepMediaResultSet_idx2 ON #TmpMRDepMediaResultSet(bucketId)
EXEC archMediaRefreshingQualifyMedia @i_spId, @i_copyId, @i_daysInAdvance
-- for volumes which have already been marked as qualified
INSERT INTO #VolForReport
OUTPUT inserted.volumeId INTO #TmpMRDepMediaUI
SELECT	S.archGroupCopyId, S.stream, S.mediaGroupId, V.VolumeId, V.MediaId, V.Attributes
FROM 	archGroupCopy C WITH (NOLOCK), archStream S WITH (NOLOCK), MMVolume V WITH (NOLOCK)
WHERE	V.MediaGroupId = S.mediaGroupId
	AND S.archGroupId = @i_spId AND (@i_copyId = 0 OR S.archGroupCopyId = @i_copyId)
AND C.id = S.archGroupCopyId AND (C.flags & 33554432) <> 0
	AND V.VolumeFlags = 2 /*VOL_FULL*/
	AND V.RecordingFormatId <> 10001
AND (V.Attributes & (8 | 16)) = 8
EXEC archMediaRefreshGetDependentMedia
INSERT INTO #VolForReport
SELECT	 DISTINCT V.copyId, V.stream, V.mediaGroupId, T1.VolumeId, T1.MediaId, T1.VolumeAttributes
FROM 	(#TmpMRDepMediaResultSet T1 LEFT OUTER JOIN  #VolForReport V2 on V2.volumeID = T1.volumeID )INNER JOIN  (#TmpMRDepMediaResultSet T
INNER JOIN #VolForReport V ON
	 T.VolumeId = V.volumeId) ON T1.BucketId = T.BucketId
WHERE V2.volumeId IS NULL
INSERT INTO @tblMedia
SELECT	V.copyId, V.stream, V.mediaGroupId, V.MediaId, MAX(V.volAttributes), SUM(ACM.physicalSize), MIN(archChunkId)
FROM	#VolForReport V, archChunk AC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK)
WHERE	AC.volumeId = V.volumeId AND (AC.flags & 256) = 0
		AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
AND (ACM.flags & 256) = 0
GROUP BY V.copyId, V.stream, V.mediaGroupId, V.MediaId
INSERT INTO @tblMediaLocation
SELECT	DISTINCT M.MediaId, M.UniqueId, M.BarCode, M.MediaTypeId, M.Attributes, M.LibraryId, M.MediaLocation,
		(case M.MediaLocation
		when 1 then (SELECT SlotId  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
		when 2 then (SELECT DriveId FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
		else M.ExportLocationId
		end),
		(case M.MediaLocation
		when 1 then (SELECT SlotName  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
		when 2 then (SELECT AliasName FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
		else ISNULL((SELECT ExportLocation FROM MMExportLocation WHERE ExportLocationId = M.ExportLocationId), '')
		end)
FROM	@tblMedia T, MMMedia AS M WITH (NOLOCK)
WHERE	M.MediaId = T.MediaId
SELECT	@i_spId AS policyId, (SELECT name FROM archGroup WITH (NOLOCK) WHERE id = @i_spId) AS policyName,
		M.copyId, (SELECT name FROM archGroupCopy WITH (NOLOCK) WHERE id = M.copyId) AS copyName,
		M.stream, M.mediaGroupId, ML.mediaId, ML.uniqueId, ML.barCode,
		ML.attributes, dbo.MMS2FUNC_GetGUIMediaAttribute(ml.mediaId) AS guiAttributes,
		ML.libraryId, (SELECT AliasName FROM MMLibrary WHERE LibraryId = ML.libraryId) AS libraryName,
ML.locationType, ML.locationId, ML.location, M.dataSize, (M.volAttributes & 472)
FROM 	@tblMedia M, @tblMediaLocation ML
WHERE	M.MediaId = ML.MediaId
ORDER BY M.copyId, M.stream, M.minChunkId
DROP TABLE #VolForReport
IF object_id('tempdb.dbo.#TmpMRDepMediaUI') IS  NOT NULL DROP TABLE #TmpMRDepMediaUI
IF object_id('tempdb.dbo.#TmpMRDepMediaResultSet') IS  NOT NULL DROP TABLE #TmpMRDepMediaResultSet
GO

IF EXISTS (select * from GxQscripts where name = 'archToBeRefreshedMedia')
	delete from GxQscripts where name = 'archToBeRefreshedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archToBeRefreshedMedia')
	delete from GXDBVersions where aliasname = 'archToBeRefreshedMedia'
GO

insert into GXDBVersions values(2, 'archToBeRefreshedMedia',  '00010007000200030000', 'archToBeRefreshedMedia', '00010007000200030000')
GO

