

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archToBeContentIndexedMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archToBeContentIndexedMedia.sp,v $ $Id: archToBeContentIndexedMedia.sp,v 1.17.34.3 2018/03/22 01:15:47 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archToBeContentIndexedMedia <<<'

IF EXISTS (select * from sysobjects where name='archToBeContentIndexedMedia')
	drop procedure archToBeContentIndexedMedia
IF EXISTS (select * from GxQscripts where name='archToBeContentIndexedMedia')
	delete from GxQscripts where name = 'archToBeContentIndexedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archToBeContentIndexedMedia')
	delete from GXDBVersions where aliasname = 'archToBeContentIndexedMedia'
GO
print '... Creating Procedure: archToBeContentIndexedMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archToBeContentIndexedMedia
  @i_archGroupId integer
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
CREATE TABLE #CI_Client(clientId INT)
DECLARE	@tblCopyMA	TABLE (
	CopyId int, HostClientId int)
DECLARE	@tblAPP		TABLE (
	appId int, appTypeId int, clientId int)
DECLARE	@tblClient	TABLE (
	clientId int, needPassPhrase int)
DECLARE	@tblAFC		TABLE (
	jobId int, appId int, archFileId int, commCellId int, archCopyId int,
	encKeyType int, encRSA int, flags int, copyPrec int,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
DECLARE @tblChunk TABLE (
	volumeId int, archChunkId bigint, commCellId int, physicalSize bigint)
DECLARE @tblVolume TABLE (
	volumeId int, mediaId int, mediaSideId int, mediaGroupId int, commCellId int,
	CreationTime int, SIDBStoreId int, SiloStatus int, firstChunkId bigint, physicalSize bigint)
DECLARE @tblMedia	TABLE (
	mediaId int, mediaSideId int, mediaGroupId int, commCellId int,	firstChunkId bigint, bytes bigint)
DECLARE @tblMediaLocation TABLE (
mediaId int, uniqueId varchar(300), barCode varchar(256), mediaTypeId int, attributes int,
libraryId int, locationType int, locationId int, location nvarchar(1024))
DECLARE	@l_cloudId int
DECLARE @l_enabled int
DECLARE @l_srcCopyId int
DECLARE @l_agId int
DECLARE @l_agcId int
SELECT	@l_cloudId = cloudId, @l_enabled = enabled, @l_srcCopyId = sourceCopyId
FROM	archContentIndexingRules WITH (NOLOCK)
WHERE	archGroupId = @i_archGroupId AND operationType = 1
IF @@ROWCOUNT = 0 OR @l_cloudId = 0 OR @l_enabled = 0
	GOTO FINISH
IF @l_srcCopyId = 0
	INSERT	INTO @tblCopyMA
	SELECT	DISTINCT CopyId, HostClientId
	FROM	MMDataPath WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE	MMDataPath.CopyId = AGC.id AND AGC.archGroupId = @i_archGroupId
ELSE
	INSERT	INTO @tblCopyMA
	SELECT	DISTINCT CopyId, HostClientId
	FROM	MMDataPath WITH (NOLOCK)
	WHERE	MMDataPath.CopyId = @l_srcCopyId
-- Exclude copies which do not have a datapath for Windows MA. Only Content Indexing on a Windows Media Agent is supported.
DELETE	@tblCopyMA
FROM	@tblCopyMA MA, APP_Client CLNT WITH (NOLOCK), simOperatingSystem SOS WITH (NOLOCK) --simSystemOS SOS WITH (NOLOCK), simOS OS WITH (NOLOCK)
WHERE	CLNT.id = MA.HostClientId
--	AND SOS.id = CLNT.simSystemOSId
--	AND OS.id = SOS.simOSId AND OS.type <> 6
	AND SOS.id = CLNT.simOperatingSystemId AND SOS.type <> 'Windows'
INSERT INTO @tblAFC
SELECT	AF.jobId, AF.appId, AFC.archFileId, AFC.commCellId, AFC.archCopyId,	AFC.encKeyType, AFC.encRSA, AFC.flags, 0
FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
WHERE	AF.archGroupId = @i_archGroupId AND AF.fileType = 1
AND AF.flags & (16 + 32) <> 0
	AND AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
AND AFC.isValid > 0 AND AFC.flags & 256 = 0
	AND AFC.archCopyId IN (SELECT DISTINCT CopyId FROM @tblCopyMA)
-- Check if Content Indexing Enabled at client level.
INSERT	INTO #CI_Client
EXEC	archContentIndexingClients @i_archGroupId
INSERT INTO @tblAPP
SELECT	APP.id, APP.appTypeId, APP.clientId
FROM	(SELECT DISTINCT appId FROM @tblAFC) AFC,
		APP_Application APP WITH (NOLOCK), #CI_Client CL
WHERE	APP.id = AFC.appId
	AND APP.clientId = CL.clientId
-- Remove encrypted archive files which need user pass phrase for decrypting the key
INSERT	INTO @tblClient
SELECT	DISTINCT clientId, 0
FROM	@tblAFC AFC, @tblAPP APP
WHERE	AFC.encKeyType > 0 AND (AFC.encRSA & 1) > 0
	AND AFC.appId = APP.appId
UPDATE	@tblClient
SET		needPassPhrase = CONVERT(int, b.attrVal)
FROM	@tblClient a, APP_ClientProp b
WHERE	b.ComponentNameId = a.clientId
	AND b.attrName = N'Encrypt: restoreAccess'
	AND b.modified = 0
DELETE	@tblAFC
FROM	@tblAFC AFC, @tblAPP APP, @tblClient CL
WHERE	AFC.encKeyType > 0 AND (AFC.encRSA & 1) > 0
	AND AFC.appId = APP.appId
	AND APP.clientId = CL.clientId
	AND CL.needPassPhrase = 1
IF @l_srcCopyId = 0
BEGIN
	-- Prefer non-encrypted archive files
	DELETE	@tblAFC
	FROM	@tblAFC a,
			(SELECT archFileId, commCellId FROM @tblAFC WHERE encKeyType = 0) b
	WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.encKeyType <> 0
	-- Prefer magnetic archive files
	DELETE	@tblAFC
	FROM	@tblAFC a,
(SELECT archFileId, commCellId FROM @tblAFC WHERE (flags & 2) <> 0) b
WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND (a.flags & 2) = 0
	UPDATE	@tblAFC
	SET		copyPrec = AGC.copy
	FROM	@tblAFC AFC, archGroupCopy AGC WITH (NOLOCK)
	WHERE	AFC.archCopyId = AGC.id
	--Delete all the chunks on transitive copy
	DELETE	@tblAFC
	FROM	@tblAFC AFC, archGroupCopy AGC WITH (NOLOCK)
	WHERE	AFC.archCopyId = AGC.id
			AND AGC.type = 5 -- KEEP only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
	-- Apply copy precedence
	DELETE	@tblAFC
	FROM	@tblAFC a,
			(SELECT archFileId, commCellId, MIN(copyPrec) AS copyPrec FROM @tblAFC GROUP BY archFileId, commCellId) b
	WHERE	a.archFileId = b.archFileId AND a.commCellId = b.commCellId AND a.copyPrec > b.copyPrec
END
INSERT INTO @tblChunk
SELECT	0, ACM.archChunkId, ACM.chunkCommCellId, SUM(ACM.physicalSize)
FROM	@tblAFC AFC
		INNER JOIN archChunkMapping ACM WITH (NOLOCK)
			ON ACM.archFileId = AFC.archFileId AND ACM.commCellId = AFC.commCellId AND ACM.archCopyId = AFC.archCopyId
		INNER JOIN archChunk AC WITH (NOLOCK)
			ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
		LEFT OUTER JOIN archContentIndexingRestart R
ON R.archFileId = ACM.archFileId AND R.commCellId = ACM.commCellId AND R.operationType = 1
WHERE	R.archFileId IS NULL OR (ACM.physicalOffset + ACM.physicalSize) > R.physicalOffset
GROUP BY ACM.archChunkId, ACM.chunkCommCellId
UPDATE	@tblChunk SET volumeId = AC.volumeId
FROM	@tblChunk T, archChunk AC WITH (NOLOCK)
WHERE	AC.id = T.archChunkId AND AC.commCellId = T.commCellId
INSERT INTO @tblVolume
SELECT	V.VolumeId, V.MediaId, V.MediaSideId, V.MediaGroupId, T.commCellId,
		V.CreationTime, V.SIDBStoreId, V.SiloStatus, T.firstChunkId, T.physicalSize
FROM 	(SELECT	commCellId, volumeId,
				MIN(archChunkId) AS firstChunkId, MAX(physicalSize) AS physicalSize
		FROM	@tblChunk
		GROUP BY commCellId, volumeId) T, MMVolume V WITH (NOLOCK)
WHERE	T.volumeId = V.VolumeId
-- Get media for SILO Restore
CREATE	TABLE #SiloVol (CopyId INT, VolumeId INT, SIDBStoreId INT, CreationTime INT)
INSERT	INTO #SiloVol
SELECT	0, 0, SIDBStoreId, MAX(CreationTime)
FROM	@tblVolume
WHERE	SIDBStoreId > 0 AND SiloStatus = 3 /*SILO_VOLUME_MIGRATED_OFFDISK*/
GROUP BY SIDBStoreId
IF @@ROWCOUNT > 0
BEGIN
	EXEC archMediaForSiloViatable 0, 0
	INSERT	INTO @tblVolume
	SELECT	V.VolumeId, V.MediaId, V.MediaSideId, V.MediaGroupId, V.origCCcommCellId,
			V.CreationTime, V.SIDBStoreId, V.SiloStatus, 0, 0
	FROM	#SiloVol T, MMVolume V WITH (READUNCOMMITTED)
	WHERE	T.VolumeId = V.VolumeId AND T.VolumeId > 0
END
DROP TABLE #SiloVol
INSERT	INTO @tblMedia
SELECT	MediaId, MediaSideId, MediaGroupId, commCellId, MIN(firstChunkId), SUM(physicalSize)
FROM	@tblVolume
GROUP BY MediaId, MediaSideId, MediaGroupId, commCellId
INSERT INTO @tblMediaLocation
SELECT	DISTINCT M.MediaId, M.UniqueId, M.BarCode, M.MediaTypeId, M.Attributes, M.LibraryId, M.MediaLocation,
		(case M.MediaTypeId
when 10001 then MP.MountPathId
		else (case M.MediaLocation
			when 1 then (SELECT SlotId  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
			when 2 then (SELECT DriveId FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
			else M.ExportLocationId
			end)
		end),
		(case M.MediaTypeId
when 10001 then MP.MountPathName
		else
			(case M.MediaLocation
			when 1 then (SELECT SlotName  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
			when 2 then (SELECT AliasName FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
			else ISNULL((SELECT ExportLocation FROM MMExportLocation WHERE ExportLocationId = M.ExportLocationId), '') end)
		end)
FROM	@tblMedia M1, MMMedia M WITH (NOLOCK), MMS2getMountPathNameGUIView MP WITH (NOLOCK)
WHERE	M.MediaId = M1.MediaId
		AND MP.MediaId = M.MediaId
FINISH:
-- Temp table #AdminJobMedia must be created by the caller
INSERT	INTO #AdminJobMedia
SELECT	(case when (S.flags & 2) = 0 then S.ArchGroupId else (select archGroupId from archStream WITH (NOLOCK) where MediaGroupId = S.mediaGroupId and (flags & 2) = 0) end),
(SELECT name FROM archGroup WITH (NOLOCK) WHERE id = (case when (S.flags & 2) = 0 then S.ArchGroupId else (select archGroupId from archStream WITH (NOLOCK) where MediaGroupId = S.mediaGroupId and (flags & 2) = 0) end)),
(case when (S.flags & 2) = 0 then S.ArchGroupCopyId else (select archGroupCopyId from archStream WITH (NOLOCK) where MediaGroupId = S.mediaGroupId and (flags & 2) = 0) end),
(SELECT name FROM archGroupCopy WITH (NOLOCK) WHERE id = (case when (S.flags & 2) = 0 then S.archGroupCopyId else (select archGroupCopyId from archStream WITH (NOLOCK) where MediaGroupId = S.mediaGroupId and (flags & 2) = 0) end)),
		S.stream, S.mediaGroupId,
		ML.mediaId, ML.uniqueId,
(case when ML.mediaTypeId = 10001 then 'Magnetic' else ML.barCode end),      ---MR 18703
		ML.attributes, dbo.MMS2FUNC_GetGUIMediaAttribute(ml.mediaId),
		ML.libraryId, (SELECT AliasName FROM MMLibrary WHERE LibraryId = ML.libraryId),
		ML.locationType, ML.locationId, ML.location, M.bytes, 0
FROM 	@tblMedia M, @tblMediaLocation ML, archStream S WITH (NOLOCK)
WHERE	M.MediaId = ML.MediaId
	AND S.mediaGroupId = M.mediaGroupId
ORDER BY S.archGroupCopyId, S.stream, M.commCellId, M.firstChunkId
DROP TABLE #CI_Client
GO

IF EXISTS (select * from GxQscripts where name = 'archToBeContentIndexedMedia')
	delete from GxQscripts where name = 'archToBeContentIndexedMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archToBeContentIndexedMedia')
	delete from GXDBVersions where aliasname = 'archToBeContentIndexedMedia'
GO

insert into GXDBVersions values(2, 'archToBeContentIndexedMedia',  '00010017003400030000', 'archToBeContentIndexedMedia', '00010017003400030000')
GO

