

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archStreamCreate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archStreamCreate.sp,v $ $Id: archStreamCreate.sp,v 1.12.60.2 2018/03/22 01:10:53 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archStreamCreate <<<'

IF EXISTS (select * from sysobjects where name='archStreamCreate')
	drop procedure archStreamCreate
IF EXISTS (select * from GxQscripts where name='archStreamCreate')
	delete from GxQscripts where name = 'archStreamCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archStreamCreate')
	delete from GXDBVersions where aliasname = 'archStreamCreate'
GO
print '... Creating Procedure: archStreamCreate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archStreamCreate
  @i_archGroupId int,
  @i_archGroupCopyId int,
  @i_isPrimaryCopy int,
  @i_maxStream int,
  @i_streamFlags int,
  @i_drivePoolId int,
  @i_spareMediaGroupId int,
  @i_desiredMediaTypeId int,
  @i_recordingFormatId int,
  @i_archGroupCopyExtFlags bigint = 0,
  @i_destMediaCopyId int = 0
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@l_lastStream	int
DECLARE	@l_mediaGroupId	int
DECLARE @l_maxGACPStreams	int
SET @l_lastStream		= 0
SET @l_mediaGroupId		= 0
DECLARE	@l_MRlastStream	int
DECLARE	@l_MRmediaGroupId	int
SET @l_MRlastStream		= 0
SET @l_MRmediaGroupId	= 0
SET @retVal = 0
IF ((@i_archGroupCopyExtFlags & 2) > 0)
BEGIN
	SELECT @l_maxGACPStreams = count(*) FROM archStream where archGroupCopyId = @i_destMediaCopyId
	IF (@i_maxStream > @l_maxGACPStreams)
	BEGIN
SET @retVal = 109
		GOTO FINISH
	END
END
BEGIN TRY
	SELECT	TOP 1 @l_lastStream = stream, @l_mediaGroupId = mediaGroupId
	FROM	archStream
	WHERE	archGroupCopyId = @i_archGroupCopyId --AND stream < CVA_SILO_STREAM_OFFSET
AND		(Flags & 1) = 0
	ORDER BY stream DESC
IF ((@i_archGroupCopyExtFlags & 2) > 0)
	BEGIN
SET @i_streamFlags = @i_streamFlags | 2
	END
	DECLARE @l_targetCopyId INTEGER
	SET @l_targetCopyId  = 0
	SELECT @l_targetCopyId = R.targetCopyId
	FROM archCopyMediaRefreshProp R
	WHERE	R.CopyId = @i_archGroupCopyId
	IF @l_targetCopyId > 0
	BEGIN
		SELECT	TOP 1 @l_MRlastStream = stream, @l_MRmediaGroupId = mediaGroupId
		FROM	archStream
		WHERE	archGroupCopyId = @l_targetCopyId --AND stream < CVA_SILO_STREAM_OFFSET
AND		(Flags & 1) = 0
		ORDER BY stream DESC
	END
	IF	@l_lastStream < @i_maxStream
	BEGIN
		-- Create more streams
		IF	@i_drivePoolId = 0 AND @l_lastStream > 0 AND @l_mediaGroupId > 0
			SELECT	@i_drivePoolId = DrivePoolId,
					@i_spareMediaGroupId = SpareGroupId,
					@i_desiredMediaTypeId = DesiredMediaTypeId,
					@i_recordingFormatId = RecordingFormatId
			FROM	MMMediaGroup
			WHERE	MediaGroupId = @l_mediaGroupId
		WHILE	@l_lastStream < @i_maxStream
		BEGIN
			SET @l_lastStream = (@l_lastStream + 1)
			DECLARE @mgId int
			DECLARE @MRmgId int
IF ((@i_archGroupCopyExtFlags & 2) = 0)
			BEGIN
			    INSERT	INTO MMMediaGroup
			    SELECT	'AG[' + CAST(@i_archGroupId AS varchar(8)) +
				']_AGC[' + CAST(@i_archGroupCopyId AS varchar(8)) +
				']_stream[' + CAST(@l_lastStream AS varchar(8)) + ']',
				@i_drivePoolId, @i_spareMediaGroupId, @i_desiredMediaTypeId, @i_recordingFormatId, 0
				SET @mgId = SCOPE_IDENTITY()
				IF @l_targetCopyId > 0
				BEGIN
					SET @l_MRlastStream = (@l_MRlastStream + 1)
					INSERT	INTO MMMediaGroup
					SELECT	'AG[' + CAST(@i_archGroupId AS varchar(8)) +
					']_AGC[' + CAST(@l_targetCopyId AS varchar(8)) +
					']_stream[' + CAST(@l_MRlastStream AS varchar(8)) + ']',
					@i_drivePoolId, @i_spareMediaGroupId, @i_desiredMediaTypeId, @i_recordingFormatId, 0
					SET @MRmgId = SCOPE_IDENTITY()
				END
			END
			ELSE
			BEGIN
				SELECT @mgId = mediaGroupId FROM archStream WHERE archGroupCopyId = @i_destMediaCopyId and stream = @l_lastStream
			END
			INSERT	INTO archStream
			SELECT	@i_archGroupId, @i_archGroupCopyId, @l_lastStream, @mgId, 1, 0, 0, @i_streamFlags
			IF @l_targetCopyId > 0
			BEGIN
				INSERT	INTO archStream
				SELECT	@i_archGroupId, @l_targetCopyId, @l_MRlastStream, @MRmgId, 1, 0, 0, @i_streamFlags
			END
		END
	END
	IF @i_isPrimaryCopy > 0
		UPDATE	archStream
		SET		isActive = (case when stream > @i_maxStream then 0 else 1 end)
		WHERE	archGroupCopyId = @i_archGroupCopyId
		AND		(stream > @i_maxStream AND isActive <> 0 OR stream <= @i_maxStream AND isActive = 0)
AND		(Flags & 1) = 0
	ELSE
		UPDATE	archStream
		SET		isActive = 1
		WHERE	archGroupCopyId = @i_archGroupCopyId
		AND		isActive = 0
AND		(Flags & 1) = 0
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET	@retVal = (SELECT ERROR_NUMBER())
END CATCH
FINISH:
SELECT @retVal
RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archStreamCreate')
	delete from GxQscripts where name = 'archStreamCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archStreamCreate')
	delete from GXDBVersions where aliasname = 'archStreamCreate'
GO

insert into GXDBVersions values(2, 'archStreamCreate',  '00010012006000020000', 'archStreamCreate', '00010012006000020000')
GO

