

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archSourceMediaForAdminJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archSourceMediaForAdminJob.sp,v $ $Id: archSourceMediaForAdminJob.sp,v 1.17.2.3 2018/03/22 01:13:14 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "archSourceMediaForAdminJob"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archSourceMediaForAdminJob <<<'

IF EXISTS (select * from sysobjects where name='archSourceMediaForAdminJob')
	drop procedure archSourceMediaForAdminJob
IF EXISTS (select * from GxQscripts where name='archSourceMediaForAdminJob')
	delete from GxQscripts where name = 'archSourceMediaForAdminJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSourceMediaForAdminJob')
	delete from GXDBVersions where aliasname = 'archSourceMediaForAdminJob'
GO
print '... Creating Procedure: archSourceMediaForAdminJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archSourceMediaForAdminJob
  @i_archGroupId integer,
  @i_adminJobId integer,
  @i_jobType integer
AS
  DECLARE @o_policyId integer
  DECLARE @o_policyName NVARCHAR(256)
  DECLARE @o_copyId integer
  DECLARE @o_copyName NVARCHAR(64)
  DECLARE @o_streamNum integer
  DECLARE @o_mediaGroupId integer
  DECLARE @o_mediaId integer
  DECLARE @o_uniqueId char(300)
  DECLARE @o_barCode char(256)
  DECLARE @o_attributes integer
  DECLARE @o_guiAttributes integer
  DECLARE @o_libraryId integer
  DECLARE @o_libraryName NVARCHAR(128)
  DECLARE @o_locationType integer
  DECLARE @o_locationId integer
  DECLARE @o_location NVARCHAR(1024)
  DECLARE @o_uncopiedBytes bigint
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tblMedia') IS NOT NULL DROP TABLE #tblMedia
IF OBJECT_ID('tempdb.dbo.#tblMediaLocation') IS NOT NULL DROP TABLE #tblMediaLocation
IF OBJECT_ID('tempdb.dbo.#MediaGUIAttrTbl') IS NOT NULL DROP TABLE #MediaGUIAttrTbl
CREATE TABLE #tblMedia (
	commCellId int, archCopyId int, streamNum int, mediaId int, mediaSideId int, firstChunkId bigint, uncopiedBytes bigint)
CREATE TABLE #tblMediaLocation (
mediaId int, uniqueId varchar(300), barCode varchar(256), mediaTypeId int, attributes int,
libraryId int, locationType int, locationId int, location nvarchar(1024))
CREATE TABLE #MediaGUIAttrTbl (
	MediaId INT, MediaAttr INT)
-- From enum CVJobType in JobManager/cvjob.h
--	AUXCOPYJOB = 6,
--	ARCHCHECKJOB = 12,
--	OFFLINECONTENTINDEXINGJOB = 20
--	AUXCOPY2JOB = 37
DECLARE	@ShowAuxCopyJobDetailsInApplicationSize int = 0
SET		@ShowAuxCopyJobDetailsInApplicationSize = ISNULL((SELECT TOP 1 value FROM MMConfigs WHERE name = 'MMS2_CONFIG_STRING_AUXCOPY_DETAILS_IN_APPLICATION_SIZE'), 0)
IF (@ShowAuxCopyJobDetailsInApplicationSize < 0)
	SET	@ShowAuxCopyJobDetailsInApplicationSize = 0
IF @i_jobType = 6
BEGIN
	INSERT	INTO #tblMedia
	SELECT	C.commCellId, C.destCopyId, C.destStream, V.mediaId, V.MediaSideId, MIN(C.archChunkId), (CASE WHEN @ShowAuxCopyJobDetailsInApplicationSize = 1 THEN SUM(unCompBytesSize) ELSE SUM(C.physicalSize) END)
	FROM	archChunkToCopy C WITH (NOLOCK), MMVolume V WITH (NOLOCK)
	WHERE	adminJobId = @i_adminJobId AND V.VolumeId = C.volumeId
	GROUP BY C.commCellId, C.destCopyId, C.destStream, V.mediaId, V.MediaSideId
END
ELSE
IF @i_jobType = 12
BEGIN
	INSERT	INTO #tblMedia
	SELECT	C.commCellId, C.archCopyId, C.streamNum, V.mediaId, V.MediaSideId, MIN(C.archChunkId), (CASE WHEN @ShowAuxCopyJobDetailsInApplicationSize = 1 THEN SUM(unCompBytesSize) ELSE SUM(C.physicalSize) END)
	FROM	archChunkToVerify C WITH (NOLOCK), MMVolume V WITH (NOLOCK)
	WHERE	adminJobId = @i_adminJobId AND V.VolumeId = C.volumeId
	GROUP BY C.commCellId, C.archCopyId, C.streamNum, V.mediaId, V.MediaSideId
END
ELSE
IF @i_jobType = 20
BEGIN
	INSERT	INTO #tblMedia
	SELECT	C.commCellId, C.archCopyId, C.streamNum, V.mediaId, V.MediaSideId, MIN(C.archChunkId), SUM(C.physicalSize)
	FROM	archContentIndexingAF C WITH (NOLOCK), MMVolume V WITH (NOLOCK)
WHERE	archGroupId = @i_archGroupId AND V.VolumeId = C.volumeId AND C.operationType = 1
	GROUP BY C.commCellId, C.archCopyId, C.streamNum, V.mediaId, V.MediaSideId
END
IF @i_jobType = 37 --AUXCOPY2JOB
BEGIN
	INSERT	INTO #tblMedia
	SELECT	C.commCellId, C.DestCopyId, C.DestStreamNum, V.mediaId, V.MediaSideId, MIN(C.archChunkId), SUM(C.unCompBytesSize)
	FROM	archChunkToReplicate C WITH (NOLOCK), MMVolume V WITH (NOLOCK)
	WHERE	C.adminJobId = @i_adminJobId AND V.VolumeId = C.volumeId
AND C.Status IN (0, 3)
	GROUP BY C.commCellId, C.DestCopyId, C.DestStreamNum, V.mediaId, V.MediaSideId
END
INSERT INTO #tblMediaLocation
SELECT	DISTINCT M.MediaId, M.UniqueId, M.BarCode, M.MediaTypeId, M.Attributes, M.LibraryId, M.MediaLocation,
		(case M.MediaTypeId
when 10001 then MP.MountPathId
		else (case M.MediaLocation
			when 1 then (SELECT SlotId  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
			when 2 then (SELECT DriveId FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
			else M.MediaLocation
			end)
		end),
		(case M.MediaTypeId
when 10001 then MP.MountPathName
		else
			(case M.MediaLocation
			when 1 then (SELECT SlotName  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
			when 2 then (SELECT AliasName FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
			else '' end)
		end)
FROM	#tblMedia M1, MMMedia M WITH (NOLOCK) LEFT OUTER JOIN MMS2getMountPathNameGUIView MP WITH (NOLOCK) ON M.MediaId = MP.MediaId
WHERE	M.MediaId = M1.MediaId
INSERT INTO #MediaGUIAttrTbl (MediaId, MediaAttr)
SELECT	DISTINCT MediaId, 0
FROM	#tblMedia
UPDATE	#MediaGUIAttrTbl
SET		MediaAttr = dbo.MMS2FUNC_GetGUIMediaAttribute(mediaId)
SELECT	@i_archGroupId, (SELECT name FROM archGroup WITH (NOLOCK) WHERE id = @i_archGroupId),
		M.archCopyId, (SELECT name FROM archGroupCopy WITH (NOLOCK) WHERE id = M.archCopyId), M.streamNum,
		(SELECT mediaGroupId FROM archStream WITH (NOLOCK) WHERE archGroupCopyId = M.archCopyId AND stream = M.streamNum),
		ML.mediaId, ML.uniqueId,
(case when ML.mediaTypeId = 10001 then ML.location else ML.barCode end),
		ML.attributes, MA.MediaAttr,
		ML.libraryId, (SELECT AliasName FROM MMLibrary WITH (NOLOCK) WHERE LibraryId = ML.libraryId),
		ML.locationType, ML.locationId, ML.location, M.uncopiedBytes
FROM 	#tblMedia M, #tblMediaLocation ML, #MediaGUIAttrTbl MA
WHERE	M.MediaId = ML.MediaId
		AND M.MediaId = MA.MediaId
ORDER BY M.archCopyId, M.streamNum, M.commCellId, M.firstChunkId
IF OBJECT_ID('tempdb.dbo.#tblMedia') IS NOT NULL DROP TABLE #tblMedia
IF OBJECT_ID('tempdb.dbo.#tblMediaLocation') IS NOT NULL DROP TABLE #tblMediaLocation
GO

IF EXISTS (select * from GxQscripts where name = 'archSourceMediaForAdminJob')
	delete from GxQscripts where name = 'archSourceMediaForAdminJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSourceMediaForAdminJob')
	delete from GXDBVersions where aliasname = 'archSourceMediaForAdminJob'
GO

insert into GXDBVersions values(2, 'archSourceMediaForAdminJob',  '00010017000200030000', 'archSourceMediaForAdminJob', '00010017000200030000')
GO

