

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archSourceCopyList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archSourceCopyList.sp,v $ $Id: archSourceCopyList.sp,v 1.5.210.5 2020/12/16 21:28:04 chandru Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archSourceCopyList')
BEGIN
	print '>>> Drop Stored Procedure: archSourceCopyList <<<'
	drop procedure archSourceCopyList
END
IF EXISTS (select * from GxQscripts where name='archSourceCopyList')
	delete from GxQscripts where name = 'archSourceCopyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSourceCopyList')
	delete from GXDBVersions where aliasname = 'archSourceCopyList'
GO
print '... Creating Procedure: archSourceCopyList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archSourceCopyList
  @i_copyId integer
AS
  DECLARE @o_copyId integer;
  DECLARE @o_sourceCopyId integer;
  DECLARE @o_defaultCopyId integer;
  DECLARE @o_archGroupId integer;
  DECLARE @o_copyFlags integer;
  DECLARE @o_dedupeFlags integer;
  DECLARE @o_maxMultiplex integer;
  DECLARE @o_isSnapCopy integer;
  DECLARE @o_isMirrorCopy integer;
  DECLARE @o_SIBlockSize integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @l_archGroupId INT
DECLARE @l_defaultCopyId INT
DECLARE @l_defaultSIBlockSizeKB INT
DECLARE @tblSourceCopy AS TABLE ( copyId integer, sourceCopyId integer, defaultCopyId integer, archGroupId integer, copyFlags integer,
  dedupeFlags integer, maxMultiplex integer, isSnapCopy integer, isMirrorCopy integer, SIBlockSize integer)
SELECT	@l_archGroupId = a.id, @l_defaultCopyId = CASE b.isSnapCopy WHEN 0 THEN a.defaultCopy ELSE a.defaultSnapCopy END,
@l_defaultSIBlockSizeKB = a.SIBlockSizeKB
FROM	archGroup a WITH (NOLOCK), archGroupCopy b WITH (NOLOCK)
WHERE	a.id = b.archGroupId
AND		b.id = @i_copyId;
WITH SourceCopy_CTE AS
(
	SELECT	id, sourceCopyId, flags, dedupeFlags, maxMultiplex, isSnapCopy, isMirrorCopy
	FROM	archGroupCopy
	WHERE	id = @i_copyId
	UNION ALL
	SELECT	C.id, C.sourceCopyId, C.flags, C.dedupeFlags, C.maxMultiplex, C.isSnapCopy, C.isMirrorCopy
	FROM	archGroupCopy C INNER JOIN SourceCopy_CTE S
ON	C.id = S.sourceCopyId AND S.sourceCopyId > 0 AND C.type <> 5
)
INSERT INTO @tblSourceCopy
SELECT	id, CASE sourceCopyId WHEN 0 THEN @l_defaultCopyId ELSE sourceCopyId END,
		@l_defaultCopyId, @l_archGroupId, flags, dedupeFlags, maxMultiplex, isSnapCopy, isMirrorCopy, 0
FROM	SourceCopy_CTE
UNION
SELECT	id, CASE sourceCopyId WHEN 0 THEN @l_defaultCopyId ELSE sourceCopyId END,
		@l_defaultCopyId, @l_archGroupId, flags, dedupeFlags, maxMultiplex, isSnapCopy, isMirrorCopy, 0
FROM	archGroupCopy
WHERE	id = @l_defaultCopyId
UPDATE T
SET SIBlockSize = (CASE WHEN T.dedupeFlags & 134217728 > 0 THEN G.SIBlockSizeKB ELSE @l_defaultSIBlockSizeKB END)
FROM @tblSourceCopy T
		LEFT OUTER JOIN archCopyToGlobalPolicy C2G ON T.copyId = C2G.copyId
		LEFT OUTER JOIN archGroup G ON C2G.globalPolicyId = G.id
IF OBJECT_ID('tempdb..#archSourceCopyListResultTable') IS NOT NULL
BEGIN
	INSERT INTO #archSourceCopyListResultTable
	SELECT	*
	FROM	@tblSourceCopy
END
ELSE
BEGIN
	SELECT * FROM @tblSourceCopy
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archSourceCopyList')
	delete from GxQscripts where name = 'archSourceCopyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSourceCopyList')
	delete from GXDBVersions where aliasname = 'archSourceCopyList'
GO

insert into GXDBVersions values(2, 'archSourceCopyList',  '00010005021000050000', 'archSourceCopyList', '00010005021000050000')
GO

