

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archSetToBeVerifiedJobsByTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archSetToBeVerifiedJobsByTime.sp,v $ $Id: archSetToBeVerifiedJobsByTime.sp,v 1.2.300.3 2020/02/14 21:59:33 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archSetToBeVerifiedJobsByTime')
BEGIN
	print '>>> Drop Stored Procedure: archSetToBeVerifiedJobsByTime <<<'
	drop procedure archSetToBeVerifiedJobsByTime
END
IF EXISTS (select * from GxQscripts where name='archSetToBeVerifiedJobsByTime')
	delete from GxQscripts where name = 'archSetToBeVerifiedJobsByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSetToBeVerifiedJobsByTime')
	delete from GXDBVersions where aliasname = 'archSetToBeVerifiedJobsByTime'
GO
print '... Creating Procedure: archSetToBeVerifiedJobsByTime'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archSetToBeVerifiedJobsByTime
  @i_archGroupId integer,
  @i_archCopyId integer,
  @i_startTime integer,
  @i_endTime integer,
  @i_setOrReset integer,
  @i_pickAllJobs integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @r_rowCount integer
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tempJobs') IS NOT NULL DROP TABLE #tempJobs
CREATE TABLE #tempJobs (jobId int, commCellId int, PRIMARY KEY(jobId, commCellId))
IF @i_setOrReset = 2
BEGIN
	INSERT	INTO #tempJobs
	SELECT	DISTINCT JDS.jobId, JDS.commCellId
	FROM	JMAdminJobStatsTable AJS WITH (NOLOCK), JMJobDataStats JDS WITH (NOLOCK)
	WHERE	AJS.jobId = JDS.jobId AND AJS.commCellId = JDS.commCellId
		AND AJS.servStart >= @i_startTime AND AJS.servStart < @i_endTime
		AND JDS.archGrpId = @i_archGroupId AND JDS.archGrpCopyId = @i_archCopyId
		AND JDS.status = 100 AND JDS.archCheckStatus IN (3, 4)
	INSERT	INTO #tempJobs
	SELECT	DISTINCT JDS.jobId, JDS.commCellId
	FROM	JMBkpStats BKP WITH (NOLOCK), JMJobDataStats JDS WITH (NOLOCK)
	WHERE	BKP.jobId = JDS.jobId AND BKP.commCellId = JDS.commCellId
		AND BKP.servStartDate >= @i_startTime AND BKP.servStartDate < @i_endTime
		AND JDS.archGrpId = @i_archGroupId AND JDS.archGrpCopyId = @i_archCopyId
		AND JDS.status = 100 AND JDS.archCheckStatus IN (3, 4)
	UPDATE	JMJobDataStats SET archCheckStatus = 0
	FROM	JMJobDataStats J, #tempJobs T
	WHERE	T.jobId = J.jobId AND T.commCellId = J.commCellId AND J.archGrpCopyId = @i_archCopyId
		AND J.status = 100 AND J.archCheckStatus IN (3, 4)
UPDATE	archChunkMapping SET flags = (flags & (~255))
	FROM	archChunkMapping ACM WITH (NOLOCK),
			(SELECT	b.id, b.commCellId
			FROM	#tempJobs a, archFile b WITH (NOLOCK)
			WHERE	a.jobId = b.jobId AND a.commCellId = b.commCellId) AF
	WHERE	ACM.archFileId = AF.id AND ACM.commCellId = AF.commCellId AND ACM.archCopyId = @i_archCopyId
		AND (ACM.flags & 1) = 1
END
IF @i_setOrReset = 1
BEGIN
  DECLARE @copyFlag	integer
  SET @copyFlag = (SELECT flags FROM archGroupCopy WHERE id = @i_archCopyId)
  IF (@i_pickAllJobs = 1)
	SET @copyFlag |= 128
  IF (@copyFlag & 128) = 128 OR (@copyFlag & 256) = 256
  BEGIN
  	INSERT	INTO #tempJobs
	SELECT	DISTINCT JDS.jobId, JDS.commCellId
	FROM	JMAdminJobStatsTable AJS WITH (NOLOCK), JMJobDataStats JDS WITH (NOLOCK)
	WHERE	AJS.jobId = JDS.jobId AND AJS.commCellId = JDS.commCellId
		AND AJS.servStart >= @i_startTime AND AJS.servStart < @i_endTime
		AND ((@copyFlag & 128) = 128 OR AJS.ER_BkpLevel = 1)
		AND JDS.archGrpId = @i_archGroupId AND JDS.archGrpCopyId = @i_archCopyId
		AND JDS.status = 100 AND JDS.archCheckStatus <> 3
	INSERT	INTO #tempJobs
	SELECT	DISTINCT JDS.jobId, JDS.commCellId
	FROM	JMBkpStats BKP WITH (NOLOCK), JMJobDataStats JDS WITH (NOLOCK)
	WHERE	BKP.jobId = JDS.jobId AND BKP.commCellId = JDS.commCellId
		AND BKP.servStartDate >= @i_startTime AND BKP.servStartDate < @i_endTime
		AND ((@copyFlag & 128) = 128 OR BKP.bkpLevel IN (1, 64, 128, 1024, 32768))
		AND JDS.archGrpId = @i_archGroupId AND JDS.archGrpCopyId = @i_archCopyId
		AND JDS.status = 100 AND JDS.archCheckStatus <> 3
	UPDATE	JMJobDataStats SET archCheckStatus = 3
	FROM	JMJobDataStats J, #tempJobs T
	WHERE	T.jobId = J.jobId AND T.commCellId = J.commCellId AND J.archGrpCopyId = @i_archCopyId
		AND J.status = 100 AND J.archCheckStatus <> 3
UPDATE	archChunkMapping SET flags = ((flags & (~255)) | 1)
	FROM	archChunkMapping ACM WITH (NOLOCK),
			(SELECT b.id, b.commCellId
			FROM	#tempJobs a, archFile b WITH (NOLOCK)
			WHERE	a.jobId = b.jobId AND a.commCellId = b.commCellId) AF
	WHERE	ACM.archFileId = AF.id AND ACM.commCellId = AF.commCellId AND ACM.archCopyId = @i_archCopyId
		AND (ACM.flags & 1) = 0
   END
END
SELECT @@ROWCOUNT
IF OBJECT_ID('tempdb.dbo.#tempJobs') IS NOT NULL DROP TABLE #tempJobs
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archSetToBeVerifiedJobsByTime')
	delete from GxQscripts where name = 'archSetToBeVerifiedJobsByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSetToBeVerifiedJobsByTime')
	delete from GXDBVersions where aliasname = 'archSetToBeVerifiedJobsByTime'
GO

insert into GXDBVersions values(2, 'archSetToBeVerifiedJobsByTime',  '00010002030000030000', 'archSetToBeVerifiedJobsByTime', '00010002030000030000')
GO

