

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archSetMedianAvgQITime.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archSetMedianAvgQITime.sp,v $ $Id: archSetMedianAvgQITime.sp,v 1.1.2.2 2020/10/26 06:40:44 lviswambharan Exp $";
--  +========================================================================+
--  | Stored Proc:  archSetMedianAvgQITime
--  |
--  | Description:  Computes Median AvgQITime for all DDBs and
--	|				Inserts entry in IdxSIDBUsageHistory with HistoryType = 2
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archSetMedianAvgQITime')
BEGIN
	print '>>> Drop Stored Procedure: archSetMedianAvgQITime <<<'
	drop procedure archSetMedianAvgQITime
END
IF EXISTS (select * from GxQscripts where name='archSetMedianAvgQITime')
	delete from GxQscripts where name = 'archSetMedianAvgQITime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSetMedianAvgQITime')
	delete from GXDBVersions where aliasname = 'archSetMedianAvgQITime'
GO
print '... Creating Procedure: archSetMedianAvgQITime'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archSetMedianAvgQITime
AS
SET NOCOUNT ON
	--
	-- Compute avgQITime with median for previous day
	--
	DECLARE @YesterdayDayStart int = 0
	DECLARE @TodayDayStart int = 0
	DECLARE @WeekStartDayDayStart int = 0
	SET @TodayDayStart = dbo.GetUnixTime(dbo.ClientLocalToUTCTime(dbo.GetDayStart(GETDATE(), 0), 2))
	SET @YesterdayDayStart = dbo.GetUnixTime(dbo.ClientLocalToUTCTime(DATEADD(DAY, datediff(DAY, 0, GETDATE()), -1), 2))
	SET @WeekStartDayDayStart = dbo.GetUnixTime(dbo.ClientLocalToUTCTime(DATEADD(DAY, datediff(DAY, 0, GETDATE()), -7), 2))
	IF NOT EXISTS (SELECT 1 FROM IdxSIDBUsageHistory WITH (READUNCOMMITTED) WHERE ModifiedTime = @YesterdayDayStart AND HistoryType = 2)
	BEGIN
		DECLARE @lt_SubStoresAvgQITime TABLE (SubStoreId int, AvgQITime bigint, RowNumber int)
		DECLARE @lt_SubStoresMedianQITime  TABLE (SubStoreId int, MedianQITime bigint)
		INSERT 	INTO @lt_SubStoresAvgQITime
		SELECT	SubStoreId, AvgQITime,
				ROW_NUMBER() OVER (PARTITION BY SubStoreId ORDER BY AvgQITime ASC) AS RowNumber
		FROM	IdxSIDBUsageHistory WITH (READUNCOMMITTED)
		WHERE	HistoryType = 0 AND ModifiedTime >= @WeekStartDayDayStart AND ModifiedTime < @TodayDayStart AND AvgQITime > 0
				AND AvgQITimeSampleCount >= 100 -- Discard QI Times if sample count less than 100
		INSERT INTO @lt_SubStoresMedianQITime
		SELECT SubStoreId,  AVG(AvgQITime)
		FROM (
				SELECT	SubStoreId, AvgQITime,
						RowNumber AS RowNumAsc,
						ROW_NUMBER() OVER (PARTITION BY SubStoreId ORDER BY RowNumber DESC) AS RowNumDesc
				FROM	@lt_SubStoresAvgQITime
			) Usage
		WHERE RowNumAsc IN (RowNumDesc, RowNumDesc - 1, RowNumDesc + 1)
		GROUP BY SubStoreId
		--If there is no valid usage history for a substore then take QI time as 0
		INSERT INTO @lt_SubStoresMedianQITime
		SELECT DISTINCT SS.SubStoreId, 0
		FROM	IdxSIDBSubStore SS  WITH (READUNCOMMITTED)
				INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON SS.SIDBStoreId = CS.SIDBStoreId
				LEFT OUTER JOIN @lt_SubStoresMedianQITime SM ON SS.SubStoreId = SM.SubStoreId
		WHERE	SS.SubStoreId > 0 AND SM.SubStoreId IS NULL
		INSERT	INTO IdxSIDBUsageHistory
		(
				SIDBStoreId,
				SubStoreId,
				CommCellId,
				HistoryType,
				ModifiedTime,
				PrimaryEntries,
				SecondaryEntries,
				AvgQITime,
				AvgQITimeSampleCount,
				NumOfConnections,
				ZeroRefCount,
				ReserveField1,
				PrimaryDataSize,
				ReserveField3,
				ReserveFieldStr,
				DataSizeToPrune,
				SizeOccupied,
				DDBManagedSize,
				DeleteChunkCount
		)
		SELECT	SU1.SIDBStoreId,
				SU1.SubStoreId,
				SU1.CommCellId,
				2 /*HistoryType*/,
				@YesterdayDayStart,
				SU1.PrimaryEntries,
				SU1.SecondaryEntries,
				SU2.MedianQITime,
				SU1.AvgQITimeSampleCount,
				SU1.NumOfConnections,
				SU1.ZeroRefCount,
				SU1.ReserveField1,
				SU1.PrimaryDataSize,
				SU1.ReserveField3,
				SU1.ReserveFieldStr,
				SU1.DataSizeToPrune,
				SU1.SizeOccupied,
				SU1.DDBManagedSize,
				SU1.DeleteChunkCount
		FROM	IdxSIDBUsageHistory SU1
				INNER JOIN @lt_SubStoresMedianQITime SU2 ON SU1.SubStoreId = SU2.SubStoreId
		WHERE	SU1.HistoryType = 0
		AND SU1.ModifiedTime =
			(SELECT MAX(ModifiedTime)
			FROM IdxSIDBUsageHistory
			WHERE HistoryType = 0
			AND SubStoreId = SU1.SubStoreId
			AND CommCellId = SU1.CommCellId)
	END
-- END of stored procedure
GO

IF EXISTS (select * from GxQscripts where name = 'archSetMedianAvgQITime')
	delete from GxQscripts where name = 'archSetMedianAvgQITime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSetMedianAvgQITime')
	delete from GXDBVersions where aliasname = 'archSetMedianAvgQITime'
GO

insert into GXDBVersions values(2, 'archSetMedianAvgQITime',  '00010001000200020000', 'archSetMedianAvgQITime', '00010001000200020000')
GO

