

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archSetJobsAgedViaTable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archSetJobsAgedViaTable.sp,v $ $Id: archSetJobsAgedViaTable.sp,v 1.13.2.6 2020/12/19 05:08:55 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archSetJobsAgedViaTable')
BEGIN
	print '>>> Drop Stored Procedure: archSetJobsAgedViaTable <<<'
	drop procedure archSetJobsAgedViaTable
END
IF EXISTS (select * from GxQscripts where name='archSetJobsAgedViaTable')
	delete from GxQscripts where name = 'archSetJobsAgedViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSetJobsAgedViaTable')
	delete from GXDBVersions where aliasname = 'archSetJobsAgedViaTable'
GO
print '... Creating Procedure: archSetJobsAgedViaTable'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archSetJobsAgedViaTable
  @i_agedByFlag bigint,
  @i_agedTime integer
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/* This temp table must be created and populated by caller before calling this stored procedure
CREATE TABLE #ToBeAgedJob (
	jobId INT, archGrpId INT, archGrpCopyId INT, dataType INT, commCellId INT,
	PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId))
*/
IF NOT EXISTS (SELECT 1 FROM #ToBeAgedJob)
BEGIN
	SET @retVal = 0
	GOTO FINISH
END
IF object_id('tempdb.dbo.#ToBeAgedAFC') IS NOT NULL DROP TABLE #ToBeAgedAFC
CREATE TABLE #ToBeAgedAFC (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
-- SAFETY CHECK --
-- DO NOT PRUNE any jobs for SILO AppId except for Failed/Killed Jobs --
DELETE 	#ToBeAgedJob
FROM 		#ToBeAgedJob T,JMJobDataStats JDS WITH (NOLOCK)
WHERE 	T.JobId = JDS.JobId
AND 		T.archGrpId = JDS.archGrpId
AND			T.archGrpCopyId = JDS.archGrpCopyId
AND 		T.commCellId = JDS.commCellId
AND 		JDS.appId IN (SELECT DISTINCT siloAppId FROM archGroupCopy WITH (NOLOCK) WHERE siloAppId > 0)
AND			JDS.status NOT IN (2, 3)
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Get archive files of pruneable jobs
INSERT	INTO #ToBeAgedAFC
SELECT	AF.id, AF.commCellId, T.archGrpCopyId
FROM	#ToBeAgedJob T, archFile AF WITH(NOLOCK)
WHERE	AF.jobId = T.jobId
	AND AF.commCellId = T.commCellId
	AND AF.fileType = T.dataType
	AND AF.archGroupId = T.archGrpId
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
DECLARE	@l_dateTime datetime
SET @l_dateTime = dbo.GetDateTime(@i_agedTime)
DECLARE	@retCode	INT
EXEC @retCode = archFileSetAgedViaTable @i_agedByFlag, @i_agedTime
SET	@retVal = @@ERROR
IF	@retVal = 0	SET	@retVal = @retCode
IF	@retVal <> 0 GOTO FINISH
DECLARE @rowCount INT
-- Mark jobs as aged
UPDATE	JMJobDataStats WITH (PAGLOCK)
SET		disabled = (J.disabled | 256), agedTime = @i_agedTime, modifiedTime = @i_agedTime, agedBy = (agedBy | @i_agedByFlag)
FROM	#ToBeAgedJob T, JMJobDataStats J
WHERE	J.jobId = T.jobId AND J.dataType = T.dataType
	AND J.archGrpCopyId = T.archGrpCopyId AND J.commCellId = T.commCellId
AND J.disabled & 256 = 0
SELECT @rowCount = @@ROWCOUNT, @retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
--If any of the jobs are marked aged above, find if the job is aged in catalog source and disable the job for cataloging
IF @rowCount > 0
BEGIN
 	DECLARE @tblCopy TABLE (
		archGroupId 	INT,
		archCopyId		INT,
		primaryCopyId INT,
		sourceCopyId	INT,
		isSnapCopy		INT,
		isMirrorCopy	INT,
		matSrcCopyId	INT,
		defCatSrcCopyId INT
	)
	INSERT INTO @tblCopy
	SELECT DISTINCT AG.id, AGC.id, (CASE AGC.isSnapCopy WHEN 0 THEN AG.defaultCopy ELSE AG.defaultSnapCopy END), AGC.sourceCopyId, AGC.isSnapCopy, AGC.isMirrorCopy, 0, 0
	FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), #ToBeAgedJob TMP
	WHERE	AG.id = TMP.archGrpId
	AND		AG.id = AGC.archGroupId
	WHILE EXISTS(SELECT T.sourceCopyId FROM @tblCopy T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
	BEGIN
		UPDATE	@tblCopy
		SET 	sourceCopyId = AGC.sourceCopyId
		FROM	@tblCopy T, archGroupCopy AGC WITH (NOLOCK)
		WHERE	T.sourceCopyId = AGC.id
		AND		AGC.isSnapCopy > 0
		AND		AGC.isMirrorCopy > 0
		SET	@retVal = @@ERROR
		IF	@retVal <> 0
			GOTO FINISH
	END
	-- The source copy will be primary copy if source copy is not defined
	UPDATE	@tblCopy
	SET 	sourceCopyId = primaryCopyId
	WHERE	sourceCopyId = 0
	UPDATE	@tblCopy
	SET matSrcCopyId = CASE WHEN t.isMirrorCopy = 1
									THEN t.sourceCopyId
								ELSE t.archCopyId
						END
	FROM @tblCopy t, archMaterializeSnapshotProp b WITH (NOLOCK)
	WHERE t.archGroupId = b.archGroupId
	AND (( b.sourceCopyId = 0 AND  t.archCopyId = t.primaryCopyId) OR (b.sourceCopyId > 0 AND t.archCopyId = b.sourceCopyId))
	AND t.isSnapCopy > 0
	UPDATE	@tblCopy
	SET defCatSrcCopyId = CASE WHEN t.isMirrorCopy = 1
									THEN t.sourceCopyId
								ELSE t.archCopyId
						END
	FROM @tblCopy t, ArchDeferredCatalogProp b WITH (NOLOCK)
	WHERE t.archGroupId = b.archGroupId
	AND (( b.sourceCopyId = 0 AND  t.archCopyId = t.primaryCopyId) OR (b.sourceCopyId > 0 AND t.archCopyId = b.sourceCopyId))
	AND t.isSnapCopy > 0
	UPDATE JMJobSnapDeferredCatalogStats
SET 	Disabled = JS.Disabled | 1, unPickReason = 4
	FROM JMJobSnapDeferredCatalogStats JS, #ToBeAgedJob T, @tblCopy SC
	WHERE T.jobId = JS.jobId
	AND		T.commCellId = JS.commCellId
	AND		T.archGrpCopyId = SC.defCatSrcCopyId
	AND  	(JS.Disabled & 1) = 0
	AND 	JS.catalogStatus in (101, 102, 103)
AND T.dataType = 1
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
	UPDATE JMJobSnapshotStats
SET 	Disabled = JS.Disabled | 1, unPickReason = 4
	FROM JMJobSnapshotStats JS, #ToBeAgedJob T, @tblCopy SC
	WHERE T.jobId = JS.jobId
	AND		T.commCellId = JS.commCellId
	AND		T.archGrpCopyId = SC.matSrcCopyId
	AND  	(JS.Disabled & 1) = 0
	AND 	JS.materializationStatus in (101, 102, 103)
AND T.dataType = 1
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
END
-- DELETE the pruned jobs from JMCompliancePolicyQualifiedjobs --
DELETE 	JMCompliancePolicyQualifiedJobs
FROM 	JMCompliancePolicyQualifiedJobs JMCQ, #ToBeAgedJob T WITH (NOLOCK)
WHERE 	JMCQ.JobId = T.JobId
AND 	JMCQ.commCellId = T.commCellId
SET @retVal = @@ERROR
FINISH:
IF object_id('tempdb.dbo.#ToBeAgedAFC') IS NOT NULL DROP TABLE #ToBeAgedAFC
-- Added condition to insert value into temp table, if this stored procedure called for pruning volume reconciliation dangled jobs
IF OBJECT_ID('tempdb.dbo.#TblArchSetJobsAgedViaTableResult') IS NOT NULL
	INSERT INTO #TblArchSetJobsAgedViaTableResult SELECT @retVal
ELSE
	SELECT @retVal
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archSetJobsAgedViaTable')
	delete from GxQscripts where name = 'archSetJobsAgedViaTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSetJobsAgedViaTable')
	delete from GXDBVersions where aliasname = 'archSetJobsAgedViaTable'
GO

insert into GXDBVersions values(2, 'archSetJobsAgedViaTable',  '00010013000200060000', 'archSetJobsAgedViaTable', '00010013000200060000')
GO

