

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archSetDefaultDataPathForDependentCopies.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archSetDefaultDataPathForDependentCopies.sp,v $ $Id: archSetDefaultDataPathForDependentCopies.sp,v 1.1.2.10 2020/05/10 01:16:50 pveeravalli Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "archSetDefaultDataPathForDependentCopies"			|
--	|																		|
--	| Dependent copies of GDSP and GACP and transitive copies may left	 	|
--	| without default DataPath when we modify datapaths on GDSP or GACP		|
--	| copy, this proc will sets the default datapath for such copies		|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archSetDefaultDataPathForDependentCopies')
BEGIN
	print '>>> Drop Stored Procedure: archSetDefaultDataPathForDependentCopies <<<'
	drop procedure archSetDefaultDataPathForDependentCopies
END
IF EXISTS (select * from GxQscripts where name='archSetDefaultDataPathForDependentCopies')
	delete from GxQscripts where name = 'archSetDefaultDataPathForDependentCopies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSetDefaultDataPathForDependentCopies')
	delete from GXDBVersions where aliasname = 'archSetDefaultDataPathForDependentCopies'
GO
print '... Creating Procedure: archSetDefaultDataPathForDependentCopies'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archSetDefaultDataPathForDependentCopies
  @i_copyId int,
  @i_globalPolicyType int
AS
BEGIN
/*
Follow this convention. Avoid unnecessary lookups to DB just because rows are not found.
Global dedup SP    - 1
Global Auxcopy SP  - 2
Global nondedup SP - 3
*/
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	IF OBJECT_ID('tempdb..#lt_Copies') IS NOT NULL DROP TABLE #lt_Copies
	CREATE TABLE #lt_Copies (CopyId INT)
	IF (@i_globalPolicyType = 0)
	BEGIN
		--policy type not set, get the policy type
		SELECT 	@i_globalPolicyType = (CASE
WHEN a.dedupeFlags & 268435456 = 268435456
THEN 1
WHEN a.extendedFlags & 1 = 1
THEN 2
WHEN a.extendedFlags & 4096 = 4096
THEN 3
							ELSE 0
						END)
		FROM	archGroupCopy a WITH(READUNCOMMITTED)
		WHERE	a.id = @i_copyId
	END
IF ((@i_globalPolicyType = 1) OR (@i_globalPolicyType = 2) OR (@i_globalPolicyType = 3))
	BEGIN
		INSERT 	INTO #lt_Copies
		SELECT  gp.copyId
        FROM    archCopyToGlobalPolicy GP WITH (READUNCOMMITTED)
        WHERE   globalPolicyId = (SELECT archGroupId FROM archGroupCopy WITH (READUNCOMMITTED) WHERE Id = @i_copyId)
	END
	IF EXISTS(SELECT 1 FROM #lt_Copies)
	BEGIN
		DECLARE @DefaultDrivePoolId INT = 0
		DECLARE @DefaultSpareGroupId INT = 0
		SELECT 	@DefaultDrivePoolId = DrivePoolId, @DefaultSpareGroupId = SpareGroupId
		FROM	MMDataPath WITH(READUNCOMMITTED)
WHERE	CopyId = @i_copyId AND (Flag & 1 /*MMS2_DEFAULT_FAILOVER*/) > 0
		UPDATE 	MMDataPath
SET		Flag = (a.Flag | 1 /*MMS2_DEFAULT_FAILOVER*/ | 2 /*MMS2_ACTIVE_FAILOVER*/ | 4 /*MMS2_ENABLED_FAILOVER*/)
		FROM	MMDataPath a,
				(
					SELECT	DP.CopyId, DP.DataPathId, DP.Flag,
							ROW_NUMBER()
							OVER(PARTITION BY DP.CopyId
ORDER BY (DP.Flag & 1 /*MMS2_DEFAULT_FAILOVER*/) DESC,
											(CASE WHEN DP.DrivePoolId = @DefaultDrivePoolId AND DP.SpareGroupId = @DefaultSpareGroupId THEN 0 ELSE 1 END),
(DP.Flag & 2 /*MMS2_ACTIVE_FAILOVER*/) DESC,
(DP.Flag & 4 /*MMS2_ENABLED_FAILOVER*/) DESC,
											DP.Priority,
											DP.DataPathId) AS RowNum
					FROM	MMDataPath DP, #lt_Copies C
					WHERE	DP.CopyId = C.CopyId
				) AS b
		WHERE	a.DataPathId = b.DataPathId
				AND b.RowNum = 1
				AND (
(b.Flag & 1 /*MMS2_DEFAULT_FAILOVER*/) = 0
OR (b.Flag & 2 /*MMS2_ACTIVE_FAILOVER*/) = 0
OR (b.Flag & 4 /*MMS2_ENABLED_FAILOVER*/) = 0
					)
	END
END

IF EXISTS (select * from GxQscripts where name = 'archSetDefaultDataPathForDependentCopies')
	delete from GxQscripts where name = 'archSetDefaultDataPathForDependentCopies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSetDefaultDataPathForDependentCopies')
	delete from GXDBVersions where aliasname = 'archSetDefaultDataPathForDependentCopies'
GO

insert into GXDBVersions values(2, 'archSetDefaultDataPathForDependentCopies',  '00010001000200100000', 'archSetDefaultDataPathForDependentCopies', '00010001000200100000')
GO

