

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archSetCopyAppRegionMap.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archSetCopyAppRegionMap.sp,v $ $Id: archSetCopyAppRegionMap.sp,v 1.1.2.6 2018/03/20 19:51:12 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archSetCopyAppRegionMap <<<'

IF EXISTS (select * from sysobjects where name='archSetCopyAppRegionMap')
	drop procedure archSetCopyAppRegionMap
IF EXISTS (select * from GxQscripts where name='archSetCopyAppRegionMap')
	delete from GxQscripts where name = 'archSetCopyAppRegionMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSetCopyAppRegionMap')
	delete from GXDBVersions where aliasname = 'archSetCopyAppRegionMap'
GO
print '... Creating Procedure: archSetCopyAppRegionMap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archSetCopyAppRegionMap
  @i_copyId integer,
  @i_regionMapXml xml
AS
  DECLARE @o_errorCode integer
  DECLARE @o_errorMessage nvarchar(4000)
SET NOCOUNT ON
SET @o_errorCode = 0
SET @o_errorMessage = ''
DECLARE @tblRegionMap TABLE (appId int, srcRegion nvarchar(1024), srcRegionId int, destRegion nvarchar(1024), destRegionId int)
INSERT	INTO @tblRegionMap
SELECT  ISNULL(col.value('subClient[1]/@subclientId','integer'), 0),
		col.value('@sourceRegion','nvarchar(1024)'), 0,
		col.value('@destinationRegion','nvarchar(1024)'), 0
FROM    @i_regionMapXml.nodes('*/regionMap') paramXML(col)
UPDATE	TRM
SET		srcRegionId = R.id
FROM	@tblRegionMap TRM
		INNER JOIN App_CloudVendorRegion R WITH (READUNCOMMITTED) ON TRM.srcRegion = R.RegionName
UPDATE	TRM
SET		destRegionId = R.id
FROM	@tblRegionMap TRM
		INNER JOIN App_CloudVendorRegion R WITH (READUNCOMMITTED) ON TRM.destRegion = R.RegionName
IF EXISTS(SELECT 1 FROM @tblRegionMap WHERE srcRegionId = 0 OR (destRegionId = 0 AND destRegion <> ''))
BEGIN
SET @o_errorCode = 150
	SELECT 	@o_errorMessage = @o_errorMessage + srcRegion + ','
	FROM 	@tblRegionMap
	WHERE	srcRegionId = 0
	SELECT 	@o_errorMessage = @o_errorMessage + destRegion + ','
	FROM 	@tblRegionMap
	WHERE	destRegionId = 0
	SET @o_errorMessage = LEFT(@o_errorMessage, LEN(@o_errorMessage)-1)
	GOTO CX_ERROR
END
--remove unselected mappings
DELETE
FROM ArchCopyAppRegionMap
WHERE CopyId = @i_copyId AND
	  EXISTS(
			SELECT 1 FROM @tblRegionMap newMap
			WHERE newMap.appId = ArchCopyAppRegionMap.AppId AND
				  newMap.srcRegionId = ArchCopyAppRegionMap.SrcRegionId AND
				  newMap.destRegionId = 0
	  )
DELETE FROM @tblRegionMap WHERE destRegionId = 0
-- Update the mapping for existing source region
UPDATE	RM
SET		destRegionId = TRM.destRegionId
FROM	ArchCopyAppRegionMap RM INNER JOIN @tblRegionMap TRM
		ON RM.copyId = @i_copyId AND RM.appId = TRM.appId AND RM.srcRegionId = TRM.srcRegionId
-- Add new mapping for source region which doesn't exists
INSERT 	INTO ArchCopyAppRegionMap
SELECT 	@i_copyId, TRM.appId, TRM.srcRegionId, TRM.destRegionId
FROM	@tblRegionMap TRM LEFT OUTER JOIN ArchCopyAppRegionMap RM
		ON RM.copyId = @i_copyId AND RM.appId = TRM.appId AND RM.srcRegionId = TRM.srcRegionId
WHERE	RM.copyId IS NULL
CX_ERROR:
SELECT @o_errorCode, @o_errorMessage
GO

IF EXISTS (select * from GxQscripts where name = 'archSetCopyAppRegionMap')
	delete from GxQscripts where name = 'archSetCopyAppRegionMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSetCopyAppRegionMap')
	delete from GXDBVersions where aliasname = 'archSetCopyAppRegionMap'
GO

insert into GXDBVersions values(2, 'archSetCopyAppRegionMap',  '00010001000200060000', 'archSetCopyAppRegionMap', '00010001000200060000')
GO

