

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archSetCCCReservedData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archSetCCCReservedData.sp,v $ $Id: archSetCCCReservedData.sp,v 1.1.2.2 2020/04/07 01:46:27 pnara Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archSetCCCReservedData')
BEGIN
	print '>>> Drop Stored Procedure: archSetCCCReservedData <<<'
	drop procedure archSetCCCReservedData
END
IF EXISTS (select * from GxQscripts where name='archSetCCCReservedData')
	delete from GxQscripts where name = 'archSetCCCReservedData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSetCCCReservedData')
	delete from GXDBVersions where aliasname = 'archSetCCCReservedData'
GO
print '... Creating Procedure: archSetCCCReservedData'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archSetCCCReservedData
  @i_Operation int,
  @i_ReservedData varchar(3072),
  @i_MasterKeyId varchar(2048),
  @i_KeyProviderId int,
  @i_EncType int
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--Don't save data if Common Criteria mode is enabled
IF EXISTS
(
	SELECT  1
	FROM 	APP_AdvanceSettings WITH(READUNCOMMITTED)
	WHERE   keyname = N'EnableCommonCriteriaMode'
	AND     entityId = 2
AND     entityType = 3
	AND     relativePath = N'CommServDB.GxGlobalParam'
	AND 	CONVERT(NVARCHAR(10), value) = N'true'
	AND		enabled = 1
	AND     deleted = 0
)
BEGIN
	RETURN
END
--i_Operation :  0 - INIT; 1 - UPDATE; 2
DECLARE @l_now INT = dbo.GetUnixTime(GetUTCDate())
IF @i_Operation = 0 /*INIT*/
BEGIN
	DELETE 	GxGlobalParam
	WHERE	name IN
			(
'CCC_ReservedData',
'CCC_MasterKeyId',
'CCC_KeyProviderId',
'CCC_EncType'
			)
	INSERT	INTO GxGlobalParam (name, value, created, modified)
SELECT	'CCC_ReservedData', @i_ReservedData, @l_now, 0
	UNION ALL
SELECT	'CCC_MasterKeyId', @i_MasterKeyId, @l_now, 0
	UNION ALL
SELECT	'CCC_KeyProviderId', CAST(@i_KeyProviderId AS nvarchar), @l_now, 0
	UNION ALL
SELECT	'CCC_EncType', CAST(@i_EncType AS nvarchar), @l_now, 0
	IF @@ERROR <> 0 OR @@ROWCOUNT = 0
		RETURN (-1)
END
ELSE  /*UPDATE*/
BEGIN
	UPDATE 	GxGlobalParam
	SET		value = @i_ReservedData
WHERE	name = 'CCC_ReservedData'
	IF @@ERROR <> 0 OR @@ROWCOUNT = 0
		RETURN (-1)
	UPDATE 	GxGlobalParam
	SET		value = @i_MasterKeyId
WHERE	name = 'CCC_MasterKeyId'
	IF @@ERROR <> 0 OR @@ROWCOUNT = 0
		RETURN (-1)
	UPDATE 	GxGlobalParam
	SET		value = CAST(@i_KeyProviderId AS nvarchar)
WHERE	name = 'CCC_KeyProviderId'
	IF @@ERROR <> 0 OR @@ROWCOUNT = 0
		RETURN (-1)
	UPDATE 	GxGlobalParam
	SET		value = CAST(@i_EncType AS nvarchar)
WHERE	name = 'CCC_EncType'
	IF @@ERROR <> 0 OR @@ROWCOUNT = 0
		RETURN (-1)
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archSetCCCReservedData')
	delete from GxQscripts where name = 'archSetCCCReservedData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSetCCCReservedData')
	delete from GXDBVersions where aliasname = 'archSetCCCReservedData'
GO

insert into GXDBVersions values(2, 'archSetCCCReservedData',  '00010001000200020000', 'archSetCCCReservedData', '00010001000200020000')
GO

