

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archSaveEncKey.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archSaveEncKey.sp,v $ $Id: archSaveEncKey.sp,v 1.6.2.7 2020/04/22 23:29:06 pnara Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archSaveEncKey')
BEGIN
	print '>>> Drop Stored Procedure: archSaveEncKey <<<'
	drop procedure archSaveEncKey
END
IF EXISTS (select * from GxQscripts where name='archSaveEncKey')
	delete from GxQscripts where name = 'archSaveEncKey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSaveEncKey')
	delete from GXDBVersions where aliasname = 'archSaveEncKey'
GO
print '... Creating Procedure: archSaveEncKey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archSaveEncKey
  @archFileId integer,
  @commCellId integer,
  @archCopyId integer,
  @streamReaderId integer,
  @jobId integer,
  @encRSA integer,
  @encKeyType integer,
  @encKey varchar(1024),
  @encKeyId integer = 0
AS
  DECLARE @errorCode integer
DECLARE @SIDBStoreId	integer = 0
DECLARE @DedupeFlags	integer = 0
DECLARE @RowCount		integer = 0
DECLARE @l_encRSA		tinyint = 0
DECLARE @l_encKeyType	int = -1
DECLARE @l_encKey		varchar(1024)
DECLARE @l_encKeyId	integer = 0
SET @l_encKeyId = @encKeyId
SELECT	@DedupeFlags = DedupeFlags
FROM	archGroupCopy
WHERE	id = @archCopyId
SELECT	@errorCode = @@ERROR, @RowCount = @@ROWCOUNT
IF	(@errorCode <> 0)
BEGIN
	GOTO ERR_EXIT
END
IF (@RowCount = 0)
BEGIN
	SET	@errorCode = -1
	GOTO ERR_EXIT
END
IF ((@dedupeFlags & 262144) > 0)
BEGIN
	SELECT	@SIDBStoreID = destSIDBStoreId
	FROM	ArchJobStreamStatus WITH (READUNCOMMITTED)
	WHERE	jobId = @jobId
			AND StreamReaderId = @streamReaderId
			AND DestCopyId = @archCopyId
	SELECT	@errorCode = @@ERROR, @RowCount = @@ROWCOUNT
	IF	(@errorCode <> 0)
	BEGIN
		GOTO ERR_EXIT
	END
	IF (@RowCount = 0)
	BEGIN
		select @SIDBStoreId = SIDBStoreId
from archCopySIDBStore with(readuncommitted) where copyId = @archCopyId and (flags & 2) > 0
	END
	SELECT	TOP 1 @l_encKeyType = ISNULL(keys.encKeyType, sidb.encKeyType), @l_encKey = ISNULL(keys.encKey, sidb.encKey), @l_encRSA = ISNULL(keys.encRSA, sidb.encRSA),
				@l_encKeyId = sidb.encKeyId
	FROM	archFileSIDBKeys sidb LEFT JOIN archEncKeys keys ON sidb.encKeyId = keys.encKeyId
	WHERE	sidb.archFileId = @archFileId
			AND sidb.commCellId = @commCellId
			AND sidb.SIDBStoreId = @SIDBStoreId
	ORDER BY sidb.archCopyId DESC
	SELECT	@errorCode = @@ERROR, @RowCount = @@ROWCOUNT
	IF	(@errorCode <> 0)
	BEGIN
		GOTO ERR_EXIT
	END
	IF (@RowCount = 0)
	BEGIN
		SELECT	TOP 1 @l_encKeyType = ISNULL(keys.encKeyType, sidb.encKeyType), @l_encKey = ISNULL(keys.encKey, sidb.encKey), @l_encRSA = ISNULL(keys.encRSA, sidb.encRSA),
					@l_encKeyId = sidb.encKeyId
		FROM	archFileSIDBKeys sidb LEFT JOIN archEncKeys keys ON sidb.encKeyId = keys.encKeyId
		WHERE	sidb.archFileId = @archFileId
				AND sidb.commCellId = @commCellId
				AND sidb.archCopyId = @archCopyId
		ORDER BY sidb.SIDBStoreId DESC
		SELECT	@errorCode = @@ERROR, @RowCount = @@ROWCOUNT
		IF	(@errorCode <> 0)
		BEGIN
			GOTO ERR_EXIT
		END
IF ((@RowCount = 0) AND ((@DedupeFlags & 134217728) != 0))
		BEGIN
			SELECT	TOP 1 @l_encKeyType = ISNULL(keys.encKeyType, sidb.encKeyType), @l_encKey = ISNULL(keys.encKey, sidb.encKey), @l_encRSA = ISNULL(keys.encRSA, sidb.encRSA),
						@l_encKeyId = sidb.encKeyId
			FROM	archFileSIDBKeys sidb LEFT JOIN archEncKeys keys ON sidb.encKeyId = keys.encKeyId
			WHERE	sidb.archFileId = @archFileId
					AND sidb.commCellId = @commCellId
					AND sidb.SIDBStoreId IN (SELECT ACS.SIDBStoreId
								FROM archCopySIDBStore ACS, archGroupCopy AGC
WHERE AGC.SIDBStoreId = @SIDBStoreId AND AGC.dedupeFlags & 268435456 > 0
								AND AGC.id = ACS.copyId)
			ORDER BY sidb.SIDBStoreId DESC
			SELECT	@errorCode = @@ERROR, @RowCount = @@ROWCOUNT
			IF	(@errorCode <> 0)
			BEGIN
				GOTO ERR_EXIT
			END
		END
		if (@l_encKeyType > 0)
		BEGIN
			SET @encRSA = @l_encRSA
			SET	@encKeyType = @l_encKeyType
			SET	@encKey = @l_encKey
		END
		INSERT INTO ArchFileSIDBKeys (archFileId, commCellId, archCopyId, encKeyType, encKey, SIDBStoreId, encRSA, encKeyId)
			VALUES (@archFileId, @commCellId, @archCopyId,
					case when @l_encKeyId > 0 then 0 else @encKeyType end,
					case when @l_encKeyId > 0 then '' else @encKey end,
					@SIDBStoreId,
					@encRSA,
					@l_encKeyId)
		SELECT	@errorCode = @@ERROR, @RowCount = @@ROWCOUNT
		IF	(@errorCode <> 0)
		BEGIN
			GOTO ERR_EXIT
		END
	END
	ELSE
	IF (@l_encKeyType > 0)
	BEGIN
		SET @encRSA = @l_encRSA
		SET	@encKeyType = @l_encKeyType
		SET	@encKey = @l_encKey
	END
END
UPDATE	archFileCopy
SET		encRSA = @encRSA,
		encKeyType = @encKeyType,
		encKey = @encKey,
flags = (flags | 1024 | 4096),
		encKeyId = @l_encKeyId
WHERE	archFileId = @archFileId
		AND commCellId = @commCellId
		AND archCopyId = @archCopyId
SELECT	@errorCode = @@ERROR, @RowCount = @@ROWCOUNT
IF	(@errorCode <> 0)
BEGIN
	GOTO ERR_EXIT
END
ERR_EXIT:
SELECT @errorCode
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archSaveEncKey')
	delete from GxQscripts where name = 'archSaveEncKey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archSaveEncKey')
	delete from GXDBVersions where aliasname = 'archSaveEncKey'
GO

insert into GXDBVersions values(2, 'archSaveEncKey',  '00010006000200070000', 'archSaveEncKey', '00010006000200070000')
GO

