

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archRunnableCITaskPresent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Procedure:  archRunnableCITaskPresent
--	| Author:	Siddharth Barman
--  |
--  | Description:  Returns 1 if any archive files are need to be content
--	|				indexed. Return 0 if no archive files required CIing.
--	| Input:		task ID
--	| Output:		1 or 0
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archRunnableCITaskPresent <<<'

IF EXISTS (select * from sysobjects where name='archRunnableCITaskPresent')
	drop procedure archRunnableCITaskPresent
IF EXISTS (select * from GxQscripts where name='archRunnableCITaskPresent')
	delete from GxQscripts where name = 'archRunnableCITaskPresent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archRunnableCITaskPresent')
	delete from GXDBVersions where aliasname = 'archRunnableCITaskPresent'
GO
print '... Creating Procedure: archRunnableCITaskPresent'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archRunnableCITaskPresent
  @i_taskId integer
AS
  DECLARE @o_runnableCITaskPresent integer
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
set nocount on
declare @o_jobId int = 0
--
if exists(
select
	af.id
from
	TM_AssocEntity ta with (nolock)
inner join
	archFile af with (nolock)
on
	af.archGroupId = ta.policyId
where
	ta.taskId = @i_taskId
	and
af.flags & (16 /*CVA_AF_CI_REQUIRED_FLAG*/ | 32 /*CVA_AF_CI_PARTIAL_FLAG*/) > 0
	and
	af.fileType = 1
	and
	not exists
	(
		select
			ja.archGrpID
		from
			JMAdminJobInfoTable ja
		inner join
				JMJobInfo ji
		on ja.jobid =ji.jobid
		where
			ja.opType = 53 /*OFFLINECONTENTINDEX*/
			and
			ji.subopType = 0
			and
			ja.commCellId = af.commCellId
			and
			ja.archGrpID = ta.policyId
	)
)
	set @o_runnableCITaskPresent = 1
else
	set @o_runnableCITaskPresent = 0
--
-- if it needs to be run and no running job for the storage policy, check whether any job is there which JM hasnt picked up yet
if (@o_runnableCITaskPresent=1)
begin
	SELECT TOP 1 @o_jobId = TMJOBS.jobId
	FROM TM_Jobs TMJOBS WITH (NOLOCK) -- only committed rows
	INNER JOIN TM_JobOptions OPT WITH (NOLOCK) ON TMJOBS.jobId = OPT.jobId AND modified = 0
	INNER JOIN TM_JobRequest TMJOBREQ WITH (NOLOCK) ON TMJOBS.jobRequestId = TMJOBREQ.jobRequestId
	INNER JOIN TM_ASSOCENTITY WITH (NOLOCK) on TM_ASSOCENTITY.taskId=@i_taskId
WHERE OPT.optionId = 140008 /*140008*/ AND (CAST(OPT.value AS INT) = TM_ASSOCENTITY.policyId) -- Same storage policy from association.
	AND TMJOBREQ.taskId = @i_taskId -- Same schedule
	AND ( TMJOBS.status = 0 OR ( (TMJOBS.status & 1) = 1 ) ) -- Not picked by JM
	if @o_jobId>0
	begin
		set @o_runnableCITaskPresent=0
	end
end
select	@o_runnableCITaskPresent
--
GO

IF EXISTS (select * from GxQscripts where name = 'archRunnableCITaskPresent')
	delete from GxQscripts where name = 'archRunnableCITaskPresent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archRunnableCITaskPresent')
	delete from GXDBVersions where aliasname = 'archRunnableCITaskPresent'
GO

insert into GXDBVersions values(2, 'archRunnableCITaskPresent',  '00000000000000000000', 'archRunnableCITaskPresent', '00000000000000000000')
GO

