

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archRestoreMediaAgentForSnap.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archRestoreMediaAgentForSnap.sp,v $ $Id: archRestoreMediaAgentForSnap.sp,v 1.11.12.2 2018/03/22 01:07:16 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archRestoreMediaAgentForSnap <<<'

IF EXISTS (select * from sysobjects where name='archRestoreMediaAgentForSnap')
	drop procedure archRestoreMediaAgentForSnap
IF EXISTS (select * from GxQscripts where name='archRestoreMediaAgentForSnap')
	delete from GxQscripts where name = 'archRestoreMediaAgentForSnap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archRestoreMediaAgentForSnap')
	delete from GXDBVersions where aliasname = 'archRestoreMediaAgentForSnap'
GO
print '... Creating Procedure: archRestoreMediaAgentForSnap'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archRestoreMediaAgentForSnap
  @i_jobId integer,
  @i_appId integer,
  @i_archFileId integer,
  @i_commCellId integer,
  @i_archCopyId integer,
  @i_dstClientId integer
AS
  DECLARE @o_errorCode integer;
  DECLARE @o_MAClientId integer;
  DECLARE @o_MAHostName varchar(510);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- local variables
DECLARE @l_errorCode		INT
DECLARE @l_pickedMAClientId	INT
DECLARE @l_pkdHostSoftState	INT
DECLARE @l_pkdHostEnabled	INT
DECLARE @l_MAClientId		INT
DECLARE @l_dstHostSoftState	INT
DECLARE @l_dstHostEnabled	INT
DECLARE @l_srcClientId		INT
DECLARE @l_srcHostSoftState	INT
DECLARE @l_srcHostEnabled	INT
DECLARE @l_proxyHostId		INT
DECLARE @l_prxHostSoftState	INT
DECLARE @l_prxHostEnabled	INT
DECLARE @l_checkLastSeenIndexMA 	INTEGER = 0
DECLARE @l_lastSeenIndexMASoftState	INTEGER = 0
DECLARE @l_lastSeenIndexMAEnabled	INTEGER = 0
SET		@l_errorCode		= 0
SET		@l_pickedMAClientId	= 0
SET		@l_pkdHostSoftState	= -999
SET		@l_pkdHostEnabled	= -999
SET		@l_MAClientId		= 0
SET		@l_dstHostSoftState	= -999
SET		@l_dstHostEnabled	= -999
SET		@l_srcClientId		= 0
SET		@l_srcHostSoftState	= -999
SET		@l_srcHostEnabled	= -999
SET		@l_proxyHostId		= 0
SET		@l_prxHostSoftState	= -999
SET		@l_prxHostEnabled	= -999
IF	@i_jobId > 0
BEGIN
SET @l_pickedMAClientId = CAST((dbo.GetJobOption(@i_jobId, 162972553)) AS INT)
END
IF	@l_pickedMAClientId > 0
BEGIN
	SELECT	@l_pkdHostSoftState = MmHostSoftState, @l_pkdHostEnabled = MmHostEnabled
	FROM	MMHost WITH (NOLOCK)
	WHERE	ClientId = @l_pickedMAClientId
	--	Return the user picked MA if it is online
	IF	@l_pkdHostSoftState = 1 AND @l_pkdHostEnabled = 1
	BEGIN
		SET @l_MAClientId = @l_pickedMAClientId
		GOTO RETURN_MA
	END
END
SET @l_checkLastSeenIndexMA = ISNULL((SELECT value FROM MMConfigs WHERE name = 'MMCONFIG_CHECK_LAST_SEEN_INDEX_MEDIAAGENT'), 0)
IF @l_checkLastSeenIndexMA > 0
BEGIN
	--get the MA name from JM options table here and see if that MA is online. If so return that MA. We have to find only snap index cache MA here.
	DECLARE @MaName     NVARCHAR(512) = ''
	DECLARE @MAId	    INT = 0
	DECLARE @jobId	    INT = 0
	DECLARE @commCellId INT = 0
	DECLARE @appId	    INT = 0
	--SELECT TOP 1 @jobId = jobId, @commCellId = commCellId FROM archFile WITH (NOLOCK) WHERE id = @i_archFileId AND commCellId = @i_commCellId
	SELECT TOP 1 @appId = appId, @commCellId = commCellId FROM archFile WITH (NOLOCK) WHERE id = @i_archFileId AND commCellId = @i_commCellId
	SELECT TOP 1 @jobId = jobId FROM JMBkpStats WITH (NOLOCK) WHERE appId = @appId AND status = 1 ORDER BY servEndDate DESC
SET @MaName = ISNULL((SELECT attributeValue FROM JMJobOptions WHERE jobId=@jobId AND commCellId=@commCellId AND attributeId=27), '')
	IF @MaName <> ''
	BEGIN
		SET @MAId = ISNULL((SELECT id FROM APP_Client WITH (NOLOCK) WHERE name = @MaName), 0)
		IF @MAId <> 0
		BEGIN
			SELECT	@l_lastSeenIndexMASoftState = MmHostSoftState, @l_lastSeenIndexMAEnabled = MmHostEnabled
			FROM	MMHost WITH (NOLOCK)
			WHERE	ClientId = @MAId
			--	Return the source client if it is an online MA
			IF	@l_lastSeenIndexMASoftState = 1 AND @l_lastSeenIndexMAEnabled = 1
				SET @l_MAClientId = @MAId
			GOTO RETURN_MA
		END
	END
END
SELECT	TOP 1 @l_srcClientId = V.SourceClientId
FROM	SMVolume V, SMVolSnapMap M, SMSnap S
WHERE	V.ArchFileId = @i_archFileId AND V.CommCellId = @i_commCellId AND V.CopyId = @i_archCopyId
	AND M.SMVolumeId = V.SMVolumeId AND S.SMSnapId = M.SMSnapId
AND (S.SnapShotEngineId IN (1, 11) OR S.OriginalSnapEngineId = 15)
IF	@l_srcClientId NOT IN (0, @l_pickedMAClientId)
BEGIN
	SELECT	@l_srcHostSoftState = MmHostSoftState, @l_srcHostEnabled = MmHostEnabled
	FROM	MMHost WITH (NOLOCK)
	WHERE	ClientId = @l_srcClientId
	--	Return the source client if it is an online MA
	IF	@l_srcHostSoftState = 1 AND @l_srcHostEnabled = 1
		SET @l_MAClientId = @l_srcClientId
	GOTO RETURN_MA
END
IF	@i_dstClientId NOT IN (0, @l_pickedMAClientId)
BEGIN
	SELECT	@l_dstHostSoftState = MmHostSoftState, @l_dstHostEnabled = MmHostEnabled
	FROM	MMHost WITH (NOLOCK)
	WHERE	ClientId = @i_dstClientId
	--	Return the destination client if it is an online MA
	IF	@l_dstHostSoftState = 1 AND @l_dstHostEnabled = 1
	BEGIN
		SET @l_MAClientId = @i_dstClientId
		GOTO RETURN_MA
	END
END
SELECT  @l_srcClientId = clientId
FROM	APP_Application WITH (NOLOCK)
WHERE	id = @i_appId
IF	@l_srcClientId NOT IN (0, @l_pickedMAClientId, @i_dstClientId)
BEGIN
	SELECT	@l_srcHostSoftState = MmHostSoftState, @l_srcHostEnabled = MmHostEnabled
	FROM	MMHost WITH (NOLOCK)
	WHERE	ClientId = @l_srcClientId
	--	Return the source client if it is an online MA
	IF	@l_srcHostSoftState = 1 AND @l_srcHostEnabled = 1
	BEGIN
		SET @l_MAClientId = @l_srcClientId
		GOTO RETURN_MA
	END
END
SELECT  @l_proxyHostId = CAST(attrVal AS INT)
FROM	APP_SubclientProp WITH (NOLOCK)
WHERE	componentNameId = @i_appId
	AND attrName = 'Snap copy : proxy to use'
	AND modified = 0
IF	@l_proxyHostId NOT IN (0, @l_pickedMAClientId, @l_srcClientId, @i_dstClientId)
BEGIN
	SELECT	@l_prxHostSoftState = MmHostSoftState, @l_prxHostEnabled = MmHostEnabled
	FROM	MMHost WITH (NOLOCK)
	WHERE	ClientId = @l_proxyHostId
	--	Return the proxy host if it is an online MA
	IF	@l_prxHostSoftState = 1 AND @l_prxHostEnabled = 1
		SET @l_MAClientId = @l_proxyHostId
END
RETURN_MA:
-- Set errorCode and MAClientId for reporting error
IF	@l_MAClientId = 0
BEGIN
SET	@l_errorCode = 383
	IF	@l_pkdHostSoftState > -1
	BEGIN
		SET @l_MAClientId = @l_pickedMAClientId
		IF	@l_pkdHostSoftState = 0
SET	@l_errorCode = 357
	END
	ELSE
	IF	@l_dstHostSoftState > -1
	BEGIN
		SET @l_MAClientId = @i_dstClientId
		IF	@l_dstHostSoftState = 0
SET	@l_errorCode = 357
	END
	ELSE
	IF	@l_srcHostSoftState > -1
	BEGIN
		SET @l_MAClientId = @l_srcClientId
		IF	@l_srcHostSoftState = 0
SET	@l_errorCode = 357
	END
	ELSE
	IF	@l_prxHostSoftState > -1
	BEGIN
		SET @l_MAClientId = @l_proxyHostId
		IF	@l_prxHostSoftState = 0
SET	@l_errorCode = 357
	END
	ELSE
SET	@l_errorCode = 436
END
IF	@l_MAClientId > 0
	SELECT	@l_errorCode, @l_MAClientId, (SELECT net_hostName FROM APP_Client WITH (NOLOCK) WHERE id = @l_MAClientId)
ELSE
	SELECT	@l_errorCode, 0, ''
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'archRestoreMediaAgentForSnap')
	delete from GxQscripts where name = 'archRestoreMediaAgentForSnap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archRestoreMediaAgentForSnap')
	delete from GXDBVersions where aliasname = 'archRestoreMediaAgentForSnap'
GO

insert into GXDBVersions values(2, 'archRestoreMediaAgentForSnap',  '00010011001200020000', 'archRestoreMediaAgentForSnap', '00010011001200020000')
GO

