

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archReservedAdminJobStreams.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archReservedAdminJobStreams.sp,v $ $Id: archReservedAdminJobStreams.sp,v 1.5.278.2 2020/11/23 20:13:10 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archReservedAdminJobStreams')
BEGIN
	print '>>> Drop Stored Procedure: archReservedAdminJobStreams <<<'
	drop procedure archReservedAdminJobStreams
END
IF EXISTS (select * from GxQscripts where name='archReservedAdminJobStreams')
	delete from GxQscripts where name = 'archReservedAdminJobStreams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archReservedAdminJobStreams')
	delete from GXDBVersions where aliasname = 'archReservedAdminJobStreams'
GO
print '... Creating Procedure: archReservedAdminJobStreams'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archReservedAdminJobStreams
  @i_jobId int,
  @i_jobType int,
  @i_SIDBStoreId int
AS
  DECLARE @o_srcReservationId int
  DECLARE @o_srcMediaGroupId int
  DECLARE @o_srcDrivePoolId int
  DECLARE @o_srcRCID int
  DECLARE @o_srcVolumeId int
  DECLARE @o_dstReservationId int
  DECLARE @o_dstMediaGroupId int
  DECLARE @o_dstDrivePoolId int
  DECLARE @o_dstRCID int
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF  @i_jobType IN (6, 25) -- AUXCOPYJOB and MEDIAREFRESHINGJOB
BEGIN
	DECLARE @tblReservation	TABLE (
			ReservationId int, ReservationType int, VolumeId int, MediaGroupId int, DrivePoolId int, RCID int, DestMediaGroupId int)
	INSERT	INTO @tblReservation
	SELECT	R.ReservationId, RJ.ReservationType, R.VolumeId, R.MediaGroupId, R.DrivePoolId, RJ.RCID, RJ.DestMediaGroupId
	FROM	MMResourceToJob RJ, MMResource R
	WHERE	R.ReservationId = RJ.ReservationId
		AND RJ.JobId_l = @i_jobId
	SELECT	S.ReservationId, S.MediaGroupId, S.DrivePoolId, S.RCID, S.VolumeId,
			D.ReservationId, D.MediaGroupId, D.DrivePoolId, D.RCID
	FROM	(SELECT	* FROM @tblReservation WHERE ReservationType = 1) S,
			(SELECT	* FROM @tblReservation WHERE ReservationType = 2) D
	WHERE	D.MediaGroupId = S.DestMediaGroupId AND S.MediaGroupId = D.DestMediaGroupId
END
/* If DV2 jobs return the reservation made on selected MA only if present*/
ELSE IF (@i_jobType = 31)
		AND (@i_SIDBStoreId > 0)
		AND EXISTS (SELECT	1
					FROM	JMJobOptions
					WHERE	jobId = @i_jobId
							AND commCellId = 2
AND attributeId = 41)
BEGIN
	SELECT	R.ReservationId, R.MediaGroupId, R.DrivePoolId, RJ.RCID, R.VolumeId,
			0, 0, 0, 0
	FROM	MMResourceToJob RJ, MMResource R
	WHERE	R.ReservationId = RJ.ReservationId
		AND RJ.JobId_l = @i_jobId
		AND R.ClientId IN (
								SELECT	attributeValueInt
								FROM	JMJobOptions
								WHERE	jobId = @i_jobId
										AND commCellId = 2
AND attributeId = 41)
END
ELSE
BEGIN
	SELECT	R.ReservationId, R.MediaGroupId, R.DrivePoolId, RJ.RCID, R.VolumeId,
			0, 0, 0, 0
	FROM	MMResourceToJob RJ, MMResource R
	WHERE	R.ReservationId = RJ.ReservationId
		AND RJ.JobId_l = @i_jobId
END
GO

IF EXISTS (select * from GxQscripts where name = 'archReservedAdminJobStreams')
	delete from GxQscripts where name = 'archReservedAdminJobStreams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archReservedAdminJobStreams')
	delete from GXDBVersions where aliasname = 'archReservedAdminJobStreams'
GO

insert into GXDBVersions values(2, 'archReservedAdminJobStreams',  '00010005027800020000', 'archReservedAdminJobStreams', '00010005027800020000')
GO

