

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archReplcationDataPathInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archReplcationDataPathInfo.sp,v $ $Id: archReplcationDataPathInfo.sp,v 1.6.208.2 2018/03/22 01:18:13 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archReplcationDataPathInfo <<<'

IF EXISTS (select * from sysobjects where name='archReplcationDataPathInfo')
	drop procedure archReplcationDataPathInfo
IF EXISTS (select * from GxQscripts where name='archReplcationDataPathInfo')
	delete from GxQscripts where name = 'archReplcationDataPathInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archReplcationDataPathInfo')
	delete from GXDBVersions where aliasname = 'archReplcationDataPathInfo'
GO
print '... Creating Procedure: archReplcationDataPathInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archReplcationDataPathInfo
  @i_appId integer,
  @i_archGroupId integer,
  @i_copyId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_CopyId integer
  DECLARE @o_CopyFlags integer
  DECLARE @o_DataPathId integer
  DECLARE @o_Flag integer
  DECLARE @o_ReadinessFlag integer
  DECLARE @o_DrivePoolId integer
  DECLARE @o_HostClientId integer
  DECLARE @o_MountPathName NVARCHAR(1024)
SET NOCOUNT ON
DECLARE @l_ClientId			integer
DECLARE @l_ArchGroupId		integer
DECLARE @l_DataPathId		integer
DECLARE	@tblDataPath TABLE (DataPathId INT, Flag INT, ReadinessFlag INT, DrivePoolId INT, HostClientId INT,
		MasterPoolId INT, MountPathId INT, MountPathTypeId INT, MountPathName NVARCHAR(1024), Precedence integer)
SELECT	@l_ClientId = clientId, @l_ArchGroupId = dataArchGrpId FROM APP_Application WHERE id = @i_appId
IF	@i_copyId = 0
BEGIN
	IF	@i_archGroupId = 0
		SET	@i_archGroupId = @l_ArchGroupId
	SELECT	@i_copyId = defaultSnapCopy FROM archGroup WHERE id = @i_archGroupId
END
-- First, choose a magnetic datapath configured at the subclient level if it exists
INSERT	INTO @tblDataPath
SELECT	A.DataPathId, A.Flag, A.ReadinessFlag, A.DrivePoolId, A.HostClientId, B.MasterPoolId, 0, 0, '', ADP.precedence
FROM	MMDataPath A, MMDrivePool B, APP_AppToDataPath ADP,
		(SELECT	TOP 1 CONVERT(INT, attrVal) AS OverrideDataPath
		FROM	APP_SubClientProp WITH (NOLOCK)
		WHERE	componentnameId = @i_appId
			AND attrName = N'Full Failover to SP dataPaths' and modified = 0) C
WHERE	A.CopyId = @i_CopyId
	AND C.OverrideDataPath = 1
AND B.DrivePoolId = A.DrivePoolId AND B.DrivePoolType =	10001
	AND ADP.dataPathId = A.DataPathId
	AND ADP.componentNameId = @i_appId
IF	@@ROWCOUNT = 0
	INSERT	INTO @tblDataPath
	SELECT	A.DataPathId, A.Flag, A.ReadinessFlag, A.DrivePoolId, A.HostClientId, B.MasterPoolId, 0, 0, '', 0
	FROM	MMDataPath A, MMDrivePool B
	WHERE	A.CopyId = @i_CopyId
AND B.DrivePoolId = A.DrivePoolId AND B.DrivePoolType = 10001
-- Second, choose a LAN-free magnetic datapath if it exists
SELECT	TOP 1 @l_DataPathId = DataPathId
FROM	@tblDataPath
WHERE	HostClientId = @l_ClientId
ORDER BY Precedence, DataPathId
IF	@l_DataPathId IS NOT NULL
	GOTO EXITOK
-- Third, choose the default datapath if it is magnetic
SELECT	TOP 1 @l_DataPathId = DataPathId
FROM	@tblDataPath
WHERE	(Flag & 1) <> 0
ORDER BY Precedence
IF	@l_DataPathId IS NOT NULL
	GOTO EXITOK
-- Last, just return the first magnetic datapath
SELECT	TOP 1 @l_DataPathId = DataPathId
FROM	@tblDataPath
ORDER BY Precedence, DataPathId
EXITOK:
IF	@l_DataPathId IS NOT NULL
	DELETE	@tblDataPath WHERE DataPathId <> @l_DataPathId
ELSE
	DELETE	@tblDataPath
UPDATE	@tblDataPath
SET		MountPathId = MP.MountPathId, MountPathTypeId = MP.MountPathTypeId, MountPathName = MP.MountPathName
FROM	@tblDataPath DP
		INNER JOIN MMMountPath MP
			ON DP.MasterPoolId = MP.MasterPoolId
IF	EXISTS (SELECT * FROM @tblDataPath WHERE MountPathTypeId > 0)
	UPDATE	@tblDataPath
	SET		MountPathName = CASE WHEN RIGHT(DC.Folder, 1) IN ('/', '\') THEN (DC.Folder + DP.MountPathName)
							ELSE (DC.Folder + (CASE WHEN LEFT(DC.Folder, 1) = '/' THEN '/' ELSE '\' END) + DP.MountPathName) END
	FROM	@tblDataPath DP
			INNER JOIN MMMountPathToStorageDevice MPSD WITH (NOLOCK) ON MPSD.MountPathId = DP.MountPathId AND DP.MountPathTypeId > 0
			INNER JOIN MMDevice D WITH (NOLOCK) ON D.DeviceId = MPSD.DeviceId
			INNER JOIN MMDeviceController DC WITH (NOLOCK) ON DC.DeviceId = D.DeviceId
SELECT	TOP 1
		@i_copyId, (SELECT flags FROM archGroupCopy WHERE id = @i_copyId),
		DataPathId, Flag, ReadinessFlag, DrivePoolId, HostClientId, MountPathName
FROM	@tblDataPath
ORDER BY Precedence
GO

IF EXISTS (select * from GxQscripts where name = 'archReplcationDataPathInfo')
	delete from GxQscripts where name = 'archReplcationDataPathInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archReplcationDataPathInfo')
	delete from GXDBVersions where aliasname = 'archReplcationDataPathInfo'
GO

insert into GXDBVersions values(2, 'archReplcationDataPathInfo',  '00010006020800020000', 'archReplcationDataPathInfo', '00010006020800020000')
GO

