

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archRecopyJobsByMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archRecopyJobsByMedia.sp,v $ $Id: archRecopyJobsByMedia.sp,v 1.12.60.6 2019/12/30 17:33:18 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archRecopyJobsByMedia')
BEGIN
	print '>>> Drop Stored Procedure: archRecopyJobsByMedia <<<'
	drop procedure archRecopyJobsByMedia
END
IF EXISTS (select * from GxQscripts where name='archRecopyJobsByMedia')
	delete from GxQscripts where name = 'archRecopyJobsByMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archRecopyJobsByMedia')
	delete from GXDBVersions where aliasname = 'archRecopyJobsByMedia'
GO
print '... Creating Procedure: archRecopyJobsByMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archRecopyJobsByMedia
  @i_mediaId integer,
  @i_userId integer
AS
  DECLARE @o_retVal integer;
  DECLARE @o_copyId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@retVal			INT = 0
DECLARE	@l_now			INT = 0
DECLARE	@l_copyId		INT = 0
IF object_id('tempdb.dbo.#tblACM') IS NOT null DROP TABLE #tblACM
IF object_id('tempdb.dbo.#tblAC') IS NOT null DROP TABLE #tblAC
IF object_id('tempdb.dbo.#tblAFC') IS NOT null DROP TABLE #tblAFC
CREATE TABLE #tblAC (
	archChunkId BIGINT, commCellId INT,
	archCopyId			INT,
	cclip				VARCHAR(255),
	physicalSize		BIGINT,
	VolumeId			INT,
	SIDBStoreId			INT,
	MediaSideId			INT,
	recordingFormat		INT,
	PRIMARY KEY (archChunkId, commCellId, archCopyId))
CREATE TABLE #tblACM (
	acCommCellId INT, archChunkId BIGINT, afCommCellId INT, archFileId INT, archCopyId INT, chunkNumber INT, physicalSize BIGINT, logicalSize BIGINT, unCompSize BIGINT,
	PRIMARY KEY (acCommCellId, archChunkId, afCommCellId, archFileId))
CREATE TABLE #tblAFC (
	archFileId INT, commCellId INT, archCopyId INT, jobId INT, fileType INT, minChunkNumber INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
DECLARE @tblCopies TABLE (
	copyId INT, defaultCopyId INT, copyType INT, isSnapCopy INT, dedupeFlags INT, sourceCopyId INT,
	PRIMARY KEY (copyId))
SET @retVal = 0
SET @l_now	= dbo.GetUnixTime(GETUTCDATE())
--
-- Check if DA is enabled before proceeding
--
declare @l_isDAEnabled integer
set @l_isDAEnabled = dbo.isDataAgingActivityEnabled (2)
if (@l_isDAEnabled = 0)
begin
set @retVal = -1000
	GOTO FINISH
end
BEGIN TRY
	INSERT	INTO #tblAFC
	SELECT	ACM.archFileId, ACM.commCellId, ACM.archCopyId, AF.jobId, AF.fileType, MIN(ACM.chunkNumber)
	FROM	archFile AF WITH (READUNCOMMITTED), archChunkMapping ACM WITH (READUNCOMMITTED), archChunk AC WITH (READUNCOMMITTED), MMVolume V WITH (READUNCOMMITTED)
	WHERE	AF.id = ACM.archFileId AND AF.commCellId = ACM.commCellId AND AF.isValid > 0
		AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId	AND ACM.chunkNumber > 0
AND AC.volumeId = V.volumeId AND AC.flags & 256 = 0
AND V.MediaId = @i_mediaId AND V.RecordingFormatId <> 10001
	GROUP BY ACM.archFileId, ACM.commCellId, ACM.archCopyId, AF.jobId, AF.fileType
	IF @@ERROR = 0 AND @@ROWCOUNT = 0
	BEGIN
SET @retVal = 100
		GOTO FINISH
	END
	INSERT INTO @tblCopies
	SELECT	C.archCopyId, AG.defaultCopy, AGC.type, AGC.isSnapCopy, AGC.dedupeFlags, (case when AGC.sourceCopyId > 0 then AGC.sourceCopyId else AG.defaultCopy end)
	FROM	(SELECT DISTINCT archCopyId
			FROM	#tblAFC) C, archGroupCopy AGC WITH (READUNCOMMITTED), archGroup AG WITH (READUNCOMMITTED)
	WHERE	C.archCopyId = AGC.id AND AGC.archGroupId = AG.id
	IF EXISTS (SELECT 1 FROM @tblCopies WHERE copyId = defaultCopyId)
	BEGIN
		SET @retVal = 1
		SELECT @l_copyId = copyId FROM @tblCopies WHERE copyId = defaultCopyId
		GOTO FINISH
	END
	ELSE IF EXISTS (SELECT 1 FROM @tblCopies WHERE isSnapCopy = 1)
	BEGIN
		SET @retVal = 2
		SELECT  @l_copyId = copyId FROM @tblCopies WHERE isSnapCopy = 1
		GOTO FINISH
	END
ELSE IF EXISTS (SELECT 1 FROM @tblCopies WHERE (dedupeFlags & 2097152) <> 0)
	BEGIN
		SET @retVal = 3
SELECT  @l_copyId = copyId FROM @tblCopies WHERE (dedupeFlags & 2097152) <> 0
		GOTO FINISH
	END
ELSE IF EXISTS (SELECT 1 FROM @tblCopies WHERE copyType = 5)
	BEGIN
		SET @retVal = 4
SELECT  @l_copyId = copyId FROM @tblCopies WHERE copyType = 5
		GOTO FINISH
	END
	DELETE	#tblAFC
	FROM	@tblCopies C INNER JOIN #tblAFC T ON C.CopyId = T.archCopyId
						LEFT OUTER JOIN archFileCopy AFC WITH (READUNCOMMITTED)
							ON	AFC.archFileId = T.archFileId AND AFC.commCellId = T.commCellId AND AFC.archCopyId = C.sourceCopyId
WHERE	AFC.archFileId Is Null OR AFC.isValid <> 1 OR (AFC.flags & 256) <> 0 OR AFC.physicalSize = 0
	DELETE	#tblAFC
	FROM	@tblCopies C INNER JOIN #tblAFC T ON C.CopyId = T.archCopyId
						LEFT OUTER JOIN JMJobDataStats J WITH (READUNCOMMITTED)
							ON	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.dataType = T.fileType AND J.archGrpCopyId = C.sourceCopyId
WHERE	J.jobId Is Null OR J.status <> 100 OR J.disabled & (1 + 256) > 0
	INSERT	INTO #tblACM
	SELECT	ACM.chunkCommCellId, ACM.archChunkId, ACM.commCellId, ACM.archFileId, ACM.archCopyId,
			(ACM.chunkNumber - T.minChunkNumber), ACM.physicalSize, ACM.logicalSize, ACM.unCompSize
	FROM	archChunkMapping ACM WITH (READUNCOMMITTED), #tblAFC T
	WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = T.archCopyId
	INSERT	INTO #tblAC
	SELECT	DISTINCT archChunkId, acCommCellId, ACM.archCopyId, AC.cclip, AC.physicalSize, V.VolumeId, V.SIDBStoreId, V.MediaSideId, V.RecordingFormatId
	FROM	#tblACM ACM, archChunk AC WITH (READUNCOMMITTED), MMVolume V WITH (READUNCOMMITTED)
	WHERE	ACM. chunkNumber >= 0
			AND ACM.archChunkId = AC.id
			AND ACM.acCommcellId = AC.CommcellId
			AND AC.volumeId = V.VolumeId
	UPDATE	archChunkMapping
SET		flags = (flags | 256), agedBy = (agedBy | 131072), modifiedTime = @l_now
	FROM	archChunkMapping ACM, #tblAFC T
	WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = T.archCopyId
		AND ACM.chunkNumber >= T.minChunkNumber
	DELETE	archChunkMapping
	FROM	archChunkMapping ACM, #tblAFC T
	WHERE	ACM.archFileId = T.archFileId AND ACM.commCellId = T.commCellId AND ACM.archCopyId = T.archCopyId
		AND ACM.chunkNumber >= T.minChunkNumber
	UPDATE	archFileCopy
SET		flags = AFC.flags & ~256,
			isValid = 0,
			lastChunkNumber = (AFC.lastChunkNumber - T.chunkNum),
			physicalSize = (AFC.physicalSize - T.physicalSize),
			logicalSize = (AFC.logicalSize - T.logicalSize),
			mediaType = 0,
			drivePoolId = 0,
			modifiedTime = @l_now,
			unCompSize = (AFC.unCompSize - T.unCompSize)
	FROM	archFileCopy AFC,
			(SELECT	archFileId, afCommCellId, archCopyId,
					COUNT(*) AS chunkNum, SUM(physicalSize) AS physicalSize, SUM(logicalSize) AS logicalSize, SUM(unCompSize) AS unCompSize
			FROM	#tblACM
			WHERE	chunkNumber >= 0
			GROUP BY archFileId, afCommCellId, archCopyId) T
	WHERE	AFC.archFileId = T.archFileId AND AFC.commCellId = T.afCommCellId AND AFC.archCopyId = T.archCopyId
	UPDATE	JDS
	SET		auxCopyJobId = 0,
			status = (CASE	WHEN T.minIsValid = 0 AND T.maxIsValid = 0 AND physicalSize = 0 THEN 101
							WHEN T.minIsValid = 0 AND T.maxIsValid = 0 AND physicalSize > 0 THEN 102
							WHEN T.minIsValid = 0 AND T.maxIsValid = 1 AND physicalSize > 0 THEN 103
					 ELSE 101
					 END),
			disabled = 0,
			archCheckEndTime = 0, archCheckStatus = 0,
			retentionFlags = 0, manualRetentionEndTime = 0,
			copiedTime = 0, agedTime = 0, mediaDeletedTime = 0, modifiedTime = @l_now,
			auxCopyStatus = (CASE	WHEN T.minIsValid = 0 AND T.maxIsValid = 0 AND physicalSize = 0 THEN 101
									WHEN T.minIsValid = 0 AND T.maxIsValid = 0 AND physicalSize > 0 THEN 102
									WHEN T.minIsValid = 0 AND T.maxIsValid = 1 AND physicalSize > 0 THEN 103
							 ELSE 101
							 END)
	FROM	JMJobDataStats JDS,
			(
			SELECT	T.JobId, T.archCopyId, T.FileType, T.CommCellId, MIN(AFC.isValid) minIsValid, MAX(AFC.isValid) maxIsValid, SUM(AFC.physicalSize) physicalSize
			FROM	(SELECT jobId, archCopyId, fileType, commCellId
					FROM	#tblAFC) T
					INNER JOIN archFile AF WITH (READUNCOMMITTED) ON T.JobId = AF.JobId AND T.CommCellId = AF.CommCellId
					INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AF.id = AFC.archFileId AND AF.CommCellID = AFC.CommCellId AND AFC.archCopyId = T.archCopyId
			GROUP BY T.JobId, T.archCopyId, T.FileType, T.CommCellId) T
	WHERE	JDS.JobId = T.JobId
			AND JDS.archGrpCopyId = T.archCopyId
			AND JDS.dataType = T.fileType
			AND JDS.CommCellId = T.CommCellId
	DELETE	FROM #tblAC
	FROM	#tblAC T, (SELECT ACM.archChunkId, ACM.chunkCommCellId, MIN(ACM.flags & 256) AS flags
										FROM archChunkMapping ACM WITH (READUNCOMMITTED), #tblAC TMP
										WHERE ACM.archChunkId = TMP.archChunkId
										AND 	ACM.chunkCommCellId = TMP.commCellId
										GROUP BY ACM.archChunkId, ACM.chunkCommCellId) C
	WHERE	C.archChunkId = T.archChunkId
	AND 	C.chunkCommCellId = T.commCellId
	AND		C.flags = 0
	INSERT	INTO MMDeletedAF
	SELECT	0, volumeId, 0, 0, archCopyId, cclip, physicalSize, archChunkId, 0, 0, 0, @l_now, 0, 0, 0, 0, 0, commCellId
	FROM	#tblAC AC
	UPDATE	archChunk
SET		flags = (flags | 256), agedBy = (agedBy | 131072), modifiedTime = @l_now
	FROM	archChunk AC, #tblAC T
	WHERE	AC.id = T.archChunkId AND AC.commCellId = T.commCellId
	--Delete chunks only if no chunks in archChunkMapping table, else leave them with AGED status
	DELETE	archChunk
	FROM	archChunk AC
			INNER JOIN #tblAC T ON	AC.id = T.archChunkId AND AC.commCellId = T.commcellId
			LEFT OUTER JOIN archChunkMapping ACM ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommcellId
	WHERE ACM.archChunkId IS NULL
	DECLARE @barCode VARCHAR(236) = ''
	SELECT	@barCode = barcode
	FROM	MMMedia
	WHERE	MediaId = @i_mediaId
	--Batching by copy
    DECLARE COPYLIST_CURSOR CURSOR FOR
    SELECT DISTINCT copyId FROM @tblCopies
    OPEN COPYLIST_CURSOR
    FETCH NEXT FROM COPYLIST_CURSOR INTO @l_copyId
    WHILE(@@FETCH_STATUS = 0)
    BEGIN
DECLARE @opMsgId        INT = (34 | (CAST(POWER(2, 24) AS BIGINT) * 84))
        DECLARE @opEvMsgId      INT = 0
        DECLARE @opId           INT = 0
        DECLARE @paramMsgId     INT = 0
        DECLARE @spName NVARCHAR(1024) = ''
        DECLARE @copyName NVARCHAR(1024) = ''
        DECLARE @l_archGroupId INT = 0
		SELECT @spName = AG.name, @copyName = AGC.name, @l_archGroupId = AG.id
        FROM    archGroup AG WITH (READUNCOMMITTED),archGroupCopy AGC WITH (READUNCOMMITTED)
        WHERE   AG.id = AGC.archGroupId
            AND AGC.id = @l_copyId
		DECLARE @jobIds TABLE (jobId INT PRIMARY KEY(JobId))
		DECLARE @jobIdsInBatch TABLE (jobId INT PRIMARY KEY(JobId))
		DECLARE @jobList nvarchar(max) = NULL
		INSERT INTO @jobIds
		SELECT	DISTINCT JobId
		FROM	#tblAFC
		WHERE	archCopyId = @l_copyId
		EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userId, 17, @l_archGroupId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId = (26 | (CAST(POWER(2, 24) AS BIGINT) * 85))
        EXEC EvGuiAuditSetParamData @opId, @spName, 0
        EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
SET @paramMsgId = (27 | (CAST(POWER(2, 24) AS BIGINT) * 85))
        EXEC EvGuiAuditSetParamData @opId, @copyName, 0
        EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
SET @paramMsgId = (25 | (CAST(POWER(2, 24) AS BIGINT) * 85))
        EXEC EvGuiAuditSetParamData @opId, @barCode, 0
        EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		WHILE EXISTS (SELECT 1 FROM @jobIds)
		BEGIN
           ;WITH CTE
            AS (SELECT TOP 50 *
            FROM  @jobIds
            ORDER BY jobId)
            DELETE FROM CTE
            OUTPUT DELETED.* INTO @jobIdsInBatch
		    SELECT @jobList = COALESCE(@jobList+', ' ,'') + CAST(jobId as varchar(10))
			FROM @jobIdsInBatch
SET @paramMsgId = (3 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParamData @opId, @jobList, 0
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		FETCH NEXT FROM COPYLIST_CURSOR INTO @l_copyId
    END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET		@retVal = (SELECT ERROR_NUMBER())
END CATCH
FINISH:
IF object_id('tempdb.dbo.#tblACM') IS NOT null DROP TABLE #tblACM
IF object_id('tempdb.dbo.#tblAC') IS NOT null DROP TABLE #tblAC
IF object_id('tempdb.dbo.#tblAFC') IS NOT null DROP TABLE #tblAFC
SELECT @retVal, @l_copyId
RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'archRecopyJobsByMedia')
	delete from GxQscripts where name = 'archRecopyJobsByMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archRecopyJobsByMedia')
	delete from GXDBVersions where aliasname = 'archRecopyJobsByMedia'
GO

insert into GXDBVersions values(2, 'archRecopyJobsByMedia',  '00010012006000060000', 'archRecopyJobsByMedia', '00010012006000060000')
GO

