

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archPruneVolSnaps.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archPruneVolSnaps.sp,v $ $Id: archPruneVolSnaps.sp,v 1.18.12.3 2018/03/22 00:59:20 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archPruneVolSnaps <<<'

IF EXISTS (select * from sysobjects where name='archPruneVolSnaps')
	drop procedure archPruneVolSnaps
IF EXISTS (select * from GxQscripts where name='archPruneVolSnaps')
	delete from GxQscripts where name = 'archPruneVolSnaps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPruneVolSnaps')
	delete from GXDBVersions where aliasname = 'archPruneVolSnaps'
GO
print '... Creating Procedure: archPruneVolSnaps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archPruneVolSnaps
  @i_ArchGroupId INTEGER,
  @i_copyId INTEGER
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN
	IF object_id('tempdb.dbo.#ToBeDeletedVols') IS NOT null DROP TABLE #ToBeDeletedVols
	CREATE TABLE #ToBeDeletedVols (
			SMVolumeId integer,
			ArchFileId integer,
			CommCellId integer,
			CopyId integer,
			primary key (SMVolumeId, ArchFileId, CommCellId, CopyId)
		)
	DECLARE @tblSnapCopy TABLE (
			CopyId integer
		)
	SET @retVal = 0
	INSERT	INTO @tblSnapCopy
	SELECT	id
	FROM	ArchGroupCopy WITH (NOLOCK)
	WHERE	isSnapCopy = 1
			AND	( @i_ArchGroupId = archGroupId OR @i_copyId = id )
	IF	object_id('tempdb.dbo.#ToBeAgedAFC') is null AND NOT EXISTS(SELECT * FROM @tblSnapCopy)
		GOTO FINISH
	-- We get list of archive files pruned from parent SP
	IF	object_id('tempdb.dbo.#ToBeAgedAFC') is not null
	BEGIN
		INSERT INTO #ToBeDeletedVols
		SELECT A.SMVolumeId, A.ArchFileId, A.CommCellId, A.CopyId
		FROM SMVolume A WITH (NOLOCK), #ToBeAgedAFC B
WHERE (A.MountStatus = 99 OR
				EXISTS (SELECT id FROM ArchGroupCopy WITH (NOLOCK) WHERE id = A.CopyId AND isSnapCopy = 1 AND isMirrorCopy = 1 AND
((flags & 1073741824) = 1073741824))
			  )
		AND A.ArchFileId = B.ArchFileId
		AND A.CommCellId = B.CommCellId
		AND A.CopyId = B.ArchCopyId
	END
	ELSE
	BEGIN
		-- Prune EDC prepared
		INSERT INTO #ToBeDeletedVols
		SELECT A.SMVolumeId, A.ArchFileId, A.CommCellId, A.CopyId
		FROM SMVolume A WITH (NOLOCK), JMPreparedJob B WITH (NOLOCK)
		WHERE A.JobId = B.JobId
		AND A.CommCellId = B.CommCellId
		AND (A.CopyId IN (SELECT CopyId FROM @tblSnapCopy))
		DELETE #ToBeDeletedVols
		FROM #ToBeDeletedVols A, ArchFileCopy B WITH (NOLOCK)
		WHERE A.ArchFileId = B.ArchFileId
		AND A.CommCellId = B.CommCellId
		AND A.CopyId = B.ArchCopyId
		INSERT INTO #ToBeDeletedVols
		SELECT A.SMVolumeId, A.ArchFileId, A.CommCellId, A.CopyId
		FROM SMVolume A WITH (NOLOCK)
WHERE (A.MountStatus = 99 OR
				EXISTS (SELECT id FROM ArchGroupCopy WITH (NOLOCK) WHERE id = A.CopyId AND isSnapCopy = 1 AND isMirrorCopy = 1 AND
((flags & 1073741824) = 1073741824))
			  )
		AND A.SMVolumeId NOT IN (SELECT SMVolumeId FROM #ToBeDeletedVols)
		AND (A.CopyId IN (SELECT CopyId FROM @tblSnapCopy))
		INSERT	INTO #ToBeDeletedVols
		SELECT	DISTINCT VOL.SMVolumeId, VOL.ArchFileId, VOL.CommCellId, VOL.CopyId
		FROM	SMVolume VOL WITH (NOLOCK) INNER JOIN SMVolSnapMap MAP WITH (NOLOCK) ON VOL.SMVolumeId = MAP.SMVolumeId
				INNER JOIN SMSnap SNAP WITH (NOLOCK) ON MAP.SMSnapId = SNAP.SMSnapId
		WHERE	SNAP.ControlHostId = 0
AND SNAP.SnapShotEngineId NOT IN ( 1, 53, 48,
58, 59 )
				AND VOL.JobId NOT IN (SELECT JobId FROM JMJobInfo WITH (NOLOCK))
AND VOL.PruneFlags <> 1
AND ( VOL.MountStatus < 39 /*SM_VS_CRT_CREATED*/ OR VOL.MountStatus = 98 /*SM_VS_DEL_FAILED*/ )
				AND	VOL.SMVolumeId NOT IN (SELECT SMVolumeId FROM #ToBeDeletedVols)
				AND (VOL.CopyId IN (SELECT CopyId FROM @tblSnapCopy))
	END
	-- Get the linked cloned DFM volumes set through SMVolSnapInfo::clone()
	-- Get all the mirrored copies for the source snaps which are going to be deleted
    WHILE EXISTS 	(SELECT T.SMVolumeId
					FROM #ToBeDeletedVols T, SMVolume S WITH (NOLOCK), ArchGroupCopy AGC  WITH (NOLOCK)
					WHERE T.SMVolumeId = S.ReserveField1
						AND S.SMVolumeId NOT IN (SELECT SMVolumeId FROM #ToBeDeletedVols)
						AND S.CopyID = AGC.id
						AND AGC.IsSnapCopy = 1
						AND AGC.IsMirrorCopy = 1)
    BEGIN
		INSERT INTO #ToBeDeletedVols
		SELECT S.SMVolumeId, S.ArchFileId, S.CommCellId, S.CopyId
		FROM #ToBeDeletedVols T, SMVolume S WITH (NOLOCK), ArchGroupCopy AGC WITH (NOLOCK)
		WHERE T.SMVolumeId = S.ReserveField1
			AND S.SMVolumeId NOT IN (SELECT SMVolumeId FROM #ToBeDeletedVols)
			AND S.CopyID = AGC.id
			AND AGC.IsSnapCopy = 1
			AND AGC.IsMirrorCopy = 1
	END
	IF EXISTS (SELECT * FROM #ToBeDeletedVols)
	BEGIN
		EXEC @retVal = MM_SMDeleteVolSnaps 0, 0
		IF @retVal <> 0
			GOTO FINISH
	END
FINISH:
DROP TABLE #ToBeDeletedVols
SELECT	@retVal
RETURN	@retVal
END
GO

IF EXISTS (select * from GxQscripts where name = 'archPruneVolSnaps')
	delete from GxQscripts where name = 'archPruneVolSnaps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPruneVolSnaps')
	delete from GXDBVersions where aliasname = 'archPruneVolSnaps'
GO

insert into GXDBVersions values(2, 'archPruneVolSnaps',  '00010018001200030000', 'archPruneVolSnaps', '00010018001200030000')
GO

