

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archPruneSpoolCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archPruneSpoolCopy.sp,v $ $Id: archPruneSpoolCopy.sp,v 1.35.40.18 2020/12/29 20:43:17 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='archPruneSpoolCopy')
BEGIN
	print '>>> Drop Stored Procedure: archPruneSpoolCopy <<<'
	drop procedure archPruneSpoolCopy
END
IF EXISTS (select * from GxQscripts where name='archPruneSpoolCopy')
	delete from GxQscripts where name = 'archPruneSpoolCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPruneSpoolCopy')
	delete from GXDBVersions where aliasname = 'archPruneSpoolCopy'
GO
print '... Creating Procedure: archPruneSpoolCopy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure archPruneSpoolCopy
  @i_archGroupId integer,
  @i_spoolCopyId integer,
  @runByDataAging integer
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@l_now INT
SET @l_now = dbo.GetUnixTime(GETUTCDATE())
DECLARE @AP_PRUNE_PRUNABLE INTEGER
SET		@AP_PRUNE_PRUNABLE = 1
DECLARE @numTargetVaultCopy INTEGER
SET			@numTargetVaultCopy = 0
DECLARE @retentionJobs INTEGER
SET		@retentionJobs = 0
DECLARE @DAJobId INTEGER
SET		@DAJobId = 0
DECLARE @PrimaryCopyId INTEGER
SET		@PrimaryCopyId = 0
DECLARE 	@ARCHIVE_GROUP_COPY_ITEM	INTEGER
SET				@ARCHIVE_GROUP_COPY_ITEM	=	8015
DECLARE		@SUB_CLIENT_ITEM	INTEGER
SET				@SUB_CLIENT_ITEM	= 2013
DECLARE @rowCnt		INTEGER
SET			@rowCnt		= 0
DECLARE	@retCode INT
IF object_id('tempdb.dbo.#TargetCopy') IS NOT null
	DROP TABLE #TargetCopy
CREATE TABLE #TargetCopy
(
	id				INT,
	isSnapCopy		INT,
	isMirrorCopy	INT
)
IF object_id('tempdb.dbo.#tblEntityInfo') IS NOT null
	DROP TABLE #tblEntityInfo
CREATE TABLE #tblEntityInfo
(
		EntityTypeId			INTEGER,
		EntityId				 	INTEGER
)
CREATE INDEX Idx_tblEntityInfo_1 ON #tblEntityInfo (EntityTypeId, EntityId)
IF object_id('tempdb.dbo.#NotAgedJob') IS NOT null
	DROP TABLE #NotAgedJob
CREATE TABLE #NotAgedJob (
	jobId INT, archGrpId INT, archGrpCopyId INT, dataType INT, commCellId INT, status INT,
	disabled INT, retentionFlags INT, appId INT, servStartDate INT, fullCycleNum INT, doNotAge INT
	PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId))
-- This is a shared temp table with stored procedure archSetJobsAgedViaTable
IF object_id('tempdb.dbo.#ToBeAgedJob') IS NOT null
	DROP TABLE #ToBeAgedJob
CREATE TABLE #ToBeAgedJob (
	jobId INT, archGrpId INT, archGrpCopyId INT, dataType INT, commCellId INT, status INT, disabled INT, doNotAge INT,
	PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId))
if object_id('tempdb.dbo.#tmpDAHoldClientList') is not null DROP TABLE #tmpDAHoldClientList
CREATE	TABLE #tmpDAHoldClientList(clientId INTEGER, reasonId INTEGER)
CREATE INDEX Idx_tmpDAHoldClientList_1 ON #tmpDAHoldClientList (clientId)
if object_id('tempdb.dbo.#tmpDAHoldInstanceList') is not null DROP TABLE #tmpDAHoldInstanceList
	CREATE	TABLE #tmpDAHoldInstanceList(
			instanceId INTEGER
	)
CREATE INDEX Idx_tmpDAHoldInstanceList_1 ON #tmpDAHoldInstanceList (instanceId)
if object_id('tempdb.dbo.#tmpNASSCOverrideSpoolRet') is not null DROP TABLE #tmpNASSCOverrideSpoolRet
CREATE	TABLE #tmpNASSCOverrideSpoolRet(
		appId					INTEGER
		primary key 	(appId)
		)
if object_id('tempdb.dbo.#tmpAppIdWithCIFSNFSConfig') is not null DROP TABLE #tmpAppIdWithCIFSNFSConfig
CREATE TABLE #tmpAppIdWithCIFSNFSConfig (
		appId int,
		primary key (appId)
)
if object_id('tempdb.dbo.#tmpCBTEnabledSubclients') is not null DROP TABLE #tmpCBTEnabledSubclients
CREATE	TABLE #tmpCBTEnabledSubclients(
		appId					INTEGER
		primary key 	(appId)
		)
DECLARE @tblMatSrcCopy TABLE (
	archGroupId INT,
	sourceCopyId INT
)
DECLARE @tblCopy TABLE (
	archGroupId 	INT,
	archCopyId		INT,
	primaryCopyId INT,
	sourceCopyId	INT,
	isSnapCopy		INT,
	isMirrorCopy	INT
)
SET	@retVal = 0
DECLARE @retainJobsOnSpoolForActiveClone INT
SET			@retainJobsOnSpoolForActiveClone = 1
SELECT @retainJobsOnSpoolForActiveClone = isnull(value, 1)
FROM MMConfigs WITH (NOLOCK)
WHERE name = 'DA_CONFIG_RETAIN_JOBS_ON_SPOOL_FOR_ACTIVE_CLONE'
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
--Get the current running DA JobId.
--There can be only 1 DA job running.
IF @runByDataAging = 1
BEGIN
	SELECT TOP 1 @DAJobId = JobId
	FROM JMAdminJobInfoTable WITH (NOLOCK)
	WHERE opType = 10
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	--Get the selected entities for pruning
	EXEC @retCode = daGetGranularSelection @DAJobId
	SELECT	@retVal = @@ERROR
	IF @retVal = 0 SET @retVal = @retCode
	IF @retVal <> 0 GOTO FINISH
	IF EXISTS (SELECT * FROM #tblEntityInfo WHERE EntityTypeId = -1)
	BEGIN
		SET	@retVal = -1
		GOTO FINISH
	END
END
INSERT INTO @tblCopy
SELECT AG.id, AGC.id, (CASE AGC.isSnapCopy WHEN 0 THEN AG.defaultCopy ELSE AG.defaultSnapCopy END), AGC.sourceCopyId, AGC.isSnapCopy, AGC.isMirrorCopy
FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
WHERE	AG.id = @i_archGroupId
AND		AG.id = AGC.archGroupId
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- The source copy will be source of Mirror copy if source copy is Mirror Copy
WHILE EXISTS(SELECT T.sourceCopyId FROM @tblCopy T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
BEGIN
	UPDATE	@tblCopy
	SET 	sourceCopyId = AGC.sourceCopyId
	FROM	@tblCopy T, archGroupCopy AGC WITH (NOLOCK)
	WHERE	T.sourceCopyId = AGC.id
	AND		AGC.isSnapCopy > 0
	AND		AGC.isMirrorCopy > 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
END
-- The source copy will be primary copy if source copy is not defined
UPDATE	@tblCopy
SET 	sourceCopyId = primaryCopyId
WHERE	sourceCopyId = 0
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
INSERT INTO @tblMatSrcCopy
SELECT DISTINCT T.archGroupId, (CASE b.sourceCopyId WHEN 0 THEN T.primaryCopyId ELSE b.sourceCopyId END)
FROM	@tblCopy T, archMaterializeSnapshotProp b WITH (NOLOCK)
WHERE	T.archGroupId = b.archGroupId
AND		T.archCopyId = (CASE b.sourceCopyId WHEN 0 THEN T.primaryCopyId ELSE b.sourceCopyId END)
AND		T.isSnapCopy > 0
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- If tape movement is not enabled then set primary snap copy as default source for tape movement and apply safety checks on primary snap copy
IF NOT EXISTS (SELECT * FROM @tblMatSrcCopy)
BEGIN
	INSERT INTO @tblMatSrcCopy
	SELECT DISTINCT T.archGroupId, primaryCopyId
	FROM	@tblCopy T
	WHERE	T.isSnapCopy > 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
END
-- Set Materialization Source Copy as source of Mirror copy, if materialization Source Copy is Mirror Copy
WHILE EXISTS(SELECT T.sourceCopyId FROM @tblMatSrcCopy T, @tblCopy C WHERE T.sourceCopyId = C.archCopyId AND C.isSnapCopy > 0 AND C.isMirrorCopy > 0)
BEGIN
	UPDATE @tblMatSrcCopy
	SET sourceCopyId = C.sourceCopyId
	FROM	@tblMatSrcCopy T, @tblCopy C
	WHERE	T.sourceCopyId = C.archCopyId
	AND		T.archGroupId = C.archGroupId
	AND		C.isSnapCopy > 0
	AND		C.isMirrorCopy > 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
END
if @runByDataAging = 0
BEGIN
	-- Do nothing if DataAging is running.
	IF EXISTS (SELECT * FROM JMJobTaskLink WHERE opType = 10)
		GOTO FINISH
	-- Do nothing if DataAging is disabled from Job Activity Control.
	IF (dbo.isDataAgingActivityEnabled(2) = 0)
		GOTO FINISH
END
-- DO NOT prune mirror copy jobs. They will be pruned with the jobs on source Snap Copy
SELECT @i_spoolCopyId = T.sourceCopyId
FROM @tblCopy T
WHERE T.archCopyId = @i_spoolCopyId
AND		T.isSnapCopy > 0
AND		T.isMirrorCopy > 0
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
SELECT @PrimaryCopyId = T.primaryCopyId
FROM   @tblCopy T
WHERE  T.archCopyId = @i_spoolCopyId
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Do nothing if DataAging is disabled for the spool copy.
-- Do nothing if Just-in-time Pruning is enabled for the spool copy.
IF NOT EXISTS (
	SELECT * FROM archAgingRule
	WHERE	copyId = @i_spoolCopyId
		AND retentionDays = 0 AND fullCycles = 0
AND flags & (4 + 8) = 0)
	GOTO FINISH
-- Check if retentionJobs is honored
SELECT	@retentionJobs = AAR.retentionJobs
FROM	@tblCopy T, archAgingRule AAR WITH (NOLOCK)
WHERE	T.archCopyId = @i_spoolCopyId
AND		T.isSnapCopy <> 0
AND		T.archCopyId = AAR.copyId
AND		(AAR.flags & 128) > 0
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
INSERT	INTO #TargetCopy
SELECT	archCopyId, isSnapCopy, isMirrorCopy
FROM	@tblCopy
WHERE	archGroupId = @i_archGroupId
AND 	archCopyId <> @i_spoolCopyId
AND		sourceCopyId = @i_spoolCopyId
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
DECLARE	@l_siloAppId INT
SET		@l_siloAppId = 0
SELECT	@l_siloAppId = siloAppId
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @i_spoolCopyId
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Get all jobs in spool copy which are not aged and not retained.
INSERT	INTO #NotAgedJob
SELECT	JDS.jobId, JDS.archGrpId, JDS.archGrpCopyId, JDS.dataType, JDS.commCellId, JDS.status, JDS.disabled, JDS.retentionFlags, JDS.appId, JBK.servStartDate, JBK.fullCycleNum, 0
FROM	JMJobDataStats JDS WITH (NOLOCK), JMBkpStats JBK WITH (NOLOCK)
WHERE	JDS.jobId = JBK.jobId
AND		JDS.commcellId = JBK.commcellId
AND		JDS.archGrpCopyId = @i_spoolCopyId
AND 	JDS.disabled & 256 = 0
AND 	JDS.appId != @l_siloAppId
UNION
SELECT	JDS.jobId, JDS.archGrpId, JDS.archGrpCopyId, JDS.dataType, JDS.commCellId, JDS.status, JDS.disabled, JDS.retentionFlags, JDS.appId, JAS.servStart, JAS.fullCycleNum, 0
FROM	JMJobDataStats JDS WITH (NOLOCK), JMAdminJobStatsTable JAS WITH (NOLOCK)
WHERE	JDS.jobId = JAS.jobId
AND		JDS.commcellId = JAS.commcellId
AND		JDS.archGrpCopyId = @i_spoolCopyId
AND 	JDS.disabled & 256 = 0
AND 	JDS.appId != @l_siloAppId
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Do Not process spool copy jobs on SP Copy/Subclients not selected or not associated for current user when run from DataAging
IF @runByDataAging = 1
BEGIN
	IF NOT EXISTS (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM AND EntityId = 0)
	BEGIN
		DELETE	#NotAgedJob
		WHERE appId NOT IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM)
		SET	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO FINISH
	END
	IF NOT EXISTS (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_COPY_ITEM AND EntityId = 0)
	BEGIN
		DELETE	#NotAgedJob
		WHERE archGrpCopyId NOT IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_COPY_ITEM)
		SET	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO FINISH
	END
END
-- Do Not process jobs if DataAging is disabled at client level
INSERT INTO #tmpDAHoldClientList
EXEC GetDAHoldClientList 0
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
IF EXISTS (SELECT clientId FROM #tmpDAHoldClientList WHERE clientId < 0)
BEGIN
	SET	@retVal = -2
	GOTO FINISH
END
-- Skip clients with DataAging disabled at client\client group level
DELETE #NotAgedJob
FROM #NotAgedJob a, #tmpDAHoldClientList b, App_Application APP WITH (NOLOCK)
WHERE a.appId = APP.id
AND   APP.clientId = b.clientId
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Do Not process jobs if DataAging is disabled at instance level
INSERT INTO #tmpDAHoldInstanceList
EXEC GetDAHoldInstanceList
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
IF EXISTS (SELECT instanceId FROM #tmpDAHoldInstanceList WHERE instanceId < 0)
BEGIN
	SET	@retVal = -2
	GOTO FINISH
END
-- Skip clients with DataAging disabled at instance level
DELETE #NotAgedJob
FROM #NotAgedJob a, #tmpDAHoldInstanceList b, App_Application APP WITH (NOLOCK)
WHERE a.appId = APP.id
AND   APP.instance = b.instanceId
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- DO NOT process jobs if retention of copy is not spool
IF NOT EXISTS (SELECT copyId FROM archAgingRule WITH (NOLOCK) WHERE copyId = @i_spoolCopyId AND retentionDays = 0 AND fullCycles = 0 AND retentionJobs = 0)
BEGIN
	SET	@retVal = -3
	GOTO FINISH
END
-- DO NOT prune the subclients with retention overridden
-- DO NOT honor spool retention at subclient level.
BEGIN
	DELETE	#NotAgedJob
	FROM #NotAgedJob a, @tblCopy b, archAppCopyAgingRule c WITH (NOLOCK), App_SubclientProp d WITH (NOLOCK)
	WHERE a.archGrpId = b.archGroupId
	AND		a.archGrpCopyId = b.archCopyId
	AND		a.archGrpId = c.archGrpId
	AND		a.appId = c.appId
	AND		(
					(CAST(d.attrVal AS INT) = 1 AND a.archGrpCopyId = b.primaryCopyId AND (c.copyId = 0 OR c.copyId = a.archGrpCopyId)) --Override only Primary Copy's Retention
					OR
					(CAST(d.attrVal AS INT) = 2 AND (c.copyId = 0 OR c.copyId = a.archGrpCopyId)) --Override All Copy's Retention
					OR
					(CAST(d.attrVal AS INT) = 3 AND c.copyId = a.archGrpCopyId) --Override each Copy's Retention
				)
	AND		c.appId = d.componentNameId
	AND		d.attrName = 'Override storage policy copy retention'
	AND		CAST(d.attrVal AS INT) > 0
	AND		d.modified = 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
END
--Get NAS Subclients to override Spool Retention
INSERT	INTO #tmpNASSCOverrideSpoolRet
EXEC getNasiDASpoolCopySubclients
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Do not prune NAS jobs on Snap Spool copy. Honor 1 cycle\1 job retention for NAS data on Snap Spool copy
-- Fix for MR# 62481\183205
DELETE #NotAgedJob
FROM #NotAgedJob a, @tblCopy b, #tmpNASSCOverrideSpoolRet c
WHERE a.archGrpCopyId = b.archCopyId
AND		b.isSnapCopy != 0
AND		a.appId = c.appId
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
--Get CIFS/NFS configured subclients
INSERT	INTO #tmpAppIdWithCIFSNFSConfig
EXEC getCIFSNFSSubclient
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Do not prune CIFS/NFS jobs on Snap Spool copy. Honor 1 cycle\1 job retention for CIFS/NFS data on Snap Spool copy
-- Fix for MR# 121992
DELETE #NotAgedJob
FROM #NotAgedJob a, @tblCopy b, #tmpAppIdWithCIFSNFSConfig c
WHERE a.archGrpCopyId = b.archCopyId
AND		b.isSnapCopy != 0
AND		a.appId = c.appId
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
--Get appIds to keep latest backup copied jobs for CBT requirements
INSERT INTO #tmpCBTEnabledSubclients
EXEC GetCBTEnabledAppIdList
SELECT	@retVal = @@ERROR, @rowCnt = @@ROWCOUNT
IF	@retVal <> 0 GOTO FINISH
IF EXISTS (SELECT 1 FROM #tmpCBTEnabledSubclients WHERE appId = -1)
BEGIN
	SET 	@retVal = -1
	IF	@retVal <> 0 GOTO FINISH
END
IF @rowCnt > 0
BEGIN
	-- Do not prune CBT configured subclients on Snap Spool copy. Honor 1 cycle\1 job retention for CBT configured subclients on Snap Spool copy
	-- Fix for MR# 189084
	DELETE #NotAgedJob
	FROM #NotAgedJob a, @tblCopy b, #tmpCBTEnabledSubclients c
	WHERE a.archGrpCopyId = b.archCopyId
	AND		b.isSnapCopy != 0
	AND		a.appId = c.appId
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
END
-- Do not prune DDB backups with Spool retention. Honor DDB retention
-- Fix for MR# 91324
DELETE #NotAgedJob
FROM #NotAgedJob a, @tblCopy b, App_SubclientProp c WITH (NOLOCK)
WHERE 	a.archGrpCopyId = b.archCopyId
AND	a.appId = c.componentNameId
AND	c.attrName = 'DDB Backup'
AND	c.attrVal = '1'
AND	c.modified = 0
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Do not prune Edge Drive subclient jobs on Spool copy.
-- Fix for MR# 117088
DELETE #NotAgedJob
FROM #NotAgedJob a, App_Application APP WITH (NOLOCK)
WHERE a.appId = APP.id
AND		APP.subclientStatus & 0x20000 = 0x20000
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
--DO NOT prune jobs with spool retention if copy is honoring job based retention
--Keep only those jobs that DO NOT honor job based retention
DELETE	#NotAgedJob
FROM	#NotAgedJob T, App_Application A WITH (NOLOCK)
WHERE	T.appId = A.id
AND		A.appTypeId NOT IN (
				SELECT appTypeId
				FROM APP_IDATypeHandlingInfo
				WHERE ignoreJobRetention = 1
			)
AND		@retentionJobs > 0
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Do not prune jobs in cycle if active clone is running
IF @retainJobsOnSpoolForActiveClone = 1
BEGIN
	UPDATE #NotAgedJob
SET 	doNotAge = doNotAge | 268435456
	FROM	#NotAgedJob a, App_Application APP WITH (NOLOCK), archFile AF WITH (NOLOCK),
				SMVolume SV WITH (NOLOCK), SMMountVolume SMV WITH (NOLOCK)
	WHERE a.appId = APP.id
AND		APP.appTypeId IN (104, 81, 22, 80, 125)
	AND		a.jobId = AF.jobId
	AND		a.commCellId = AF.commCellId
AND		AF.flags & 4194304 > 0
	AND		AF.id = SV.archFileId
	AND		AF.commCellId = SV.commCellId
	AND		a.archGrpCopyId = SV.copyId
	AND		SV.SMVolumeId = SMV.SMVolumeId
AND		SMV.MountFlags & 2048 > 0
	AND		SMV.MountStatus <= 59
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	UPDATE TMP
SET 	TMP.doNotAge = TMP.doNotAge | 268435456
	FROM	#NotAgedJob TMP, #NotAgedJob b
	WHERE TMP.appId = b.appId
	AND		TMP.fullCycleNum = b.fullCycleNum
	AND		TMP.servStartDate <= b.servStartDate
AND		b.doNotAge & 268435456 > 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
END
-- Unset retentionFlags if no extended rule exists
UPDATE	#NotAgedJob
SET		retentionFlags = 0
FROM	#NotAgedJob a LEFT OUTER JOIN archAgingRuleExtended b
ON		a.archGrpCopyId = b.copyId
WHERE	b.CopyId IS null
AND		a.retentionFlags > 0
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Get all jobs in spool copy which are not aged and not retained. If a job in spool copy has status = 100,
-- it should be fully copied to at least one secondary copy even it is disabled for copy.
INSERT	INTO #ToBeAgedJob
SELECT	DISTINCT T.jobId, T.archGrpId, T.archGrpCopyId, T.dataType, T.commCellId, T.status, T.disabled, 0
FROM	#NotAgedJob T, JMJobDataStats J WITH (NOLOCK)
WHERE	J.jobId = T.jobId
AND 	J.dataType = T.dataType
AND 	J.commCellId = T.commCellId
AND 	J.archGrpCopyId IN (SELECT id FROM #TargetCopy WHERE isMirrorCopy = 0)
AND 	((J.status = 100) OR (T.archGrpCopyId = @PrimaryCopyId AND T.status != 100))
AND 	T.retentionFlags = 0
AND 	T.disabled & (2 + 1) = 0
AND		T.doNotAge & 268435456 = 0
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Filter out jobs which are not fully copied or not even picked to any copy
IF @runByDataAging <> 2
	DELETE	#ToBeAgedJob
	FROM	#ToBeAgedJob T LEFT OUTER JOIN JMJobDataStats J WITH (NOLOCK)
	ON	J.jobId = T.jobId
	AND J.dataType = T.dataType
	AND J.commCellId = T.commCellId
	AND J.archGrpCopyId IN (SELECT id FROM #TargetCopy)
	WHERE	T.status = 100
		AND (J.jobId IS null OR J.status IN (101, 102, 103)
AND J.disabled & (1 + 256) = 0)
ELSE
	UPDATE	#ToBeAgedJob
	SET		doNotAge = doNotAge | 1
	FROM	#ToBeAgedJob T LEFT OUTER JOIN JMJobDataStats J WITH (NOLOCK)
	ON	J.jobId = T.jobId
	AND J.dataType = T.dataType
	AND J.commCellId = T.commCellId
	AND J.archGrpCopyId IN (SELECT id FROM #TargetCopy)
	WHERE	T.status = 100
		AND (J.jobId IS null OR J.status IN (101, 102, 103)
AND J.disabled & (1 + 256) = 0)
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
SELECT 	@numTargetVaultCopy = COUNT(*)
FROM	#TargetCopy
WHERE	isSnapCopy > 0
AND		isMirrorCopy = 0
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
IF EXISTS (SELECT * FROM @tblCopy WHERE archCopyId = @i_spoolCopyId AND	isSnapCopy > 0)
BEGIN
	INSERT	INTO #ToBeAgedJob
	SELECT	DISTINCT T.jobId, T.archGrpId, T.archGrpCopyId, T.dataType, T.commCellId, T.status, T.disabled, 0
	FROM	#NotAgedJob T, JMJobSnapShotStats J WITH (NOLOCK)
	WHERE	J.jobId = T.jobId
	AND 	J.commCellId = T.commCellId
	AND 	T.archGrpCopyId IN (SELECT sourceCopyId FROM @tblMatSrcCopy)
	AND		T.status = 100
	AND 	T.retentionFlags = 0
AND 	T.disabled & 2 = 0
AND		T.doNotAge & 268435456 = 0
	AND 	(J.materializationStatus = 100 OR (J.disabled & 1) = 1)
	AND		NOT EXISTS (
							SELECT	*
							FROM	#ToBeAgedJob c
							WHERE	T.jobId = c.jobId
							AND		T.archGrpCopyId = c.archGrpCopyId
							AND		T.commCellId = c.commCellId
							AND		T.dataType = c.dataType
						)
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	-- Filter out jobs which are not picked for Tape Movement and not picked for any vault copies
	IF @runByDataAging <> 2
		DELETE	#ToBeAgedJob
		FROM	#ToBeAgedJob T
		LEFT OUTER JOIN JMJobSnapShotStats J WITH (NOLOCK)
			ON		J.jobId = T.jobId
			AND 	J.commCellId = T.commCellId
			AND		J.materializationStatus IN (100)
		LEFT OUTER JOIN JMJobDataStats JDS WITH (NOLOCK)
			ON	JDS.jobId = T.jobId
			AND JDS.dataType = T.dataType
			AND JDS.commCellId = T.commCellId
			AND JDS.archGrpCopyId IN (SELECT id FROM #TargetCopy WHERE isMirrorCopy = 0)
			AND	JDS.status IN (100)
		WHERE	T.status = 100
		AND 	T.archGrpCopyId IN (SELECT sourceCopyId FROM @tblMatSrcCopy)
		AND 	J.jobId IS null
		AND 	JDS.jobId IS null
	ELSE
		UPDATE	#ToBeAgedJob
		SET		doNotAge = doNotAge | 2
		FROM	#ToBeAgedJob T
		LEFT OUTER JOIN JMJobSnapShotStats J WITH (NOLOCK)
			ON		J.jobId = T.jobId
			AND 	J.commCellId = T.commCellId
			AND		J.materializationStatus IN (100)
		LEFT OUTER JOIN JMJobDataStats JDS WITH (NOLOCK)
			ON	JDS.jobId = T.jobId
			AND JDS.dataType = T.dataType
			AND JDS.commCellId = T.commCellId
			AND JDS.archGrpCopyId IN (SELECT id FROM #TargetCopy WHERE isMirrorCopy = 0)
			AND	JDS.status IN (100)
		WHERE	T.status = 100
		AND 	T.archGrpCopyId IN (SELECT sourceCopyId FROM @tblMatSrcCopy)
		AND 	J.jobId IS null
		AND 	JDS.jobId IS null
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
END
-- Filter out jobs which are not copied
IF @runByDataAging <> 2
	DELETE	#ToBeAgedJob
	FROM	#ToBeAgedJob T, JMJobDataStats J WITH (NOLOCK)
	WHERE	J.jobId = T.jobId
	AND 	J.commCellId = T.commCellId
	AND		J.dataType = T.dataType
	AND		J.archGrpCopyId IN (SELECT id FROM #TargetCopy)
	AND		T.status = 100
	AND 	J.status IN (101, 102, 103)
AND		J.disabled & (1 + 256) = 0
ELSE
	UPDATE	#ToBeAgedJob
	SET		doNotAge = doNotAge | 1
	FROM	#ToBeAgedJob T, JMJobDataStats J WITH (NOLOCK)
	WHERE	J.jobId = T.jobId
	AND 	J.commCellId = T.commCellId
	AND		J.dataType = T.dataType
	AND		J.archGrpCopyId IN (SELECT id FROM #TargetCopy)
	AND		T.status = 100
	AND 	J.status IN (101, 102, 103)
AND		J.disabled & (1 + 256) = 0
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Filter out jobs which are not Moved To Tape
IF @runByDataAging <> 2
	DELETE	#ToBeAgedJob
	FROM	#ToBeAgedJob T, JMJobSnapShotStats J WITH (NOLOCK)
	WHERE	J.jobId = T.jobId
	AND 	J.commCellId = T.commCellId
	AND 	T.archGrpCopyId IN (SELECT sourceCopyId FROM @tblMatSrcCopy)
	AND		T.status = 100
	AND 	J.materializationStatus IN (101, 102, 103)
AND 	J.disabled & 1 = 0
ELSE
	UPDATE	#ToBeAgedJob
	SET		doNotAge = doNotAge | 2
	FROM	#ToBeAgedJob T, JMJobSnapShotStats J WITH (NOLOCK)
	WHERE	J.jobId = T.jobId
	AND 	J.commCellId = T.commCellId
	AND 	T.archGrpCopyId IN (SELECT sourceCopyId FROM @tblMatSrcCopy)
	AND		T.status = 100
	AND 	J.materializationStatus IN (101, 102, 103)
AND 	J.disabled & 1 = 0
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Get Mirror Snap Copy jobs if the copy is source of mirror snap copy
INSERT	INTO #ToBeAgedJob
SELECT	T.jobId, T.archGrpId, C.archCopyId, T.dataType, T.commCellId, T.status, T.disabled, T.doNotAge
FROM	#ToBeAgedJob T, @tblCopy C
WHERE	T.archGrpId = C.archGroupId
AND		T.archGrpCopyId = C.sourceCopyId
AND 	C.isSnapCopy > 0
AND 	C.isMirrorCopy > 0
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- DO NOT PROCESS ANY FOREIGN JOBS
DELETE #ToBeAgedJob
FROM #ToBeAgedJob T, APP_CommCell C WITH (NOLOCK)
WHERE	T.commCellId = C.id
AND		C.type > 1
SET	@retVal = @@ERROR
IF	@retVal <> 0 GOTO FINISH
-- Set jobs in the shared temp table #ToBeAgedJob as aged
IF @runByDataAging <> 2
BEGIN
	IF @runByDataAging = 1 AND NOT EXISTS(SELECT 1 FROM MMConfigs WITH(NOLOCK) WHERE name = 'DA_CONFIG_DISABLE_DATROUBLESHOOTING_DATA_COLLECTION' AND value = 1)
	BEGIN
		--Update DAJobRetentionInfo table
		DECLARE @timeNow INT = dbo.GetUnixTime(GETUTCDATE())
		--Reset old reasons here
		UPDATE DAJobRetentionInfo SET jobRetainReason = 0, modified = @timeNow
		WHERE copyId = @i_spoolCopyId
		SET	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO FINISH
		--DONOTAGE_FILTERED is also set for spoolcopy case not just granular data aging, so reset that flag if appIdSelectedForPruning is 1
UPDATE a SET jobRetainReason = CASE WHEN ACA.appIdSelectedForPruning = 1 THEN ACA.doNotAge & ~(8) ELSE ACA.doNotAge END, appFlags = ACA.appFlags, modified = @timeNow
		FROM DAJobRetentionInfo a INNER JOIN ArchAppCopyToBeAged ACA ON a.appId = ACA.appId AND a.copyId = ACA.copyId
		AND a.copyId = @i_spoolCopyId AND ACA.doNotAge > 0
		SET	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO FINISH
		/*
		Reason for this block. When the copy is dependent on global policy even though copy is filtered in granular selection,
		if global policy is selected, DASelectAppIdToBeAged sets appIdSelectedForPruning = 1.
		But in this stored proc for spool copy processing we don't process jobs if the copy is not in granular selection.
		Refer the query 'DELETE #NotAged' based on #tblEntityInfo in this stored procedure somewhere above.
		So setting DONOTAGE_FILTERED flag based on granular selection here.
		*/
		IF NOT EXISTS (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM AND EntityId = 0)
		BEGIN
UPDATE DAJobRetentionInfo SET jobRetainReason = jobRetainReason | 8
			WHERE appId NOT IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM)
			SET	@retVal = @@ERROR
			IF	@retVal <> 0 GOTO FINISH
		END
		IF NOT EXISTS (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_COPY_ITEM AND EntityId = 0)
		BEGIN
UPDATE DAJobRetentionInfo SET jobRetainReason = jobRetainReason | 8
			WHERE copyId NOT IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_COPY_ITEM)
			SET	@retVal = @@ERROR
			IF	@retVal <> 0 GOTO FINISH
		END
		UPDATE	a
SET	jobRetainReason = (jobRetainReason | 256), modified = @timeNow
		FROM	DAJobRetentionInfo a, #NotAgedJob b
		WHERE	a.jobId = b.jobId
			AND	a.commCellId = b.commCellId
			AND	a.copyId = b.archGrpCopyId
			AND	a.dataType = b.dataType
AND b.disabled & 2 != 0
		SET	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO FINISH
		UPDATE a
SET		jobRetainReason = jobRetainReason | 268435456, modified = @timeNow
		FROM	DAJobRetentionInfo a, #NotAgedJob b
		WHERE	a.jobId = b.jobId
		AND		a.commCellId = b.commCellId
		AND		a.copyId = b.archGrpCopyId
		AND		a.dataType = b.dataType
AND		b.doNotAge & 268435456 > 0
		SET	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO FINISH
		UPDATE  a
SET     jobRetainReason = (jobRetainReason | 128)
                FROM    DAJobRetentionInfo a, #NotAgedJob b
                WHERE   a.jobId = b.jobId
    		AND a.commCellId = b.commCellId
                AND a.copyId = b.archGrpCopyId
                AND	a.dataType = b.dataType
                AND b.retentionFlags != 0
                SET @retVal = @@ERROR
                IF  @retVal <> 0 GOTO FINISH
		UPDATE a
SET		jobRetainReason = jobRetainReason | 512, modified = @timeNow
		FROM	DAJobRetentionInfo a, #NotAgedJob b
		WHERE	a.jobId = b.jobId
		AND		a.commCellId = b.commCellId
		AND		a.copyId = b.archGrpCopyId
		AND		a.dataType = b.dataType
		AND NOT EXISTS(
		SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK)
		WHERE JDS.jobId = b.jobId
		AND JDS.commcellId = b.commcellId
		AND	JDS.dataType = b.dataType
		AND JDS.archGrpCopyId IN (SELECT id FROM #TargetCopy WHERE isMirrorCopy = 0)
		AND JDS.status = 100
		)
		AND b.archGrpCopyId NOT IN (SELECT sourceCopyId FROM @tblMatSrcCopy)
AND a.jobRetainReason & (256 + 128 + 268435456) = 0
		SET @retVal = @@ERROR
    		IF  @retVal <> 0 GOTO FINISH
		IF EXISTS (SELECT * FROM @tblCopy WHERE archCopyId = @i_spoolCopyId AND isSnapCopy > 0)
		BEGIN
			UPDATE a
SET		jobRetainReason = jobRetainReason | 131072, modified = @timeNow
			FROM	DAJobRetentionInfo a INNER JOIN #NotAgedJob b
			ON		a.jobId = b.jobId
			AND		a.commCellId = b.commCellId
			AND		a.copyId = b.archGrpCopyId
			AND		a.dataType = b.dataType
			LEFT OUTER JOIN JMJobSnapShotStats JSS WITH(NOLOCK)
			ON b.jobId = JSS.jobId
			AND b.commcellId = JSS.commcellId
			AND JSS.materializationStatus = 100
			WHERE	b.archGrpCopyId IN (SELECT sourceCopyId FROM @tblMatSrcCopy) AND JSS.jobId IS NULL
			AND NOT EXISTS
			(
				SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK)
				WHERE JDS.jobId = b.jobId
				AND JDS.commcellId = b.commcellId
				AND	JDS.dataType = b.dataType
				AND JDS.archGrpCopyId IN (SELECT id FROM #TargetCopy WHERE isMirrorCopy = 0)
				AND JDS.status = 100
			)
AND a.jobRetainReason & (256 + 128 + 268435456) = 0
		END
	END
	IF EXISTS (SELECT * FROM #ToBeAgedJob)
	BEGIN
		BEGIN TRANSACTION
EXEC @retCode = archSetJobsAgedViaTable 32768, @l_now
		SET	@retVal = @@ERROR
		IF	@retVal = 0 SET @retVal = @retCode
		IF	@retVal = 0
			COMMIT TRANSACTION
		ELSE
			ROLLBACK TRANSACTION
	END
END
ELSE
BEGIN
	UPDATE	#ArchJobCopy
	SET		pruneStatus = @AP_PRUNE_PRUNABLE
	FROM	#ArchJobCopy a, #ToBeAgedJob b
	WHERE	a.jobId = b.jobId
		AND	a.copyId = b.archGrpCopyId
		AND	(a.FileType = b.dataType OR a.FileType = 0)
		AND	a.commCellId = b.commCellId
		AND b.doNotAge = 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	UPDATE	#ArchJobCopy
SET		pruneStatus = (pruneStatus |512),
jobRetainReason = (jobRetainReason | 512)
	FROM	#ArchJobCopy a, #ToBeAgedJob b
	WHERE	a.jobId = b.jobId
		AND	a.copyId = b.archGrpCopyId
		AND	(a.FileType = b.dataType OR a.FileType = 0)
		AND	a.commCellId = b.commCellId
		AND b.doNotAge & 1 > 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	UPDATE	#ArchJobCopy
SET		pruneStatus = (pruneStatus |131072),
jobRetainReason = (jobRetainReason | 131072)
	FROM	#ArchJobCopy a, #ToBeAgedJob b
	WHERE	a.jobId = b.jobId
		AND	a.copyId = b.archGrpCopyId
		AND	(a.FileType = b.dataType OR a.FileType = 0)
		AND	a.commCellId = b.commCellId
		AND b.doNotAge & 2 > 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	UPDATE	#ArchJobCopy
SET		pruneStatus = (pruneStatus | 256),
jobRetainReason = (jobRetainReason | 256)
	FROM	#ArchJobCopy a, #NotAgedJob b
	WHERE	a.jobId = b.jobId
		AND	a.copyId = b.archGrpCopyId
		AND	(a.FileType = b.dataType OR a.FileType = 0)
		AND	a.commCellId = b.commCellId
AND b.disabled & 2 != 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	UPDATE	#ArchJobCopy
SET		pruneStatus = (pruneStatus | 268435456),
jobRetainReason = jobRetainReason | 268435456
	FROM	#ArchJobCopy a, #NotAgedJob b
	WHERE	a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.copyId = b.archGrpCopyId
	AND		(a.FileType = b.dataType OR a.FileType = 0)
AND		b.doNotAge & 268435456 > 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	UPDATE	#ArchJobCopy
SET		pruneStatus = (pruneStatus | 128),
jobRetainReason = (jobRetainReason | 128),
			extRetentionFlags = b.retentionFlags
	FROM	#ArchJobCopy a, #NotAgedJob b
	WHERE	a.jobId = b.jobId
		AND	a.copyId = b.archGrpCopyId
		AND	(a.FileType = b.dataType OR a.FileType = 0)
		AND	a.commCellId = b.commCellId
		AND b.retentionFlags != 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO FINISH
	-- For regular SPOOL Copy
	IF EXISTS (SELECT * FROM @tblCopy WHERE archCopyId = @i_spoolCopyId AND	isSnapCopy = 0)
	BEGIN
		UPDATE	#ArchJobCopy
SET		pruneStatus = (pruneStatus |512),
jobRetainReason = (jobRetainReason | 512)
		FROM	#ArchJobCopy a, #NotAgedJob b
		WHERE	a.jobId = b.jobId
			AND	a.copyId = b.archGrpCopyId
			AND	(a.FileType = b.dataType OR a.FileType = 0)
			AND	a.commCellId = b.commCellId
			AND NOT EXISTS (
				SELECT	*
				FROM	#ToBeAgedJob c
				WHERE	b.jobId = c.jobId
				AND		b.archGrpCopyId = c.archGrpCopyId
				AND		b.commCellId = c.commCellId
				AND		b.dataType = c.dataType
			)
AND a.pruneStatus & (256 + 128 + 268435456) = 0
		SET	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO FINISH
	END
	-- For SNAP SPOOL Copy
	IF EXISTS (SELECT * FROM @tblCopy WHERE archCopyId = @i_spoolCopyId AND	isSnapCopy > 0)
	BEGIN
		--If job is picked for AuxCopy then set DONOTAGE_NOTCOPIED
		IF @numTargetVaultCopy > 0
		BEGIN
			UPDATE	#ArchJobCopy
SET		pruneStatus = (pruneStatus |512),
jobRetainReason = (jobRetainReason | 512)
			FROM	#ArchJobCopy a, #NotAgedJob b
			WHERE	a.jobId = b.jobId
				AND	a.copyId = b.archGrpCopyId
				AND	(a.FileType = b.dataType OR a.FileType = 0)
				AND	a.commCellId = b.commCellId
			AND		NOT EXISTS (
					SELECT	*
					FROM	#ToBeAgedJob c
					WHERE	b.jobId = c.jobId
					AND		b.archGrpCopyId = c.archGrpCopyId
					AND		b.commCellId = c.commCellId
					AND		b.dataType = c.dataType
				)
AND a.pruneStatus & (256 + 128 + 268435456) = 0
			SET	@retVal = @@ERROR
			IF	@retVal <> 0 GOTO FINISH
		END
		--If job is not picked for AuxCopy then set DONOTAGE_BYMATERIALIZATIONRULE
		UPDATE	#ArchJobCopy
		SET		pruneStatus = (CASE WHEN (JDS.jobId IS null OR (JDS.status IN (101, 102, 103) AND JDS.disabled & 1 = 1))
THEN ((pruneStatus | 131072) & ~512)
															WHEN (J.jobId IS NULL OR (J.materializationStatus IN (101, 102, 103) AND J.disabled & 1 = 1))
THEN (pruneStatus | 512)
ELSE (pruneStatus | 131072)
												END),
				jobRetainReason = (CASE WHEN (JDS.jobId IS null OR (JDS.status IN (101, 102, 103) AND JDS.disabled & 1 = 1))
THEN ((jobRetainReason | 131072) & ~512)
															WHEN (J.jobId IS NULL OR (J.materializationStatus IN (101, 102, 103) AND J.disabled & 1 = 1))
THEN (jobRetainReason | 512)
ELSE (jobRetainReason | 131072)
												END)
		FROM	#ArchJobCopy a
		INNER JOIN #NotAgedJob b
			ON 		a.jobId = b.jobId
			AND		a.commCellId = b.commCellId
			AND		a.copyId = b.archGrpCopyId
			AND		(a.FileType = b.dataType OR a.FileType = 0)
		LEFT OUTER JOIN JMJobDataStats JDS WITH (NOLOCK)
			ON	JDS.jobId = b.jobId
			AND JDS.dataType = b.dataType
			AND JDS.commCellId = b.commCellId
			AND JDS.archGrpCopyId IN (SELECT id FROM #TargetCopy)
		LEFT OUTER JOIN JMJobSnapShotStats J WITH (NOLOCK)
			ON		b.jobId = J.jobId
			AND 	b.commCellId = J.commCellId
		WHERE	b.archGrpCopyId IN (SELECT sourceCopyId FROM @tblMatSrcCopy)
		AND		b.status = 100
		AND		(JDS.jobId IS null OR JDS.status IN (101, 102, 103))
		AND		(J.jobId IS NULL OR J.materializationStatus IN (101, 102, 103))
		AND		NOT EXISTS (
					SELECT	*
					FROM	#ToBeAgedJob c
					WHERE	b.jobId = c.jobId
					AND		b.archGrpCopyId = c.archGrpCopyId
					AND		b.commCellId = c.commCellId
					AND		b.dataType = c.dataType
				)
AND 	a.pruneStatus & (256 + 128 + 268435456) = 0
		SET	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO FINISH
	END
END
FINISH:
IF object_id('tempdb.dbo.#tblEntityInfo') IS NOT null
	DROP TABLE #tblEntityInfo
if object_id('tempdb.dbo.#tmpDAHoldClientList') is not null
	DROP TABLE #tmpDAHoldClientList
if object_id('tempdb.dbo.#tmpDAHoldInstanceList') is not null
	DROP TABLE #tmpDAHoldInstanceList
IF object_id('tempdb.dbo.#TargetCopy') IS NOT null
	DROP TABLE #TargetCopy
IF object_id('tempdb.dbo.#ToBeAgedJob') IS NOT null
	DROP TABLE #ToBeAgedJob
IF object_id('tempdb.dbo.#NotAgedJob') IS NOT null
	DROP TABLE #NotAgedJob
IF object_id('tempdb.dbo.#tmpNASSCOverrideSpoolRet') is not null
	DROP TABLE #tmpNASSCOverrideSpoolRet
if object_id('tempdb.dbo.#tmpAppIdWithCIFSNFSConfig') is not null
	DROP TABLE #tmpAppIdWithCIFSNFSConfig
if object_id('tempdb.dbo.#tmpCBTEnabledSubclients') is not null
	DROP TABLE #tmpCBTEnabledSubclients
SELECT @retVal
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'archPruneSpoolCopy')
	delete from GxQscripts where name = 'archPruneSpoolCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPruneSpoolCopy')
	delete from GXDBVersions where aliasname = 'archPruneSpoolCopy'
GO

insert into GXDBVersions values(2, 'archPruneSpoolCopy',  '00010035004000180000', 'archPruneSpoolCopy', '00010035004000180000')
GO

