

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archPruneDanglingSILO.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archPruneDanglingSILO.sp,v $ $Id: archPruneDanglingSILO.sp,v 1.7.274.3 2018/09/29 20:23:30 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archPruneDanglingSILO <<<'

IF EXISTS (select * from sysobjects where name='archPruneDanglingSILO')
	drop procedure archPruneDanglingSILO
IF EXISTS (select * from GxQscripts where name='archPruneDanglingSILO')
	delete from GxQscripts where name = 'archPruneDanglingSILO'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPruneDanglingSILO')
	delete from GXDBVersions where aliasname = 'archPruneDanglingSILO'
GO
print '... Creating Procedure: archPruneDanglingSILO'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archPruneDanglingSILO
  @i_dummy INTEGER
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_retVal INTEGER;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE	@errorCode 	INTEGER
	SET			@errorCode 	= 0
	DECLARE	@retCode 	INTEGER
	SET			@retCode 	= 0
	DECLARE @SILOListCursorFlag 	INTEGER
	SET 		@SILOListCursorFlag 	= 0
	DECLARE @curSIDBStoreId				INTEGER
	SET 		@curSIDBStoreId			 	= 0
	DECLARE @curCommCellId				INTEGER
	SET 		@curCommCellId			 	= 0
	/*************************** Create Temp Tables ***************************/
	if object_id('tempdb.dbo.#DanglingSiloList') is not null DROP TABLE #DanglingSiloList
	if object_id('tempdb.dbo.#PrunableStoreList') is not null DROP TABLE #PrunableStoreList
	CREATE	TABLE #DanglingSiloList (
			SIDBStoreId 			INTEGER,
			volumeId 					INTEGER,
			commCellId				INTEGER,
			clientId					INTEGER,
			mountPathId  			INTEGER,
			mountPathTypeId		INTEGER,
			mountPathName 		NVARCHAR(2048),
			userName		 			VARCHAR(1024),
			UserPassword			VARCHAR(1024),
			volumeAttribute		INTEGER,
			PRIMARY KEY (SIDBStoreId, commCellId))
	CREATE	TABLE #PrunableStoreList (
			SIDBStoreId INT,
			commCellId	INT,
			PRIMARY KEY (SIDBStoreId, commCellId))
	-- Get only those SIDBStoreId that have recyclable volumes
	INSERT INTO #DanglingSiloList
	EXEC archGetPrunableSILOList 1, 0
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
	IF EXISTS (SELECT * FROM #DanglingSiloList WHERE SIDBStoreId = -1)
	BEGIN
		-- Error in getting Dangling SILO List
		SET		@errorCode = -1
		GOTO 	CX_EXIT
	END
	DECLARE	SILOListCursor CURSOR STATIC FOR
		SELECT DISTINCT SIDBStoreId, commCellId
		FROM #DanglingSiloList
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
	SET		@SILOListCursorFlag = 1
	OPEN	SILOListCursor
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
	FETCH	NEXT
	FROM SILOListCursor
	INTO	@curSIDBStoreId, @curCommCellId
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		EXEC @retCode = archDeleteSILOArchiveFiles @curSIDBStoreId, @curCommCellId, 0
		SET	@errorCode = @@ERROR
		IF	@errorCode = 0	SET	@errorCode = @retCode
		IF	@errorCode <> 0 GOTO CX_EXIT
		FETCH	NEXT
		FROM SILOListCursor
		INTO	@curSIDBStoreId, @curCommCellId
		SET	@errorCode = @@ERROR
		IF	@errorCode <> 0 GOTO CX_EXIT
	END
	-- Handle the regular SEALED SI Store pruning here that does not have SILO backup enabled
	INSERT INTO #PrunableStoreList
	SELECT DISTINCT V.SIDBStoreId, (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
	FROM MMVolume V WITH (NOLOCK), IDXSIDBStore SS WITH (NOLOCK)
	WHERE V.SIDBStoreId = SS.SIDBStoreId
	AND	(CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END) = SS.commCellId
AND	(SS.flags & 2097152) = 0
	AND	V.SIDBStoreId > 0
	AND	V.VolumeFlags = 6	-- Recyclable Volumes
	SET	@errorCode = @@ERROR
	IF	@errorCode <> 0 GOTO CX_EXIT
	-- Remove the ACTIVE SIDBStoreId
	DELETE #PrunableStoreList
	FROM #PrunableStoreList PSL, archCopySIDBStore ACS WITH (NOLOCK)
	WHERE PSL.SIDBStoreId = ACS.SIDBStoreId
AND ACS.flags & 4 > 0
	AND		PSL.commCellId = 2	-- Active commcell SIDBStoreId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_EXIT
	-- Remove the NOT PRUNABLE SIDBStoreId if there is atleast one non-recyclable volume
	DELETE #PrunableStoreList
	FROM #PrunableStoreList PSL, MMVolume V WITH (NOLOCK)
	WHERE PSL.SIDBStoreId = V.SIDBStoreId
	AND		PSL.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
	AND		V.VolumeFlags <> 6
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_EXIT
	-- Remove the SIDBStoreId if there is atleast one volume referenced in archChunk table
	DELETE #PrunableStoreList
	FROM #PrunableStoreList PSL, MMVolume V WITH (NOLOCK), archChunk AC WITH (NOLOCK)
	WHERE PSL.SIDBStoreId = V.SIDBStoreId
	AND		PSL.commCellId = (CASE WHEN V.OrigCcCommCellId > 0 THEN V.OrigCcCommCellId ELSE 2 END)
	AND		V.VolumeId = AC.VolumeId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_EXIT
	-- Remove the SIDBStoreId if the SILO tape backup job is currently running for that store
	DELETE #PrunableStoreList
	FROM #PrunableStoreList PSL, archCopySIDBStore ACSS WITH (NOLOCK),
		 archGroupCopy AGC WITH (NOLOCK), JMJobInfo JI WITH (NOLOCK),
		 JMBkpJobInfo BJI WITH (NOLOCK), JMJobOptions JO WITH (NOLOCK)
	WHERE PSL.SIDBStoreId = ACSS.SIDBStoreId
	AND		PSL.commCellId = ACSS.CommCellId
	AND		ACSS.CopyId = AGC.id
	AND		AGC.siloAppId = BJI.applicationId
	AND		BJI.jobId = JI.jobId
	AND		BJI.commcellId = JI.commCellId
	AND		JI.opType = 4
	AND		JI.jobId = JO.jobId
	AND		JI.commcellId = JO.commCellId
	AND		JO.attributeId = 21
	AND		JO.attributeValueInt = PSL.SIDBStoreId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_EXIT
	-- Mark these prunable stores as Recyclable and AGED
	UPDATE IdxSIDBStore WITH (PAGLOCK)
SET flags = (flags | (128 | 256))
	FROM IdxSIDBStore SS, #PrunableStoreList PSL
	WHERE SS.SIDBStoreId = PSL.SIDBStoreId
	AND	SS.commCellId = PSL.commCellId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_EXIT
CX_EXIT:
	IF @SILOListCursorFlag = 1
	BEGIN
			CLOSE				SILOListCursor
			DEALLOCATE	SILOListCursor
	END
	DROP TABLE #DanglingSiloList
	DROP TABLE #PrunableStoreList
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'archPruneDanglingSILO')
	delete from GxQscripts where name = 'archPruneDanglingSILO'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPruneDanglingSILO')
	delete from GXDBVersions where aliasname = 'archPruneDanglingSILO'
GO

insert into GXDBVersions values(2, 'archPruneDanglingSILO',  '00010007027400030000', 'archPruneDanglingSILO', '00010007027400030000')
GO

