

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archPopulateSIVolumeChunkList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archPopulateSIVolumeChunkList.sp,v $ $Id: archPopulateSIVolumeChunkList.sp,v 1.6.208.1 2018/03/22 01:03:49 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archPopulateSIVolumeChunkList <<<'

IF EXISTS (select * from sysobjects where name='archPopulateSIVolumeChunkList')
	drop procedure archPopulateSIVolumeChunkList
IF EXISTS (select * from GxQscripts where name='archPopulateSIVolumeChunkList')
	delete from GxQscripts where name = 'archPopulateSIVolumeChunkList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPopulateSIVolumeChunkList')
	delete from GXDBVersions where aliasname = 'archPopulateSIVolumeChunkList'
GO
print '... Creating Procedure: archPopulateSIVolumeChunkList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archPopulateSIVolumeChunkList
  @i_truncateTables INTEGER,
  @i_DumpFileName NVARCHAR(2048),
  @i_DumpFileLocation NVARCHAR(2048),
  @i_dummy INTEGER
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_retVal INTEGER
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @SQL	NVARCHAR(2048)
	SET		@SQL	= ''
	DECLARE	@errorCode 	INTEGER
	SET			@errorCode 	= 0
	CREATE TABLE #tmpSIVolumeChunk
	(
		mountPathId	INTEGER,
		volumeId 		INTEGER,
		chunkId 		BIGINT,
		chunkSize		BIGINT,
		isSIVolume	TINYINT
	)
	IF @i_DumpFileName IS NULL OR @i_DumpFileName = ''
		SET @i_DumpFileName = 'SIVolumChunkList.csv'
	DECLARE @SIVolChunkCSVFile	NVARCHAR(2048)
	SET			@SIVolChunkCSVFile	= @i_DumpFileLocation + '\' + @i_DumpFileName
	IF @i_truncateTables = 1
	BEGIN
	IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[SIVolumeChunk]') and OBJECTPROPERTY(id, N'IsTable') = 1)
		DROP TABLE SIVolumeChunk
		CREATE TABLE SIVolumeChunk
		(
			chunkId 		BIGINT,
			volumeId 		INTEGER,
			mountPathId	INTEGER,
			chunkSize		BIGINT,
			isSIVolume	TINYINT,
			creatTime		DATETIME
		)
	END
	SET @SQL = 'BULK INSERT #tmpSIVolumeChunk FROM ''' + @SIVolChunkCSVFile  + ''' WITH (FIRSTROW = 2,FIELDTERMINATOR = '','')'
	EXEC (@SQL)
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_EXIT
	INSERT INTO SIVolumeChunk
	SELECT chunkId, volumeId, mountPathId, chunkSize, isSIVolume, getUTCDate()
	FROM #tmpSIVolumeChunk
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_EXIT
	DELETE #tmpSIVolumeChunk
CX_EXIT:
	SELECT @errorCode
	DROP TABLE #tmpSIVolumeChunk
	RETURN
GO


IF EXISTS (select * from GxQscripts where name = 'archPopulateSIVolumeChunkList')
	delete from GxQscripts where name = 'archPopulateSIVolumeChunkList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPopulateSIVolumeChunkList')
	delete from GXDBVersions where aliasname = 'archPopulateSIVolumeChunkList'
GO

insert into GXDBVersions values(2, 'archPopulateSIVolumeChunkList',  '00010006020800010000', 'archPopulateSIVolumeChunkList', '00010006020800010000')
GO

