

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archPopulateSIDBData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archPopulateSIDBData.sp,v $ $Id: archPopulateSIDBData.sp,v 1.5.208.1 2018/03/22 00:55:07 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archPopulateSIDBData <<<'

IF EXISTS (select * from sysobjects where name='archPopulateSIDBData')
	drop procedure archPopulateSIDBData
IF EXISTS (select * from GxQscripts where name='archPopulateSIDBData')
	delete from GxQscripts where name = 'archPopulateSIDBData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPopulateSIDBData')
	delete from GXDBVersions where aliasname = 'archPopulateSIDBData'
GO
print '... Creating Procedure: archPopulateSIDBData'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archPopulateSIDBData
  @i_truncateTables INTEGER,
  @i_PrimaryDumpFile NVARCHAR(2048) = NULL,
  @i_SecondaryDumpFile NVARCHAR(2048) = NULL,
  @i_DumpFileLocation NVARCHAR(2048),
  @i_dummy INTEGER
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_retVal INTEGER
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @SQL	NVARCHAR(2048)
	SET		@SQL	= ''
	DECLARE @dumpCmd	NVARCHAR(2048)
	SET			@dumpCmd	= ''
	IF @i_PrimaryDumpFile IS NULL OR @i_PrimaryDumpFile = ''
		SET @i_PrimaryDumpFile = 'SIDBPrimary.csv'
	IF @i_SecondaryDumpFile IS NULL OR @i_SecondaryDumpFile = ''
		SET @i_SecondaryDumpFile = 'SIDBSecondary.csv'
	DECLARE @primaryCSVFile	NVARCHAR(2048)
	SET			@primaryCSVFile	= @i_DumpFileLocation + '\' + @i_PrimaryDumpFile
	DECLARE @secondaryCSVFile	NVARCHAR(2048)
	SET			@secondaryCSVFile	= @i_DumpFileLocation + '\' + @i_SecondaryDumpFile
	DECLARE	@errorCode 	INTEGER
	SET			@errorCode 	= 0
	CREATE TABLE #tmpSIDBPrimary
	(
		CommCellId						INTEGER,
		SIDBStoreId						INTEGER,
		spare 								INTEGER,
		flags 								INTEGER,
		volumeId 							INTEGER,
		archivingTime 				INTEGER,
		mountPathId 					INTEGER,
		archiveFileId 				INTEGER,
		objectNumber 					INTEGER,
		refCount 							INTEGER,
		tagHdrCount 				 	INTEGER,
		padding								INTEGER,
		id 										INTEGER,
		size 									BIGINT,
		chunkId 							BIGINT,
		archiveOffset 				BIGINT,
		objMetaOffset 				BIGINT,
		metaOffset						BIGINT
	)
	CREATE TABLE #tmpSIDBSecondary
	(
		CommCellId			INTEGER,
		SIDBStoreId			INTEGER,
		archFileId			INTEGER,
		id 							BIGINT,
		primaryId 			BIGINT,
		archiveOffset 	BIGINT,
		objMetaOffset 	BIGINT,
		objectNumber 		INTEGER,
		flags						INTEGER
	)
	IF @i_truncateTables = 1
	BEGIN
		IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[SIDBPrimary]') and OBJECTPROPERTY(id, N'IsTable') = 1)
			DROP TABLE SIDBPrimary
		CREATE TABLE SIDBPrimary
		(
			commCellId 						INTEGER,
			SIDBStoreId						INTEGER,
			spare 								INTEGER,
			flags 								INTEGER,
			volumeId 							INTEGER,
			archivingTime 				INTEGER,
			mountPathId 					INTEGER,
			archiveFileId 				INTEGER,
			objectNumber 					INTEGER,
			refCount 							INTEGER,
			tagHdrCount 				 	INTEGER,
			padding								INTEGER,
			id 										INTEGER,
			size 									BIGINT,
			chunkId 							BIGINT,
			archiveOffset 				BIGINT,
			objMetaOffset 				BIGINT,
			metaOffset						BIGINT,
			archCopyId						INTEGER
		)
		IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[SIDBSecondary]') and OBJECTPROPERTY(id, N'IsTable') = 1)
			DROP TABLE SIDBSecondary
		CREATE TABLE SIDBSecondary
		(
			commCellId 			INTEGER,
			SIDBStoreId			INTEGER,
			archFileId			INTEGER,
			id 							BIGINT,
			primaryId 			BIGINT,
			archiveOffset 	BIGINT,
			objMetaOffset 	BIGINT,
			objectNumber 		INTEGER,
			flags						INTEGER,
			archCopyId			INTEGER
		)
	END
	SET @SQL = 'BULK INSERT #tmpSIDBPrimary FROM ''' + @primaryCSVFile + ''' WITH (FIRSTROW = 2,FIELDTERMINATOR = '','')'
	EXEC (@SQL)
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_EXIT
	SET @SQL = 'BULK INSERT #tmpSIDBSecondary FROM ''' + @secondaryCSVFile + ''' WITH (FIRSTROW = 2,FIELDTERMINATOR = '','')'
	EXEC (@SQL)
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_EXIT
	INSERT INTO SIDBPrimary
	SELECT 	T.CommCellId, T.SIDBStoreId, T.spare, T.flags, T.volumeId, T.archivingTime, T.mountPathId, T.archiveFileId, T.objectNumber,
					T.refCount, T.tagHdrCount, T.padding, T.id, T.size, T.chunkId, T.archiveOffset, T.objMetaOffset,
					T.metaOffset, ISNULL(S.copyId, 0)
	FROM #tmpSIDBPrimary T, archCopySIDBStore S WITH (NOLOCK)
	WHERE T.SIDBStoreId = S.SIDBStoreId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_EXIT
	INSERT INTO SIDBSecondary
	SELECT 	T.CommCellId, T.SIDBStoreId, T.archFileId, T.id, T.primaryId, T.archiveOffset,
					T.objMetaOffset, T.objectNumber, T.flags, ISNULL(S.copyId, 0)
	FROM #tmpSIDBSecondary T, archCopySIDBStore S WITH (NOLOCK)
	WHERE T.SIDBStoreId = S.SIDBStoreId
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_EXIT
CX_EXIT:
	SELECT @errorCode
	RETURN
GO


IF EXISTS (select * from GxQscripts where name = 'archPopulateSIDBData')
	delete from GxQscripts where name = 'archPopulateSIDBData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPopulateSIDBData')
	delete from GXDBVersions where aliasname = 'archPopulateSIDBData'
GO

insert into GXDBVersions values(2, 'archPopulateSIDBData',  '00010005020800010000', 'archPopulateSIDBData', '00010005020800010000')
GO

