

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/archPinJobsOnCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archPinJobsOnCopy.sp,v $ $Id: archPinJobsOnCopy.sp,v 1.15.48.6 2018/09/21 04:08:51 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: archPinJobsOnCopy <<<'

IF EXISTS (select * from sysobjects where name='archPinJobsOnCopy')
	drop procedure archPinJobsOnCopy
IF EXISTS (select * from GxQscripts where name='archPinJobsOnCopy')
	delete from GxQscripts where name = 'archPinJobsOnCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPinJobsOnCopy')
	delete from GXDBVersions where aliasname = 'archPinJobsOnCopy'
GO
print '... Creating Procedure: archPinJobsOnCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure archPinJobsOnCopy
  @i_setOrReset INTEGER,
  @i_pinEndTime BIGINT,
  @i_userId INTEGER,
  @i_xml XML
AS
  DECLARE @r_retVal INTEGER;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE	@tblJobSelFull TABLE (
			parentJobId		int,
 			childJobId 		int,
 			commCellId 		int,
 			archGrpId			int,
 			archGrpCopyId	int
			)
	DECLARE	@tblLinkedJobsOnCopy TABLE (
 			JobId 				int,
 			CommCellId 		int,
 			archGrpId 		int,
 			archGrpCopyId int,
 			appId					int,
 			appTypeId			int,
 			retentionDays	int,
 			retentionJobs	int,
 			isBad					int
			)
	DECLARE	@tblLinkedJobsOnSameCopy TABLE (
 			JobId 				int,
 			CommCellId 		int,
 			archGrpId 		int,
 			archGrpCopyId int,
 			appId					int,
 			retentionJobs	int
			)
	DECLARE @tblJobMaxRet TABLE (
			JobId 				int,
			CommCellId 		int,
			archGrpId 		int,
			retentionDays int,
			Primary Key (JobId, CommCellId, archGrpId)
			)
	DECLARE	@tblCopySource TABLE(
			CopyId 					int,
			sourceCopyId 		int,
			primaryCopy 		int,
			isMirrorCopy		int,
			Primary Key (CopyId)
			)
	DECLARE @t_errorCode INTEGER = 0
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @maxIntVal 		INTEGER
	SET			@maxIntVal 		= 2147483647
	DECLARE @isUserAdmin	INTEGER
	SET		@isUserAdmin	= 0
	DECLARE	@allowJobRetentionChangeOnWormCopy	INTEGER
	SET		@allowJobRetentionChangeOnWormCopy	= 0
	DECLARE @pinnedJobNotSupported TABLE( jobIdToDelete INT, jobId INT, componentNameId INT)
	EXEC sec_isUserAdmin @i_userId, @isUserAdmin OUTPUT
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SELECT @allowJobRetentionChangeOnWormCopy = isnull(value, 0)
	FROM MMConfigs
	WHERE name = 'DA_CONFIG_ALLOW_JOB_RETENTION_CHANGE_ON_WORM_COPY'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SELECT	DISTINCT T.item.value('@jobId', 'INTEGER') AS JobId,
					T.item.value('@commCellId', 'INTEGER') AS commCellId,
					T.item.value('@archGrpCopyId', 'INTEGER') AS archGrpCopyId
	INTO 	#JobsToPin
	FROM	@i_xml.nodes('/GalaxyOperations_PinJobs/JobInfo') T(item)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF	@i_setOrReset <= 0
		SET @i_pinEndTime = 0
	DELETE #JobsToPin
	OUTPUT deleted.JobId, JDS.JobId, ASCP.componentNameId INTO @pinnedJobNotSupported
	FROM    #JobsToPin J
              LEFT OUTER JOIN JMJobDataStats JDS WITH (NOLOCK) ON J.JobId = JDS.jobId AND J.commCellId = JDS.commCellId AND J.archGrpCopyId = JDS.archGrpCopyId AND JDS.status IN (100,101,102,103) AND JDS.disabled & 256 = 0
              LEFT OUTER JOIN APP_SubClientProp ASCP WITH (NOLOCK) ON ASCP.componentNameId = JDS.appId AND (ASCP.cs_attrName = CHECKSUM(N'Index SubClient') AND ASCP.attrname = N'Index SubClient'and ASCP.attrVal <> '0' and ASCP.modified = 0)
		WHERE  JDS.jobID IS NULL
              OR ASCP.componentNameId IS NOT NULL
IF @@ROWCOUNT > 0
SET     @t_errorCode      =     @t_errorCode |  ISNULL((SELECT TOP 1 9  FROM @pinnedJobNotSupported WHERE JobId IS NULL),0) |  ISNULL((SELECT TOP 1 195 FROM @pinnedJobNotSupported WHERE JobId IS NOT NULL),0)
	-- Do not unpin jobs from WORM storage policy copies
	IF	(@i_pinEndTime >= 0 AND (@isUserAdmin = 0 OR @allowJobRetentionChangeOnWormCopy = 0))
	BEGIN
		DELETE 	#JobsToPin
		FROM 	#JobsToPin JP, JMJobDataStats JDS WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
		WHERE 	JP.JobId = JDS.JobId
		AND 	JP.commCellId = JDS.commCellId
		AND		JP.archGrpCopyId = JDS.archGrpCopyId
AND		(JDS.disabled & 2) <> 0 AND (JDS.manualRetentionEndTime >= @i_pinEndTime OR JDS.manualRetentionEndTime = -1)
AND 	AGC.id = JP.archGrpCopyId AND (AGC.flags & 16777216) <> 0
	END
	-- Prevent pin/unpin for Snap Mirror copies
	DELETE #JobsToPin
	FROM #JobsToPin JP, JMJobDataStats JDS WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE 	JP.JobId = JDS.JobId
		AND 	JP.commCellId = JDS.commCellId
		AND		JP.archGrpCopyId = JDS.archGrpCopyId
		AND		AGC.Id = JDS.archGrpCopyId AND AGC.isMirrorCopy > 0
	-- Get linked jobs
	INSERT	INTO @tblJobSelFull
	SELECT	DISTINCT JDL.ParentJobId, JDL.ChildJobId, JDL.CommCellId, JDS.archGrpId, JDS.archGrpCopyId
	FROM	#JobsToPin JP, JMJobDataLinkForDA JDL WITH (NOLOCK), JMJobDataStats JDS WITH (NOLOCK)
	WHERE	JP.JobId = JDL.ParentJobId
	AND 	JP.commCellId = JDL.CommCellId
	AND		JP.JobId = JDS.jobId
	AND 	JP.commCellId = JDS.commCellId
	AND		JP.archGrpCopyId	= JDS.archGrpCopyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get linked jobs on copy
	INSERT	INTO @tblLinkedJobsOnCopy
	SELECT	JDS.jobId, JDS.CommCellId, JDS.archGrpId, JDS.archGrpCopyId, JDS.appId, APP.appTypeId,
					CASE AR.retentionDays WHEN -1 THEN @maxIntVal ELSE AR.retentionDays END, 0,
MAX(JDS.Disabled & 64)
	FROM	@tblJobSelFull T, JMJobDataStats JDS WITH (NOLOCK), APP_Application APP WITH (NOLOCK), ArchAgingRule AR WITH (NOLOCK)
	WHERE	T.childJobId = JDS.JobId
	AND 	T.commCellId = JDS.CommCellId
	AND		JDS.status = 100
AND		JDS.disabled & 256 = 0
	AND		JDS.appId = APP.Id
	AND		JDS.archGrpCopyId = AR.copyId
	GROUP BY JDS.jobId, JDS.CommCellId, JDS.archGrpId, JDS.archGrpCopyId, JDS.appId, APP.appTypeId,
						CASE AR.retentionDays WHEN -1 THEN @maxIntVal ELSE AR.retentionDays END
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the retentionDays for Migrator and Archiver AppTypes
	UPDATE	@tblLinkedJobsOnCopy
	SET		retentionDays = CASE AR.archiverRetDays WHEN -1 THEN @maxIntVal ELSE AR.archiverRetDays END
	FROM	@tblLinkedJobsOnCopy T, ArchAgingRule AR WITH (NOLOCK)
	WHERE	T.archGrpCopyId = AR.copyId
	AND	T.appTypeId IN (
						SELECT appTypeId
						FROM APP_IDATypeHandlingInfo
						WHERE isDMAppType = 1
			)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE	@tblLinkedJobsOnCopy
	SET		retentionJobs = AAR.retentionJobs
	FROM	@tblLinkedJobsOnCopy a, archAgingRule AAR WITH (NOLOCK)
	WHERE	a.archGrpCopyId = AAR.copyId
AND		(AAR.flags & 128) > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE	@tblLinkedJobsOnCopy
	SET		retentionJobs = 0
	FROM	@tblLinkedJobsOnCopy a, App_Application APP WITH (NOLOCK), APP_IDATypeHandlingInfo ATYPE WITH (NOLOCK)
	WHERE	a.appId = APP.id
	AND		APP.appTypeId = ATYPE.appTypeId
	AND		ATYPE.ignoreJobRetention = 1
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get linked jobs on same copy as that of parent job
	INSERT	INTO @tblLinkedJobsOnSameCopy
	SELECT	DISTINCT TT.jobId, TT.CommCellId, TT.archGrpId, TT.archGrpCopyId, TT.appId, TT.retentionJobs
	FROM	@tblJobSelFull T, @tblLinkedJobsOnCopy TT
	WHERE	T.childJobId = TT.jobId
	AND 	T.commCellId = TT.commCellId
	AND		T.archGrpCopyId = TT.archGrpCopyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Same Jobs Data and Logs may exist on different SP-Copy
	-- Pin/UnPin the rest of the jobs on copy with maximum retention
	DELETE @tblLinkedJobsOnCopy
	FROM	@tblLinkedJobsOnCopy T, @tblLinkedJobsOnSameCopy TT
	WHERE	T.jobId = TT.jobId
	AND 	T.commCellId = TT.commCellId
	AND		T.archGrpId = TT.archGrpId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Get job on copy with highest retention and not marked BAD
	--Get jobs on copy that honors regular retention since linking rule is not honored on copy that honors job based retention
	INSERT	INTO @tblJobMaxRet
	SELECT	JobId, CommCellId, archGrpId, MAX(retentionDays)
	FROM	@tblLinkedJobsOnCopy
	WHERE		isBad = 0
	AND			retentionJobs = 0
	GROUP BY JobId, CommCellId, archGrpId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Get job on copy with highest retention if no good job found
	INSERT	INTO @tblJobMaxRet
	SELECT	JobId, CommCellId, archGrpId, MAX(retentionDays)
	FROM		@tblLinkedJobsOnCopy a
	WHERE		NOT EXISTS (SELECT T.JobId FROM @tblJobMaxRet AS T
										WHERE a.JobId = T.jobId
										AND 	a.CommCellId = T.CommCellId
										AND		a.archGrpId = T.archGrpId)
	AND			retentionJobs = 0
	GROUP BY JobId, CommCellId, archGrpId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Do Not PIN SILO Jobs
	DELETE 	#JobsToPin
	FROM 		#JobsToPin JP, JMJobDataStats JDS WITH (NOLOCK)
	WHERE 	JP.JobId = JDS.JobId
	AND 		JP.commCellId = JDS.commCellId
	AND			JP.archGrpCopyId = JDS.archGrpCopyId
	AND 		JDS.appId IN (SELECT DISTINCT siloAppId FROM archGroupCopy WITH (NOLOCK) WHERE siloAppId > 0)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Do Not PIN SILO Jobs
	DELETE 	@tblLinkedJobsOnSameCopy
	WHERE		appId IN (SELECT DISTINCT siloAppId FROM archGroupCopy WITH (NOLOCK) WHERE siloAppId > 0)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Do Not PIN SILO Jobs
	DELETE 	@tblLinkedJobsOnCopy
	WHERE		appId IN (SELECT DISTINCT siloAppId FROM archGroupCopy WITH (NOLOCK) WHERE siloAppId > 0)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get source copy information for all Snap Copies
	INSERT	INTO @tblCopySource
	SELECT	a.id, a.sourceCopyId, b.defaultSnapCopy, a.isMirrorCopy
	FROM	archGroupCopy a WITH (NOLOCK), archGroup b WITH (NOLOCK)
	WHERE	a.archGroupId = b.id
	AND		a.isSnapCopy > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- The source copy will be source of Mirror copy if source copy is Mirror Copy
	WHILE EXISTS(SELECT T.sourceCopyId FROM @tblCopySource T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
	BEGIN
		UPDATE	@tblCopySource
		SET 	sourceCopyId = AGC.sourceCopyId
		FROM	@tblCopySource T, archGroupCopy AGC WITH (NOLOCK)
		WHERE	T.sourceCopyId = AGC.id
		AND		AGC.isSnapCopy > 0
		AND		AGC.isMirrorCopy > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	-- The source copy will be primary copy if no source copy defined
	UPDATE	@tblCopySource
	SET 	sourceCopyId = primaryCopy
	WHERE	sourceCopyId = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF @i_setOrReset > 0
	BEGIN
		-- Pin the selected jobs
		UPDATE	JMJobDataStats WITH (PAGLOCK)
SET			disabled = (disabled | 2),
						manualRetentionEndTime = @i_pinEndTime
		FROM		#JobsToPin JP, JMJobDataStats JDS
		WHERE 	JP.JobId = JDS.JobId
		AND 		JP.commCellId = JDS.commCellId
		AND			JP.archGrpCopyId = JDS.archGrpCopyId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Pin the selected jobs on mirror copies
		UPDATE	JMJobDataStats WITH (PAGLOCK)
SET			disabled = (disabled | 2),
						manualRetentionEndTime = @i_pinEndTime
		FROM		#JobsToPin JP, JMJobDataStats JDS, @tblCopySource C
		WHERE 	JP.JobId = JDS.JobId
		AND 		JP.commCellId = JDS.commCellId
		AND			JP.archGrpCopyId = C.sourceCopyId
		AND			C.CopyId = JDS.archGrpCopyId
		AND			C.isMirrorCopy > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Pin all linked jobs if they are on same copy as that of parent job
		-- Do NOT Pin linked jobs on copy with job based retention
		UPDATE	JMJobDataStats WITH (PAGLOCK)
SET			disabled = (disabled | 2),
						manualRetentionEndTime = @i_pinEndTime
		FROM		@tblLinkedJobsOnSameCopy JS, JMJobDataStats JDS
		WHERE 	JS.JobId = JDS.JobId
		AND 		JS.commCellId = JDS.commCellId
		AND			JS.archGrpCopyId = JDS.archGrpCopyId
		AND			JS.retentionJobs = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Pin the selected jobs on mirror copies
		UPDATE	JMJobDataStats WITH (PAGLOCK)
SET			disabled = (disabled | 2),
						manualRetentionEndTime = @i_pinEndTime
		FROM		@tblLinkedJobsOnSameCopy JS, JMJobDataStats JDS, @tblCopySource C
		WHERE 	JS.JobId = JDS.JobId
		AND 		JS.commCellId = JDS.commCellId
		AND			JS.archGrpCopyId = C.sourceCopyId
		AND			JS.retentionJobs = 0
		AND			C.CopyId = JDS.archGrpCopyId
		AND			C.isMirrorCopy > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Pin all linked jobs on copy with higher retention if they are not on same copy as that of parent job
		UPDATE	JMJobDataStats WITH (PAGLOCK)
SET			disabled = (disabled | 2),
						manualRetentionEndTime = @i_pinEndTime
		FROM		@tblLinkedJobsOnCopy JC, @tblJobMaxRet MR, JMJobDataStats JDS
		WHERE 	JC.JobId = MR.JobId
		AND 		JC.commCellId = MR.commCellId
		AND			JC.retentionDays = MR.retentionDays
		AND			JC.JobId = JDS.JobId
		AND 		JC.commCellId = JDS.commCellId
		AND			JC.archGrpCopyId = JDS.archGrpCopyId
		AND			JC.retentionJobs = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Pin the selected jobs on mirror copies
		UPDATE	JMJobDataStats WITH (PAGLOCK)
SET			disabled = (disabled | 2),
						manualRetentionEndTime = @i_pinEndTime
		FROM		@tblLinkedJobsOnCopy JC, @tblJobMaxRet MR, JMJobDataStats JDS, @tblCopySource C
		WHERE 	JC.JobId = MR.JobId
		AND 		JC.commCellId = MR.commCellId
		AND			JC.retentionDays = MR.retentionDays
		AND			JC.JobId = JDS.JobId
		AND 		JC.commCellId = JDS.commCellId
		AND			JC.archGrpCopyId = C.sourceCopyId
		AND			JC.retentionJobs = 0
		AND			C.CopyId = JDS.archGrpCopyId
		AND			C.isMirrorCopy > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	ELSE
	BEGIN
		-- UnPin the selected jobs
		UPDATE	JMJobDataStats WITH (PAGLOCK)
SET			disabled = (disabled & ~2),
						manualRetentionEndTime = 0
		FROM		#JobsToPin JP, JMJobDataStats JDS
		WHERE 	JP.JobId = JDS.JobId
		AND 		JP.commCellId = JDS.commCellId
		AND			JP.archGrpCopyId = JDS.archGrpCopyId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE	JMJobDataStats WITH (PAGLOCK)
SET			disabled = (disabled & ~2),
						manualRetentionEndTime = 0
		FROM		#JobsToPin JP, JMJobDataStats JDS, @tblCopySource C
		WHERE 	JP.JobId = JDS.JobId
		AND 		JP.commCellId = JDS.commCellId
		AND			JP.archGrpCopyId = C.sourceCopyId
		AND			C.CopyId = JDS.archGrpCopyId
		AND			C.isMirrorCopy > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- UnPin all linked jobs if they are on same copy as that of parent job
		UPDATE	JMJobDataStats WITH (PAGLOCK)
SET			disabled = (disabled & ~2),
						manualRetentionEndTime = 0
		FROM		@tblLinkedJobsOnSameCopy JS, JMJobDataStats JDS
		WHERE 	JS.JobId = JDS.JobId
		AND 		JS.commCellId = JDS.commCellId
		AND			JS.archGrpCopyId = JDS.archGrpCopyId
		AND			JS.retentionJobs = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- UnPin all linked jobs if they are on same copy as that of parent job
		UPDATE	JMJobDataStats WITH (PAGLOCK)
SET			disabled = (disabled & ~2),
						manualRetentionEndTime = 0
		FROM		@tblLinkedJobsOnSameCopy JS, JMJobDataStats JDS, @tblCopySource C
		WHERE 	JS.JobId = JDS.JobId
		AND 		JS.commCellId = JDS.commCellId
		AND			JS.archGrpCopyId = C.sourceCopyId
		AND			JS.retentionJobs = 0
		AND			C.CopyId = JDS.archGrpCopyId
		AND			C.isMirrorCopy > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- UnPin all linked jobs on copy with higher retention if they are not on same copy as that of parent job
		UPDATE	JMJobDataStats WITH (PAGLOCK)
SET			disabled = (disabled & ~2),
						manualRetentionEndTime = 0
		FROM		@tblLinkedJobsOnCopy JC, @tblJobMaxRet MR, JMJobDataStats JDS
		WHERE 	JC.JobId = MR.JobId
		AND 		JC.commCellId = MR.commCellId
		AND			JC.retentionDays = MR.retentionDays
		AND			JC.JobId = JDS.JobId
		AND 		JC.commCellId = JDS.commCellId
		AND			JC.archGrpCopyId = JDS.archGrpCopyId
		AND			JC.retentionJobs = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE	JMJobDataStats WITH (PAGLOCK)
SET			disabled = (disabled & ~2),
						manualRetentionEndTime = 0
		FROM		@tblLinkedJobsOnCopy JC, @tblJobMaxRet MR, JMJobDataStats JDS, @tblCopySource C
		WHERE 	JC.JobId = MR.JobId
		AND 		JC.commCellId = MR.commCellId
		AND			JC.retentionDays = MR.retentionDays
		AND			JC.JobId = JDS.JobId
		AND 		JC.commCellId = JDS.commCellId
		AND			JC.archGrpCopyId = C.sourceCopyId
		AND			JC.retentionJobs = 0
		AND			C.CopyId = JDS.archGrpCopyId
		AND			C.isMirrorCopy > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
CX_EXIT:
	IF @errorCode = 0
		SET @errorCode = @t_errorCode
	IF OBJECT_ID('tempdb.dbo.#tblResultArchPinJobsOnCopy') IS NOT NULL
	BEGIN
		INSERT INTO #tblResultArchPinJobsOnCopy
		SELECT	@errorCode
	END
	ELSE
		SELECT	@errorCode
	RETURN @errorCode;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'archPinJobsOnCopy')
	delete from GxQscripts where name = 'archPinJobsOnCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archPinJobsOnCopy')
	delete from GXDBVersions where aliasname = 'archPinJobsOnCopy'
GO

insert into GXDBVersions values(2, 'archPinJobsOnCopy',  '00010015004800060000', 'archPinJobsOnCopy', '00010015004800060000')
GO

